/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.sample.showcase.widgetlist;

import android.content.Context;
import android.content.res.Resources;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import dji.v5.ux.R;
import dji.v5.ux.sample.showcase.widgetlist.WidgetListFragment;
import dji.v5.ux.sample.showcase.widgetlist.WidgetListItem;
import java.util.ArrayList;
import java.util.List;

public class WidgetListItemAdapter
extends RecyclerView.Adapter<WidgetListItemViewHolder> {
    private ArrayList<WidgetListItem> widgetListItems;
    private WidgetListFragment.OnWidgetItemSelectedListener onWidgetItemSelectedListener;

    public WidgetListItemAdapter(ArrayList<WidgetListItem> widgetListItems, WidgetListFragment.OnWidgetItemSelectedListener onWidgetItemSelectedListener) {
        this.widgetListItems = widgetListItems;
        this.onWidgetItemSelectedListener = onWidgetItemSelectedListener;
    }

    public WidgetListItemViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        TextView v = (TextView)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.uxsdk_widget_list_item, parent, false);
        return new WidgetListItemViewHolder(v, this.onWidgetItemSelectedListener);
    }

    public void onBindViewHolder(WidgetListItemViewHolder holder, int position) {
        holder.titleTextView.setText(this.widgetListItems.get(position).getTitleId());
    }

    public int getItemCount() {
        return this.widgetListItems.size();
    }

    public void onBindViewHolder(WidgetListItemViewHolder holder, int position, List<Object> payloads) {
        super.onBindViewHolder((RecyclerView.ViewHolder)holder, position, payloads);
    }

    public class WidgetListItemViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private TextView titleTextView;
        private WidgetListFragment.OnWidgetItemSelectedListener onWidgetItemSelectedListener;

        private WidgetListItemViewHolder(TextView itemView, WidgetListFragment.OnWidgetItemSelectedListener onWidgetItemSelectedListener) {
            super((View)itemView);
            this.titleTextView = itemView;
            this.onWidgetItemSelectedListener = onWidgetItemSelectedListener;
            this.titleTextView.setOnClickListener((View.OnClickListener)this);
        }

        public void onClick(View v) {
            this.onWidgetItemSelectedListener.onWidgetItemSelected(this.getAdapterPosition());
        }

        public void setSelected(boolean selected, Resources resources) {
            if (selected) {
                this.titleTextView.setBackgroundColor(resources.getColor(R.color.uxsdk_gray_4));
            } else {
                this.titleTextView.setBackgroundColor(resources.getColor(R.color.uxsdk_dark_theme_background));
            }
        }
    }
}

