/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.obstacle;

import android.content.Context;
import android.graphics.Outline;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.widget.TextView;
import android.widget.Toast;
import com.google.android.material.tabs.TabLayout;
import dji.sdk.keyvalue.utils.ProductUtil;
import dji.sdk.keyvalue.value.flightcontroller.FCFlightMode;
import dji.sdk.keyvalue.value.product.ProductType;
import dji.v5.manager.aircraft.perception.data.ObstacleAvoidanceType;
import dji.v5.utils.common.AndUtil;
import dji.v5.utils.common.LogUtils;
import dji.v5.utils.common.StringUtils;
import dji.v5.utils.dpad.DpadProductManager;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.ViewUtil;
import dji.v5.ux.obstacle.AvoidanceShortcutWidgetModel;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 82\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003:\u000289B\u001d\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001e\u001a\u00020\u001fH\u0014J\"\u0010 \u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010!\u001a\u00020\u0016H\u0014J\b\u0010\"\u001a\u00020\u001fH\u0014J\b\u0010#\u001a\u00020\u001fH\u0014J\u0012\u0010$\u001a\u00020\u001f2\b\u0010%\u001a\u0004\u0018\u00010\u0004H\u0016J\u0012\u0010&\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010\u0004H\u0016J\u0012\u0010(\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010\u0004H\u0016J\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u0004H\u0002J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u0015H\u0002J\b\u0010,\u001a\u00020\u001fH\u0002J\b\u0010-\u001a\u00020\u001fH\u0002J\b\u0010.\u001a\u00020\u001fH\u0002J\u0010\u0010/\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u0015H\u0002J\u0010\u00100\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0015H\u0002J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020\u001502H\u0002J\f\u00103\u001a\u000204*\u00020\u0012H\u0002J\u0010\u00105\u001a\u00020\u001f2\u0006\u00106\u001a\u000204H\u0002J\n\u00107\u001a\u0004\u0018\u000104H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006:"}, d2={"Ldji/v5/ux/obstacle/AvoidanceShortcutWidget;", "Ldji/v5/ux/core/base/widget/ConstraintLayoutWidget;", "Ldji/v5/ux/obstacle/AvoidanceShortcutWidget$ModelState;", "Lcom/google/android/material/tabs/TabLayout$BaseOnTabSelectedListener;", "Lcom/google/android/material/tabs/TabLayout$Tab;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "apasTab", "Lcom/google/android/material/tabs/TabLayout;", "apasDesc", "Landroid/widget/TextView;", "compositeDisposable", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "flightMode", "Ldji/sdk/keyvalue/value/flightcontroller/FCFlightMode;", "tabItemResMap", "", "Ldji/v5/manager/aircraft/perception/data/ObstacleAvoidanceType;", "", "currentMode", "widgetModel", "Ldji/v5/ux/obstacle/AvoidanceShortcutWidgetModel;", "getWidgetModel", "()Ldji/v5/ux/obstacle/AvoidanceShortcutWidgetModel;", "widgetModel$delegate", "Lkotlin/Lazy;", "onAttachedToWindow", "", "initView", "defStyleAttr", "reactToModelChanges", "onDetachedFromWindow", "onTabSelected", "tab", "onTabUnselected", "p0", "onTabReselected", "selectTab", "setObstacleAction", "type", "revertObstacleAction", "updateTabItems", "updateTabByMode", "updateSelectTab", "generateTabItem", "getAPASModeRange", "", "getFlightModeString", "", "showToast", "msg", "getIdealDimensionRatioString", "Companion", "ModelState", "android-sdk-v5-uxsdk_release"})
@SourceDebugExtension(value={"SMAP\nAvoidanceShortcutWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvoidanceShortcutWidget.kt\ndji/v5/ux/obstacle/AvoidanceShortcutWidget\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,268:1\n1855#2,2:269\n*S KotlinDebug\n*F\n+ 1 AvoidanceShortcutWidget.kt\ndji/v5/ux/obstacle/AvoidanceShortcutWidget\n*L\n184#1:269,2\n*E\n"})
public final class AvoidanceShortcutWidget
extends ConstraintLayoutWidget<ModelState>
implements TabLayout.BaseOnTabSelectedListener<TabLayout.Tab> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private TabLayout apasTab;
    private TextView apasDesc;
    @NotNull
    private final CompositeDisposable compositeDisposable;
    @NotNull
    private FCFlightMode flightMode;
    @NotNull
    private final Map<ObstacleAvoidanceType, Integer> tabItemResMap;
    @NotNull
    private ObstacleAvoidanceType currentMode;
    @NotNull
    private final Lazy widgetModel$delegate;
    @NotNull
    private static final String TAG = "AvoidanceShortcutWidget";

    @JvmOverloads
    public AvoidanceShortcutWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, 0, 4, null);
        this.compositeDisposable = new CompositeDisposable();
        this.flightMode = FCFlightMode.UNKNOWN;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ObstacleAvoidanceType.BRAKE, (Object)R.string.uxsdk_fpv_setting_safe_obstacle_avoidance_behavior_brake_btn), TuplesKt.to((Object)ObstacleAvoidanceType.BYPASS, (Object)R.string.uxsdk_fpv_setting_safe_obstacle_avoidance_behavior_detour_btn), TuplesKt.to((Object)ObstacleAvoidanceType.CLOSE, (Object)R.string.uxsdk_fpv_setting_safe_obstacle_avoidance_behavior_off_btn)};
        this.tabItemResMap = MapsKt.mapOf((Pair[])pairArray);
        this.currentMode = ObstacleAvoidanceType.CLOSE;
        this.widgetModel$delegate = LazyKt.lazy(AvoidanceShortcutWidget::widgetModel_delegate$lambda$0);
    }

    public /* synthetic */ AvoidanceShortcutWidget(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    private final AvoidanceShortcutWidgetModel getWidgetModel() {
        Lazy lazy = this.widgetModel$delegate;
        return (AvoidanceShortcutWidgetModel)lazy.getValue();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.getWidgetModel().setup();
        }
        this.apasTab = (TabLayout)this.findViewById(R.id.omni_apas_tab);
        this.apasDesc = (TextView)this.findViewById(R.id.omni_apas_desc);
        TabLayout tabLayout = this.apasTab;
        if (tabLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apasTab");
            tabLayout = null;
        }
        tabLayout.setClipToOutline(true);
        TabLayout tabLayout2 = this.apasTab;
        if (tabLayout2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apasTab");
            tabLayout2 = null;
        }
        tabLayout2.setOutlineProvider(new ViewOutlineProvider(this){
            final /* synthetic */ AvoidanceShortcutWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public void getOutline(View view, Outline outline) {
                block0: {
                    Outline outline2 = outline;
                    if (outline2 == null) break block0;
                    Outline outline3 = outline2;
                    AvoidanceShortcutWidget avoidanceShortcutWidget = this.this$0;
                    Outline $this$getOutline_u24lambda_u240 = outline3;
                    boolean bl = false;
                    float radius = avoidanceShortcutWidget.getContext().getResources().getDimension(R.dimen.uxsdk_4_dp);
                    View view2 = view;
                    View view3 = view;
                    $this$getOutline_u24lambda_u240.setRoundRect(0, 0, view2 != null ? view2.getWidth() : 0, view3 != null ? view3.getHeight() : 0, radius);
                }
            }
        });
    }

    @Override
    protected void initView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        LayoutInflater.from((Context)context).inflate(R.layout.uxsdk_setting_menu_omni_apas_layout, (ViewGroup)this, true);
    }

    @Override
    protected void reactToModelChanges() {
        Disposable disposable = this.getWidgetModel().getProductTypeProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ AvoidanceShortcutWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(ProductType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AvoidanceShortcutWidget.access$updateTabItems(this.this$0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addReaction(disposable);
        Disposable disposable2 = this.getWidgetModel().getFlightModeProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ AvoidanceShortcutWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(FCFlightMode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AvoidanceShortcutWidget.access$setFlightMode$p(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"subscribe(...)");
        this.addReaction(disposable2);
        Disposable disposable3 = this.getWidgetModel().getObstacleAvoidanceTypeProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ AvoidanceShortcutWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(ObstacleAvoidanceType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AvoidanceShortcutWidget.access$setCurrentMode$p(this.this$0, it);
                AvoidanceShortcutWidget.access$updateSelectTab(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"subscribe(...)");
        this.addReaction(disposable3);
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.getWidgetModel().cleanup();
        }
        this.compositeDisposable.clear();
        super.onDetachedFromWindow();
    }

    public void onTabSelected(@Nullable TabLayout.Tab tab) {
        TabLayout.Tab tab2 = tab;
        Object object = tab2 != null ? tab2.getTag() : null;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type dji.v5.manager.aircraft.perception.data.ObstacleAvoidanceType");
        ObstacleAvoidanceType value = (ObstacleAvoidanceType)object;
        this.setObstacleAction(value);
        if (value != ObstacleAvoidanceType.CLOSE) {
            String mode = this.getFlightModeString(this.flightMode);
            if (Intrinsics.areEqual((Object)mode, (Object)"A") || Intrinsics.areEqual((Object)mode, (Object)"S")) {
                String string2;
                Object object2;
                if (value == ObstacleAvoidanceType.BRAKE) {
                    object2 = new Object[]{mode};
                    string2 = StringUtils.getResStr((Context)this.getContext(), (int)R.string.uxsdk_setting_menu_perception_break_s_mode, (Object[])object2);
                } else {
                    object2 = new Object[]{mode};
                    string2 = StringUtils.getResStr((int)R.string.uxsdk_setting_menu_perception_apas_s_mode, (Object[])object2);
                }
                String content = string2;
                object2 = content;
                Intrinsics.checkNotNull((Object)object2);
                this.showToast((String)object2);
            }
        } else {
            String resStr = StringUtils.getResStr((int)R.string.uxsdk_setting_menu_perception_apas_off_dialog_content, (Object[])new Object[0]);
            ViewUtil.showToast(this.getContext(), resStr);
        }
    }

    public void onTabUnselected(@Nullable TabLayout.Tab p0) {
    }

    public void onTabReselected(@Nullable TabLayout.Tab p0) {
    }

    private final void selectTab(TabLayout.Tab tab) {
        TabLayout tabLayout = this.apasTab;
        if (tabLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apasTab");
            tabLayout = null;
        }
        tabLayout.removeOnTabSelectedListener((TabLayout.BaseOnTabSelectedListener)this);
        tab.select();
        TabLayout tabLayout2 = this.apasTab;
        if (tabLayout2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apasTab");
            tabLayout2 = null;
        }
        tabLayout2.addOnTabSelectedListener((TabLayout.BaseOnTabSelectedListener)this);
    }

    private final void setObstacleAction(ObstacleAvoidanceType type) {
        this.getWidgetModel().setObstacleActionType(type).observeOn(SchedulerProvider.ui()).subscribe(new CompletableObserver(this){
            final /* synthetic */ AvoidanceShortcutWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSubscribe(Disposable d) {
                Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            }

            public void onComplete() {
            }

            public void onError(Throwable e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Object[] objectArray = new Object[]{"setObstacleAction onError:" + e};
                LogUtils.e((String)"AvoidanceShortcutWidget", (Object[])objectArray);
                AvoidanceShortcutWidget.access$revertObstacleAction(this.this$0);
            }
        });
    }

    private final void revertObstacleAction() {
        this.updateTabByMode();
    }

    private final void updateTabItems() {
        this.setVisibility(0);
        TabLayout tabLayout = this.apasTab;
        if (tabLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apasTab");
            tabLayout = null;
        }
        tabLayout.removeAllTabs();
        Iterable $this$forEach$iv = this.getAPASModeRange();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ObstacleAvoidanceType it = (ObstacleAvoidanceType)element$iv;
            boolean bl = false;
            TabLayout tabLayout2 = this.apasTab;
            if (tabLayout2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"apasTab");
                tabLayout2 = null;
            }
            tabLayout2.addTab(this.generateTabItem(it), false);
        }
        this.updateTabByMode();
    }

    private final void updateTabByMode() {
        this.updateSelectTab(this.currentMode);
    }

    private final void updateSelectTab(ObstacleAvoidanceType type) {
        int i = 0;
        TabLayout tabLayout = this.apasTab;
        if (tabLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apasTab");
            tabLayout = null;
        }
        int n = tabLayout.getTabCount();
        while (i < n) {
            TabLayout.Tab tab;
            TabLayout tabLayout2 = this.apasTab;
            if (tabLayout2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"apasTab");
                tabLayout2 = null;
            }
            TabLayout.Tab tab2 = tab = tabLayout2.getTabAt(i);
            if ((tab2 != null ? tab2.getTag() : null) == type) {
                this.selectTab(tab);
                TextView textView = this.apasDesc;
                if (textView == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"apasDesc");
                    textView = null;
                }
                textView.setText((CharSequence)(switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1 -> AndUtil.getResString((int)R.string.uxsdk_setting_menu_perception_apas_description);
                    case 2 -> AndUtil.getResString((int)R.string.uxsdk_setting_menu_perception_break_description);
                    case 3 -> AndUtil.getResString((int)R.string.uxsdk_setting_menu_perception_close_description);
                    default -> "";
                }));
                break;
            }
            ++i;
        }
    }

    private final TabLayout.Tab generateTabItem(ObstacleAvoidanceType type) {
        TabLayout.Tab tab;
        TabLayout tabLayout = this.apasTab;
        if (tabLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"apasTab");
            tabLayout = null;
        }
        TabLayout.Tab $this$generateTabItem_u24lambda_u242 = tab = tabLayout.newTab();
        boolean bl = false;
        Integer n = this.tabItemResMap.get(type);
        Intrinsics.checkNotNull((Object)n);
        $this$generateTabItem_u24lambda_u242.setText(((Number)n).intValue());
        $this$generateTabItem_u24lambda_u242.setTag((Object)type);
        TabLayout.Tab tab2 = tab;
        Intrinsics.checkNotNullExpressionValue((Object)tab2, (String)"apply(...)");
        return tab2;
    }

    private final List<ObstacleAvoidanceType> getAPASModeRange() {
        List list;
        if (ProductUtil.isM3EProduct() || ProductUtil.isM4EProduct() || ProductUtil.isM4DProduct()) {
            Object[] objectArray = new ObstacleAvoidanceType[]{ObstacleAvoidanceType.BRAKE, ObstacleAvoidanceType.BYPASS, ObstacleAvoidanceType.CLOSE};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            Object[] objectArray = new ObstacleAvoidanceType[]{ObstacleAvoidanceType.BRAKE, ObstacleAvoidanceType.CLOSE};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        return list;
    }

    private final String getFlightModeString(FCFlightMode $this$getFlightModeString) {
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$getFlightModeString.ordinal()]) {
            case 1 -> "";
            case 2 -> "A";
            case 3 -> "S";
            case 4 -> "T";
            default -> DpadProductManager.getInstance().isDjiRcPlus() || DpadProductManager.getInstance().isDjiRcPro() || ProductUtil.isM30Product() || ProductUtil.isM350Product() || ProductUtil.isM400Product() ? "N" : "P";
        };
    }

    private final void showToast(String msg) {
        AndroidSchedulers.mainThread().scheduleDirect(() -> AvoidanceShortcutWidget.showToast$lambda$3(this, msg));
    }

    @Override
    @Nullable
    public String getIdealDimensionRatioString() {
        return null;
    }

    @JvmOverloads
    public AvoidanceShortcutWidget(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }

    private static final AvoidanceShortcutWidgetModel widgetModel_delegate$lambda$0() {
        DJISDKModel dJISDKModel = DJISDKModel.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dJISDKModel, (String)"getInstance(...)");
        ObservableInMemoryKeyedStore observableInMemoryKeyedStore = ObservableInMemoryKeyedStore.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)observableInMemoryKeyedStore, (String)"getInstance(...)");
        return new AvoidanceShortcutWidgetModel(dJISDKModel, observableInMemoryKeyedStore);
    }

    private static final void showToast$lambda$3(AvoidanceShortcutWidget this$0, String $msg) {
        Toast.makeText((Context)this$0.getContext(), (CharSequence)$msg, (int)0).show();
    }

    public static final /* synthetic */ void access$updateTabItems(AvoidanceShortcutWidget $this) {
        $this.updateTabItems();
    }

    public static final /* synthetic */ void access$setFlightMode$p(AvoidanceShortcutWidget $this, FCFlightMode fCFlightMode) {
        $this.flightMode = fCFlightMode;
    }

    public static final /* synthetic */ void access$setCurrentMode$p(AvoidanceShortcutWidget $this, ObstacleAvoidanceType obstacleAvoidanceType) {
        $this.currentMode = obstacleAvoidanceType;
    }

    public static final /* synthetic */ void access$updateSelectTab(AvoidanceShortcutWidget $this, ObstacleAvoidanceType type) {
        $this.updateSelectTab(type);
    }

    public static final /* synthetic */ void access$revertObstacleAction(AvoidanceShortcutWidget $this) {
        $this.revertObstacleAction();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldji/v5/ux/obstacle/AvoidanceShortcutWidget$Companion;", "", "<init>", "()V", "TAG", "", "android-sdk-v5-uxsdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b6\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldji/v5/ux/obstacle/AvoidanceShortcutWidget$ModelState;", "", "<init>", "()V", "android-sdk-v5-uxsdk_release"})
    public static abstract class ModelState {
        private ModelState() {
        }

        public /* synthetic */ ModelState(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ObstacleAvoidanceType.values().length];
            try {
                nArray[ObstacleAvoidanceType.BYPASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObstacleAvoidanceType.BRAKE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObstacleAvoidanceType.CLOSE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[FCFlightMode.values().length];
            try {
                nArray[FCFlightMode.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FCFlightMode.ATTI.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FCFlightMode.GPS_SPORT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FCFlightMode.TRIPOD_GPS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

