/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.core.models.annotations;

import androidx.annotation.ColorInt;
import dji.v5.ux.mapkit.core.models.BasePointCollection;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import java.util.List;

public class DJIPolygonOptions
extends BasePointCollection {
    private float mWidth;
    private float mZIndex;
    @ColorInt
    private int mStrokeColor = -16777216;
    @ColorInt
    private int mFillColor = -16777216;
    private boolean mVisible = true;

    public DJIPolygonOptions strokeWidth(float width) {
        this.mWidth = width;
        return this;
    }

    public DJIPolygonOptions zIndex(float zIndex) {
        this.mZIndex = zIndex;
        return this;
    }

    public DJIPolygonOptions strokeColor(@ColorInt int color2) {
        this.mStrokeColor = color2;
        return this;
    }

    public DJIPolygonOptions fillColor(@ColorInt int color2) {
        this.mFillColor = color2;
        return this;
    }

    public float getStrokeWidth() {
        return this.mWidth;
    }

    public float getZIndex() {
        return this.mZIndex;
    }

    @ColorInt
    public int getStrokeColor() {
        return this.mStrokeColor;
    }

    @ColorInt
    public int getFillColor() {
        return this.mFillColor;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public DJIPolygonOptions add(DJILatLng point) {
        this.addPoint(point);
        return this;
    }

    public DJIPolygonOptions add(DJILatLng ... points) {
        for (DJILatLng point : points) {
            this.addPoint(point);
        }
        return this;
    }

    public DJIPolygonOptions addAll(List<DJILatLng> points) {
        for (DJILatLng point : points) {
            this.addPoint(point);
        }
        return this;
    }
}

