/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.hsi;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.ui.hsi.fpv.IFPVParams;
import dji.v5.ux.core.util.MatrixUtils;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AircraftAttitudeView
extends View {
    private static final String TAG = "AircraftAttitudeView";
    private static final int VIEW_DRAW_FRAME_RATE = 60;
    private static final int DATA_RECEIVED_FRAME_RATE = 10;
    @NonNull
    private static final float[] EMPTY_FLOAT_ARRAYS = new float[0];
    private static final float AIRCRAFT_NOSE_PERCENTAGE_OF_PARENT = 0.06349207f;
    private static final float AIRCRAFT_HEADING_VIEW_PERCENTAGE_OF_PARENT = 0.0952381f;
    private static final float AIRCRAFT_HEADING_CIRCLE_PERCENTAGE = 0.41666666f;
    private static final float[] C2I_MATRIX = new float[]{0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    @NonNull
    private final Paint mPaint;
    private int mVideoViewWidth;
    private int mVideoViewHeight;
    private int mActualWidthBack;
    private int mActualHeightBack;
    private int mActualWidth;
    private int mActualHeight;
    private final int mLineStrokeWidth;
    private float mYaw;
    private float mRoll;
    private float mPitch;
    private float mSpeedX;
    private float mSpeedY;
    private float mSpeedZ;
    @NonNull
    private final List<float[]> mParameters = new ArrayList<float[]>();
    @NonNull
    private final PublishSubject<float[]> mAircraftAttitudePublisher = PublishSubject.create();
    @Nullable
    private ViewModel mViewModel;
    @Nullable
    private CompositeDisposable mDisposable;
    private IFPVParams mFpvParams;

    public AircraftAttitudeView(Context context) {
        this(context, null);
    }

    public AircraftAttitudeView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AircraftAttitudeView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.AircraftAttitudeView);
        this.mActualWidth = typedArray.getDimensionPixelSize(R.styleable.AircraftAttitudeView_uxsdk_actual_width, -1);
        this.mActualHeight = typedArray.getDimensionPixelSize(R.styleable.AircraftAttitudeView_uxsdk_actual_height, -1);
        this.mActualWidthBack = this.mActualWidth;
        this.mActualHeightBack = this.mActualHeight;
        typedArray.recycle();
        this.mLineStrokeWidth = context.getResources().getDimensionPixelSize(R.dimen.uxsdk_1_dp);
        this.mPaint = new Paint(5);
        this.mPaint.setColor(this.getResources().getColor(R.color.uxsdk_green_in_dark));
        this.mPaint.setStrokeWidth((float)this.mLineStrokeWidth);
    }

    public float getFpvFocusX() {
        return this.mFpvParams.getFocusX();
    }

    public float getFpvFocusY() {
        return this.mFpvParams.getFocusY();
    }

    public float getVideoCenterX() {
        return this.mFpvParams.getCenterX();
    }

    public float getVideoCenterY() {
        return this.mFpvParams.getCenterY();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFpvParams = IFPVParams.Companion.getCurrent();
        this.mDisposable = new CompositeDisposable();
        this.processAircraftAttitude();
        this.processHorizontalLineAndSpeedVectorMark();
    }

    private void processHorizontalLineAndSpeedVectorMark() {
        this.mDisposable.add(Observable.interval((long)16L, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(Schedulers.single()).map(aLong -> this.getParameters()).distinctUntilChanged().observeOn(Schedulers.computation()).map(floats -> {
            ViewModel viewModel = new ViewModel();
            if (((float[])floats).length > 0) {
                SpeedVectorData speedVectorData = new SpeedVectorData();
                speedVectorData.setPitch(floats[2]);
                speedVectorData.setYaw(floats[3]);
                speedVectorData.setRoll(floats[4]);
                this.updateHorizontalLine(viewModel, (int)floats[0], (int)floats[1], speedVectorData);
                this.updateSpeedVectorMark(viewModel, (int)floats[0], (int)floats[1], speedVectorData, floats[5], floats[6], floats[7]);
            }
            return viewModel;
        }).onErrorReturn(throwable -> {
            LogUtils.e((String)TAG, (Object[])new Object[]{throwable.getMessage()});
            return new ViewModel();
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(viewModel -> {
            if (!viewModel.isValidate()) {
                return;
            }
            this.mViewModel = viewModel;
            this.invalidate();
        }));
    }

    private float[] getParameters() {
        if (this.mParameters.isEmpty()) {
            return EMPTY_FLOAT_ARRAYS;
        }
        if (this.mParameters.get(0) == null) {
            this.mParameters.remove(0);
            return EMPTY_FLOAT_ARRAYS;
        }
        if (this.mParameters.size() > 1) {
            return this.mParameters.remove(0);
        }
        return this.mParameters.get(0);
    }

    private void processAircraftAttitude() {
        this.mDisposable.add(this.mAircraftAttitudePublisher.debounce(10L, TimeUnit.MILLISECONDS, Schedulers.newThread()).observeOn(Schedulers.single()).map(floats -> new float[][]{this.mParameters.isEmpty() ? null : this.mParameters.get(this.mParameters.size() - 1), floats}).observeOn(Schedulers.computation()).map(params -> {
            if (params[0] == null) {
                this.mParameters.add(params[1]);
            } else {
                float[] startElement = params[0];
                float[] floats = params[1];
                int interval = 6;
                boolean isDrasticChange = floats[2] * startElement[2] < 0.0f || floats[3] * startElement[3] < 0.0f || floats[4] * startElement[4] < 0.0f;
                float pitchOffset = (floats[2] - startElement[2]) / (float)interval;
                float yawOffset = (floats[3] - startElement[3]) / (float)interval;
                float rollOffset = (floats[4] - startElement[4]) / (float)interval;
                float speedXOffset = (floats[5] - startElement[5]) / (float)interval;
                float speedYOffset = (floats[6] - startElement[6]) / (float)interval;
                float speedZOffset = (floats[7] - startElement[7]) / (float)interval;
                for (int i = 1; i < interval; ++i) {
                    float[] fArray;
                    if (!isDrasticChange) {
                        float[] fArray2 = new float[8];
                        fArray2[0] = floats[0];
                        fArray2[1] = floats[1];
                        fArray2[2] = startElement[2] + pitchOffset * (float)i;
                        fArray2[3] = startElement[3] + yawOffset * (float)i;
                        fArray2[4] = startElement[4] + rollOffset * (float)i;
                        fArray2[5] = startElement[5] + speedXOffset * (float)i;
                        fArray2[6] = startElement[6] + speedYOffset * (float)i;
                        fArray = fArray2;
                        fArray2[7] = startElement[7] + speedZOffset * (float)i;
                    } else {
                        fArray = this.getOffset(i, interval, startElement, floats);
                    }
                    float[] offset = fArray;
                    this.mParameters.add(offset);
                }
                this.mParameters.add(floats);
            }
            return true;
        }).onErrorReturn(throwable -> {
            LogUtils.e((String)TAG, (Object[])new Object[]{throwable.getMessage()});
            return false;
        }).subscribe());
    }

    private float[] getOffset(int i, int interval, float[] startElement, float[] floats) {
        return i < interval / 2 ? startElement : floats;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mDisposable != null && !this.mDisposable.isDisposed()) {
            this.mDisposable.dispose();
        }
    }

    public void setYaw(float yaw) {
        this.mYaw = yaw;
        this.recalculateAndInvalidate();
    }

    public void setRoll(float roll) {
        this.mRoll = roll;
        this.recalculateAndInvalidate();
    }

    public void setPitch(float pitch) {
        this.mPitch = pitch;
        this.recalculateAndInvalidate();
    }

    public void setSpeedX(float speedX) {
        this.mSpeedX = speedX;
        this.recalculateAndInvalidate();
    }

    public void setSpeedY(float speedY) {
        this.mSpeedY = speedY;
        this.recalculateAndInvalidate();
    }

    public void setSpeedZ(float speedZ) {
        this.mSpeedZ = speedZ;
        this.recalculateAndInvalidate();
    }

    public void setVideoViewSize(int videoViewWidth, int videoViewHeight) {
        this.mVideoViewWidth = videoViewWidth;
        this.mVideoViewHeight = videoViewHeight;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mActualHeight == -1) {
            this.mActualHeight = this.getHeight();
        }
        if (this.mActualWidth == -1) {
            this.mActualWidth = this.getWidth();
        }
        int aircraftNoseSize = Math.min((int)((float)this.mActualWidth * 0.06349207f), (int)((float)this.mActualHeight * 0.06349207f));
        this.drawAircraftNose(canvas, aircraftNoseSize);
        if (this.mViewModel != null) {
            this.drawAircraftHorizon(canvas, aircraftNoseSize, this.mViewModel.aircraftHorizonRotate, this.mViewModel.aircraftHorizonOffsetY);
            this.drawAircraftHeading(canvas, this.mViewModel.aircraftHeadingOffsetX, this.mViewModel.aircraftHeadingOffsetY);
            return;
        }
        this.drawAircraftHorizon(canvas, aircraftNoseSize, 0.0f, 0.0f);
        this.drawAircraftHeading(canvas, 0.0f, 0.0f);
    }

    public void setSize(int width, int height) {
        this.mActualWidth = width;
        this.mActualHeight = height;
        this.invalidate();
    }

    public void resetSize() {
        this.setSize(this.mActualWidthBack, this.mActualHeightBack);
    }

    private void drawAircraftNose(Canvas canvas, int aircraftNoseSize) {
        canvas.drawLine((float)(this.getWidth() - aircraftNoseSize) / 2.0f, (float)this.getHeight() / 2.0f, (float)(this.getWidth() + aircraftNoseSize) / 2.0f, (float)this.getHeight() / 2.0f, this.mPaint);
        canvas.drawLine((float)this.getWidth() / 2.0f, (float)(this.getHeight() + aircraftNoseSize) / 2.0f, (float)this.getWidth() / 2.0f, (float)(this.getHeight() - aircraftNoseSize) / 2.0f, this.mPaint);
    }

    private void drawAircraftHeading(Canvas canvas, float offsetX, float offsetY) {
        float middleHeight = (float)this.getHeight() / 2.0f;
        float middleWidth = (float)this.getWidth() / 2.0f;
        float aircraftHeadingSize = Math.min((float)this.mActualWidth * 0.0952381f, (float)this.mActualHeight * 0.0952381f);
        canvas.save();
        canvas.translate(middleWidth, middleHeight);
        float radius = aircraftHeadingSize / 2.0f * 0.41666666f;
        float length = (float)Math.sqrt(offsetX * offsetX + offsetY * offsetY);
        float drawRate = (length - radius) / length;
        canvas.drawLine(0.0f, 0.0f, offsetX * drawRate, offsetY * drawRate, this.mPaint);
        canvas.translate(offsetX, offsetY);
        this.mPaint.setStyle(Paint.Style.STROKE);
        canvas.drawCircle(0.0f, 0.0f, radius, this.mPaint);
        canvas.drawLine(-aircraftHeadingSize / 2.0f, 0.0f, -radius, 0.0f, this.mPaint);
        canvas.drawLine(radius, 0.0f, aircraftHeadingSize / 2.0f, 0.0f, this.mPaint);
        canvas.drawLine(0.0f, -radius, 0.0f, -radius * 2.0f, this.mPaint);
        canvas.restore();
    }

    private void drawAircraftHorizon(Canvas canvas, int aircraftNoseSize, float rotate, float offsetY) {
        float middleHeight = (float)this.getHeight() / 2.0f;
        float middleWidth = (float)this.getWidth() / 2.0f;
        canvas.save();
        canvas.translate(middleWidth, middleHeight);
        canvas.rotate(rotate);
        canvas.translate(0.0f, -offsetY);
        canvas.drawLine(-((float)this.mActualWidth) / 2.0f, 0.0f, (float)(-aircraftNoseSize) / 4.0f * 3.0f, 0.0f, this.mPaint);
        canvas.drawLine((float)aircraftNoseSize / 4.0f * 3.0f, 0.0f, (float)this.mActualWidth / 2.0f, 0.0f, this.mPaint);
        canvas.restore();
    }

    private void updateHorizontalLine(ViewModel viewModel, int displayWidth, int displayHeight, SpeedVectorData speedVectorData) {
        float[] i2gMat = MatrixUtils.createRotationMatrix(speedVectorData.yaw, speedVectorData.pitch, speedVectorData.roll);
        float[] bl2gMat = MatrixUtils.createRotationMatrix(speedVectorData.yaw, 0.0f, 0.0f);
        float[] g2blMat = MatrixUtils.transposeMatrix(bl2gMat);
        float[] i2blMat = MatrixUtils.productMatrix(g2blMat, i2gMat);
        float[] c2blMat = MatrixUtils.productMatrix(i2blMat, C2I_MATRIX);
        float[] bl2cMat = MatrixUtils.transposeMatrix(c2blMat);
        float[] kMat = MatrixUtils.createIntrinsicMatrix(this.getFpvFocusX(), this.getFpvFocusY(), this.getVideoCenterX(), this.getVideoCenterY());
        float[] v1 = new float[]{bl2cMat[0] / bl2cMat[6], bl2cMat[3] / bl2cMat[6], 1.0f};
        float[] v2 = new float[]{(bl2cMat[0] + bl2cMat[1]) / (bl2cMat[6] + bl2cMat[7]), (bl2cMat[3] + bl2cMat[4]) / (bl2cMat[6] + bl2cMat[7]), 1.0f};
        v1 = MatrixUtils.rotateVector(v1, kMat);
        v2 = MatrixUtils.rotateVector(v2, kMat);
        float a = (v2[1] - v1[1]) / (v2[0] - v1[0]);
        float angrad = (float)Math.atan(a);
        float rotate = (float)Math.toDegrees(angrad);
        float c = v1[1] - a * v1[0];
        float offsetY = (float)displayHeight / 2.0f - (float)displayWidth / 2.0f * a - c * (float)displayHeight / (this.getVideoCenterY() * 2.0f);
        viewModel.aircraftHorizonRotate = rotate;
        viewModel.aircraftHorizonOffsetY = offsetY;
    }

    private void updateSpeedVectorMark(ViewModel viewModel, int displayWidth, int displayHeight, SpeedVectorData speedVectorData, float speedX, float speedY, float speedZ) {
        float[] i2gMat = MatrixUtils.createRotationMatrix(speedVectorData.yaw, speedVectorData.pitch, speedVectorData.roll);
        float[] g2iMat = MatrixUtils.transposeMatrix(i2gMat);
        float[] fArray = new float[]{speedX, speedY, speedZ};
        float[] speedVector = fArray;
        float[] vi = MatrixUtils.rotateVector(speedVector, g2iMat);
        if (vi[0] >= 0.0f) {
            float[] c2gMat = MatrixUtils.productMatrix(i2gMat, C2I_MATRIX);
            float[] g2cMat = MatrixUtils.transposeMatrix(c2gMat);
            float[] kMat = MatrixUtils.createIntrinsicMatrix(this.getFpvFocusX(), this.getFpvFocusY(), this.getVideoCenterX(), this.getVideoCenterY());
            float[] mMat = MatrixUtils.productMatrix(kMat, g2cMat);
            speedVector = MatrixUtils.rotateVector(speedVector, mMat);
            speedVector[0] = speedVector[0] / speedVector[2];
            speedVector[1] = speedVector[1] / speedVector[2];
            float vectorX = (speedVector[0] - this.getVideoCenterX()) * (float)displayWidth / (this.getVideoCenterX() * 2.0f);
            float vectorY = (speedVector[1] - this.getVideoCenterY()) * (float)displayHeight / (this.getVideoCenterY() * 2.0f);
            if (vectorX < -((float)displayWidth) / 2.0f || vectorX > (float)displayWidth / 2.0f) {
                float checkedX = Math.max(vectorX, (float)(-displayWidth) / 2.0f);
                checkedX = vectorX > (float)displayWidth / 2.0f ? (float)displayWidth / 2.0f : checkedX;
                float checkedY = checkedX / vectorX * vectorY;
                vectorX = checkedX;
                vectorY = checkedY;
            }
            if (vectorY < -((float)displayHeight) / 2.0f || vectorY > (float)displayHeight / 2.0f) {
                float checkedY = Math.max(vectorY, (float)(-displayHeight) / 2.0f);
                checkedY = vectorY > (float)displayHeight / 2.0f ? (float)displayHeight / 2.0f : checkedY;
                vectorX = vectorX / vectorY * checkedY;
                vectorY = checkedY;
            }
            viewModel.aircraftHeadingOffsetX = vectorX;
            viewModel.aircraftHeadingOffsetY = vectorY;
        }
    }

    private void recalculateAndInvalidate() {
        this.mAircraftAttitudePublisher.onNext((Object)new float[]{this.mVideoViewWidth, this.mVideoViewHeight, this.mPitch, this.mYaw, this.mRoll, this.mSpeedX, this.mSpeedY, this.mSpeedZ});
    }

    private static final class ViewModel {
        float aircraftHorizonRotate = Float.NaN;
        float aircraftHorizonOffsetY = Float.NaN;
        float aircraftHeadingOffsetX = Float.NaN;
        float aircraftHeadingOffsetY = Float.NaN;

        private ViewModel() {
        }

        boolean isValidate() {
            return !Float.isNaN(this.aircraftHorizonRotate) || !Float.isNaN(this.aircraftHorizonOffsetY) || !Float.isNaN(this.aircraftHeadingOffsetX) || !Float.isNaN(this.aircraftHeadingOffsetY);
        }
    }

    private class SpeedVectorData {
        private float pitch;
        private float yaw;
        private float roll;

        private SpeedVectorData() {
        }

        public float getPitch() {
            return this.pitch;
        }

        public void setPitch(float pitch) {
            this.pitch = pitch;
        }

        public float getYaw() {
            return this.yaw;
        }

        public void setYaw(float yaw) {
            this.yaw = yaw;
        }

        public float getRoll() {
            return this.roll;
        }

        public void setRoll(float roll) {
            this.roll = roll;
        }
    }
}

