/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.component;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.appcompat.widget.AppCompatTextView;
import dji.v5.ux.R;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Ldji/v5/ux/core/ui/component/StrokeTextView;", "Landroidx/appcompat/widget/AppCompatTextView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "strokeWidth", "", "getStrokeWidth", "()F", "setStrokeWidth", "(F)V", "strokeColor", "getStrokeColor", "()I", "setStrokeColor", "(I)V", "onDrawingFlag", "", "getOnDrawingFlag", "()Z", "setOnDrawingFlag", "(Z)V", "invalidate", "", "onDraw", "canvas", "Landroid/graphics/Canvas;", "android-sdk-v5-uxsdk_release"})
public class StrokeTextView
extends AppCompatTextView {
    private float strokeWidth;
    private int strokeColor;
    private boolean onDrawingFlag;

    @JvmOverloads
    public StrokeTextView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super((Context)new ContextThemeWrapper(context, R.style.Widget_StrokeTextView), attrs, defStyleAttr);
        Context newContext = this.getContext();
        TypedArray typedArray = newContext.obtainStyledAttributes(attrs, R.styleable.StrokeTextView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray ta = typedArray;
        this.strokeWidth = ta.getDimension(R.styleable.StrokeTextView_uxsdk_textStrokeWidth, 0.0f);
        this.strokeColor = ta.getColor(R.styleable.StrokeTextView_uxsdk_textStrokeColor, 0);
        ta.recycle();
        try {
            Field field = TextView.class.getDeclaredField("mShadowRadius");
            field.setAccessible(true);
            field.setFloat((Object)this, this.strokeWidth);
            field.setAccessible(false);
        }
        catch (Exception exception) {
            this.setShadowLayer(this.strokeWidth, 0.0f, 0.0f, 0);
        }
    }

    public /* synthetic */ StrokeTextView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final float getStrokeWidth() {
        return this.strokeWidth;
    }

    public final void setStrokeWidth(float f) {
        this.strokeWidth = f;
    }

    public final int getStrokeColor() {
        return this.strokeColor;
    }

    public final void setStrokeColor(int n) {
        this.strokeColor = n;
    }

    public final boolean getOnDrawingFlag() {
        return this.onDrawingFlag;
    }

    public final void setOnDrawingFlag(boolean bl) {
        this.onDrawingFlag = bl;
    }

    public void invalidate() {
        if (!this.onDrawingFlag) {
            super.invalidate();
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.onDrawingFlag = true;
        ColorStateList lastColor = this.getTextColors();
        this.setTextColor(this.strokeColor);
        this.getPaint().setStyle(Paint.Style.STROKE);
        this.getPaint().setStrokeWidth(this.strokeWidth);
        super.onDraw(canvas);
        this.setTextColor(lastColor);
        this.getPaint().setStyle(Paint.Style.FILL);
        super.onDraw(canvas);
        this.onDrawingFlag = false;
    }

    @JvmOverloads
    public StrokeTextView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public StrokeTextView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

