/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.ToggleButton;
import androidx.core.view.ViewCompat;
import dji.v5.utils.common.AndUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DividerConstraintLayout;
import dji.v5.ux.core.util.ViewUtil;

public class SwitcherCell
extends DividerConstraintLayout {
    protected ToggleButton mSwitcher;
    protected TextView mSummary;
    protected TextView mTitle;
    protected TextView mDesc;
    protected View mDisableHintView;
    protected String mDisableHintText;
    private View mInfoIcon;
    protected String mPopupHintText;
    private OnCheckedChangedListener mListener;
    private View.OnClickListener mPopupHintClickListener;
    private View.OnClickListener mDisableClickListener;

    public SwitcherCell(Context context) {
        this(context, null);
    }

    public SwitcherCell(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwitcherCell(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs, defStyleAttr);
    }

    private void initialize(Context context, AttributeSet attrs, int defStyleAttr) {
        int layout2;
        LayoutInflater.from((Context)context).inflate(R.layout.uxsdk_cell_switcher_layout, (ViewGroup)this, true);
        TypedArray ta = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SwitcherCell, defStyleAttr, 0);
        this.mSwitcher = (ToggleButton)this.findViewById(R.id.toggle_switcher);
        this.mSummary = (TextView)this.findViewById(R.id.summary);
        this.mTitle = (TextView)this.findViewById(R.id.title);
        this.mDesc = (TextView)this.findViewById(R.id.desc);
        this.mDisableHintView = this.findViewById(R.id.disable_hint_view);
        this.mInfoIcon = this.findViewById(R.id.info_icon);
        if (ta.hasValue(R.styleable.SwitcherCell_uxsdk_title)) {
            this.mTitle.setText((CharSequence)ta.getString(R.styleable.SwitcherCell_uxsdk_title));
        } else {
            this.mTitle.setVisibility(8);
        }
        if (ta.hasValue(R.styleable.SwitcherCell_uxsdk_titleTextSize)) {
            this.mTitle.setTextSize(0, ta.getDimension(R.styleable.SwitcherCell_uxsdk_titleTextSize, 16.0f));
        }
        if (ta.hasValue(R.styleable.SwitcherCell_uxsdk_titleColor)) {
            this.mTitle.setTextColor(ta.getColor(R.styleable.SwitcherCell_uxsdk_titleColor, this.getResources().getColor(R.color.uxsdk_dic_color_c24_white_Transparent6)));
        }
        if (ta.hasValue(R.styleable.SwitcherCell_uxsdk_summary)) {
            this.mSummary.setText((CharSequence)ta.getString(R.styleable.SwitcherCell_uxsdk_summary));
        } else {
            this.mSummary.setVisibility(8);
        }
        if (ta.hasValue(R.styleable.SwitcherCell_uxsdk_summaryTextSize)) {
            this.mSummary.setTextSize(0, ta.getDimension(R.styleable.SwitcherCell_uxsdk_summaryTextSize, 14.0f));
        }
        if (ta.hasValue(R.styleable.SwitcherCell_uxsdk_summaryColor)) {
            this.mSummary.setTextColor(ta.getColor(R.styleable.SwitcherCell_uxsdk_summaryColor, this.getResources().getColor(R.color.uxsdk_dic_color_c8_white)));
        }
        this.setupDesc(ta);
        if (ta.hasValue(R.styleable.SwitcherCell_uxsdk_checked)) {
            this.mSwitcher.setChecked(ta.getBoolean(R.styleable.SwitcherCell_uxsdk_checked, false));
        }
        if (ta.hasValue(R.styleable.SwitcherCell_uxsdk_switchToggleBg)) {
            this.mSwitcher.setBackgroundResource(ta.getResourceId(R.styleable.SwitcherCell_uxsdk_switchToggleBg, R.drawable.uxsdk_toggle_green_selector));
        }
        if (ta.hasValue(R.styleable.SwitcherCell_uxsdk_layout) && (layout2 = ta.getResourceId(R.styleable.SwitcherCell_uxsdk_layout, 0)) > 0) {
            View view = LayoutInflater.from((Context)context).inflate(layout2, null);
            this.addView(view);
        }
        this.setupInfoView(ta);
        ta.recycle();
        ViewCompat.setSaveFromParentEnabled((View)this, (boolean)false);
        this.mSwitcher.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (this.mListener != null) {
                this.mListener.onCheckedChanged(this, isChecked);
            }
        });
        this.setMinHeight((int)AndUtil.getItemHeight((Context)this.getContext()));
        this.setListeners();
    }

    private void setupDesc(TypedArray ta) {
        if (ta.hasValue(R.styleable.SwitcherCell_uxsdk_desc)) {
            this.mDesc.setText((CharSequence)ta.getString(R.styleable.SwitcherCell_uxsdk_desc));
        } else {
            this.mDesc.setVisibility(8);
        }
        if (ta.hasValue(R.styleable.SwitcherCell_uxsdk_descColor)) {
            this.mDesc.setTextColor(ta.getColor(R.styleable.SwitcherCell_uxsdk_descColor, this.getResources().getColor(R.color.uxsdk_dic_color_c24_white_Transparent6)));
        }
        if (ta.hasValue(R.styleable.SwitcherCell_uxsdk_descTextSize)) {
            this.mDesc.setTextSize(0, (float)ta.getDimensionPixelSize(R.styleable.SwitcherCell_uxsdk_descTextSize, this.getResources().getDimensionPixelSize(R.dimen.uxsdk_dic_text_size_16sp)));
        }
        if (ta.hasValue(R.styleable.SwitcherCell_uxsdk_descMarginVertical)) {
            int margin = ta.getDimensionPixelSize(R.styleable.SwitcherCell_uxsdk_descMarginVertical, this.getResources().getDimensionPixelSize(R.dimen.uxsdk_dic_text_size_16sp));
            ViewGroup.LayoutParams lp = this.mDesc.getLayoutParams();
            if (lp instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)lp;
                mlp.topMargin = margin;
                mlp.bottomMargin = margin;
                this.mDesc.setLayoutParams((ViewGroup.LayoutParams)mlp);
            }
        }
    }

    private void setupInfoView(TypedArray ta) {
        if (ta.hasValue(R.styleable.SwitcherCell_uxsdk_disableHint)) {
            this.mDisableHintText = ta.getString(R.styleable.SwitcherCell_uxsdk_disableHint);
        }
        boolean showInfoIcon = false;
        if (ta.hasValue(R.styleable.SwitcherCell_uxsdk_showInfoHintIcon)) {
            showInfoIcon = ta.getBoolean(R.styleable.SwitcherCell_uxsdk_showInfoHintIcon, false);
        }
        if (ta.hasValue(R.styleable.SwitcherCell_uxsdk_infoPopupHint)) {
            this.mPopupHintText = ta.getString(R.styleable.SwitcherCell_uxsdk_infoPopupHint);
        }
        this.mInfoIcon.setVisibility(showInfoIcon || !TextUtils.isEmpty((CharSequence)this.mPopupHintText) ? 0 : 8);
    }

    private void setListeners() {
        this.mDisableHintView.setOnClickListener(v -> {
            if (this.mSwitcher.isEnabled()) {
                return;
            }
            if (this.mDisableClickListener != null) {
                this.mDisableClickListener.onClick(v);
            } else if (!TextUtils.isEmpty((CharSequence)this.mDisableHintText) && !this.mSwitcher.isEnabled()) {
                ViewUtil.showToast(this.getContext(), this.mDisableHintText, 0);
            }
        });
        this.mInfoIcon.setOnClickListener(v -> {
            if (this.mPopupHintClickListener != null) {
                this.mPopupHintClickListener.onClick(v);
            } else if (!TextUtils.isEmpty((CharSequence)this.mPopupHintText)) {
                ViewUtil.showToast(this.getContext(), this.mPopupHintText, 0);
            }
        });
    }

    public void setChecked(boolean checked) {
        this.mSwitcher.setChecked(checked);
    }

    public boolean isChecked() {
        return this.mSwitcher.isChecked();
    }

    public void setOnCheckedChangedListener(OnCheckedChangedListener listener2) {
        this.mListener = listener2;
    }

    public void resetValue(boolean checked) {
        OnCheckedChangedListener listener2 = this.mListener;
        this.mListener = null;
        this.setChecked(checked);
        this.mListener = listener2;
    }

    public void updateSummaryText(String text) {
        if (this.mSummary != null) {
            if (this.mSummary.getVisibility() != 0) {
                this.mSummary.setVisibility(0);
            }
            this.mSummary.setText((CharSequence)text);
        }
    }

    public void updateDesc(int text) {
        if (this.mDesc != null) {
            this.mDesc.setText(text);
        }
    }

    public void updateDesc(CharSequence desc) {
        this.mDesc.setText(desc);
        if (desc instanceof SpannableString) {
            this.mDesc.setMovementMethod(LinkMovementMethod.getInstance());
        }
    }

    public void updateEnabledStatus(boolean enabled) {
        this.setEnabled(enabled);
        int textColor = enabled ? this.getContext().getResources().getColor(R.color.uxsdk_white) : this.getContext().getResources().getColor(R.color.uxsdk_gray);
        this.mSummary.setTextColor(textColor);
        this.mTitle.setTextColor(textColor);
        this.mInfoIcon.setAlpha(enabled ? 1.0f : 0.5f);
        this.setToggleEnabled(enabled);
        this.mDisableHintView.setVisibility(enabled ? 8 : 0);
        if (!enabled) {
            this.mDisableHintView.setMinimumHeight(this.getMinHeight());
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mSwitcher.setEnabled(enabled);
    }

    public void setToggleEnabled(boolean enabled) {
        this.mSwitcher.setEnabled(enabled);
        this.mSwitcher.setAlpha(enabled ? 1.0f : 0.5f);
    }

    public void setDisableHint(String disableHint) {
        this.mDisableHintText = disableHint;
    }

    public void setPopupHint(String popupHint) {
        this.mPopupHintText = popupHint;
    }

    public void setOnDisableHintClickListener(View.OnClickListener listener2) {
        this.mDisableClickListener = listener2;
    }

    public void setOnPopupHintClickListener(View.OnClickListener listener2) {
        this.mPopupHintClickListener = listener2;
    }

    public static interface OnCheckedChangedListener {
        public void onCheckedChanged(SwitcherCell var1, boolean var2);
    }
}

