/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.visualcamera.shutter;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.CameraKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.camera.CameraExposureSettings;
import dji.sdk.keyvalue.value.camera.CameraShutterSpeed;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Flowable;

public class CameraConfigShutterWidgetModel
extends WidgetModel
implements ICameraIndex {
    private DataProcessor<CameraExposureSettings> exposureSettingsProcessor;
    private DataProcessor<CameraShutterSpeed> shutterSpeedProcessor;
    private ComponentIndexType cameraIndex = ComponentIndexType.LEFT_OR_MAIN;
    private CameraLensType lensType = CameraLensType.CAMERA_LENS_ZOOM;

    public CameraConfigShutterWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore keyedStore) {
        super(djiSdkModel, keyedStore);
        this.exposureSettingsProcessor = DataProcessor.create(new CameraExposureSettings());
        this.shutterSpeedProcessor = DataProcessor.create(CameraShutterSpeed.UNKNOWN);
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.cameraIndex;
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.lensType;
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.cameraIndex = cameraIndex;
        this.lensType = lensType;
        this.restart();
    }

    public Flowable<CameraShutterSpeed> getShutterSpeed() {
        return this.shutterSpeedProcessor.toFlowable();
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyExposureSettings, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType), this.exposureSettingsProcessor, exposureSettings -> {
            if (exposureSettings.getShutterSpeed() != null) {
                this.shutterSpeedProcessor.onNext(exposureSettings.getShutterSpeed());
            }
        });
    }

    @Override
    protected void inCleanup() {
    }

    @Override
    protected void updateStates() {
    }
}

