/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.core.camera;

import androidx.annotation.NonNull;
import dji.v5.ux.mapkit.core.camera.DJICameraUpdate;
import dji.v5.ux.mapkit.core.maps.DJIMap;
import dji.v5.ux.mapkit.core.models.DJICameraPosition;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.DJILatLngBounds;

public final class DJICameraUpdateFactory {
    private DJICameraUpdateFactory() {
    }

    public static DJICameraUpdate newCameraPosition(@NonNull DJICameraPosition cameraPosition) {
        return new CameraPositionUpdate(cameraPosition.target, cameraPosition.zoom, cameraPosition.tilt, cameraPosition.bearing);
    }

    public static DJICameraUpdate newLatLngBounds(@NonNull DJILatLngBounds bounds, int width, int height, int zoom, int padding) {
        return new CameraBoundsUpdate(bounds, width, height, zoom, padding);
    }

    public static DJICameraUpdate newLatLngBounds(@NonNull DJILatLngBounds bounds, int width, int height, int zoom) {
        return new CameraBoundsUpdate(bounds, width, height, zoom, 0);
    }

    public static DJICameraUpdate newLatLngBounds(@NonNull DJILatLngBounds bounds, int zoom, int padding) {
        return new CameraBoundsUpdate(bounds, 0, 0, zoom, padding);
    }

    public static DJICameraUpdate newLatLngBounds(@NonNull DJILatLngBounds bounds, int paddingtop, int paddingRight, int paddingBottom, int paddingLeft, int zoom) {
        return new CameraBoundsUpdate(bounds, paddingtop, paddingRight, paddingBottom, paddingLeft, zoom);
    }

    public static DJICameraUpdate newLatLngBounds(@NonNull DJILatLngBounds bounds, int zoom) {
        return new CameraBoundsUpdate(bounds, 0, 0, zoom, 0);
    }

    public static final class CameraPositionUpdate
    implements DJICameraUpdate {
        private final DJILatLng target;
        private final float zoom;
        private final float tilt;
        private final float bearing;

        public CameraPositionUpdate(DJILatLng target, float zoom, float tilt, float bearing) {
            this.target = target;
            this.zoom = zoom;
            this.tilt = tilt;
            this.bearing = bearing;
        }

        @Override
        public DJILatLng getTarget() {
            return this.target;
        }

        @Override
        public float getZoom() {
            return this.zoom;
        }

        @Override
        public float getTilt() {
            return this.tilt;
        }

        @Override
        public float getBearing() {
            return this.bearing;
        }

        @Override
        public DJICameraPosition getCameraPosition(@NonNull DJIMap map) {
            DJICameraPosition previousPosition = map.getCameraPosition();
            DJICameraPosition.Builder builder = new DJICameraPosition.Builder().zoom(this.zoom).tilt(this.tilt).bearing(this.bearing);
            if (this.target == null) {
                builder.target(previousPosition.target);
            } else {
                builder.target(this.target);
            }
            return builder.build();
        }
    }

    public static final class CameraBoundsUpdate
    implements DJICameraUpdate {
        private DJILatLngBounds bounds;
        private int width;
        private int height;
        private int zoom;
        private int padding = -1;
        private int paddingTop;
        private int paddingRight;
        private int paddingBottom;
        private int paddingLeft;

        CameraBoundsUpdate(DJILatLngBounds bounds, int width, int height, int zoom, int padding) {
            this.bounds = bounds;
            this.width = width;
            this.height = height;
            this.zoom = zoom;
            this.padding = padding;
        }

        CameraBoundsUpdate(DJILatLngBounds bounds, int paddingTop, int paddingRight, int paddingBottom, int paddingLeft, int zoom) {
            this.bounds = bounds;
            this.paddingTop = paddingTop;
            this.paddingRight = paddingRight;
            this.paddingBottom = paddingBottom;
            this.paddingLeft = paddingLeft;
            this.zoom = zoom;
        }

        @Override
        public DJICameraPosition getCameraPosition(@NonNull DJIMap map) {
            return null;
        }

        @Override
        public DJILatLng getTarget() {
            return null;
        }

        public DJILatLngBounds getBounds() {
            return this.bounds;
        }

        @Override
        public float getZoom() {
            return this.zoom;
        }

        @Override
        public float getTilt() {
            return 0.0f;
        }

        @Override
        public float getBearing() {
            return 0.0f;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getPadding() {
            return this.padding;
        }

        public int getPaddingTop() {
            return this.paddingTop;
        }

        public int getPaddingRight() {
            return this.paddingRight;
        }

        public int getPaddingBottom() {
            return this.paddingBottom;
        }

        public int getPaddingLeft() {
            return this.paddingLeft;
        }
    }
}

