/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.map;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.GimbalKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.common.LocationCoordinate2D;
import dji.sdk.keyvalue.value.common.LocationCoordinate3D;
import dji.v5.common.callback.CommonCallbacks;
import dji.v5.common.error.IDJIError;
import dji.v5.manager.KeyManager;
import dji.v5.manager.aircraft.flysafe.FlySafeNotificationListener;
import dji.v5.manager.aircraft.flysafe.FlyZoneManager;
import dji.v5.manager.aircraft.flysafe.info.FlySafeReturnToHomeInformation;
import dji.v5.manager.aircraft.flysafe.info.FlySafeSeriousWarningInformation;
import dji.v5.manager.aircraft.flysafe.info.FlySafeTipInformation;
import dji.v5.manager.aircraft.flysafe.info.FlySafeWarningInformation;
import dji.v5.manager.aircraft.flysafe.info.FlyZoneInformation;
import dji.v5.manager.aircraft.flysafe.info.FlyZoneLicenseInfo;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MapWidgetModel
extends WidgetModel {
    public static final double INVALID_COORDINATE = 181.0;
    private final DataProcessor<LocationCoordinate3D> aircraftLocationDataProcessor;
    private final DataProcessor<LocationCoordinate2D> homeLocationDataProcessor;
    private final DataProcessor<Double> gimbalYawDataProcessor;
    private final DataProcessor<Double> aircraftHeadingDataProcessor;
    private final DataProcessor<String> flightControllerSerialNumberDataProcessor;
    public final DataProcessor<List<FlyZoneInformation>> flyZoneInformationDataProcessor;
    private final FlySafeNotificationListener flySafeNotificationListener = new FlySafeNotificationListener(){

        public void onWarningNotificationUpdate(@NonNull FlySafeWarningInformation info) {
        }

        public void onSeriousWarningNotificationUpdate(@NonNull FlySafeSeriousWarningInformation info) {
        }

        public void onReturnToHomeNotificationUpdate(@NonNull FlySafeReturnToHomeInformation info) {
        }

        public void onTipNotificationUpdate(@NonNull FlySafeTipInformation info) {
        }

        public void onSurroundingFlyZonesUpdate(@NonNull List<FlyZoneInformation> infos) {
            MapWidgetModel.this.flyZoneInformationDataProcessor.onNext(infos);
        }
    };

    public MapWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore keyedStore) {
        super(djiSdkModel, keyedStore);
        this.aircraftLocationDataProcessor = DataProcessor.create(new LocationCoordinate3D(Double.valueOf(181.0), Double.valueOf(181.0), Double.valueOf(-1.0)));
        this.homeLocationDataProcessor = DataProcessor.create(new LocationCoordinate2D(Double.valueOf(181.0), Double.valueOf(181.0)));
        this.gimbalYawDataProcessor = DataProcessor.create(0.0);
        this.aircraftHeadingDataProcessor = DataProcessor.create(0.0);
        this.flightControllerSerialNumberDataProcessor = DataProcessor.create("");
        this.flyZoneInformationDataProcessor = DataProcessor.create(new CopyOnWriteArrayList());
        KeyManager.getInstance().listen(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyConnection), (Object)this, (oldValue, newValue) -> {
            if (newValue == Boolean.TRUE) {
                this.updateFlyZoneInformation();
            }
        });
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAircraftLocation3D), this.aircraftLocationDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyHomeLocation), this.homeLocationDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)GimbalKey.KeyYawRelativeToAircraftHeading), this.gimbalYawDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeySerialNumber), this.flightControllerSerialNumberDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyCompassHeading), this.aircraftHeadingDataProcessor);
        FlyZoneManager.getInstance().addFlySafeNotificationListener(this.flySafeNotificationListener);
    }

    @Override
    protected void inCleanup() {
        FlyZoneManager.getInstance().removeFlySafeNotificationListener(this.flySafeNotificationListener);
    }

    @Override
    protected void updateStates() {
    }

    private void updateFlyZoneInformation() {
        LocationCoordinate2D location = (LocationCoordinate2D)KeyManager.getInstance().getValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAircraftLocation));
        if (location == null) {
            return;
        }
        FlyZoneManager.getInstance().getFlyZonesInSurroundingArea(location, (CommonCallbacks.CompletionCallbackWithParam)new CommonCallbacks.CompletionCallbackWithParam<List<FlyZoneInformation>>(){

            public void onSuccess(List<FlyZoneInformation> flyZoneInformation) {
                MapWidgetModel.this.flyZoneInformationDataProcessor.onNext(flyZoneInformation);
            }

            public void onFailure(@NonNull IDJIError error) {
            }
        });
    }

    public void setFlyZoneLicensesEnabled(FlyZoneLicenseInfo info, boolean isEnable, CommonCallbacks.CompletionCallback callback) {
        FlyZoneManager.getInstance().setFlyZoneLicensesEnabled(info, isEnable, callback);
    }

    public void unlockAuthorizationFlyZone(int flyZoneID, CommonCallbacks.CompletionCallback callback) {
        FlyZoneManager.getInstance().unlockAuthorizationFlyZone(flyZoneID, callback);
    }

    public Flowable<LocationCoordinate3D> getAircraftLocation() {
        return this.aircraftLocationDataProcessor.toFlowable();
    }

    public Flowable<LocationCoordinate2D> getHomeLocation() {
        return this.homeLocationDataProcessor.toFlowable();
    }

    public Flowable<Double> getGimbalHeading() {
        return this.gimbalYawDataProcessor.toFlowable();
    }

    public Flowable<Double> getAircraftHeading() {
        return this.aircraftHeadingDataProcessor.toFlowable();
    }
}

