/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.hsi;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.WindowManager;
import dji.v5.utils.common.DJIExecutor;
import dji.v5.utils.common.LogUtils;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.disposables.Disposable;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 /2\u00020\u0001:\u0005+,-./B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010!\u001a\u00020\u001dJ\u0006\u0010\"\u001a\u00020\u001dJ\u0006\u0010#\u001a\u00020\u001dJ\u0010\u0010$\u001a\u00020\u001d2\b\u0010%\u001a\u0004\u0018\u00010&J\u0018\u0010'\u001a\u00020\u001d2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u000bR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Ldji/v5/ux/core/ui/hsi/HSICompassProcesser;", "", "context", "Landroid/content/Context;", "listener", "Ldji/v5/ux/core/ui/hsi/HSICompassProcesser$CompassListener;", "<init>", "(Landroid/content/Context;Ldji/v5/ux/core/ui/hsi/HSICompassProcesser$CompassListener;)V", "mSensorMgr", "Landroid/hardware/SensorManager;", "mAccelerometerStatus", "", "mMagneticStatus", "mDefaultDisplay", "Landroid/view/Display;", "mRegisterManager", "Ldji/v5/ux/core/ui/hsi/HSICompassProcesser$RegisterManager;", "mAccelerometerData", "", "mMagneticValues", "mListener", "getMListener", "()Ldji/v5/ux/core/ui/hsi/HSICompassProcesser$CompassListener;", "setMListener", "(Ldji/v5/ux/core/ui/hsi/HSICompassProcesser$CompassListener;)V", "sampleTimeInMs", "", "lastUpdateTime", "calcOrientation", "", "screenOrientation", "notifyDisposable", "Lio/reactivex/rxjava3/disposables/Disposable;", "start", "stop", "updateScreenOrientation", "onSensorChanged", "event", "Landroid/hardware/SensorEvent;", "onAccuracyChanged", "sensor", "Landroid/hardware/Sensor;", "accuracy", "CompassListener", "RegisterManager", "HSICompassSensorEventListener", "HSICompassSensorOrientationEventListener", "Companion", "android-sdk-v5-uxsdk_debug"})
public final class HSICompassProcesser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SensorManager mSensorMgr;
    private int mAccelerometerStatus;
    private int mMagneticStatus;
    @NotNull
    private final Display mDefaultDisplay;
    @NotNull
    private final RegisterManager mRegisterManager;
    @Nullable
    private float[] mAccelerometerData;
    @Nullable
    private float[] mMagneticValues;
    @NotNull
    private CompassListener mListener;
    private final long sampleTimeInMs;
    private long lastUpdateTime;
    private volatile int screenOrientation;
    @Nullable
    private Disposable notifyDisposable;
    private static final int SAMPLING_PERIOD_US = 3;
    @NotNull
    private static final String TAG = "HSICompassProcesser";

    public HSICompassProcesser(@NotNull Context context, @NotNull CompassListener listener2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Object object = context.getApplicationContext().getSystemService("sensor");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.SensorManager");
        this.mSensorMgr = (SensorManager)object;
        this.mAccelerometerStatus = -1;
        this.mMagneticStatus = -1;
        this.sampleTimeInMs = 100L;
        Object object2 = context.getSystemService("window");
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type android.view.WindowManager");
        WindowManager wm = (WindowManager)object2;
        this.mDefaultDisplay = wm.getDefaultDisplay();
        Sensor mAccelerometerSensor = this.mSensorMgr.getDefaultSensor(1);
        Sensor mMagneticSensor = this.mSensorMgr.getDefaultSensor(2);
        SensorEventListener sensorEventListener = new HSICompassSensorEventListener(new WeakReference<HSICompassProcesser>(this));
        WeakReference<HSICompassProcesser> weakReference = new WeakReference<HSICompassProcesser>(this);
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getApplicationContext(...)");
        this.mRegisterManager = new RegisterManager(this.mSensorMgr, mAccelerometerSensor, mMagneticSensor, sensorEventListener, new HSICompassSensorOrientationEventListener(weakReference, context2));
        this.mListener = listener2;
    }

    @NotNull
    public final CompassListener getMListener() {
        return this.mListener;
    }

    public final void setMListener(@NotNull CompassListener compassListener) {
        Intrinsics.checkNotNullParameter((Object)compassListener, (String)"<set-?>");
        this.mListener = compassListener;
    }

    private final void calcOrientation() {
        if (this.mAccelerometerData == null || this.mMagneticValues == null) {
            return;
        }
        float[] values = new float[3];
        float[] matrix = new float[9];
        SensorManager.getRotationMatrix((float[])matrix, null, (float[])this.mAccelerometerData, (float[])this.mMagneticValues);
        SensorManager.getOrientation((float[])matrix, (float[])values);
        values[0] = (float)Math.toDegrees(values[0]);
        Ref.FloatRef orientation = new Ref.FloatRef();
        orientation.element = values[0];
        if (orientation.element < 0.0f) {
            orientation.element += (float)360;
        }
        orientation.element += (float)this.screenOrientation;
        if (orientation.element > 360.0f) {
            orientation.element -= 360.0f;
        }
        int strength = RangesKt.coerceAtMost((int)this.mAccelerometerStatus, (int)this.mMagneticStatus);
        Disposable disposable = this.notifyDisposable;
        if (disposable != null) {
            disposable.dispose();
        }
        this.notifyDisposable = AndroidSchedulers.mainThread().scheduleDirect(() -> HSICompassProcesser.calcOrientation$lambda$0(this, strength, orientation));
    }

    public final void start() {
        this.mRegisterManager.registerSensorListener();
        this.updateScreenOrientation();
    }

    public final void stop() {
        block0: {
            this.mRegisterManager.unRegisterSensorListener();
            Disposable disposable = this.notifyDisposable;
            if (disposable == null) break block0;
            disposable.dispose();
        }
    }

    public final void updateScreenOrientation() {
        this.screenOrientation = this.mDefaultDisplay.getRotation() * 90;
    }

    public final void onSensorChanged(@Nullable SensorEvent event) {
        long now;
        SensorEvent sensorEvent;
        SensorEvent sensorEvent2 = event;
        boolean bl = sensorEvent2 != null && (sensorEvent2 = sensorEvent2.sensor) != null ? sensorEvent2.getType() == 1 : false;
        if (bl) {
            this.mAccelerometerData = event.values;
        }
        boolean bl2 = (sensorEvent = event) != null && (sensorEvent = sensorEvent.sensor) != null ? sensorEvent.getType() == 2 : false;
        if (bl2) {
            this.mMagneticValues = event.values;
        }
        if ((now = System.currentTimeMillis()) - this.lastUpdateTime >= this.sampleTimeInMs) {
            this.lastUpdateTime = now;
            this.calcOrientation();
        }
    }

    public final void onAccuracyChanged(@Nullable Sensor sensor, int accuracy) {
        Object object = new Object[1];
        Sensor sensor2 = sensor;
        object[0] = "onAccuracyChanged: type: " + (sensor2 != null ? Integer.valueOf(sensor2.getType()) : null) + ", accuracy: " + accuracy;
        LogUtils.d((String)TAG, (Object[])object);
        Sensor sensor3 = sensor;
        Object object2 = object = sensor3 != null ? Integer.valueOf(sensor3.getType()) : null;
        int n = 1;
        if (object2 != null && (Integer)object2 == n) {
            this.mAccelerometerStatus = accuracy;
        } else {
            Object object3 = object;
            n = 2;
            if (object3 != null && (Integer)object3 == n) {
                this.mMagneticStatus = accuracy;
            }
        }
    }

    private static final void calcOrientation$lambda$0(HSICompassProcesser this$0, int $strength, Ref.FloatRef $orientation) {
        this$0.mListener.onOrientationChange($strength, $orientation.element);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ldji/v5/ux/core/ui/hsi/HSICompassProcesser$Companion;", "", "<init>", "()V", "SAMPLING_PERIOD_US", "", "TAG", "", "android-sdk-v5-uxsdk_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\b`\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Ldji/v5/ux/core/ui/hsi/HSICompassProcesser$CompassListener;", "", "onOrientationChange", "", "strength", "", "degree", "", "android-sdk-v5-uxsdk_debug"})
    public static interface CompassListener {
        public void onOrientationChange(int var1, float var2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldji/v5/ux/core/ui/hsi/HSICompassProcesser$HSICompassSensorEventListener;", "Landroid/hardware/SensorEventListener;", "weakRefHSICompassProcesser", "Ljava/lang/ref/WeakReference;", "Ldji/v5/ux/core/ui/hsi/HSICompassProcesser;", "<init>", "(Ljava/lang/ref/WeakReference;)V", "onSensorChanged", "", "event", "Landroid/hardware/SensorEvent;", "onAccuracyChanged", "sensor", "Landroid/hardware/Sensor;", "accuracy", "", "android-sdk-v5-uxsdk_debug"})
    private static final class HSICompassSensorEventListener
    implements SensorEventListener {
        @NotNull
        private final WeakReference<HSICompassProcesser> weakRefHSICompassProcesser;

        public HSICompassSensorEventListener(@NotNull WeakReference<HSICompassProcesser> weakRefHSICompassProcesser) {
            Intrinsics.checkNotNullParameter(weakRefHSICompassProcesser, (String)"weakRefHSICompassProcesser");
            this.weakRefHSICompassProcesser = weakRefHSICompassProcesser;
        }

        public void onSensorChanged(@Nullable SensorEvent event) {
            block0: {
                HSICompassProcesser hSICompassProcesser = (HSICompassProcesser)this.weakRefHSICompassProcesser.get();
                if (hSICompassProcesser == null) break block0;
                hSICompassProcesser.onSensorChanged(event);
            }
        }

        public void onAccuracyChanged(@Nullable Sensor sensor, int accuracy) {
            block0: {
                HSICompassProcesser hSICompassProcesser = (HSICompassProcesser)this.weakRefHSICompassProcesser.get();
                if (hSICompassProcesser == null) break block0;
                hSICompassProcesser.onAccuracyChanged(sensor, accuracy);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldji/v5/ux/core/ui/hsi/HSICompassProcesser$HSICompassSensorOrientationEventListener;", "Landroid/view/OrientationEventListener;", "weakRefHSICompassProcesser", "Ljava/lang/ref/WeakReference;", "Ldji/v5/ux/core/ui/hsi/HSICompassProcesser;", "context", "Landroid/content/Context;", "<init>", "(Ljava/lang/ref/WeakReference;Landroid/content/Context;)V", "onOrientationChanged", "", "orientation", "", "android-sdk-v5-uxsdk_debug"})
    private static final class HSICompassSensorOrientationEventListener
    extends OrientationEventListener {
        @NotNull
        private final WeakReference<HSICompassProcesser> weakRefHSICompassProcesser;

        public HSICompassSensorOrientationEventListener(@NotNull WeakReference<HSICompassProcesser> weakRefHSICompassProcesser, @NotNull Context context) {
            Intrinsics.checkNotNullParameter(weakRefHSICompassProcesser, (String)"weakRefHSICompassProcesser");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context);
            this.weakRefHSICompassProcesser = weakRefHSICompassProcesser;
        }

        public void onOrientationChanged(int orientation) {
            block0: {
                HSICompassProcesser hSICompassProcesser = (HSICompassProcesser)this.weakRefHSICompassProcesser.get();
                if (hSICompassProcesser == null) break block0;
                hSICompassProcesser.updateScreenOrientation();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldji/v5/ux/core/ui/hsi/HSICompassProcesser$RegisterManager;", "", "sensorManager", "Landroid/hardware/SensorManager;", "mAccelerometerSensor", "Landroid/hardware/Sensor;", "mMagneticSensor", "mRcOriListener", "Landroid/hardware/SensorEventListener;", "orientationEventListener", "Landroid/view/OrientationEventListener;", "<init>", "(Landroid/hardware/SensorManager;Landroid/hardware/Sensor;Landroid/hardware/Sensor;Landroid/hardware/SensorEventListener;Landroid/view/OrientationEventListener;)V", "handler", "Landroid/os/Handler;", "registerSensorListener", "", "unRegisterSensorListener", "android-sdk-v5-uxsdk_debug"})
    private static final class RegisterManager {
        @NotNull
        private final SensorManager sensorManager;
        @Nullable
        private final Sensor mAccelerometerSensor;
        @Nullable
        private final Sensor mMagneticSensor;
        @NotNull
        private final SensorEventListener mRcOriListener;
        @NotNull
        private final OrientationEventListener orientationEventListener;
        @NotNull
        private final Handler handler;

        public RegisterManager(@NotNull SensorManager sensorManager, @Nullable Sensor mAccelerometerSensor, @Nullable Sensor mMagneticSensor, @NotNull SensorEventListener mRcOriListener, @NotNull OrientationEventListener orientationEventListener) {
            Intrinsics.checkNotNullParameter((Object)sensorManager, (String)"sensorManager");
            Intrinsics.checkNotNullParameter((Object)mRcOriListener, (String)"mRcOriListener");
            Intrinsics.checkNotNullParameter((Object)orientationEventListener, (String)"orientationEventListener");
            this.sensorManager = sensorManager;
            this.mAccelerometerSensor = mAccelerometerSensor;
            this.mMagneticSensor = mMagneticSensor;
            this.mRcOriListener = mRcOriListener;
            this.orientationEventListener = orientationEventListener;
            this.handler = new Handler(DJIExecutor.getLooper());
        }

        public final void registerSensorListener() {
            block1: {
                Sensor sensor = this.mAccelerometerSensor;
                if (sensor == null) break block1;
                Sensor it = sensor;
                boolean bl = false;
                Sensor sensor2 = this.mMagneticSensor;
                if (sensor2 != null) {
                    Sensor it2 = sensor2;
                    boolean bl2 = false;
                    this.handler.post(() -> RegisterManager.registerSensorListener$lambda$2$lambda$1$lambda$0(this));
                }
            }
        }

        public final void unRegisterSensorListener() {
            this.handler.post(() -> RegisterManager.unRegisterSensorListener$lambda$3(this));
        }

        private static final void registerSensorListener$lambda$2$lambda$1$lambda$0(RegisterManager this$0) {
            this$0.sensorManager.registerListener(this$0.mRcOriListener, this$0.mAccelerometerSensor, 3, 3, this$0.handler);
            this$0.sensorManager.registerListener(this$0.mRcOriListener, this$0.mMagneticSensor, 3, 3, this$0.handler);
            if (this$0.orientationEventListener.canDetectOrientation()) {
                this$0.orientationEventListener.enable();
            }
        }

        private static final void unRegisterSensorListener$lambda$3(RegisterManager this$0) {
            this$0.sensorManager.unregisterListener(this$0.mRcOriListener);
            if (this$0.orientationEventListener.canDetectOrientation()) {
                this$0.orientationEventListener.disable();
            }
        }
    }
}

