/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.component;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import dji.v5.ux.R;
import dji.v5.ux.core.ui.component.IsothermRangeSeekbar;
import java.text.DecimalFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Ldji/v5/ux/core/ui/component/StreamPaletteRangeSeekbar;", "Ldji/v5/ux/core/ui/component/IsothermRangeSeekbar;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "zoomMultiple", "", "getZoomMultiple", "()D", "setZoomMultiple", "(D)V", "df", "Ljava/text/DecimalFormat;", "getDf", "()Ljava/text/DecimalFormat;", "setDf", "(Ljava/text/DecimalFormat;)V", "drawLeftThumb", "", "canvas", "Landroid/graphics/Canvas;", "drawRightThumb", "getTouchRect", "Landroid/graphics/Rect;", "thumb", "Landroid/graphics/drawable/Drawable;", "android-sdk-v5-uxsdk_debug"})
public final class StreamPaletteRangeSeekbar
extends IsothermRangeSeekbar {
    private double zoomMultiple;
    @NotNull
    private DecimalFormat df;

    public StreamPaletteRangeSeekbar(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.zoomMultiple = 1.0;
        this.df = new DecimalFormat("#.#");
    }

    public /* synthetic */ StreamPaletteRangeSeekbar(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    public final double getZoomMultiple() {
        return this.zoomMultiple;
    }

    public final void setZoomMultiple(double d) {
        this.zoomMultiple = d;
    }

    @NotNull
    public final DecimalFormat getDf() {
        return this.df;
    }

    public final void setDf(@NotNull DecimalFormat decimalFormat) {
        Intrinsics.checkNotNullParameter((Object)decimalFormat, (String)"<set-?>");
        this.df = decimalFormat;
    }

    @Override
    protected void drawLeftThumb(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        int leftTop = this.getHeight() / 2 - this.getThumbHeight() / 2;
        int leftX = this.getThumbPosition(this.mLeftValue) - this.getThumbWidth();
        this.mLeftThumb.setBounds(leftX, leftTop, leftX + this.getThumbWidth(), leftTop + this.getThumbHeight());
        if (this.isEnabled()) {
            this.mLeftThumb.draw(canvas);
        }
        String text = this.zoomMultiple == 1.0 ? String.valueOf(this.getLeftValue()) : this.df.format((double)this.getLeftValue() * this.zoomMultiple).toString();
        this.getTextPaint().getTextBounds(text, 0, text.length(), this.getTextBounds());
        int textRight = leftX + this.getTextBounds().width();
        if (textRight > this.getWidth()) {
            this.getTextPaint().setTextAlign(Paint.Align.RIGHT);
        } else {
            this.getTextPaint().setTextAlign(Paint.Align.LEFT);
        }
        float textTop = (float)this.mLeftThumb.getBounds().bottom + this.getResources().getDimension(R.dimen.uxsdk_4_dp);
        float textLeft = this.mLeftThumb.getBounds().left;
        canvas.drawText(text, textLeft, textTop + (float)this.getTextBounds().height(), this.getTextPaint());
    }

    @Override
    protected void drawRightThumb(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        int rightX = this.getThumbPosition(this.mRightValue);
        int rightTop = this.getHeight() / 2 - this.getThumbHeight() / 2;
        this.mRightThumb.setBounds(rightX, rightTop, rightX + this.getThumbWidth(), rightTop + this.getThumbHeight());
        if (this.isEnabled()) {
            this.mRightThumb.draw(canvas);
        }
        String text = this.zoomMultiple == 1.0 ? String.valueOf(this.getRightValue()) : this.df.format((double)this.getRightValue() * this.zoomMultiple).toString();
        this.getTextPaint().getTextBounds(text, 0, text.length(), this.getTextBounds());
        int textRight = rightX - this.getTextBounds().width();
        if (textRight < 0) {
            this.getTextPaint().setTextAlign(Paint.Align.LEFT);
        } else {
            this.getTextPaint().setTextAlign(Paint.Align.RIGHT);
        }
        float textTop = (float)this.mRightThumb.getBounds().top + this.getResources().getDimension(R.dimen.uxsdk_4_dp);
        float textLeft = this.mRightThumb.getBounds().right;
        canvas.drawText(text, textLeft, textTop - (float)this.getTextBounds().height(), this.getTextPaint());
    }

    @Override
    @NotNull
    protected Rect getTouchRect(@Nullable Drawable thumb) {
        Rect rect = this.mTouchRect = super.getTouchRect(thumb);
        rect.left -= this.getThumbWidth();
        rect = this.mTouchRect;
        rect.right += this.getThumbWidth();
        rect = this.mTouchRect;
        rect.top -= this.getThumbHeight() / 2;
        rect = this.mTouchRect;
        rect.bottom += this.getThumbHeight() / 2;
        Rect rect2 = this.mTouchRect;
        Intrinsics.checkNotNullExpressionValue((Object)rect2, (String)"mTouchRect");
        return rect2;
    }
}

