/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import dji.v5.utils.common.AndUtil;
import dji.v5.ux.R;

public class RangeSeekBar
extends View {
    protected Drawable mLeftThumb;
    protected Drawable mRightThumb;
    protected Drawable mBackgroundDrawable;
    protected Drawable mProgressDrawable;
    protected int mThumbSize;
    protected int mMax = 100;
    protected int mMin = 0;
    protected float mDrawMax = this.mMax;
    protected float mDrawMin = this.mMin;
    protected int mLeftValue = 0;
    protected int mRightValue = this.mMax;
    protected int mMaxHeight;
    protected float mDownX;
    protected float mDownY;
    protected float mLastTouchX;
    protected Drawable mTouchThumb;
    protected Rect mTouchRect = new Rect();
    protected OnChangedListener mOnChangedListener;

    public RangeSeekBar(Context context) {
        this(context, null);
    }

    public RangeSeekBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RangeSeekBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.RangeSeekBar);
        this.mLeftThumb = ta.getDrawable(R.styleable.RangeSeekBar_uxsdk_range_leftThumbDrawable);
        if (this.mLeftThumb == null) {
            this.mLeftThumb = this.getResources().getDrawable(R.drawable.uxsdk_ic_temp_cold);
        }
        this.mRightThumb = ta.getDrawable(R.styleable.RangeSeekBar_uxsdk_range_rightThumbDrawable);
        if (this.mRightThumb == null) {
            this.mRightThumb = this.getResources().getDrawable(R.drawable.uxsdk_ic_temp_hot);
        }
        this.mBackgroundDrawable = ta.getDrawable(R.styleable.RangeSeekBar_uxsdk_range_backgroundDrawable);
        if (this.mBackgroundDrawable == null) {
            this.mBackgroundDrawable = this.getResources().getDrawable(R.drawable.uxsdk_range_seekbar_bg);
        }
        this.mProgressDrawable = ta.getDrawable(R.styleable.RangeSeekBar_uxsdk_range_progressDrawable);
        if (this.mProgressDrawable == null) {
            this.mProgressDrawable = this.getResources().getDrawable(R.drawable.uxsdk_ic_isotherm_seekbar);
        }
        this.mThumbSize = ta.getDimensionPixelSize(R.styleable.RangeSeekBar_uxsdk_range_thumbSize, 0);
        if (this.mThumbSize == 0) {
            this.mLeftThumb.getIntrinsicWidth();
        }
        this.mMaxHeight = ta.getDimensionPixelSize(R.styleable.RangeSeekBar_uxsdk_range_progressHeight, AndUtil.dip2px((Context)context, (float)3.0f));
        ta.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightNeeded = this.mThumbSize;
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        heightMeasureSpec = heightMode == 0x40000000 ? View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)0x40000000) : (heightMode == Integer.MIN_VALUE ? View.MeasureSpec.makeMeasureSpec((int)(heightSize < heightNeeded ? heightSize : heightNeeded), (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)heightNeeded, (int)0x40000000));
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawBackground(canvas);
        this.drawProgress(canvas);
        this.drawLeftThumb(canvas);
        this.drawRightThumb(canvas);
    }

    protected void drawBackground(Canvas canvas) {
        int paddingLeft = this.getPaddingLeft() + this.mThumbSize / 2;
        int paddingRight = this.getPaddingRight() + this.mThumbSize / 2;
        this.mBackgroundDrawable.setBounds(paddingLeft, this.getHeight() / 2 - this.mMaxHeight / 2, this.getWidth() - paddingRight, this.getHeight() / 2 + this.mMaxHeight / 2);
        this.mBackgroundDrawable.draw(canvas);
    }

    protected void drawProgress(Canvas canvas) {
        int leftX = this.getThumbPosition(this.mLeftValue);
        int rightX = this.getThumbPosition(this.mRightValue);
        this.mProgressDrawable.setBounds(leftX, this.mBackgroundDrawable.getBounds().top, rightX, this.mBackgroundDrawable.getBounds().bottom);
        this.mProgressDrawable.draw(canvas);
    }

    protected void drawLeftThumb(Canvas canvas) {
        this.mLeftThumb.setBounds(this.getThumbPosition(this.mLeftValue) - this.mThumbSize / 2, 0, this.getThumbPosition(this.mLeftValue) + this.mThumbSize / 2, this.mThumbSize);
        this.mLeftThumb.draw(canvas);
    }

    protected void drawRightThumb(Canvas canvas) {
        this.mRightThumb.setBounds(this.getThumbPosition(this.mRightValue) - this.mThumbSize / 2, 0, this.getThumbPosition(this.mRightValue) + this.mThumbSize / 2, this.mThumbSize);
        this.mRightThumb.draw(canvas);
    }

    protected int getThumbPosition(int value) {
        float width = (float)(this.getWidth() - this.getPaddingRight()) - (float)this.mThumbSize / 2.0f - (float)this.getPaddingLeft() - (float)this.mThumbSize / 2.0f;
        float range = this.mDrawMax - this.mDrawMin;
        float v = (float)value - this.mDrawMin;
        return Math.round(v / range * width) + this.getPaddingLeft() + this.mThumbSize / 2;
    }

    protected int getValueByDelta(float delta) {
        int width = this.getWidth() - this.getPaddingRight() - this.getPaddingLeft() - this.mThumbSize;
        int range = this.mMax - this.mMin;
        return Math.round(delta / (float)width * (float)range);
    }

    public int getMax() {
        return this.mMax;
    }

    public void setMax(int max) {
        if (max == this.mMax) {
            return;
        }
        this.mMax = max;
        this.mDrawMax = this.mMax;
        this.postInvalidate();
    }

    public int getMin() {
        return this.mMin;
    }

    public void setMin(int min) {
        if (min == this.mMin) {
            return;
        }
        this.mMin = min;
        this.mDrawMin = this.mMin;
        this.postInvalidate();
    }

    public int getLeftValue() {
        return this.mLeftValue;
    }

    public void setLeftValue(int leftValue) {
        if (leftValue < this.mMin) {
            leftValue = this.mMin;
        }
        if (this.mLeftValue == leftValue) {
            return;
        }
        this.mLeftValue = leftValue;
        this.postInvalidate();
    }

    public int getRightValue() {
        return this.mRightValue;
    }

    public void setRightValue(int rightValue) {
        if (rightValue > this.mMax) {
            rightValue = this.mMax;
        }
        if (this.mRightValue == rightValue) {
            return;
        }
        this.mRightValue = rightValue;
        this.postInvalidate();
    }

    public void animateMax(int max) {
        if (max == this.mMax || max <= this.mMin) {
            return;
        }
        ValueAnimator objectAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mMax, max});
        objectAnimator.setDuration(200L);
        objectAnimator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        objectAnimator.addUpdateListener(animation -> {
            this.mDrawMax = ((Float)animation.getAnimatedValue()).floatValue();
            this.postInvalidate();
        });
        objectAnimator.start();
        this.mMax = max;
    }

    public void animateMin(int min) {
        if (min == this.mMin || min >= this.mMax) {
            return;
        }
        ValueAnimator objectAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mMin, min});
        objectAnimator.setDuration(200L);
        objectAnimator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        objectAnimator.addUpdateListener(animation -> {
            this.mDrawMin = ((Float)animation.getAnimatedValue()).floatValue();
            this.postInvalidate();
        });
        objectAnimator.start();
        this.mMin = min;
    }

    public OnChangedListener getOnChangedListener() {
        return this.mOnChangedListener;
    }

    public void setOnChangedListener(OnChangedListener onChangedListener) {
        this.mOnChangedListener = onChangedListener;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                if (!this.handleTouchDown(event)) break;
                return false;
            }
            case 2: {
                this.handleTouchMove(event);
                break;
            }
            case 1: 
            case 3: {
                this.mTouchThumb = null;
                this.onSeekEnd();
                break;
            }
        }
        return true;
    }

    private void handleTouchMove(MotionEvent event) {
        float x = event.getX();
        float delta = x - this.mLastTouchX;
        this.mLastTouchX = x;
        int value = this.getValueByDelta(Math.abs(delta));
        if (delta < 0.0f) {
            value = -value;
        }
        if (this.mTouchThumb == this.mLeftThumb) {
            int newValue = this.mLeftValue + value;
            if (newValue < this.mMin) {
                newValue = this.mMin;
            }
            if (newValue >= this.mRightValue) {
                newValue = this.mRightValue - 1;
            }
            this.mLeftValue = newValue;
            this.onValueChanged(true);
        } else if (this.mTouchThumb == this.mRightThumb) {
            int newValue = this.mRightValue + value;
            if (newValue <= this.mLeftValue) {
                newValue = this.mLeftValue + 1;
            }
            if (newValue > this.mMax) {
                newValue = this.mMax;
            }
            this.mRightValue = newValue;
            this.onValueChanged(true);
        }
        this.postInvalidate();
    }

    private boolean handleTouchDown(MotionEvent event) {
        this.mDownX = event.getX();
        this.mDownY = event.getY();
        this.mLastTouchX = event.getX();
        if (this.getTouchRect(this.mLeftThumb).contains((int)this.mDownX, (int)this.mDownY)) {
            this.mTouchThumb = this.mLeftThumb;
            this.onSeekStart();
        } else if (this.getTouchRect(this.mRightThumb).contains((int)this.mDownX, (int)this.mDownY)) {
            this.mTouchThumb = this.mRightThumb;
            this.onSeekStart();
        }
        return this.mTouchThumb == null;
    }

    protected Rect getTouchRect(Drawable thumb) {
        this.mTouchRect.set(thumb.getBounds().left - this.mThumbSize / 2, thumb.getBounds().top, thumb.getBounds().right + this.mThumbSize / 2, thumb.getBounds().bottom);
        return this.mTouchRect;
    }

    private void onSeekStart() {
        if (this.mOnChangedListener != null) {
            this.mOnChangedListener.onSeekStart(this);
        }
    }

    private void onValueChanged(boolean fromUser) {
        if (this.mOnChangedListener != null) {
            this.mOnChangedListener.onValueChanged(this, this.mLeftValue, this.mRightValue, fromUser);
        }
    }

    private void onSeekEnd() {
        if (this.mOnChangedListener != null) {
            this.mOnChangedListener.onSeekEnd(this);
        }
    }

    public static interface OnChangedListener {
        public void onSeekStart(RangeSeekBar var1);

        public void onValueChanged(RangeSeekBar var1, int var2, int var3, boolean var4);

        public void onSeekEnd(RangeSeekBar var1);
    }
}

