/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.widget.fpvinteraction;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.value.camera.CameraExposureCompensation;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.R;
import dji.v5.ux.cameracore.widget.fpvinteraction.ExposureMeteringWidgetModel;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.ui.VerticalSeekBar;
import dji.v5.ux.core.ui.exposure.ExposeVSeekBar;
import dji.v5.ux.core.util.SettingDefinitions;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.kotlin.Flowables;
import java.util.List;
import kotlin.collections.CollectionsKt;

public class ExposureMeteringWidget
extends ConstraintLayoutWidget<Object>
implements ICameraIndex {
    protected static final float DEFAULT_CENTER_METER_SCALE_X = 1.376f;
    protected static final float DEFAULT_CENTER_METER_SCALE_Y = 1.0f;
    private float centerMeterScaleX = 1.376f;
    private float centerMeterScaleY = 1.0f;
    private ExposureMeteringWidgetModel widgetModel;
    private ExposeVSeekBar mExposeVSeekBar;

    public ExposureMeteringWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public ExposureMeteringWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public ExposureMeteringWidget(@NonNull Context context) {
        super(context);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        ExposureMeteringWidget.inflate((Context)context, (int)R.layout.uxsdk_expose_focus_view, (ViewGroup)this);
        if (!this.isInEditMode()) {
            this.widgetModel = new ExposureMeteringWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
        }
        this.initSeekBar();
    }

    @Override
    protected void reactToModelChanges() {
        Disposable d = Flowables.INSTANCE.combineLatest(this.widgetModel.exposureCompensationProcessor.toFlowable(), this.widgetModel.compensationRangeProcessor.toFlowable()).observeOn(SchedulerProvider.ui()).subscribe(cameraExposureCompensationListPair -> {
            List evList = (List)cameraExposureCompensationListPair.component2();
            CameraExposureCompensation ev = (CameraExposureCompensation)cameraExposureCompensationListPair.component1();
            if (evList == null || evList.size() <= 0) {
                return;
            }
            int index = CollectionsKt.indexOf((List)evList, (Object)ev);
            if (index < 0) {
                return;
            }
            this.mExposeVSeekBar.setMax(evList.size() - 1);
            this.mExposeVSeekBar.setProgress(index);
        }, throwable -> {});
        this.addReaction(d);
    }

    @Override
    @Nullable
    public String getIdealDimensionRatioString() {
        return null;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
        super.onDetachedFromWindow();
    }

    public void initSeekBar() {
        this.mExposeVSeekBar = (ExposeVSeekBar)this.findViewById(R.id.expose_level_seekbar);
        this.mExposeVSeekBar.setMax(100);
        this.mExposeVSeekBar.setShowSeekBar(true);
        this.mExposeVSeekBar.setOnChangeListener(new VerticalSeekBar.OnVSBChangeListener(){

            @Override
            public void onProgressChanged(VerticalSeekBar bar, int value, boolean fromUser) {
                if (!fromUser) {
                    return;
                }
                ExposureMeteringWidget.this.invalidate();
                ExposureMeteringWidget.this.addDisposable(ExposureMeteringWidget.this.widgetModel.setEV(value).observeOn(SchedulerProvider.ui()).subscribe(() -> {}));
            }

            @Override
            public void onStartTrackingTouch(VerticalSeekBar bar) {
                ExposureMeteringWidget.this.showProgressBar();
            }

            @Override
            public void onStopTrackingTouch(VerticalSeekBar bar) {
                ExposureMeteringWidget.this.hideProgressBar();
            }
        });
    }

    private void showProgressBar() {
        this.invalidate();
    }

    private void hideProgressBar() {
        this.invalidate();
    }

    public SettingDefinitions.ControlMode clickEvent(@NonNull SettingDefinitions.ControlMode controlMode, float x, float y, float parentWidth, float parentHeight) {
        switch (controlMode) {
            case CENTER_METER: 
            case SPOT_METER: {
                this.addImageBackground();
                this.setX(x -= (float)this.getWidth() / 2.0f);
                this.setY(y -= (float)this.getHeight() / 2.0f);
                break;
            }
        }
        return SettingDefinitions.ControlMode.SPOT_METER;
    }

    private void addImageBackground() {
        this.setScaleX(1.0f);
        this.setScaleY(1.0f);
    }

    public void removeImageBackground() {
        this.setBackground(null);
    }

    public float getCenterMeterScaleX() {
        return this.centerMeterScaleX;
    }

    public void setCenterMeterScaleX(float centerMeterScaleX) {
        this.centerMeterScaleX = centerMeterScaleX;
    }

    public float getCenterMeterScaleY() {
        return this.centerMeterScaleY;
    }

    public void setCenterMeterScaleY(float centerMeterScaleY) {
        this.centerMeterScaleY = centerMeterScaleY;
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.widgetModel.getCameraIndex();
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.widgetModel.getLensType();
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.widgetModel.updateCameraSource(cameraIndex, lensType);
    }
}

