/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.battery;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;

public class BatteryAlertWidgetModel
extends WidgetModel {
    private final DataProcessor<Integer> lowBatteryWarningProcessor = DataProcessor.create(0);
    private final DataProcessor<Integer> seriousLowBatteryWarningProcessor = DataProcessor.create(0);
    private final DataProcessor<Boolean> connectionProcessor = DataProcessor.create(false);

    protected BatteryAlertWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore uxKeyManager) {
        super(djiSdkModel, uxKeyManager);
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyLowBatteryWarningThreshold), this.lowBatteryWarningProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeySeriousLowBatteryWarningThreshold), this.seriousLowBatteryWarningProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyConnection), this.connectionProcessor);
    }

    @Override
    protected void inCleanup() {
    }

    public Completable changeLowBatteryWarning(int value) {
        return this.djiSdkModel.setValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyLowBatteryWarningThreshold), value);
    }

    public Completable changeSeriousLowBatteryWarning(int value) {
        return this.djiSdkModel.setValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeySeriousLowBatteryWarningThreshold), value);
    }

    public Flowable<Integer> getLowBatteryWarning() {
        return this.lowBatteryWarningProcessor.toFlowableOnUI();
    }

    public Flowable<Integer> getSeriousLowBatteryWarning() {
        return this.seriousLowBatteryWarningProcessor.toFlowableOnUI();
    }

    public Flowable<Boolean> getConnection() {
        return this.connectionProcessor.toFlowableOnUI();
    }
}

