/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.widget.cameracontrols.photovideoswitch;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.R;
import dji.v5.ux.cameracore.widget.cameracontrols.RemoteControllerButtonDownModel;
import dji.v5.ux.cameracore.widget.cameracontrols.photovideoswitch.PhotoVideoSwitchWidgetModel;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.FrameLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.UxErrorHandle;

public class PhotoVideoSwitchWidget
extends FrameLayoutWidget<Object>
implements View.OnClickListener,
ICameraIndex {
    private static final String TAG = "PhotoVideoSwitchWidget";
    private ImageView foregroundImageView;
    private Drawable photoModeDrawable;
    private Drawable videoModeDrawable;
    private PhotoVideoSwitchWidgetModel widgetModel;
    private RemoteControllerButtonDownModel buttonDownModel;

    public PhotoVideoSwitchWidget(@NonNull Context context) {
        super(context);
    }

    public PhotoVideoSwitchWidget(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public PhotoVideoSwitchWidget(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        PhotoVideoSwitchWidget.inflate((Context)context, (int)R.layout.uxsdk_widget_photo_video_switch, (ViewGroup)this);
        this.foregroundImageView = (ImageView)this.findViewById(R.id.image_view_foreground);
        if (!this.isInEditMode()) {
            this.widgetModel = new PhotoVideoSwitchWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
            this.buttonDownModel = new RemoteControllerButtonDownModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
            this.setOnClickListener(this);
        }
        this.photoModeDrawable = this.getResources().getDrawable(R.drawable.uxsdk_ic_camera_mode_photo);
        this.videoModeDrawable = this.getResources().getDrawable(R.drawable.uxsdk_ic_camera_mode_video);
        if (attrs != null) {
            this.initAttributes(context, attrs);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
            this.buttonDownModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
            this.buttonDownModel.cleanup();
        }
        super.onDetachedFromWindow();
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.isEnabled().observeOn(SchedulerProvider.ui()).subscribe(this::enableWidget));
        this.addReaction(this.widgetModel.isPictureMode().observeOn(SchedulerProvider.ui()).subscribe(this::updateUI));
        this.addReaction(this.buttonDownModel.isShutterButtonDownProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe(aBoolean -> {
            if (aBoolean == Boolean.TRUE) {
                this.widgetModel.changeToPhotoMode();
            }
        }));
        this.addReaction(this.buttonDownModel.isRecordButtonDownProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe(aBoolean -> {
            if (aBoolean == Boolean.TRUE) {
                this.widgetModel.changeToVideoMode();
            }
        }));
    }

    @Override
    @NonNull
    public String getIdealDimensionRatioString() {
        return this.getResources().getString(R.string.uxsdk_widget_default_ratio);
    }

    public void onClick(View v) {
        this.widgetModel.toggleCameraMode().observeOn(SchedulerProvider.ui()).subscribe(() -> {}, UxErrorHandle.logErrorConsumer(TAG, "Switch camera Mode"));
    }

    private void initAttributes(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.PhotoVideoSwitchWidget);
        if (!this.isInEditMode()) {
            this.updateCameraSource(ComponentIndexType.find((int)typedArray.getInt(R.styleable.PhotoVideoSwitchWidget_uxsdk_cameraIndex, 0)), CameraLensType.UNKNOWN);
        }
        if (typedArray.getDrawable(R.styleable.PhotoVideoSwitchWidget_uxsdk_photoModeIcon) != null) {
            this.photoModeDrawable = typedArray.getDrawable(R.styleable.PhotoVideoSwitchWidget_uxsdk_photoModeIcon);
        }
        if (typedArray.getDrawable(R.styleable.PhotoVideoSwitchWidget_uxsdk_videoModeIcon) != null) {
            this.videoModeDrawable = typedArray.getDrawable(R.styleable.PhotoVideoSwitchWidget_uxsdk_videoModeIcon);
        }
        this.setIconBackground(typedArray.getDrawable(R.styleable.PhotoVideoSwitchWidget_uxsdk_iconBackground));
        typedArray.recycle();
    }

    private void updateUI(boolean isPictureMode) {
        if (isPictureMode) {
            this.foregroundImageView.setImageDrawable(this.photoModeDrawable);
        } else {
            this.foregroundImageView.setImageDrawable(this.videoModeDrawable);
        }
    }

    private void enableWidget(Boolean isEnabled) {
        this.setEnabled(isEnabled);
    }

    private void checkAndUpdateUI() {
        if (!this.isInEditMode()) {
            this.addDisposable(this.widgetModel.isPictureMode().firstOrError().observeOn(SchedulerProvider.ui()).subscribe(this::updateUI, UxErrorHandle.logErrorConsumer(TAG, "Update UI ")));
        }
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.widgetModel.getCameraIndex();
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.widgetModel.getLensType();
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.widgetModel.updateCameraSource(cameraIndex, lensType);
    }

    @Nullable
    public Drawable getPhotoModeIcon() {
        return this.photoModeDrawable;
    }

    public void setPhotoModeIcon(@DrawableRes int resourceId) {
        this.setPhotoModeIcon(this.getResources().getDrawable(resourceId));
    }

    public void setPhotoModeIcon(@Nullable Drawable drawable2) {
        this.photoModeDrawable = drawable2;
        this.checkAndUpdateUI();
    }

    @Nullable
    public Drawable getVideoModeIcon() {
        return this.videoModeDrawable;
    }

    public void setVideoModeIcon(@DrawableRes int resourceId) {
        this.setVideoModeIcon(this.getResources().getDrawable(resourceId));
    }

    public void setVideoModeIcon(@Nullable Drawable drawable2) {
        this.videoModeDrawable = drawable2;
        this.checkAndUpdateUI();
    }

    @Nullable
    public Drawable getIconBackground() {
        return this.foregroundImageView.getBackground();
    }

    public void setIconBackground(@DrawableRes int resourceId) {
        this.foregroundImageView.setBackgroundResource(resourceId);
    }

    public void setIconBackground(@Nullable Drawable drawable2) {
        this.foregroundImageView.setBackground(drawable2);
    }
}

