/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.accessory;

import dji.rtk.CoordinateSystem;
import dji.sdk.keyvalue.key.DJIKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.key.ProductKey;
import dji.sdk.keyvalue.utils.ProductUtil;
import dji.sdk.keyvalue.value.product.ProductType;
import dji.sdk.keyvalue.value.rtkbasestation.RTKReferenceStationSource;
import dji.v5.common.utils.RxUtil;
import dji.v5.manager.KeyManager;
import dji.v5.manager.aircraft.rtk.RTKSystemState;
import dji.v5.manager.aircraft.rtk.RTKSystemStateListener;
import dji.v5.manager.areacode.AreaCode;
import dji.v5.manager.areacode.AreaCodeChangeListener;
import dji.v5.manager.areacode.AreaCodeData;
import dji.v5.manager.areacode.AreaCodeManager;
import dji.v5.manager.interfaces.IAreaCodeManager;
import dji.v5.manager.interfaces.INetworkRTKManager;
import dji.v5.manager.interfaces.IRTKCenter;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Consumer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0004\u0018\u0000 82\u00020\u0001:\u00018B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010.\u001a\u00020/H\u0014J\b\u00100\u001a\u00020/H\u0014J\b\u00101\u001a\u00020/H\u0002J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u00103\u001a\u00020\u001cH\u0002J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u0013052\u0006\u00103\u001a\u00020\u001cH\u0002J\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020\u0013052\u0006\u00103\u001a\u00020\u001cH\u0002J\b\u00107\u001a\u00020\u001cH\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001c0&8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010'R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00130&8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010'R\u001d\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00120&8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010'R\u001d\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120&8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010'\u00a8\u00069"}, d2={"Ldji/v5/ux/accessory/RTKTypeSwitchWidgetModel;", "Ldji/v5/ux/core/base/WidgetModel;", "djiSdkModel", "Ldji/v5/ux/core/base/DJISDKModel;", "uxKeyManager", "Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;", "areaCodeManager", "Ldji/v5/manager/interfaces/IAreaCodeManager;", "rtkCenter", "Ldji/v5/manager/interfaces/IRTKCenter;", "<init>", "(Ldji/v5/ux/core/base/DJISDKModel;Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;Ldji/v5/manager/interfaces/IAreaCodeManager;Ldji/v5/manager/interfaces/IRTKCenter;)V", "getAreaCodeManager", "()Ldji/v5/manager/interfaces/IAreaCodeManager;", "getRtkCenter", "()Ldji/v5/manager/interfaces/IRTKCenter;", "supportReferenceStationListProcessor", "Ldji/v5/ux/core/util/DataProcessor;", "", "Ldji/sdk/keyvalue/value/rtkbasestation/RTKReferenceStationSource;", "areaCodeProcessor", "", "productTypeProcessor", "Ldji/sdk/keyvalue/value/product/ProductType;", "rtkSourceProcessor", "coordinateSystemListProcessor", "Ldji/rtk/CoordinateSystem;", "isMotorOnProcessor", "", "qxRTKManager", "Ldji/v5/manager/interfaces/INetworkRTKManager;", "customNetworkRTKManager", "currentRtkSource", "areaCodeChangeListener", "Ldji/v5/manager/areacode/AreaCodeChangeListener;", "rtkSystemStateListener", "Ldji/v5/manager/aircraft/rtk/RTKSystemStateListener;", "isMotorsOn", "Lio/reactivex/rxjava3/core/Flowable;", "()Lio/reactivex/rxjava3/core/Flowable;", "rtkSource", "getRtkSource", "coordinateSystemList", "getCoordinateSystemList", "supportReferenceStationList", "getSupportReferenceStationList", "inSetup", "", "inCleanup", "updateSupportReferenceStationList", "getSupportReferenceStationSource", "supportNetworkRTK", "getMavicSupportReferenceStationSource", "", "getDefaultSupportReferenceStationSource", "isInChina", "Companion", "android-sdk-v5-uxsdk_release"})
public final class RTKTypeSwitchWidgetModel
extends WidgetModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IAreaCodeManager areaCodeManager;
    @NotNull
    private final IRTKCenter rtkCenter;
    @NotNull
    private final DataProcessor<List<RTKReferenceStationSource>> supportReferenceStationListProcessor;
    @NotNull
    private final DataProcessor<String> areaCodeProcessor;
    @NotNull
    private final DataProcessor<ProductType> productTypeProcessor;
    @NotNull
    private final DataProcessor<RTKReferenceStationSource> rtkSourceProcessor;
    @NotNull
    private final DataProcessor<List<CoordinateSystem>> coordinateSystemListProcessor;
    @NotNull
    private final DataProcessor<Boolean> isMotorOnProcessor;
    @Nullable
    private INetworkRTKManager qxRTKManager;
    @Nullable
    private INetworkRTKManager customNetworkRTKManager;
    @NotNull
    private RTKReferenceStationSource currentRtkSource;
    @NotNull
    private final AreaCodeChangeListener areaCodeChangeListener;
    @NotNull
    private final RTKSystemStateListener rtkSystemStateListener;
    @NotNull
    private static final String TAG = "RTKTypeSwitchWidgetModel";
    @NotNull
    private static final String CUSTOM_RTK_SETTING_CACHE = "customRTKSettingCache";

    public RTKTypeSwitchWidgetModel(@NotNull DJISDKModel djiSdkModel, @NotNull ObservableInMemoryKeyedStore uxKeyManager, @NotNull IAreaCodeManager areaCodeManager, @NotNull IRTKCenter rtkCenter) {
        Intrinsics.checkNotNullParameter((Object)djiSdkModel, (String)"djiSdkModel");
        Intrinsics.checkNotNullParameter((Object)uxKeyManager, (String)"uxKeyManager");
        Intrinsics.checkNotNullParameter((Object)areaCodeManager, (String)"areaCodeManager");
        Intrinsics.checkNotNullParameter((Object)rtkCenter, (String)"rtkCenter");
        super(djiSdkModel, uxKeyManager);
        this.areaCodeManager = areaCodeManager;
        this.rtkCenter = rtkCenter;
        DataProcessor dataProcessor = DataProcessor.create(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(dataProcessor, (String)"create(...)");
        this.supportReferenceStationListProcessor = dataProcessor;
        DataProcessor<String> dataProcessor2 = DataProcessor.create(AreaCode.UNKNOWN.getCode());
        Intrinsics.checkNotNullExpressionValue(dataProcessor2, (String)"create(...)");
        this.areaCodeProcessor = dataProcessor2;
        DataProcessor<ProductType> dataProcessor3 = DataProcessor.create(ProductType.UNKNOWN);
        Intrinsics.checkNotNullExpressionValue(dataProcessor3, (String)"create(...)");
        this.productTypeProcessor = dataProcessor3;
        DataProcessor<RTKReferenceStationSource> dataProcessor4 = DataProcessor.create(RTKReferenceStationSource.UNKNOWN);
        Intrinsics.checkNotNullExpressionValue(dataProcessor4, (String)"create(...)");
        this.rtkSourceProcessor = dataProcessor4;
        DataProcessor dataProcessor5 = DataProcessor.create(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(dataProcessor5, (String)"create(...)");
        this.coordinateSystemListProcessor = dataProcessor5;
        DataProcessor<Boolean> dataProcessor6 = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor6, (String)"create(...)");
        this.isMotorOnProcessor = dataProcessor6;
        this.currentRtkSource = RTKReferenceStationSource.UNKNOWN;
        this.areaCodeChangeListener = (arg_0, arg_1) -> RTKTypeSwitchWidgetModel.areaCodeChangeListener$lambda$0(this, arg_0, arg_1);
        this.rtkSystemStateListener = arg_0 -> RTKTypeSwitchWidgetModel.rtkSystemStateListener$lambda$1(this, arg_0);
        this.qxRTKManager = this.rtkCenter.getQXRTKManager();
        this.customNetworkRTKManager = this.rtkCenter.getCustomRTKManager();
    }

    @NotNull
    public final IAreaCodeManager getAreaCodeManager() {
        return this.areaCodeManager;
    }

    @NotNull
    public final IRTKCenter getRtkCenter() {
        return this.rtkCenter;
    }

    @NotNull
    public final Flowable<Boolean> isMotorsOn() {
        Flowable<Boolean> flowable = this.isMotorOnProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<RTKReferenceStationSource> getRtkSource() {
        Flowable<RTKReferenceStationSource> flowable = this.rtkSourceProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<List<CoordinateSystem>> getCoordinateSystemList() {
        Flowable<List<CoordinateSystem>> flowable = this.coordinateSystemListProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<List<RTKReferenceStationSource>> getSupportReferenceStationList() {
        Flowable<List<RTKReferenceStationSource>> flowable = this.supportReferenceStationListProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyAreMotorsOn), this.isMotorOnProcessor);
        this.addDisposable(RxUtil.addListener((DJIKey)KeyTools.createKey((DJIKeyInfo)ProductKey.KeyProductType), (Object)this).subscribe(new Consumer(this){
            final /* synthetic */ RTKTypeSwitchWidgetModel this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(ProductType it) {
                RTKTypeSwitchWidgetModel.access$getProductTypeProcessor$p(this.this$0).onNext(it);
                RTKTypeSwitchWidgetModel.access$updateSupportReferenceStationList(this.this$0);
            }
        }));
        this.areaCodeManager.addAreaCodeChangeListener(this.areaCodeChangeListener);
        this.rtkCenter.addRTKSystemStateListener(this.rtkSystemStateListener);
    }

    @Override
    protected void inCleanup() {
        this.areaCodeManager.removeAreaCodeChangeListener(this.areaCodeChangeListener);
        this.rtkCenter.removeRTKSystemStateListener(this.rtkSystemStateListener);
        KeyManager.getInstance().cancelListen((Object)this);
    }

    private final void updateSupportReferenceStationList() {
        if (ProductType.DJI_MAVIC_3_ENTERPRISE_SERIES == this.productTypeProcessor.getValue()) {
            if (Intrinsics.areEqual((Object)this.areaCodeProcessor.getValue(), (Object)AreaCode.CHINA.getCode())) {
                this.supportReferenceStationListProcessor.onNext(this.getSupportReferenceStationSource(true));
            } else {
                this.supportReferenceStationListProcessor.onNext(this.getSupportReferenceStationSource(false));
            }
        } else {
            this.supportReferenceStationListProcessor.onNext(this.getSupportReferenceStationSource(this.isInChina()));
        }
    }

    private final List<RTKReferenceStationSource> getSupportReferenceStationSource(boolean supportNetworkRTK) {
        return ProductUtil.isM3EProduct() || ProductUtil.isM4EProduct() || ProductUtil.isM4DProduct() ? this.getMavicSupportReferenceStationSource(supportNetworkRTK) : this.getDefaultSupportReferenceStationSource(supportNetworkRTK);
    }

    private final List<RTKReferenceStationSource> getMavicSupportReferenceStationSource(boolean supportNetworkRTK) {
        List list;
        if (supportNetworkRTK) {
            Object[] objectArray = new RTKReferenceStationSource[]{RTKReferenceStationSource.NONE, RTKReferenceStationSource.BASE_STATION, RTKReferenceStationSource.NTRIP_NETWORK_SERVICE, RTKReferenceStationSource.CUSTOM_NETWORK_SERVICE};
            list = CollectionsKt.mutableListOf((Object[])objectArray);
        } else {
            Object[] objectArray = new RTKReferenceStationSource[]{RTKReferenceStationSource.NONE, RTKReferenceStationSource.BASE_STATION, RTKReferenceStationSource.CUSTOM_NETWORK_SERVICE};
            list = CollectionsKt.mutableListOf((Object[])objectArray);
        }
        return list;
    }

    private final List<RTKReferenceStationSource> getDefaultSupportReferenceStationSource(boolean supportNetworkRTK) {
        List list;
        Object[] objectArray = new Object[]{"supportNetworkRTK=" + supportNetworkRTK};
        LogUtils.i((String)TAG, (Object[])objectArray);
        if (supportNetworkRTK) {
            objectArray = new RTKReferenceStationSource[]{RTKReferenceStationSource.NONE, RTKReferenceStationSource.BASE_STATION, RTKReferenceStationSource.QX_NETWORK_SERVICE, RTKReferenceStationSource.NTRIP_NETWORK_SERVICE, RTKReferenceStationSource.CUSTOM_NETWORK_SERVICE};
            list = CollectionsKt.mutableListOf((Object[])objectArray);
        } else {
            objectArray = new RTKReferenceStationSource[]{RTKReferenceStationSource.NONE, RTKReferenceStationSource.BASE_STATION, RTKReferenceStationSource.CUSTOM_NETWORK_SERVICE};
            list = CollectionsKt.mutableListOf((Object[])objectArray);
        }
        return list;
    }

    private final boolean isInChina() {
        String countryCode = AreaCodeManager.getInstance().getAreaCode().getAreaCode();
        return AreaCode.CHINA.getCode().equals(countryCode);
    }

    private static final void areaCodeChangeListener$lambda$0(RTKTypeSwitchWidgetModel this$0, AreaCodeData areaCodeData, AreaCodeData result) {
        this$0.areaCodeProcessor.onNext(result.getAreaCode());
        this$0.updateSupportReferenceStationList();
    }

    private static final void rtkSystemStateListener$lambda$1(RTKTypeSwitchWidgetModel this$0, RTKSystemState it) {
        RTKReferenceStationSource rtkSource = it.getRtkReferenceStationSource();
        List coordinateSystemList = new ArrayList();
        RTKReferenceStationSource rTKReferenceStationSource = rtkSource;
        switch (rTKReferenceStationSource == null ? -1 : WhenMappings.$EnumSwitchMapping$0[rTKReferenceStationSource.ordinal()]) {
            case 1: 
            case 2: {
                Object[] objectArray = new CoordinateSystem[]{CoordinateSystem.WGS84, CoordinateSystem.CGCS2000};
                coordinateSystemList = CollectionsKt.arrayListOf((Object[])objectArray);
            }
        }
        if (this$0.currentRtkSource != rtkSource) {
            this$0.currentRtkSource = rtkSource;
            this$0.rtkSourceProcessor.onNext(rtkSource);
            this$0.coordinateSystemListProcessor.onNext(coordinateSystemList);
        }
    }

    public static final /* synthetic */ DataProcessor access$getProductTypeProcessor$p(RTKTypeSwitchWidgetModel $this) {
        return $this.productTypeProcessor;
    }

    public static final /* synthetic */ void access$updateSupportReferenceStationList(RTKTypeSwitchWidgetModel $this) {
        $this.updateSupportReferenceStationList();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ldji/v5/ux/accessory/RTKTypeSwitchWidgetModel$Companion;", "", "<init>", "()V", "TAG", "", "CUSTOM_RTK_SETTING_CACHE", "android-sdk-v5-uxsdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RTKReferenceStationSource.values().length];
            try {
                nArray[RTKReferenceStationSource.QX_NETWORK_SERVICE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKReferenceStationSource.NTRIP_NETWORK_SERVICE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

