/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.visualcamera.iso;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.CameraKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.camera.CameraExposureSettings;
import dji.sdk.keyvalue.value.camera.CameraISO;
import dji.sdk.keyvalue.value.camera.ExposureSensitivityMode;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Flowable;

public class CameraConfigISOAndEIWidgetModel
extends WidgetModel
implements ICameraIndex {
    protected static final String LOCKED_ISO_VALUE = "500";
    private final DataProcessor<CameraExposureSettings> exposureSettingsProcessor;
    private final DataProcessor<CameraISO> isoProcessor;
    private final DataProcessor<ExposureSensitivityMode> exposureSensitivityModeProcessor;
    private final DataProcessor<Integer> eiValueProcessor;
    private final DataProcessor<String> isoAndEIValueProcessor;
    private ComponentIndexType cameraIndex = ComponentIndexType.LEFT_OR_MAIN;
    private CameraLensType lensType = CameraLensType.CAMERA_LENS_ZOOM;

    public CameraConfigISOAndEIWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore keyedStore) {
        super(djiSdkModel, keyedStore);
        this.exposureSettingsProcessor = DataProcessor.create(new CameraExposureSettings());
        this.isoProcessor = DataProcessor.create(CameraISO.UNKNOWN);
        this.exposureSensitivityModeProcessor = DataProcessor.create(ExposureSensitivityMode.UNKNOWN);
        this.eiValueProcessor = DataProcessor.create(0);
        this.isoAndEIValueProcessor = DataProcessor.create("");
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.cameraIndex;
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.lensType;
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.cameraIndex = cameraIndex;
        this.lensType = lensType;
        this.restart();
    }

    public Flowable<CameraISO> getISO() {
        return this.isoProcessor.toFlowable();
    }

    public Flowable<String> getISOAndEIValue() {
        return this.isoAndEIValueProcessor.toFlowable();
    }

    public Flowable<Boolean> isEIMode() {
        return this.exposureSensitivityModeProcessor.toFlowable().concatMap(exposureSensitivityMode -> Flowable.just((Object)(exposureSensitivityMode == ExposureSensitivityMode.EI ? 1 : 0)));
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyExposureSettings, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType), this.exposureSettingsProcessor);
        this.bindDataProcessor(KeyTools.createCameraKey((DJIKeyInfo)CameraKey.KeyISO, (ComponentIndexType)this.cameraIndex, (CameraLensType)this.lensType), this.isoProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyExposureSensitivityMode, (ComponentIndexType)this.cameraIndex), this.exposureSensitivityModeProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyEIValue, (ComponentIndexType)this.cameraIndex), this.eiValueProcessor);
    }

    @Override
    protected void inCleanup() {
    }

    @Override
    protected void updateStates() {
        this.updateConsolidatedISOValue();
    }

    private void updateConsolidatedISOValue() {
        if (this.exposureSensitivityModeProcessor.getValue() == ExposureSensitivityMode.EI) {
            this.isoAndEIValueProcessor.onNext(String.valueOf(this.eiValueProcessor.getValue()));
        } else if (this.isoProcessor.getValue() == CameraISO.ISO_FIXED && this.exposureSettingsProcessor.getValue().getIso() == 0) {
            this.isoAndEIValueProcessor.onNext(LOCKED_ISO_VALUE);
        } else {
            this.isoAndEIValueProcessor.onNext(String.valueOf(this.exposureSettingsProcessor.getValue().getIso()));
        }
    }
}

