/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.remotecontroller.calibration;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import dji.sdk.keyvalue.value.remotecontroller.RcCalibrateState;
import dji.v5.utils.common.LogUtils;
import dji.v5.utils.common.StringUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.ViewUtil;
import dji.v5.ux.remotecontroller.RcCalibrationWidgetModel;
import dji.v5.ux.remotecontroller.calibration.CalibrationRadioButton;
import dji.v5.ux.remotecontroller.calibration.OnCalibrationListener;
import dji.v5.ux.remotecontroller.calibration.stick.StickCalibrationView;
import dji.v5.ux.remotecontroller.calibration.wheel.WheelCalibrationView;
import java.util.ArrayList;

public class SmartControllerCalibrationView
extends LinearLayout
implements OnCalibrationListener,
View.OnClickListener {
    Button mInteractionBtn;
    protected Button outerInteractionBtn;
    ViewPager mViewPager;
    protected ArrayList<View> mViewList;
    CalibrationRadioButton mRgStick;
    CalibrationRadioButton mRgWheel;
    protected StickCalibrationView mStickCalibrationView;
    protected WheelCalibrationView mWheelCalibrationView;
    protected RcCalibrationWidgetModel rcCalibrationWidgetModel;
    private RcCalibrateState mCalibrationMode = RcCalibrateState.UNKNOWN;
    private boolean isStartCalibration = false;
    private View.OnClickListener startCalibrationListener = view -> {
        if (this.mCalibrationMode == RcCalibrateState.UNKNOWN) {
            this.rcCalibrationWidgetModel.startCalibration();
        } else if (this.mCalibrationMode == RcCalibrateState.EXIT) {
            this.rcCalibrationWidgetModel.finishCalibration();
        }
    };

    public SmartControllerCalibrationView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.isInEditMode()) {
            return;
        }
        this.init();
    }

    private void init() {
        if (this.isInEditMode()) {
            return;
        }
        this.rcCalibrationWidgetModel = new RcCalibrationWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
        this.mInteractionBtn = (Button)this.findViewById(R.id.fpv_rcsetting_cele_btn);
        this.mViewPager = (ViewPager)this.findViewById(R.id.calibration_pages);
        this.mRgStick = (CalibrationRadioButton)this.findViewById(R.id.setting_ui_rc_calibration_stick_rg);
        this.mRgWheel = (CalibrationRadioButton)this.findViewById(R.id.setting_ui_rc_calibration_wheel_rg);
        this.mInteractionBtn.setOnClickListener(this.startCalibrationListener);
        this.mRgStick.setOnClickListener(this);
        this.mRgWheel.setOnClickListener(this);
        this.mStickCalibrationView = (StickCalibrationView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.uxsdk_setting_ui_rc_smart_controller_stick_calibration_view, null);
        this.mWheelCalibrationView = (WheelCalibrationView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.uxsdk_setting_ui_rc_smart_controller_wheel_calibration_view, null);
        this.mStickCalibrationView.setListener(this);
        this.mStickCalibrationView.setViewModel(this.rcCalibrationWidgetModel);
        this.mWheelCalibrationView.setListener(this);
        this.mWheelCalibrationView.setViewModel(this.rcCalibrationWidgetModel);
        this.mViewList = new ArrayList(2);
        this.mViewList.add((View)this.mStickCalibrationView);
        this.mViewList.add((View)this.mWheelCalibrationView);
        this.mViewPager.setOffscreenPageLimit(1);
        this.mViewPager.setAdapter(new PagerAdapter(){

            public int getCount() {
                return SmartControllerCalibrationView.this.mViewList.size();
            }

            public boolean isViewFromObject(View view, Object object) {
                return view == object;
            }

            public Object instantiateItem(ViewGroup container, int position) {
                View targetView = SmartControllerCalibrationView.this.mViewList.get(position);
                if (targetView.getParent() != null) {
                    ((ViewGroup)targetView.getParent()).removeView(targetView);
                }
                container.addView(targetView);
                return SmartControllerCalibrationView.this.mViewList.get(position);
            }

            public void destroyItem(ViewGroup container, int position, Object object) {
                container.removeView(SmartControllerCalibrationView.this.mViewList.get(position));
            }
        });
        this.mViewPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                if (position == 0) {
                    SmartControllerCalibrationView.this.mRgStick.setChecked(true);
                } else {
                    SmartControllerCalibrationView.this.mRgWheel.setChecked(true);
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.mViewPager.setCurrentItem(0);
        this.rcCalibrationWidgetModel.rcCalibrateStateDataProcessor.toFlowableOnUI().subscribe(rcCalibrateState -> {
            this.mCalibrationMode = rcCalibrateState;
            this.updateViewByMode();
            if (this.mCalibrationMode == RcCalibrateState.UNKNOWN && !this.isStartCalibration) {
                this.reset();
            }
        });
        this.rcCalibrationWidgetModel.isCalibrateStartProcessor.toFlowableOnUI().subscribe(aBoolean -> {
            this.isStartCalibration = aBoolean;
            if (this.mCalibrationMode == RcCalibrateState.UNKNOWN && aBoolean.booleanValue()) {
                this.reset();
            }
        });
    }

    @Override
    public void onCalibrationFinished(int partType) {
        LogUtils.e((String)"Calibration", (Object[])new Object[]{"partType = " + partType + " Done"});
        if (partType == 1) {
            this.mRgStick.setCalirationComplete(true);
            if (!this.mWheelCalibrationView.isCalibrated()) {
                this.mViewPager.setCurrentItem(1);
            }
        } else if (partType == 2) {
            this.mRgWheel.setCalirationComplete(true);
            if (!this.mStickCalibrationView.isCalibrated()) {
                this.mViewPager.setCurrentItem(0);
            }
        }
        this.updateViewByMode();
    }

    @Override
    public void onCalibrationCanceled(int partType) {
        LogUtils.e((String)"Calibration", (Object[])new Object[]{"partType = " + partType + " Canceled"});
        if (partType == 1) {
            this.mRgStick.setCalirationComplete(false);
        } else if (partType == 2) {
            this.mRgWheel.setCalirationComplete(false);
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.setting_ui_rc_calibration_stick_rg) {
            this.mViewPager.setCurrentItem(0);
        } else if (v.getId() == R.id.setting_ui_rc_calibration_wheel_rg) {
            this.mViewPager.setCurrentItem(1);
        }
    }

    private void updateViewByMode() {
        RcCalibrateState mode = this.mCalibrationMode;
        LogUtils.e((String)"Calibration", (Object[])new Object[]{"mode = " + mode});
        if (mode == RcCalibrateState.NORMAL || mode == RcCalibrateState.UNKNOWN) {
            this.mInteractionBtn.setEnabled(true);
            this.mInteractionBtn.setText(R.string.uxsdk_setting_ui_rc_cele);
            if (this.outerInteractionBtn != null) {
                this.outerInteractionBtn.setEnabled(true);
                this.outerInteractionBtn.setText(R.string.uxsdk_setting_ui_rc_cele);
            }
        } else if (mode == RcCalibrateState.RECORDCENTER) {
            this.mInteractionBtn.setEnabled(false);
            this.mInteractionBtn.setText(R.string.uxsdk_setting_ui_rc_cele_in_progress_hint);
            if (this.outerInteractionBtn != null) {
                this.outerInteractionBtn.setText(R.string.uxsdk_setting_ui_rc_cele_in_progress_hint);
                this.outerInteractionBtn.setEnabled(false);
            }
        } else if (mode == RcCalibrateState.LIMITVALUE) {
            this.mInteractionBtn.setText(R.string.uxsdk_setting_ui_rc_cele_in_progress_hint);
            this.mInteractionBtn.setEnabled(false);
            if (this.mStickCalibrationView.isCalibrated() && this.mWheelCalibrationView.isCalibrated()) {
                this.mInteractionBtn.setEnabled(true);
            }
            if (this.outerInteractionBtn != null) {
                this.outerInteractionBtn.setText(R.string.uxsdk_setting_ui_rc_cele_in_progress_hint);
                this.outerInteractionBtn.setEnabled(false);
                if (this.mStickCalibrationView.isCalibrated() && this.mWheelCalibrationView.isCalibrated()) {
                    this.outerInteractionBtn.setEnabled(true);
                }
            }
        } else if (mode == RcCalibrateState.TIMEOUT_EXIT) {
            String content = StringUtils.getResStr((int)R.string.uxsdk_setting_ui_rc_calibration_time_out, (Object[])new Object[0]);
            ViewUtil.showToast(this.getContext(), content);
        } else if (mode == RcCalibrateState.EXIT) {
            this.mInteractionBtn.setText(R.string.uxsdk_setting_ui_rc_finish);
            this.mInteractionBtn.setEnabled(true);
            if (this.outerInteractionBtn != null) {
                this.outerInteractionBtn.setText(R.string.uxsdk_setting_ui_rc_finish);
                this.outerInteractionBtn.setEnabled(true);
            }
        }
    }

    private void reset() {
        this.mCalibrationMode = RcCalibrateState.UNKNOWN;
        this.mStickCalibrationView.reset();
        this.mWheelCalibrationView.reset();
        this.mViewPager.setCurrentItem(0);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.rcCalibrationWidgetModel.setup();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode()) {
            this.rcCalibrationWidgetModel.cleanup();
        }
    }
}

