/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.maplibre.annotations;

import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.Polygon;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.style.layers.FillLayer;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.LineLayer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.style.sources.Source;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolygon;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolygonOptions;
import dji.v5.ux.mapkit.core.utils.DJIMapkitLog;
import dji.v5.ux.mapkit.maplibre.utils.MapboxExtension;
import dji.v5.ux.mapkit.maplibre.utils.MapboxUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 A2\u00020\u0001:\u0001ABO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00126\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\rH\u0016J\u0010\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020\rH\u0016J\b\u0010(\u001a\u00020\bH\u0016J\u0010\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020\bH\u0016J\b\u0010+\u001a\u00020\bH\u0016J\u0010\u0010,\u001a\u00020$2\u0006\u0010*\u001a\u00020\bH\u0016J\b\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020$2\u0006\u00100\u001a\u00020.H\u0016J\u0018\u00101\u001a\u00020$2\u000e\u00102\u001a\n\u0012\u0004\u0012\u000204\u0018\u000103H\u0016J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020403H\u0016J\r\u00106\u001a\u00020$H\u0000\u00a2\u0006\u0002\b7J\r\u00108\u001a\u00020$H\u0000\u00a2\u0006\u0002\b9J\u001c\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;2\f\u00102\u001a\b\u0012\u0004\u0012\u0002040;H\u0002J\u0010\u0010=\u001a\u00020$2\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010@\u001a\u00020$2\u0006\u0010>\u001a\u00020?H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0016\u001a\u00020\u00178@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0015\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001b\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0015\u001a\u0004\b\u001c\u0010\u0013R\u001b\u0010\u001e\u001a\u00020\u001f8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0015\u001a\u0004\b \u0010!\u00a8\u0006B"}, d2={"Ldji/v5/ux/mapkit/maplibre/annotations/MaplibrePolygon;", "Ldji/v5/ux/mapkit/core/models/annotations/DJIPolygon;", "mapboxMap", "Lcom/mapbox/mapboxsdk/maps/MapboxMap;", "options", "Ldji/v5/ux/mapkit/core/models/annotations/DJIPolygonOptions;", "onRemovePolygon", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "zindex", "polygon", "", "<init>", "(Lcom/mapbox/mapboxsdk/maps/MapboxMap;Ldji/v5/ux/mapkit/core/models/annotations/DJIPolygonOptions;Lkotlin/jvm/functions/Function2;)V", "source", "Lcom/mapbox/mapboxsdk/style/sources/GeoJsonSource;", "getSource", "()Lcom/mapbox/mapboxsdk/style/sources/GeoJsonSource;", "source$delegate", "Lkotlin/Lazy;", "polygonLayer", "Lcom/mapbox/mapboxsdk/style/layers/FillLayer;", "getPolygonLayer$android_sdk_v5_uxsdk_debug", "()Lcom/mapbox/mapboxsdk/style/layers/FillLayer;", "polygonLayer$delegate", "borderSource", "getBorderSource", "borderSource$delegate", "borderLayer", "Lcom/mapbox/mapboxsdk/style/layers/LineLayer;", "getBorderLayer$android_sdk_v5_uxsdk_debug", "()Lcom/mapbox/mapboxsdk/style/layers/LineLayer;", "borderLayer$delegate", "remove", "", "isVisible", "setVisible", "visible", "getFillColor", "setFillColor", "color", "getStrokeColor", "setStrokeColor", "getStrokeWidth", "", "setStrokeWidth", "strokeWidth", "setPoints", "points", "", "Ldji/v5/ux/mapkit/core/models/DJILatLng;", "getPoints", "clear", "clear$android_sdk_v5_uxsdk_debug", "restore", "restore$android_sdk_v5_uxsdk_debug", "getPolygonLngLats", "", "Lcom/mapbox/geojson/Point;", "setUpBorderSource", "style", "Lcom/mapbox/mapboxsdk/maps/Style;", "setUpPolygonSource", "Companion", "android-sdk-v5-uxsdk_debug"})
@SourceDebugExtension(value={"SMAP\nMaplibrePolygon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaplibrePolygon.kt\ndji/v5/ux/mapkit/maplibre/annotations/MaplibrePolygon\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n1#2:154\n1549#3:155\n1620#3,3:156\n1549#3:159\n1620#3,3:160\n1549#3:163\n1620#3,3:164\n1549#3:167\n1620#3,3:168\n*S KotlinDebug\n*F\n+ 1 MaplibrePolygon.kt\ndji/v5/ux/mapkit/maplibre/annotations/MaplibrePolygon\n*L\n133#1:155\n133#1:156,3\n134#1:159\n134#1:160,3\n137#1:163\n137#1:164,3\n138#1:167\n138#1:168,3\n*E\n"})
public final class MaplibrePolygon
implements DJIPolygon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MapboxMap mapboxMap;
    @NotNull
    private final DJIPolygonOptions options;
    @NotNull
    private final Function2<Integer, MaplibrePolygon, Boolean> onRemovePolygon;
    @NotNull
    private final Lazy source$delegate;
    @NotNull
    private final Lazy polygonLayer$delegate;
    @NotNull
    private final Lazy borderSource$delegate;
    @NotNull
    private final Lazy borderLayer$delegate;
    @NotNull
    private static final String TAG = "MaplibrePolygon";

    public MaplibrePolygon(@NotNull MapboxMap mapboxMap, @NotNull DJIPolygonOptions options, @NotNull Function2<? super Integer, ? super MaplibrePolygon, Boolean> onRemovePolygon) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)mapboxMap, (String)"mapboxMap");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter(onRemovePolygon, (String)"onRemovePolygon");
            this.mapboxMap = mapboxMap;
            this.options = options;
            this.onRemovePolygon = onRemovePolygon;
            this.source$delegate = LazyKt.lazy(() -> MaplibrePolygon.source_delegate$lambda$0(this));
            this.polygonLayer$delegate = LazyKt.lazy(() -> MaplibrePolygon.polygonLayer_delegate$lambda$1(this));
            this.borderSource$delegate = LazyKt.lazy(() -> MaplibrePolygon.borderSource_delegate$lambda$2(this));
            this.borderLayer$delegate = LazyKt.lazy(() -> MaplibrePolygon.borderLayer_delegate$lambda$3(this));
            DJIMapkitLog.i(TAG, "init");
            Style style2 = this.mapboxMap.getStyle();
            if (style2 == null) break block1;
            Style it = style2;
            boolean bl = false;
            if (it.isFullyLoaded()) {
                this.setUpPolygonSource(it);
                this.setUpBorderSource(it);
            }
        }
    }

    private final GeoJsonSource getSource() {
        Lazy lazy = this.source$delegate;
        return (GeoJsonSource)lazy.getValue();
    }

    @NotNull
    public final FillLayer getPolygonLayer$android_sdk_v5_uxsdk_debug() {
        Lazy lazy = this.polygonLayer$delegate;
        return (FillLayer)lazy.getValue();
    }

    private final GeoJsonSource getBorderSource() {
        Lazy lazy = this.borderSource$delegate;
        return (GeoJsonSource)lazy.getValue();
    }

    @NotNull
    public final LineLayer getBorderLayer$android_sdk_v5_uxsdk_debug() {
        Lazy lazy = this.borderLayer$delegate;
        return (LineLayer)lazy.getValue();
    }

    @Override
    public void remove() {
        block1: {
            DJIMapkitLog.i(TAG, "remove " + this.getPolygonLayer$android_sdk_v5_uxsdk_debug().getId() + ", " + this.getBorderLayer$android_sdk_v5_uxsdk_debug().getId());
            Style style2 = this.mapboxMap.getStyle();
            if (style2 == null) break block1;
            Style it = style2;
            boolean bl = false;
            if (!((Boolean)this.onRemovePolygon.invoke((Object)((int)this.options.getZIndex()), (Object)this)).booleanValue()) {
                DJIMapkitLog.e(TAG, "remove polygon " + this + " fail");
            }
            MapboxExtension.removeLayerAndLog(it, (Layer)this.getPolygonLayer$android_sdk_v5_uxsdk_debug());
            MapboxExtension.removeLayerAndLog(it, (Layer)this.getBorderLayer$android_sdk_v5_uxsdk_debug());
            MapboxExtension.removeSourceAndLog(it, (Source)this.getSource());
            MapboxExtension.removeSourceAndLog(it, (Source)this.getBorderSource());
        }
    }

    @Override
    public boolean isVisible() {
        return Intrinsics.areEqual((Object)"visible", (Object)this.getPolygonLayer$android_sdk_v5_uxsdk_debug().getVisibility().value);
    }

    @Override
    public void setVisible(boolean visible) {
        PropertyValue[] propertyValueArray = new PropertyValue[]{PropertyFactory.visibility((String)(visible ? "visible" : "none"))};
        this.getPolygonLayer$android_sdk_v5_uxsdk_debug().withProperties(propertyValueArray);
        propertyValueArray = new PropertyValue[]{PropertyFactory.visibility((String)(visible ? "visible" : "none"))};
        this.getBorderLayer$android_sdk_v5_uxsdk_debug().withProperties(propertyValueArray);
    }

    @Override
    public int getFillColor() {
        return this.getPolygonLayer$android_sdk_v5_uxsdk_debug().getFillColorAsInt();
    }

    @Override
    public void setFillColor(int color2) {
        PropertyValue[] propertyValueArray = new PropertyValue[]{PropertyFactory.fillColor((int)color2)};
        this.getPolygonLayer$android_sdk_v5_uxsdk_debug().withProperties(propertyValueArray);
    }

    @Override
    public int getStrokeColor() {
        return this.getBorderLayer$android_sdk_v5_uxsdk_debug().getLineColorAsInt();
    }

    @Override
    public void setStrokeColor(int color2) {
        PropertyValue[] propertyValueArray = new PropertyValue[]{PropertyFactory.fillColor((int)color2)};
        this.getBorderLayer$android_sdk_v5_uxsdk_debug().withProperties(propertyValueArray);
    }

    @Override
    public float getStrokeWidth() {
        Object object = this.getBorderLayer$android_sdk_v5_uxsdk_debug().getLineWidth().getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
        return ((Float)object).floatValue() * 5.0f;
    }

    @Override
    public void setStrokeWidth(float strokeWidth) {
        PropertyValue[] propertyValueArray = new PropertyValue[]{PropertyFactory.lineWidth((Float)Float.valueOf(strokeWidth / 5.0f))};
        this.getBorderLayer$android_sdk_v5_uxsdk_debug().withProperties(propertyValueArray);
    }

    @Override
    public void setPoints(@Nullable List<DJILatLng> points) {
        this.options.setPoints(points);
        GeoJsonSource geoJsonSource = this.getSource();
        List<DJILatLng> list = this.options.getPoints();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getPoints(...)");
        geoJsonSource.setGeoJson((Geometry)Polygon.fromLngLats((List)CollectionsKt.listOf(this.getPolygonLngLats(list))));
        GeoJsonSource geoJsonSource2 = this.getBorderSource();
        List<DJILatLng> list2 = this.options.getPoints();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getPoints(...)");
        geoJsonSource2.setGeoJson((Geometry)LineString.fromLngLats(this.getPolygonLngLats(list2)));
    }

    @Override
    @NotNull
    public List<DJILatLng> getPoints() {
        List<DJILatLng> list = this.options.getPoints();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getPoints(...)");
        return list;
    }

    public final void clear$android_sdk_v5_uxsdk_debug() {
        block0: {
            DJIMapkitLog.i(TAG, "clear");
            Style style2 = this.mapboxMap.getStyle();
            if (style2 == null) break block0;
            Style it = style2;
            boolean bl = false;
            MapboxExtension.removeLayerAndLog(it, (Layer)this.getPolygonLayer$android_sdk_v5_uxsdk_debug());
            MapboxExtension.removeSourceAndLog(it, (Source)this.getSource());
            MapboxExtension.removeLayerAndLog(it, (Layer)this.getBorderLayer$android_sdk_v5_uxsdk_debug());
            MapboxExtension.removeSourceAndLog(it, (Source)this.getBorderSource());
        }
    }

    public final void restore$android_sdk_v5_uxsdk_debug() {
        block0: {
            DJIMapkitLog.i(TAG, "restore");
            Style style2 = this.mapboxMap.getStyle();
            if (style2 == null) break block0;
            Style it = style2;
            boolean bl = false;
            MapboxExtension.addSourceAndLog(it, (Source)this.getSource());
            MapboxExtension.addSourceAndLog(it, (Source)this.getBorderSource());
        }
    }

    private final List<Point> getPolygonLngLats(List<? extends DJILatLng> points) {
        List list;
        if (!Intrinsics.areEqual((Object)CollectionsKt.first(points), (Object)CollectionsKt.last(points))) {
            LatLng it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            List list2;
            List $this$getPolygonLngLats_u24lambda_u248 = list2 = CollectionsKt.toMutableList((Collection)points);
            boolean $i$a$-apply-MaplibrePolygon$getPolygonLngLats$22 = false;
            $this$getPolygonLngLats_u24lambda_u248.add(CollectionsKt.first(points));
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable $i$a$-apply-MaplibrePolygon$getPolygonLngLats$22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                DJILatLng dJILatLng = (DJILatLng)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(MapboxUtil.fromDJILatLng((DJILatLng)it));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (LatLng)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Point.fromLngLat((double)it.getLongitude(), (double)it.getLatitude(), (double)it.getAltitude()));
            }
            list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        } else {
            Collection collection;
            DJILatLng it;
            Iterable $this$map$iv = points;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (DJILatLng)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(MapboxUtil.fromDJILatLng(it));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (LatLng)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Point.fromLngLat((double)it.getLongitude(), (double)it.getLatitude(), (double)it.getAltitude()));
            }
            list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }
        return list;
    }

    private final void setUpBorderSource(Style style2) {
        MapboxExtension.addSourceAndLog(style2, (Source)this.getBorderSource());
    }

    private final void setUpPolygonSource(Style style2) {
        MapboxExtension.addSourceAndLog(style2, (Source)this.getSource());
    }

    private static final GeoJsonSource source_delegate$lambda$0(MaplibrePolygon this$0) {
        String string2 = MapboxUtil.getPolygonSourceIdAndIncrement();
        List<DJILatLng> list = this$0.options.getPoints();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getPoints(...)");
        return new GeoJsonSource(string2, (Geometry)Polygon.fromLngLats((List)CollectionsKt.listOf(this$0.getPolygonLngLats(list))));
    }

    private static final FillLayer polygonLayer_delegate$lambda$1(MaplibrePolygon this$0) {
        PropertyValue[] propertyValueArray = new PropertyValue[]{PropertyFactory.fillColor((int)this$0.options.getFillColor()), PropertyFactory.fillOpacity((Float)Float.valueOf(this$0.options.getAlpha()))};
        return new FillLayer(MapboxUtil.getPolygonLayerIdAndIncrement(), this$0.getSource().getId()).withProperties(propertyValueArray);
    }

    private static final GeoJsonSource borderSource_delegate$lambda$2(MaplibrePolygon this$0) {
        String string2 = MapboxUtil.getPolygonBorderSourceIdAndIncrement();
        List<DJILatLng> list = this$0.options.getPoints();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getPoints(...)");
        return new GeoJsonSource(string2, (Geometry)LineString.fromLngLats(this$0.getPolygonLngLats(list)));
    }

    private static final LineLayer borderLayer_delegate$lambda$3(MaplibrePolygon this$0) {
        PropertyValue[] propertyValueArray = new PropertyValue[]{PropertyFactory.lineColor((int)this$0.options.getStrokeColor()), PropertyFactory.lineWidth((Float)Float.valueOf(this$0.options.getStrokeWidth() / 5.0f)), PropertyFactory.lineJoin((String)"round")};
        return new LineLayer(MapboxUtil.getPolygonBorderLayerIdAndIncrement(), this$0.getBorderSource().getId()).withProperties(propertyValueArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldji/v5/ux/mapkit/maplibre/annotations/MaplibrePolygon$Companion;", "", "<init>", "()V", "TAG", "", "android-sdk-v5-uxsdk_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

