/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.core.models.annotations;

import android.graphics.PointF;
import androidx.annotation.FloatRange;
import dji.v5.ux.mapkit.core.models.DJIBitmapDescriptor;
import dji.v5.ux.mapkit.core.models.DJILatLng;

public class DJIMarkerOptions {
    private boolean mDraggable;
    private DJILatLng mPosition;
    private PointF mAnchor = new PointF(0.5f, 0.5f);
    private DJIBitmapDescriptor mIcon;
    private float mRotation;
    private int mZIndex;
    private boolean isCustomAnchor;
    private boolean mVisible = true;
    private String mTitle = "";
    private boolean mFlat;
    private boolean mInfoWindowEnable = true;

    public DJIMarkerOptions draggable(boolean draggable) {
        this.mDraggable = draggable;
        return this;
    }

    public DJIMarkerOptions position(DJILatLng position) {
        this.mPosition = position;
        return this;
    }

    public DJIMarkerOptions anchor(@FloatRange(from=0.0, to=1.0) float u, @FloatRange(from=0.0, to=1.0) float v) {
        this.isCustomAnchor = true;
        this.mAnchor = new PointF(u, v);
        return this;
    }

    public DJIMarkerOptions icon(DJIBitmapDescriptor bitmap) {
        this.mIcon = bitmap;
        return this;
    }

    public DJIMarkerOptions rotation(float rotation) {
        this.mRotation = rotation;
        return this;
    }

    public DJIMarkerOptions zIndex(int zIndex) {
        this.mZIndex = zIndex;
        return this;
    }

    public DJIMarkerOptions visible(boolean visible) {
        this.mVisible = visible;
        return this;
    }

    public DJIMarkerOptions title(String title) {
        this.mTitle = title;
        return this;
    }

    public DJIMarkerOptions flat(boolean flat) {
        this.mFlat = flat;
        return this;
    }

    public DJIMarkerOptions setInfoWindowEnable(boolean infoWindowEnable) {
        this.mInfoWindowEnable = infoWindowEnable;
        return this;
    }

    public boolean getDraggable() {
        return this.mDraggable;
    }

    public DJILatLng getPosition() {
        return this.mPosition;
    }

    @FloatRange(from=0.0, to=1.0)
    public float getAnchorU() {
        return this.mAnchor.x;
    }

    @FloatRange(from=0.0, to=1.0)
    public float getAnchorV() {
        return this.mAnchor.y;
    }

    public DJIBitmapDescriptor getIcon() {
        return this.mIcon;
    }

    public float getRotation() {
        return this.mRotation;
    }

    public int getZIndex() {
        return this.mZIndex;
    }

    public boolean isCustomAnchor() {
        return this.isCustomAnchor;
    }

    public boolean getVisible() {
        return this.mVisible;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public boolean isFlat() {
        return this.mFlat;
    }

    public boolean isInfoWindowEnable() {
        return this.mInfoWindowEnable;
    }
}

