/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.core.models;

import androidx.annotation.NonNull;
import dji.v5.ux.mapkit.core.models.DJILatLng;

public class DJICameraPosition {
    public final DJILatLng target;
    public final float zoom;
    public final float tilt;
    public final float bearing;

    private DJICameraPosition() {
        this.target = null;
        this.zoom = 0.0f;
        this.tilt = 0.0f;
        this.bearing = 0.0f;
    }

    public DJICameraPosition(DJILatLng target, float zoom, float tilt, float bearing) {
        this.target = target;
        this.zoom = zoom;
        this.tilt = tilt;
        this.bearing = ((double)bearing <= 0.0 ? bearing % 360.0f + 360.0f : bearing) % 360.0f;
    }

    public DJICameraPosition(DJILatLng position, float zoom) {
        this(position, zoom, 0.0f, 0.0f);
    }

    public DJILatLng getPosition() {
        return this.target;
    }

    public float getZoom() {
        return this.zoom;
    }

    public float getTilt() {
        return this.tilt;
    }

    public float getBearing() {
        return this.bearing;
    }

    public static final DJICameraPosition fromLatLngZoom(DJILatLng target, float zoom) {
        return new DJICameraPosition(target, zoom, 0.0f, 0.0f);
    }

    public int hashCode() {
        int result = this.target != null ? this.target.hashCode() : 0;
        result = 31 * result + (this.zoom != 0.0f ? Float.floatToIntBits(this.zoom) : 0);
        result = 31 * result + (this.tilt != 0.0f ? Float.floatToIntBits(this.tilt) : 0);
        result = 31 * result + (this.bearing != 0.0f ? Float.floatToIntBits(this.bearing) : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DJICameraPosition)) {
            return false;
        }
        DJICameraPosition o = (DJICameraPosition)obj;
        return this.target.equals(o.target) && this.zoom == o.zoom && this.tilt == o.tilt && this.bearing == o.bearing;
    }

    public String toString() {
        return "latlng: " + this.target + " zoom: " + this.zoom + " tilt: " + this.tilt + " bearing: " + this.bearing;
    }

    public static Builder builder(DJICameraPosition camera) {
        return new Builder(camera);
    }

    public static final class Builder {
        private DJILatLng target;
        private float zoom;
        private float tilt;
        private float bearing;

        public Builder() {
        }

        public Builder(DJICameraPosition previous) {
            this.target = previous.target;
            this.zoom = previous.zoom;
            this.tilt = previous.tilt;
            this.bearing = previous.bearing;
        }

        public Builder target(@NonNull DJILatLng location) {
            this.target = location;
            return this;
        }

        public Builder zoom(float zoom) {
            this.zoom = zoom;
            return this;
        }

        public Builder tilt(float tilt) {
            this.tilt = tilt;
            return this;
        }

        public Builder bearing(float bearing) {
            this.bearing = bearing;
            return this;
        }

        public DJICameraPosition build() {
            return new DJICameraPosition(this.target, this.zoom, this.tilt, this.bearing);
        }
    }
}

