/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.systemstatus;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.StyleRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import dji.v5.manager.diagnostic.DJIDeviceStatus;
import dji.v5.manager.diagnostic.WarningLevel;
import dji.v5.utils.common.DisplayUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.WidgetSizeDescription;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.GlobalPreferencesManager;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.extension.ViewExtensions;
import dji.v5.ux.core.util.UnitConversionUtil;
import dji.v5.ux.core.util.UxErrorHandle;
import dji.v5.ux.core.widget.systemstatus.SystemStatusWidget;
import dji.v5.ux.core.widget.systemstatus.SystemStatusWidgetModel;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.processors.PublishProcessor;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003`abB'\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\"\u00103\u001a\u0002042\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u00105\u001a\u000204H\u0014J\b\u00106\u001a\u000204H\u0014J\b\u00107\u001a\u000204H\u0014J\u0010\u00108\u001a\u0002042\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u0002042\u0006\u0010<\u001a\u00020=H\u0002J\u0012\u0010>\u001a\u00020?2\b\u0010@\u001a\u0004\u0018\u00010AH\u0002J\u001a\u0010B\u001a\u0004\u0018\u00010A2\u0006\u0010C\u001a\u00020%2\u0006\u0010D\u001a\u00020EH\u0002J\u0010\u0010F\u001a\u0002042\u0006\u0010G\u001a\u00020?H\u0002J\b\u0010H\u001a\u00020IH\u0002J\u0018\u0010J\u001a\u0002042\u0006\u0010K\u001a\u00020:2\u0006\u0010L\u001a\u00020?H\u0002J\b\u0010M\u001a\u000204H\u0002J\n\u0010N\u001a\u0004\u0018\u00010AH\u0016J\u0010\u0010S\u001a\u0002042\b\b\u0001\u0010T\u001a\u00020\bJ\u0018\u0010U\u001a\u0002042\u0006\u0010V\u001a\u00020\u001e2\b\b\u0001\u0010W\u001a\u00020\bJ\u0010\u0010U\u001a\u0002042\b\b\u0001\u0010W\u001a\u00020\bJ\u0010\u0010X\u001a\u00020\b2\u0006\u0010V\u001a\u00020\u001eH\u0007J\u0018\u0010Y\u001a\u0002042\u0006\u0010V\u001a\u00020\u001e2\b\u0010Z\u001a\u0004\u0018\u00010#J\u0010\u0010Y\u001a\u0002042\b\u0010Z\u001a\u0004\u0018\u00010#J\u0010\u0010[\u001a\u0004\u0018\u00010#2\u0006\u0010V\u001a\u00020\u001eJ\u0018\u0010\\\u001a\u0002042\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0003J\u000e\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00020^H\u0016J\f\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00130^R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R'\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\b0\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u001b\u001a\u0004\b\u001f\u0010 R\u001c\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0006\u0012\u0004\u0018\u00010#0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010&\u001a\u00020%2\b\b\u0001\u0010$\u001a\u00020%8G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R$\u0010-\u001a\u00020,2\u0006\u0010+\u001a\u00020,@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u000e\u00102\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010O\u001a\u00020PX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010R\u00a8\u0006c"}, d2={"Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidget;", "Ldji/v5/ux/core/base/widget/ConstraintLayoutWidget;", "Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidget$ModelState;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "systemStatusTextView", "Landroid/widget/TextView;", "systemStatusBackgroundImageView", "Landroid/widget/ImageView;", "blinkAnimation", "Landroid/view/animation/Animation;", "uiUpdateStateProcessor", "Lio/reactivex/rxjava3/processors/PublishProcessor;", "Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidget$UIState;", "getUiUpdateStateProcessor", "()Lio/reactivex/rxjava3/processors/PublishProcessor;", "widgetModel", "Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidgetModel;", "getWidgetModel", "()Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidgetModel;", "widgetModel$delegate", "Lkotlin/Lazy;", "textColorMap", "", "Ldji/v5/manager/diagnostic/WarningLevel;", "getTextColorMap", "()Ljava/util/Map;", "textColorMap$delegate", "backgroundDrawableMap", "Landroid/graphics/drawable/Drawable;", "textSize", "", "systemStatusMessageTextSize", "getSystemStatusMessageTextSize", "()F", "setSystemStatusMessageTextSize", "(F)V", "value", "Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidget$DefaultMode;", "defaultMode", "getDefaultMode", "()Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidget$DefaultMode;", "setDefaultMode", "(Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidget$DefaultMode;)V", "stateChangeResourceId", "initView", "", "onAttachedToWindow", "onDetachedFromWindow", "reactToModelChanges", "updateUI", "status", "Ldji/v5/manager/diagnostic/DJIDeviceStatus;", "updateMessage", "messageData", "Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidgetModel$WarningStatusMessageData;", "isMaxHeightMessage", "", "text", "", "formatMaxHeight", "maxHeight", "unitType", "Ldji/v5/ux/core/util/UnitConversionUtil$UnitType;", "blinkBackground", "isUrgentMessage", "reactToCompassError", "Lio/reactivex/rxjava3/disposables/Disposable;", "updateVoiceNotification", "statusItem", "isMotorOn", "checkAndUpdateUI", "getIdealDimensionRatioString", "widgetSizeDescription", "Ldji/v5/ux/core/base/WidgetSizeDescription;", "getWidgetSizeDescription", "()Ldji/v5/ux/core/base/WidgetSizeDescription;", "setSystemStatusMessageTextAppearance", "textAppearance", "setSystemStatusMessageTextColor", "level", "color", "getSystemStatusMessageTextColor", "setSystemStatusBackgroundDrawable", "background", "getSystemStatusBackgroundDrawable", "initAttributes", "getWidgetStateUpdate", "Lio/reactivex/rxjava3/core/Flowable;", "getUIStateUpdates", "UIState", "ModelState", "DefaultMode", "android-sdk-v5-uxsdk_debug"})
@SourceDebugExtension(value={"SMAP\nSystemStatusWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SystemStatusWidget.kt\ndji/v5/ux/core/widget/systemstatus/SystemStatusWidget\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TypedArray.kt\nandroidx/core/content/res/TypedArrayKt\n+ 4 TypedArrayExtensions.kt\ndji/v5/ux/core/extension/TypedArrayExtensions\n*L\n1#1,449:1\n1#2:450\n1#2:489\n1#2:493\n1#2:497\n1#2:501\n233#3:451\n234#3,2:508\n151#4,5:452\n125#4,5:457\n88#4,5:462\n64#4,5:467\n64#4,5:472\n64#4,5:477\n64#4,5:482\n101#4,2:487\n103#4:490\n101#4,2:491\n103#4:494\n101#4,2:495\n103#4:498\n101#4,2:499\n103#4:502\n125#4,5:503\n*S KotlinDebug\n*F\n+ 1 SystemStatusWidget.kt\ndji/v5/ux/core/widget/systemstatus/SystemStatusWidget\n*L\n364#1:489\n367#1:493\n370#1:497\n373#1:501\n342#1:451\n342#1:508,2\n343#1:452,5\n346#1:457,5\n349#1:462,5\n352#1:467,5\n355#1:472,5\n358#1:477,5\n361#1:482,5\n364#1:487,2\n364#1:490\n367#1:491,2\n367#1:494\n370#1:495,2\n370#1:498\n373#1:499,2\n373#1:502\n376#1:503,5\n*E\n"})
public class SystemStatusWidget
extends ConstraintLayoutWidget<ModelState> {
    @NotNull
    private final TextView systemStatusTextView;
    @NotNull
    private final ImageView systemStatusBackgroundImageView;
    @NotNull
    private final Animation blinkAnimation;
    @NotNull
    private final PublishProcessor<UIState> uiUpdateStateProcessor;
    @NotNull
    private final Lazy widgetModel$delegate;
    @NotNull
    private final Lazy textColorMap$delegate;
    @NotNull
    private final Map<WarningLevel, Drawable> backgroundDrawableMap;
    @NotNull
    private DefaultMode defaultMode;
    private int stateChangeResourceId;
    @NotNull
    private final WidgetSizeDescription widgetSizeDescription;

    @JvmOverloads
    public SystemStatusWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        View view = this.findViewById(R.id.textview_system_status);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        this.systemStatusTextView = (TextView)view;
        View view2 = this.findViewById(R.id.imageview_system_status_background);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
        this.systemStatusBackgroundImageView = (ImageView)view2;
        Animation animation = AnimationUtils.loadAnimation((Context)context, (int)R.anim.uxsdk_anim_blink);
        Intrinsics.checkNotNullExpressionValue((Object)animation, (String)"loadAnimation(...)");
        this.blinkAnimation = animation;
        PublishProcessor publishProcessor = PublishProcessor.create();
        Intrinsics.checkNotNullExpressionValue((Object)publishProcessor, (String)"create(...)");
        this.uiUpdateStateProcessor = publishProcessor;
        this.widgetModel$delegate = LazyKt.lazy(SystemStatusWidget::widgetModel_delegate$lambda$0);
        this.textColorMap$delegate = LazyKt.lazy(() -> SystemStatusWidget.textColorMap_delegate$lambda$1(this));
        this.backgroundDrawableMap = new LinkedHashMap();
        this.defaultMode = DefaultMode.COLOR;
        this.systemStatusTextView.setSelected(true);
        AttributeSet attributeSet = attrs;
        if (attributeSet != null) {
            AttributeSet it = attributeSet;
            boolean bl = false;
            this.initAttributes(context, it);
        }
        this.widgetSizeDescription = new WidgetSizeDescription(WidgetSizeDescription.SizeType.OTHER, WidgetSizeDescription.Dimension.EXPAND, WidgetSizeDescription.Dimension.EXPAND);
    }

    public /* synthetic */ SystemStatusWidget(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @NotNull
    protected final PublishProcessor<UIState> getUiUpdateStateProcessor() {
        return this.uiUpdateStateProcessor;
    }

    private final SystemStatusWidgetModel getWidgetModel() {
        Lazy lazy = this.widgetModel$delegate;
        return (SystemStatusWidgetModel)lazy.getValue();
    }

    private final Map<WarningLevel, Integer> getTextColorMap() {
        Lazy lazy = this.textColorMap$delegate;
        return (Map)lazy.getValue();
    }

    @Dimension
    public final float getSystemStatusMessageTextSize() {
        return this.systemStatusTextView.getTextSize();
    }

    public final void setSystemStatusMessageTextSize(@Dimension float textSize) {
        this.systemStatusTextView.setTextSize(textSize);
    }

    @NotNull
    public final DefaultMode getDefaultMode() {
        return this.defaultMode;
    }

    public final void setDefaultMode(@NotNull DefaultMode value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.defaultMode = value;
        if (value == DefaultMode.COLOR) {
            this.setSystemStatusMessageTextColor(WarningLevel.SERIOUS_WARNING, ViewExtensions.getColor((View)this, R.color.uxsdk_status_error));
            this.setSystemStatusMessageTextColor(WarningLevel.WARNING, ViewExtensions.getColor((View)this, R.color.uxsdk_status_warning));
            this.setSystemStatusMessageTextColor(WarningLevel.NORMAL, ViewExtensions.getColor((View)this, R.color.uxsdk_status_good));
            this.setSystemStatusMessageTextColor(WarningLevel.UNKNOWN, ViewExtensions.getColor((View)this, R.color.uxsdk_status_offline));
            this.setSystemStatusBackgroundDrawable(null);
        } else {
            this.setSystemStatusMessageTextColor(ViewExtensions.getColor((View)this, R.color.uxsdk_white));
            this.setSystemStatusBackgroundDrawable(WarningLevel.SERIOUS_WARNING, ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_gradient_error));
            this.setSystemStatusBackgroundDrawable(WarningLevel.WARNING, ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_gradient_warning));
            this.setSystemStatusBackgroundDrawable(WarningLevel.NORMAL, ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_gradient_good));
            this.setSystemStatusBackgroundDrawable(WarningLevel.UNKNOWN, ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_gradient_offline));
        }
    }

    @Override
    protected void initView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ConstraintLayout.inflate((Context)context, (int)R.layout.uxsdk_widget_system_status, (ViewGroup)((ViewGroup)this));
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.getWidgetModel().setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.getWidgetModel().cleanup();
        }
        super.onDetachedFromWindow();
    }

    @Override
    protected void reactToModelChanges() {
        Disposable disposable = this.getWidgetModel().getSystemStatus().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ SystemStatusWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(DJIDeviceStatus it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SystemStatusWidget.access$updateUI(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addReaction(disposable);
        this.addReaction(this.reactToCompassError());
        Disposable disposable2 = this.getWidgetModel().getWarningStatusMessageData().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ SystemStatusWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(SystemStatusWidgetModel.WarningStatusMessageData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SystemStatusWidget.access$updateMessage(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"subscribe(...)");
        this.addReaction(disposable2);
        Disposable disposable3 = this.getWidgetModel().getProductConnection().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ SystemStatusWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Boolean it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SystemStatusWidget.access$getWidgetStateDataProcessor(this.this$0).onNext((Object)new ModelState.ProductConnected(it));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"subscribe(...)");
        this.addReaction(disposable3);
    }

    private final void updateUI(DJIDeviceStatus status) {
        WarningLevel warningLevel = status.warningLevel();
        Intrinsics.checkNotNullExpressionValue((Object)warningLevel, (String)"warningLevel(...)");
        ViewExtensions.setTextColor(this.systemStatusTextView, this.getSystemStatusMessageTextColor(warningLevel));
        WarningLevel warningLevel2 = status.warningLevel();
        Intrinsics.checkNotNullExpressionValue((Object)warningLevel2, (String)"warningLevel(...)");
        ViewExtensions.setImageDrawable(this.systemStatusBackgroundImageView, this.getSystemStatusBackgroundDrawable(warningLevel2));
        this.blinkBackground(status.warningLevel() == WarningLevel.SERIOUS_WARNING);
        this.getWidgetStateDataProcessor().onNext((Object)new ModelState.SystemStatusUpdated(status));
    }

    private final void updateMessage(SystemStatusWidgetModel.WarningStatusMessageData messageData) {
        this.systemStatusTextView.setText(this.isMaxHeightMessage(messageData.getMessage()) ? (CharSequence)(messageData.getMessage() + " - " + this.formatMaxHeight(messageData.getMaxHeight(), messageData.getUnitType())) : (CharSequence)messageData.getMessage());
    }

    private final boolean isMaxHeightMessage(String text) {
        return DJIDeviceStatus.IN_NFZ_MAX_HEIGHT.statusCode().equals(text);
    }

    private final String formatMaxHeight(float maxHeight, UnitConversionUtil.UnitType unitType) {
        Object[] objectArray;
        Object[] objectArray2;
        if (unitType == UnitConversionUtil.UnitType.IMPERIAL) {
            Resources resources = this.getResources();
            var5_3 = new Object[1];
            var6_4 = Locale.US;
            var7_5 = "%.0f";
            var8_6 = new Object[]{Float.valueOf(maxHeight)};
            Intrinsics.checkNotNullExpressionValue((Object)String.format(var6_4, var7_5, Arrays.copyOf(var8_6, var8_6.length)), (String)"format(locale, format, *args)");
            objectArray2 = resources.getString(R.string.uxsdk_value_feet, var5_3);
            Intrinsics.checkNotNull((Object)objectArray2);
            objectArray = objectArray2;
        } else {
            Resources resources = this.getResources();
            var5_3 = new Object[1];
            var6_4 = Locale.US;
            var7_5 = "%.0f";
            var8_6 = new Object[]{Float.valueOf(maxHeight)};
            Intrinsics.checkNotNullExpressionValue((Object)String.format(var6_4, var7_5, Arrays.copyOf(var8_6, var8_6.length)), (String)"format(locale, format, *args)");
            objectArray2 = resources.getString(R.string.uxsdk_value_meters, var5_3);
            Intrinsics.checkNotNull((Object)objectArray2);
            objectArray = objectArray2;
        }
        Object[] maxHeightStr = objectArray;
        objectArray2 = new Object[]{maxHeightStr};
        return ViewExtensions.getString((View)this, R.string.uxsdk_max_flight_height_limit, objectArray2);
    }

    private final void blinkBackground(boolean isUrgentMessage) {
        if (isUrgentMessage) {
            this.systemStatusBackgroundImageView.startAnimation(this.blinkAnimation);
        } else {
            this.systemStatusBackgroundImageView.clearAnimation();
        }
    }

    private final Disposable reactToCompassError() {
        Disposable disposable = Flowable.combineLatest((Publisher)((Publisher)this.getWidgetModel().getSystemStatus()), (Publisher)((Publisher)this.getWidgetModel().isMotorOn()), (BiFunction)reactToCompassError.1.INSTANCE).observeOn(SchedulerProvider.ui()).subscribe(arg_0 -> SystemStatusWidget.reactToCompassError$lambda$3(this, arg_0), UxErrorHandle.logErrorConsumer("SystemStatusWidget", "react to Compass Error: "));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        return disposable;
    }

    private final void updateVoiceNotification(DJIDeviceStatus statusItem, boolean isMotorOn) {
        if (isMotorOn && statusItem == DJIDeviceStatus.COMPASS_ERROR) {
            Disposable disposable = this.getWidgetModel().sendVoiceNotification().subscribe();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
            this.addDisposable(disposable);
        }
    }

    private final void checkAndUpdateUI() {
        if (!this.isInEditMode()) {
            Disposable disposable = this.getWidgetModel().getSystemStatus().firstOrError().observeOn(SchedulerProvider.ui()).subscribe(arg_0 -> SystemStatusWidget.checkAndUpdateUI$lambda$4(this, arg_0), UxErrorHandle.logErrorConsumer("SystemStatusWidget", "Update UI "));
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
            this.addDisposable(disposable);
        }
    }

    @Override
    @Nullable
    public String getIdealDimensionRatioString() {
        return null;
    }

    @Override
    @NotNull
    public WidgetSizeDescription getWidgetSizeDescription() {
        return this.widgetSizeDescription;
    }

    public final void setSystemStatusMessageTextAppearance(@StyleRes int textAppearance) {
        this.systemStatusTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    public final void setSystemStatusMessageTextColor(@NotNull WarningLevel level, @ColorInt int color2) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Integer n = color2;
        this.getTextColorMap().put(level, n);
        this.checkAndUpdateUI();
    }

    public final void setSystemStatusMessageTextColor(@ColorInt int color2) {
        Integer n = color2;
        this.getTextColorMap().put(WarningLevel.SERIOUS_WARNING, n);
        n = color2;
        this.getTextColorMap().put(WarningLevel.WARNING, n);
        n = color2;
        this.getTextColorMap().put(WarningLevel.NORMAL, n);
        n = color2;
        this.getTextColorMap().put(WarningLevel.UNKNOWN, n);
        this.checkAndUpdateUI();
    }

    /*
     * WARNING - void declaration
     */
    @ColorInt
    public final int getSystemStatusMessageTextColor(@NotNull WarningLevel level) {
        int n;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Integer n2 = this.getTextColorMap().get(level);
        if (n2 != null) {
            void var2_2;
            int it = ((Number)n2).intValue();
            boolean bl = false;
            n = var2_2;
        } else {
            n = ViewExtensions.getColor((View)this, R.color.uxsdk_status_offline);
        }
        return n;
    }

    public final void setSystemStatusBackgroundDrawable(@NotNull WarningLevel level, @Nullable Drawable background) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this.backgroundDrawableMap.put(level, background);
        this.checkAndUpdateUI();
    }

    public final void setSystemStatusBackgroundDrawable(@Nullable Drawable background) {
        this.backgroundDrawableMap.put(WarningLevel.SERIOUS_WARNING, background);
        this.backgroundDrawableMap.put(WarningLevel.WARNING, background);
        this.backgroundDrawableMap.put(WarningLevel.NORMAL, background);
        this.backgroundDrawableMap.put(WarningLevel.UNKNOWN, background);
        this.checkAndUpdateUI();
    }

    @Nullable
    public final Drawable getSystemStatusBackgroundDrawable(@NotNull WarningLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return this.backgroundDrawableMap.get(level);
    }

    @SuppressLint(value={"Recycle"})
    private final void initAttributes(Context context, AttributeSet attrs) {
        Unit unit;
        Drawable it;
        boolean bl;
        TypedArray $this$getDrawableAndUse$iv;
        Drawable drawable$iv;
        TypedArray $this$getColorAndUse$iv;
        TypedArray $this$getDimensionAndUse$iv;
        TypedArray $this$getResourceIdAndUse$iv;
        int it2;
        TypedArray $this$getIntegerAndUse$iv;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SystemStatusWidget);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray $this$use$iv = typedArray;
        boolean $i$f$use = false;
        TypedArray typedArray2 = $this$use$iv;
        boolean bl2 = false;
        TypedArray typedArray3 = typedArray2;
        int index$iv = R.styleable.SystemStatusWidget_uxsdk_defaultMode;
        boolean $i$f$getIntegerAndUse = false;
        int intValue$iv = $this$getIntegerAndUse$iv.getInteger(index$iv, -1);
        if (intValue$iv != -1) {
            it2 = intValue$iv;
            boolean bl3 = false;
            this.setDefaultMode(DefaultMode.Companion.find(it2));
        }
        $this$getIntegerAndUse$iv = typedArray2;
        index$iv = R.styleable.SystemStatusWidget_uxsdk_systemStatusMessageTextAppearance;
        boolean $i$f$getResourceIdAndUse = false;
        int resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            it2 = resourceId$iv;
            boolean bl4 = false;
            this.setSystemStatusMessageTextAppearance(it2);
        }
        $this$getResourceIdAndUse$iv = typedArray2;
        index$iv = R.styleable.SystemStatusWidget_uxsdk_systemStatusMessageTextSize;
        boolean $i$f$getDimensionAndUse = false;
        float dimension$iv = $this$getDimensionAndUse$iv.getDimension(index$iv, -1.0f);
        if (!(dimension$iv == -1.0f)) {
            float it3 = dimension$iv;
            boolean bl5 = false;
            this.setSystemStatusMessageTextSize(DisplayUtil.pxToSp((Context)context, (float)it3));
        }
        $this$getDimensionAndUse$iv = typedArray2;
        index$iv = R.styleable.SystemStatusWidget_uxsdk_systemStatusMessageErrorTextColor;
        boolean $i$f$getColorAndUse = false;
        int colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            int it4 = colorInt$iv;
            boolean bl6 = false;
            this.setSystemStatusMessageTextColor(WarningLevel.SERIOUS_WARNING, it4);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.SystemStatusWidget_uxsdk_systemStatusMessageWarningTextColor;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            int it5 = colorInt$iv;
            boolean bl7 = false;
            this.setSystemStatusMessageTextColor(WarningLevel.WARNING, it5);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.SystemStatusWidget_uxsdk_systemStatusMessageGoodTextColor;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            int it6 = colorInt$iv;
            boolean bl8 = false;
            this.setSystemStatusMessageTextColor(WarningLevel.NORMAL, it6);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.SystemStatusWidget_uxsdk_systemStatusMessageOfflineTextColor;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            int it7 = colorInt$iv;
            boolean bl9 = false;
            this.setSystemStatusMessageTextColor(WarningLevel.UNKNOWN, it7);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.SystemStatusWidget_uxsdk_systemStatusErrorBackgroundDrawable;
        boolean $i$f$getDrawableAndUse = false;
        Drawable drawable2 = drawable$iv = $this$getDrawableAndUse$iv.getDrawable(index$iv);
        if (drawable2 != null) {
            Drawable it$iv = drawable2;
            bl = false;
            it = drawable$iv;
            boolean bl10 = false;
            this.setSystemStatusBackgroundDrawable(WarningLevel.SERIOUS_WARNING, it);
        }
        $this$getDrawableAndUse$iv = typedArray2;
        index$iv = R.styleable.SystemStatusWidget_uxsdk_systemStatusWarningBackgroundDrawable;
        $i$f$getDrawableAndUse = false;
        Drawable drawable3 = drawable$iv = $this$getDrawableAndUse$iv.getDrawable(index$iv);
        if (drawable3 != null) {
            Drawable it$iv = drawable3;
            bl = false;
            it = drawable$iv;
            boolean bl11 = false;
            this.setSystemStatusBackgroundDrawable(WarningLevel.WARNING, it);
        }
        $this$getDrawableAndUse$iv = typedArray2;
        index$iv = R.styleable.SystemStatusWidget_uxsdk_systemStatusGoodBackgroundDrawable;
        $i$f$getDrawableAndUse = false;
        Drawable drawable4 = drawable$iv = $this$getDrawableAndUse$iv.getDrawable(index$iv);
        if (drawable4 != null) {
            Drawable it$iv = drawable4;
            bl = false;
            it = drawable$iv;
            boolean bl12 = false;
            this.setSystemStatusBackgroundDrawable(WarningLevel.NORMAL, it);
        }
        $this$getDrawableAndUse$iv = typedArray2;
        index$iv = R.styleable.SystemStatusWidget_uxsdk_systemStatusOfflineBackgroundDrawable;
        $i$f$getDrawableAndUse = false;
        Drawable drawable5 = drawable$iv = $this$getDrawableAndUse$iv.getDrawable(index$iv);
        if (drawable5 != null) {
            Drawable it$iv = drawable5;
            bl = false;
            it = drawable$iv;
            boolean bl13 = false;
            this.setSystemStatusBackgroundDrawable(WarningLevel.UNKNOWN, it);
        }
        $this$getDrawableAndUse$iv = typedArray2;
        index$iv = R.styleable.SystemStatusWidget_uxsdk_onStateChange;
        $i$f$getResourceIdAndUse = false;
        resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            int it8 = resourceId$iv;
            boolean bl14 = false;
            this.stateChangeResourceId = it8;
        }
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl15 = false;
        $this$use$iv.recycle();
    }

    @Override
    @NotNull
    public Flowable<ModelState> getWidgetStateUpdate() {
        return super.getWidgetStateUpdate();
    }

    @NotNull
    public final Flowable<UIState> getUIStateUpdates() {
        Flowable flowable = this.uiUpdateStateProcessor.onBackpressureBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"onBackpressureBuffer(...)");
        return flowable;
    }

    @JvmOverloads
    public SystemStatusWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public SystemStatusWidget(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final SystemStatusWidgetModel widgetModel_delegate$lambda$0() {
        DJISDKModel dJISDKModel = DJISDKModel.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dJISDKModel, (String)"getInstance(...)");
        ObservableInMemoryKeyedStore observableInMemoryKeyedStore = ObservableInMemoryKeyedStore.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)observableInMemoryKeyedStore, (String)"getInstance(...)");
        return new SystemStatusWidgetModel(dJISDKModel, observableInMemoryKeyedStore, GlobalPreferencesManager.getInstance());
    }

    private static final Map textColorMap_delegate$lambda$1(SystemStatusWidget this$0) {
        Map map;
        if (this$0.isInEditMode()) {
            map = new LinkedHashMap();
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)WarningLevel.SERIOUS_WARNING, (Object)ViewExtensions.getColor((View)this$0, R.color.uxsdk_status_error)), TuplesKt.to((Object)WarningLevel.WARNING, (Object)ViewExtensions.getColor((View)this$0, R.color.uxsdk_status_warning)), TuplesKt.to((Object)WarningLevel.NORMAL, (Object)ViewExtensions.getColor((View)this$0, R.color.uxsdk_status_good)), TuplesKt.to((Object)WarningLevel.UNKNOWN, (Object)ViewExtensions.getColor((View)this$0, R.color.uxsdk_status_offline))};
            map = MapsKt.mutableMapOf((Pair[])pairArray);
        }
        return map;
    }

    private static final void reactToCompassError$lambda$3(SystemStatusWidget this$0, android.util.Pair values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Object object = values.first;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
        DJIDeviceStatus dJIDeviceStatus = (DJIDeviceStatus)object;
        Object object2 = values.second;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"second");
        this$0.updateVoiceNotification(dJIDeviceStatus, (Boolean)object2);
    }

    private static final void checkAndUpdateUI$lambda$4(SystemStatusWidget this$0, DJIDeviceStatus it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateUI(it);
    }

    public static final /* synthetic */ void access$updateUI(SystemStatusWidget $this, DJIDeviceStatus status) {
        $this.updateUI(status);
    }

    public static final /* synthetic */ void access$updateMessage(SystemStatusWidget $this, SystemStatusWidgetModel.WarningStatusMessageData messageData) {
        $this.updateMessage(messageData);
    }

    public static final /* synthetic */ PublishProcessor access$getWidgetStateDataProcessor(SystemStatusWidget $this) {
        return $this.getWidgetStateDataProcessor();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\tB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0002\u001a\u00020\u00038G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\n"}, d2={"Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidget$DefaultMode;", "", "value", "", "<init>", "(Ljava/lang/String;II)V", "()I", "COLOR", "GRADIENT", "Companion", "android-sdk-v5-uxsdk_debug"})
    public static final class DefaultMode
    extends Enum<DefaultMode> {
        @NotNull
        public static final Companion Companion;
        private final int value;
        @NotNull
        private static final DefaultMode[] values;
        public static final /* enum */ DefaultMode COLOR;
        public static final /* enum */ DefaultMode GRADIENT;
        private static final /* synthetic */ DefaultMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DefaultMode(int value) {
            this.value = value;
        }

        @JvmName(name="value")
        public final int value() {
            return this.value;
        }

        public static DefaultMode[] values() {
            return (DefaultMode[])$VALUES.clone();
        }

        public static DefaultMode valueOf(String value) {
            return Enum.valueOf(DefaultMode.class, value);
        }

        @NotNull
        public static EnumEntries<DefaultMode> getEntries() {
            return $ENTRIES;
        }

        @NotNull
        public static final DefaultMode[] getValues() {
            return Companion.getValues();
        }

        @JvmStatic
        @NotNull
        public static final DefaultMode find(int value) {
            return Companion.find(value);
        }

        static {
            COLOR = new DefaultMode(0);
            GRADIENT = new DefaultMode(1);
            $VALUES = defaultModeArray = new DefaultMode[]{DefaultMode.COLOR, DefaultMode.GRADIENT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            values = DefaultMode.values();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0007R$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0010\n\u0002\u0010\n\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidget$DefaultMode$Companion;", "", "<init>", "()V", "values", "", "Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidget$DefaultMode;", "getValues$annotations", "getValues", "()[Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidget$DefaultMode;", "[Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidget$DefaultMode;", "find", "value", "", "android-sdk-v5-uxsdk_debug"})
        @SourceDebugExtension(value={"SMAP\nSystemStatusWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SystemStatusWidget.kt\ndji/v5/ux/core/widget/systemstatus/SystemStatusWidget$DefaultMode$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,449:1\n1#2:450\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DefaultMode[] getValues() {
                return values;
            }

            @JvmStatic
            public static /* synthetic */ void getValues$annotations() {
            }

            @JvmStatic
            @NotNull
            public final DefaultMode find(int value) {
                DefaultMode defaultMode;
                DefaultMode defaultMode2;
                block2: {
                    DefaultMode[] defaultModeArray = this.getValues();
                    int n = defaultModeArray.length;
                    for (int i = 0; i < n; ++i) {
                        DefaultMode defaultMode3;
                        DefaultMode it = defaultMode3 = defaultModeArray[i];
                        boolean bl = false;
                        if (!(it.value() == value)) continue;
                        defaultMode2 = defaultMode3;
                        break block2;
                    }
                    defaultMode2 = defaultMode = null;
                }
                if (defaultMode2 == null) {
                    defaultMode = COLOR;
                }
                return defaultMode;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidget$ModelState;", "", "<init>", "()V", "ProductConnected", "SystemStatusUpdated", "Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidget$ModelState$ProductConnected;", "Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidget$ModelState$SystemStatusUpdated;", "android-sdk-v5-uxsdk_debug"})
    public static abstract class ModelState {
        private ModelState() {
        }

        public /* synthetic */ ModelState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u00a8\u0006\u0010"}, d2={"Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidget$ModelState$ProductConnected;", "Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidget$ModelState;", "isConnected", "", "<init>", "(Z)V", "()Z", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_debug"})
        public static final class ProductConnected
        extends ModelState {
            private final boolean isConnected;

            public ProductConnected(boolean isConnected) {
                super(null);
                this.isConnected = isConnected;
            }

            public final boolean isConnected() {
                return this.isConnected;
            }

            public final boolean component1() {
                return this.isConnected;
            }

            @NotNull
            public final ProductConnected copy(boolean isConnected) {
                return new ProductConnected(isConnected);
            }

            public static /* synthetic */ ProductConnected copy$default(ProductConnected productConnected, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = productConnected.isConnected;
                }
                return productConnected.copy(bl);
            }

            @NotNull
            public String toString() {
                return "ProductConnected(isConnected=" + this.isConnected + ")";
            }

            public int hashCode() {
                return Boolean.hashCode(this.isConnected);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ProductConnected)) {
                    return false;
                }
                ProductConnected productConnected = (ProductConnected)other;
                return this.isConnected == productConnected.isConnected;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidget$ModelState$SystemStatusUpdated;", "Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidget$ModelState;", "status", "Ldji/v5/manager/diagnostic/DJIDeviceStatus;", "<init>", "(Ldji/v5/manager/diagnostic/DJIDeviceStatus;)V", "getStatus", "()Ldji/v5/manager/diagnostic/DJIDeviceStatus;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_debug"})
        public static final class SystemStatusUpdated
        extends ModelState {
            @NotNull
            private final DJIDeviceStatus status;

            public SystemStatusUpdated(@NotNull DJIDeviceStatus status) {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                super(null);
                this.status = status;
            }

            @NotNull
            public final DJIDeviceStatus getStatus() {
                return this.status;
            }

            @NotNull
            public final DJIDeviceStatus component1() {
                return this.status;
            }

            @NotNull
            public final SystemStatusUpdated copy(@NotNull DJIDeviceStatus status) {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                return new SystemStatusUpdated(status);
            }

            public static /* synthetic */ SystemStatusUpdated copy$default(SystemStatusUpdated systemStatusUpdated, DJIDeviceStatus dJIDeviceStatus, int n, Object object) {
                if ((n & 1) != 0) {
                    dJIDeviceStatus = systemStatusUpdated.status;
                }
                return systemStatusUpdated.copy(dJIDeviceStatus);
            }

            @NotNull
            public String toString() {
                return "SystemStatusUpdated(status=" + this.status + ")";
            }

            public int hashCode() {
                return this.status.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SystemStatusUpdated)) {
                    return false;
                }
                SystemStatusUpdated systemStatusUpdated = (SystemStatusUpdated)other;
                return this.status == systemStatusUpdated.status;
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0001\u0005\u00a8\u0006\u0006"}, d2={"Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidget$UIState;", "", "<init>", "()V", "WidgetClicked", "Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidget$UIState$WidgetClicked;", "android-sdk-v5-uxsdk_debug"})
    public static abstract class UIState {
        private UIState() {
        }

        public /* synthetic */ UIState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidget$UIState$WidgetClicked;", "Ldji/v5/ux/core/widget/systemstatus/SystemStatusWidget$UIState;", "<init>", "()V", "android-sdk-v5-uxsdk_debug"})
        public static final class WidgetClicked
        extends UIState {
            @NotNull
            public static final WidgetClicked INSTANCE = new WidgetClicked();

            private WidgetClicked() {
                super(null);
            }
        }
    }
}

