/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.hsi;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import dji.sdk.keyvalue.value.common.LocationCoordinate2D;
import dji.sdk.keyvalue.value.common.Velocity3D;
import dji.sdk.keyvalue.value.rtkmobilestation.RTKTakeoffAltitudeInfo;
import dji.v5.common.utils.GpsUtils;
import dji.v5.common.utils.UnitUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.ui.hsi.dashboard.AttitudeDashBoard;
import dji.v5.ux.core.widget.hsi.AttitudeDisplayModel;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableEmitter;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\b\u0007\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010+\u001a\u00020,H\u0014J\b\u0010-\u001a\u00020,H\u0014J\b\u0010.\u001a\u00020,H\u0002J\b\u0010/\u001a\u00020,H\u0002J\"\u00100\u001a\u00020,2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u00101\u001a\u00020,2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u00102\u001a\u00020,H\u0014J\n\u00103\u001a\u0004\u0018\u000104H\u0016R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0014\"\u0004\b\u001f\u0010\u0016R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Ldji/v5/ux/core/widget/hsi/AttitudeDisplayWidget;", "Ldji/v5/ux/core/base/widget/ConstraintLayoutWidget;", "", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mAttitudeDashBoard", "Ldji/v5/ux/core/ui/hsi/dashboard/AttitudeDashBoard;", "getMAttitudeDashBoard", "()Ldji/v5/ux/core/ui/hsi/dashboard/AttitudeDashBoard;", "setMAttitudeDashBoard", "(Ldji/v5/ux/core/ui/hsi/dashboard/AttitudeDashBoard;)V", "mTvAslText", "Landroid/widget/TextView;", "getMTvAslText", "()Landroid/widget/TextView;", "setMTvAslText", "(Landroid/widget/TextView;)V", "mTvAslValue", "getMTvAslValue", "setMTvAslValue", "mTvVsText", "getMTvVsText", "setMTvVsText", "mTvVsValue", "getMTvVsValue", "setMTvVsValue", "mAltitude", "", "mHomePointAltitude", "mSpeedZ", "", "mDroneLocation", "Ldji/sdk/keyvalue/value/common/LocationCoordinate2D;", "mCompositeDisposable", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "widgetModel", "Ldji/v5/ux/core/widget/hsi/AttitudeDisplayModel;", "onAttachedToWindow", "", "onDetachedFromWindow", "updateAltitude", "updateSpeed", "initView", "loadLayout", "reactToModelChanges", "getIdealDimensionRatioString", "", "android-sdk-v5-uxsdk_debug"})
public class AttitudeDisplayWidget
extends ConstraintLayoutWidget<Boolean> {
    @Nullable
    private AttitudeDashBoard mAttitudeDashBoard;
    @Nullable
    private TextView mTvAslText;
    @Nullable
    private TextView mTvAslValue;
    @Nullable
    private TextView mTvVsText;
    @Nullable
    private TextView mTvVsValue;
    private double mAltitude;
    private double mHomePointAltitude;
    private float mSpeedZ;
    @Nullable
    private LocationCoordinate2D mDroneLocation;
    @NotNull
    private final CompositeDisposable mCompositeDisposable;
    @NotNull
    private final AttitudeDisplayModel widgetModel;

    @JvmOverloads
    public AttitudeDisplayWidget(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Context context2 = context;
        Intrinsics.checkNotNull((Object)context2);
        super(context2, attrs, defStyleAttr);
        this.mCompositeDisposable = new CompositeDisposable();
        DJISDKModel dJISDKModel = DJISDKModel.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dJISDKModel, (String)"getInstance(...)");
        ObservableInMemoryKeyedStore observableInMemoryKeyedStore = ObservableInMemoryKeyedStore.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)observableInMemoryKeyedStore, (String)"getInstance(...)");
        this.widgetModel = new AttitudeDisplayModel(dJISDKModel, observableInMemoryKeyedStore);
    }

    public /* synthetic */ AttitudeDisplayWidget(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @Nullable
    public final AttitudeDashBoard getMAttitudeDashBoard() {
        return this.mAttitudeDashBoard;
    }

    public final void setMAttitudeDashBoard(@Nullable AttitudeDashBoard attitudeDashBoard) {
        this.mAttitudeDashBoard = attitudeDashBoard;
    }

    @Nullable
    public final TextView getMTvAslText() {
        return this.mTvAslText;
    }

    public final void setMTvAslText(@Nullable TextView textView) {
        this.mTvAslText = textView;
    }

    @Nullable
    public final TextView getMTvAslValue() {
        return this.mTvAslValue;
    }

    public final void setMTvAslValue(@Nullable TextView textView) {
        this.mTvAslValue = textView;
    }

    @Nullable
    public final TextView getMTvVsText() {
        return this.mTvVsText;
    }

    public final void setMTvVsText(@Nullable TextView textView) {
        this.mTvVsText = textView;
    }

    @Nullable
    public final TextView getMTvVsValue() {
        return this.mTvVsValue;
    }

    public final void setMTvVsValue(@Nullable TextView textView) {
        this.mTvVsValue = textView;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            AttitudeDashBoard attitudeDashBoard = this.mAttitudeDashBoard;
            if (attitudeDashBoard != null) {
                attitudeDashBoard.setModel(this.widgetModel);
            }
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
    }

    private final void updateAltitude() {
        this.mCompositeDisposable.add(Observable.create(arg_0 -> AttitudeDisplayWidget.updateAltitude$lambda$0(this, arg_0)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(new Consumer(this){
            final /* synthetic */ AttitudeDisplayWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Object aValue) {
                block1: {
                    Locale locale = Locale.US;
                    String string2 = "%06.1f";
                    Object[] objectArray = new Object[]{aValue};
                    String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, format, *args)");
                    String value = string3;
                    TextView textView = this.this$0.getMTvAslValue();
                    if (Intrinsics.areEqual((Object)(textView != null ? textView.getText() : null), (Object)value)) break block1;
                    TextView textView2 = this.this$0.getMTvAslValue();
                    if (textView2 != null) {
                        textView2.setText((CharSequence)value);
                    }
                }
            }
        }));
    }

    private final void updateSpeed() {
        block1: {
            float showSpeedZ = this.mSpeedZ;
            if (!Float.isNaN(this.mSpeedZ) && !(this.mSpeedZ == 0.0f)) {
                showSpeedZ = -this.mSpeedZ;
            }
            float value = UnitUtils.transFormSpeedIntoDifferentUnit((float)showSpeedZ);
            TextView textView = this.mTvVsValue;
            if (textView == null) break block1;
            Locale locale = Locale.US;
            String string2 = "%03.1f";
            Object[] objectArray = new Object[]{Float.valueOf(value)};
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, format, *args)");
            textView.setText((CharSequence)string3);
        }
    }

    @Override
    protected void initView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.loadLayout(context);
        this.mAttitudeDashBoard = (AttitudeDashBoard)this.findViewById(R.id.pfd_attitude_dash_board);
        this.mTvAslText = (TextView)this.findViewById(R.id.pfd_asl_text);
        this.mTvAslValue = (TextView)this.findViewById(R.id.pfd_asl_value);
        this.mTvVsText = (TextView)this.findViewById(R.id.pfd_vs_text);
        this.mTvVsValue = (TextView)this.findViewById(R.id.pfd_vs_value);
    }

    public void loadLayout(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ConstraintLayout.inflate((Context)context, (int)R.layout.uxsdk_liveview_pfd_attitude_display_widget, (ViewGroup)((ViewGroup)this));
    }

    @Override
    protected void reactToModelChanges() {
        this.mCompositeDisposable.add(this.widgetModel.getVelocityProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ AttitudeDisplayWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Velocity3D velocity3D) {
                Intrinsics.checkNotNullParameter((Object)velocity3D, (String)"velocity3D");
                AttitudeDisplayWidget.access$setMSpeedZ$p(this.this$0, (float)velocity3D.getZ().doubleValue());
                AttitudeDisplayWidget.access$updateSpeed(this.this$0);
            }
        }));
        this.mCompositeDisposable.add(this.widgetModel.getAltitudeProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ AttitudeDisplayWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(double altitude) {
                AttitudeDisplayWidget.access$setMAltitude$p(this.this$0, altitude);
                AttitudeDisplayWidget.access$updateAltitude(this.this$0);
            }
        }));
        this.mCompositeDisposable.add(this.widgetModel.getRtkTakeoffAltitudeInfoProcessor().toFlowable().observeOn(SchedulerProvider.ui()).filter(new Predicate(this){
            final /* synthetic */ AttitudeDisplayWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final boolean test(RTKTakeoffAltitudeInfo info) {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                return Math.abs(AttitudeDisplayWidget.access$getMHomePointAltitude$p(this.this$0) - (double)((float)info.getAltitude().doubleValue())) >= 0.001;
            }
        }).subscribe(new Consumer(this){
            final /* synthetic */ AttitudeDisplayWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(RTKTakeoffAltitudeInfo rtkTakeoffAltitudeInfo) {
                Intrinsics.checkNotNullParameter((Object)rtkTakeoffAltitudeInfo, (String)"rtkTakeoffAltitudeInfo");
                AttitudeDisplayWidget.access$setMHomePointAltitude$p(this.this$0, rtkTakeoffAltitudeInfo.getAltitude());
                AttitudeDisplayWidget.access$updateAltitude(this.this$0);
            }
        }));
        this.mCompositeDisposable.add(this.widgetModel.getAircraftLocationDataProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ AttitudeDisplayWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(LocationCoordinate2D locationCoordinate2D) {
                AttitudeDisplayWidget.access$setMDroneLocation$p(this.this$0, locationCoordinate2D);
                if (AttitudeDisplayWidget.access$getMDroneLocation$p(this.this$0) != null) {
                    AttitudeDisplayWidget.access$updateAltitude(this.this$0);
                }
            }
        }));
    }

    @Override
    @Nullable
    public String getIdealDimensionRatioString() {
        return null;
    }

    @JvmOverloads
    public AttitudeDisplayWidget(@Nullable Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public AttitudeDisplayWidget(@Nullable Context context) {
        this(context, null, 0, 6, null);
    }

    private static final void updateAltitude$lambda$0(AttitudeDisplayWidget this$0, ObservableEmitter emitter) {
        Double d;
        Double lat;
        Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
        if (this$0.mDroneLocation != null) {
            LocationCoordinate2D locationCoordinate2D = this$0.mDroneLocation;
            Intrinsics.checkNotNull((Object)locationCoordinate2D);
            v1 = locationCoordinate2D.getLatitude();
        } else {
            v1 = lat = Double.valueOf(Double.NaN);
        }
        if (this$0.mDroneLocation != null) {
            LocationCoordinate2D locationCoordinate2D = this$0.mDroneLocation;
            Intrinsics.checkNotNull((Object)locationCoordinate2D);
            d = locationCoordinate2D.getLongitude();
        } else {
            d = Double.NaN;
        }
        Double lon = d;
        double d2 = this$0.mHomePointAltitude + this$0.mAltitude;
        Intrinsics.checkNotNull((Object)lat);
        double d3 = lat;
        Intrinsics.checkNotNull((Object)lon);
        double aslValue = GpsUtils.egm96Altitude((double)d2, (double)d3, (double)lon);
        float value = UnitUtils.getValueFromMetricByLength((float)((float)aslValue), (UnitUtils.UnitType)(UnitUtils.isMetricUnits() ? UnitUtils.UnitType.METRIC : UnitUtils.UnitType.IMPERIAL));
        emitter.onNext((Object)Float.valueOf(value));
        emitter.onComplete();
    }

    public static final /* synthetic */ void access$setMSpeedZ$p(AttitudeDisplayWidget $this, float f) {
        $this.mSpeedZ = f;
    }

    public static final /* synthetic */ void access$updateSpeed(AttitudeDisplayWidget $this) {
        $this.updateSpeed();
    }

    public static final /* synthetic */ void access$setMAltitude$p(AttitudeDisplayWidget $this, double d) {
        $this.mAltitude = d;
    }

    public static final /* synthetic */ void access$updateAltitude(AttitudeDisplayWidget $this) {
        $this.updateAltitude();
    }

    public static final /* synthetic */ double access$getMHomePointAltitude$p(AttitudeDisplayWidget $this) {
        return $this.mHomePointAltitude;
    }

    public static final /* synthetic */ void access$setMHomePointAltitude$p(AttitudeDisplayWidget $this, double d) {
        $this.mHomePointAltitude = d;
    }

    public static final /* synthetic */ void access$setMDroneLocation$p(AttitudeDisplayWidget $this, LocationCoordinate2D locationCoordinate2D) {
        $this.mDroneLocation = locationCoordinate2D;
    }

    public static final /* synthetic */ LocationCoordinate2D access$getMDroneLocation$p(AttitudeDisplayWidget $this) {
        return $this.mDroneLocation;
    }
}

