/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.hd.frequency;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.AirLinkKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.airlink.Bandwidth;
import dji.sdk.keyvalue.value.airlink.ChannelSelectionMode;
import dji.sdk.keyvalue.value.airlink.FrequencyBand;
import dji.sdk.keyvalue.value.airlink.FrequencyInterferenceInfo;
import dji.sdk.keyvalue.value.airlink.SDRHdOffsetParams;
import dji.sdk.keyvalue.value.common.IntMinMax;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.List;

public class FreqRangeRectViewModel
extends WidgetModel {
    private DataProcessor<Integer> frequencyPointIndexProcessor = DataProcessor.create(0);
    private DataProcessor<ChannelSelectionMode> channelSelectionModeDataProcessor = DataProcessor.create(ChannelSelectionMode.UNKNOWN);
    private DataProcessor<Bandwidth> bandwidthDataProcessor = DataProcessor.create(Bandwidth.UNKNOWN);
    private DataProcessor<List<FrequencyInterferenceInfo>> frequencyPointRSSIInfoDataProcessor = DataProcessor.create(new ArrayList());
    private DataProcessor<IntMinMax> frequencyPointIndexRangeProcessor = DataProcessor.create(new IntMinMax());
    private DataProcessor<SDRHdOffsetParams> sdrHdOffsetParamsProcessor = DataProcessor.create(new SDRHdOffsetParams());
    private DataProcessor<FrequencyBand> frequencyBandDataProcessor = DataProcessor.create(FrequencyBand.UNKNOWN);

    protected FreqRangeRectViewModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore uxKeyManager) {
        super(djiSdkModel, uxKeyManager);
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyFrequencyPoint), this.frequencyPointIndexProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyChannelSelectionMode), this.channelSelectionModeDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyBandwidth), this.bandwidthDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyFrequencyInterference), this.frequencyPointRSSIInfoDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyFrequencyPointRange), this.frequencyPointIndexRangeProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeySDRHdOffsetParams), this.sdrHdOffsetParamsProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyFrequencyBand), this.frequencyBandDataProcessor);
    }

    @Override
    protected void inCleanup() {
    }

    public Flowable<Integer> getFrequencyPointIndex() {
        return this.frequencyPointIndexProcessor.toFlowableOnUI();
    }

    public Completable setFrequencyPointIndex(Integer value) {
        return this.djiSdkModel.setValue(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyFrequencyPoint), value);
    }

    public Flowable<ChannelSelectionMode> getChannelSelectionMode() {
        return this.channelSelectionModeDataProcessor.toFlowableOnUI();
    }

    public Flowable<Bandwidth> getBandwidth() {
        return this.bandwidthDataProcessor.toFlowableOnUI();
    }

    public Flowable<List<FrequencyInterferenceInfo>> getFrequencyPointRSSIInfo() {
        return this.frequencyPointRSSIInfoDataProcessor.toFlowableOnUI();
    }

    public Flowable<IntMinMax> getFrequencyPointIndexRange() {
        return this.frequencyPointIndexRangeProcessor.toFlowableOnUI();
    }

    public Flowable<SDRHdOffsetParams> getSDRHdOffsetParams() {
        return this.sdrHdOffsetParamsProcessor.toFlowableOnUI();
    }

    public Flowable<FrequencyBand> getFrequencyBand() {
        return this.frequencyBandDataProcessor.toFlowableOnUI();
    }
}

