/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.hd;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.AirLinkKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.airlink.Bandwidth;
import dji.sdk.keyvalue.value.airlink.FrequencyInterferenceInfo;
import dji.sdk.keyvalue.value.airlink.SDRHdOffsetParams;
import dji.sdk.keyvalue.value.common.IntMinMax;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.List;

public class InfoWidgetModel
extends WidgetModel {
    private DataProcessor<Bandwidth> bandwidthDataProcessor = DataProcessor.create(Bandwidth.UNKNOWN);
    private DataProcessor<List<FrequencyInterferenceInfo>> frequencyInterfaceInfoProcessor = DataProcessor.create(new ArrayList());
    private DataProcessor<IntMinMax> frequencyPointIndexRangeProcessor = DataProcessor.create(new IntMinMax());
    private DataProcessor<SDRHdOffsetParams> sdrHdOffsetParamsDataProcessor = DataProcessor.create(new SDRHdOffsetParams());
    private DataProcessor<Double> dynamicDataRateProcessor = DataProcessor.create(0.0);
    private DataProcessor<Integer> frequencyPointIndexProcessor = DataProcessor.create(0);
    private DataProcessor<Integer> downLinkQualityProcessor = DataProcessor.create(0);
    private DataProcessor<Integer> upLinkQualityProcessor = DataProcessor.create(0);
    private DataProcessor<Integer> linkSignalQualityProcessor = DataProcessor.create(0);
    private DataProcessor<Boolean> fcConnectionProcessor = DataProcessor.create(false);

    protected InfoWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore uxKeyManager) {
        super(djiSdkModel, uxKeyManager);
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyBandwidth), this.bandwidthDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyFrequencyInterference), this.frequencyInterfaceInfoProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyFrequencyPointRange), this.frequencyPointIndexRangeProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeySDRHdOffsetParams), this.sdrHdOffsetParamsDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyDynamicDataRate), this.dynamicDataRateProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyFrequencyPoint), this.frequencyPointIndexProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyDownLinkQuality), this.downLinkQualityProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyUpLinkQuality), this.upLinkQualityProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyLinkSignalQuality), this.linkSignalQualityProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyConnection), this.fcConnectionProcessor);
    }

    @Override
    protected void inCleanup() {
    }

    public Flowable<Bandwidth> getBandwidth() {
        return this.bandwidthDataProcessor.toFlowableOnUI();
    }

    public Flowable<List<FrequencyInterferenceInfo>> getFrequencyInterfaceInfoList() {
        return this.frequencyInterfaceInfoProcessor.toFlowableOnUI();
    }

    public Flowable<IntMinMax> getFrequencyPointIndexRange() {
        return this.frequencyPointIndexRangeProcessor.toFlowableOnUI();
    }

    public Flowable<SDRHdOffsetParams> getSdrHdOffsetParamsData() {
        return this.sdrHdOffsetParamsDataProcessor.toFlowableOnUI();
    }

    public Flowable<Double> getDynamicDataRate() {
        return this.dynamicDataRateProcessor.toFlowableOnUI();
    }

    public Flowable<Integer> getFrequencyPointIndex() {
        return this.frequencyPointIndexProcessor.toFlowableOnUI();
    }

    public Flowable<Integer> getDownLinkQuality() {
        return this.downLinkQualityProcessor.toFlowableOnUI();
    }

    public Flowable<Integer> getUpLinkQuality() {
        return this.upLinkQualityProcessor.toFlowableOnUI();
    }

    public Flowable<Integer> getLinkSignalQuality() {
        return this.linkSignalQualityProcessor.toFlowableOnUI();
    }

    public Flowable<Boolean> getFcConnection() {
        return this.fcConnectionProcessor.toFlowableOnUI();
    }
}

