/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.gpssignal;

import dji.sdk.keyvalue.key.DJIKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.key.RtkMobileStationKey;
import dji.sdk.keyvalue.value.flightcontroller.GPSSignalLevel;
import dji.sdk.keyvalue.value.rtkbasestation.RTKReferenceStationSource;
import dji.sdk.keyvalue.value.rtkbasestation.RTKServiceState;
import dji.sdk.keyvalue.value.rtkbasestation.RTKStationConnetState;
import dji.sdk.keyvalue.value.rtkmobilestation.RTKReceiverInfo;
import dji.sdk.keyvalue.value.rtkmobilestation.RTKSatelliteInfo;
import dji.v5.common.callback.CommonCallbacks;
import dji.v5.common.error.IDJIError;
import dji.v5.et.DJIKeyEtKt;
import dji.v5.et.DJIKeyInfoEtKt;
import dji.v5.manager.KeyManager;
import dji.v5.manager.aircraft.rtk.RTKSystemState;
import dji.v5.manager.aircraft.rtk.RTKSystemStateListener;
import dji.v5.manager.aircraft.rtk.network.INetworkServiceInfoListener;
import dji.v5.manager.aircraft.rtk.station.RTKStationConnectStatusListener;
import dji.v5.manager.interfaces.IRTKCenter;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.accessory.RTKStartServiceHelper;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0003>?@B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u00100\u001a\u000201H\u0014J\b\u00102\u001a\u000201H\u0014J\u000e\u00103\u001a\u0002012\u0006\u00104\u001a\u00020\u000fJ\u0010\u00105\u001a\u0002012\u0006\u00106\u001a\u000207H\u0002J\b\u00108\u001a\u000201H\u0002J\b\u00109\u001a\u000201H\u0002J\b\u0010:\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u0002012\u0006\u0010.\u001a\u00020\u0013H\u0002J\b\u0010=\u001a\u00020;H\u0002J\u0010\u0010+\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rH\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u001d0\u001d0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u001f0\u001f0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00190'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00190'8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001f0'8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010)R\u0017\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001d0'8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010)\u00a8\u0006A"}, d2={"Ldji/v5/ux/core/widget/gpssignal/GpsSignalWidgetModel;", "Ldji/v5/ux/core/base/WidgetModel;", "djiSdkModel", "Ldji/v5/ux/core/base/DJISDKModel;", "keyedStore", "Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;", "rtkCenter", "Ldji/v5/manager/interfaces/IRTKCenter;", "<init>", "(Ldji/v5/ux/core/base/DJISDKModel;Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;Ldji/v5/manager/interfaces/IRTKCenter;)V", "getRtkCenter", "()Ldji/v5/manager/interfaces/IRTKCenter;", "rtkSystemState", "Ldji/v5/manager/aircraft/rtk/RTKSystemState;", "isRtkModuleAvailable", "", "rtkServiceState", "Ldji/sdk/keyvalue/value/rtkbasestation/RTKServiceState;", "currentGpsSignalLevel", "Ldji/sdk/keyvalue/value/flightcontroller/GPSSignalLevel;", "baseStationConnectStatus", "Ldji/sdk/keyvalue/value/rtkbasestation/RTKStationConnetState;", "isUsingRtkKeeping", "gpsSatelliteCountProcessor", "Ldji/v5/ux/core/util/DataProcessor;", "", "kotlin.jvm.PlatformType", "rtkSatelliteCountProcessor", "gpsSignalLevelProcessor", "Ldji/v5/ux/core/widget/gpssignal/GpsSignalWidgetModel$SignalLevel;", "rtkOverviewProcessor", "Ldji/v5/ux/core/widget/gpssignal/GpsSignalWidgetModel$RtkOverview;", "rtkSystemStateListener", "Ldji/v5/manager/aircraft/rtk/RTKSystemStateListener;", "connectStatusListener", "Ldji/v5/manager/aircraft/rtk/station/RTKStationConnectStatusListener;", "networkServiceInfoListener", "Ldji/v5/manager/aircraft/rtk/network/INetworkServiceInfoListener;", "gpsSatelliteCount", "Lio/reactivex/rxjava3/core/Flowable;", "getGpsSatelliteCount", "()Lio/reactivex/rxjava3/core/Flowable;", "rtkSatelliteCount", "getRtkSatelliteCount", "rtkOverview", "getRtkOverview", "gpsSignalLevel", "getGpsSignalLevel", "inSetup", "", "inCleanup", "setRTKEnable", "boolean", "updateRTKListener", "rtkSource", "Ldji/sdk/keyvalue/value/rtkbasestation/RTKReferenceStationSource;", "updateRtkOverview", "resetData", "updateBaseRtkState", "Ldji/v5/ux/core/widget/gpssignal/GpsSignalWidgetModel$RtkState;", "updateSignalLevel", "updateRtcmStatus", "RtkOverview", "RtkState", "SignalLevel", "android-sdk-v5-uxsdk_debug"})
@SourceDebugExtension(value={"SMAP\nGPSSignalWidgetModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GPSSignalWidgetModel.kt\ndji/v5/ux/core/widget/gpssignal/GpsSignalWidgetModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,411:1\n1549#2:412\n1620#2,3:413\n*S KotlinDebug\n*F\n+ 1 GPSSignalWidgetModel.kt\ndji/v5/ux/core/widget/gpssignal/GpsSignalWidgetModel\n*L\n333#1:412\n333#1:413,3\n*E\n"})
public final class GpsSignalWidgetModel
extends WidgetModel {
    @NotNull
    private final IRTKCenter rtkCenter;
    @NotNull
    private RTKSystemState rtkSystemState;
    private boolean isRtkModuleAvailable;
    @NotNull
    private RTKServiceState rtkServiceState;
    @NotNull
    private GPSSignalLevel currentGpsSignalLevel;
    @NotNull
    private RTKStationConnetState baseStationConnectStatus;
    private boolean isUsingRtkKeeping;
    @NotNull
    private final DataProcessor<Integer> gpsSatelliteCountProcessor;
    @NotNull
    private final DataProcessor<Integer> rtkSatelliteCountProcessor;
    @NotNull
    private final DataProcessor<SignalLevel> gpsSignalLevelProcessor;
    @NotNull
    private final DataProcessor<RtkOverview> rtkOverviewProcessor;
    @NotNull
    private final RTKSystemStateListener rtkSystemStateListener;
    @NotNull
    private final RTKStationConnectStatusListener connectStatusListener;
    @NotNull
    private final INetworkServiceInfoListener networkServiceInfoListener;

    public GpsSignalWidgetModel(@NotNull DJISDKModel djiSdkModel, @NotNull ObservableInMemoryKeyedStore keyedStore, @NotNull IRTKCenter rtkCenter) {
        Intrinsics.checkNotNullParameter((Object)djiSdkModel, (String)"djiSdkModel");
        Intrinsics.checkNotNullParameter((Object)keyedStore, (String)"keyedStore");
        Intrinsics.checkNotNullParameter((Object)rtkCenter, (String)"rtkCenter");
        super(djiSdkModel, keyedStore);
        this.rtkCenter = rtkCenter;
        this.rtkSystemState = new RTKSystemState();
        this.rtkServiceState = RTKServiceState.UNKNOWN;
        this.currentGpsSignalLevel = GPSSignalLevel.UNKNOWN;
        this.baseStationConnectStatus = RTKStationConnetState.UNKNOWN;
        DataProcessor<Integer> dataProcessor = DataProcessor.create(0);
        Intrinsics.checkNotNullExpressionValue(dataProcessor, (String)"create(...)");
        this.gpsSatelliteCountProcessor = dataProcessor;
        DataProcessor<Integer> dataProcessor2 = DataProcessor.create(0);
        Intrinsics.checkNotNullExpressionValue(dataProcessor2, (String)"create(...)");
        this.rtkSatelliteCountProcessor = dataProcessor2;
        DataProcessor<SignalLevel> dataProcessor3 = DataProcessor.create(SignalLevel.LEVEL_1);
        Intrinsics.checkNotNullExpressionValue(dataProcessor3, (String)"create(...)");
        this.gpsSignalLevelProcessor = dataProcessor3;
        DataProcessor<RtkOverview> dataProcessor4 = DataProcessor.create(new RtkOverview(false, false, false, null, null, false, 63, null));
        Intrinsics.checkNotNullExpressionValue(dataProcessor4, (String)"create(...)");
        this.rtkOverviewProcessor = dataProcessor4;
        this.rtkSystemStateListener = arg_0 -> GpsSignalWidgetModel.rtkSystemStateListener$lambda$0(this, arg_0);
        this.connectStatusListener = arg_0 -> GpsSignalWidgetModel.connectStatusListener$lambda$1(this, arg_0);
        this.networkServiceInfoListener = new INetworkServiceInfoListener(this){
            final /* synthetic */ GpsSignalWidgetModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onServiceStateUpdate(RTKServiceState state) {
                block1: {
                    RTKServiceState rTKServiceState = state;
                    if (rTKServiceState == null) break block1;
                    RTKServiceState rTKServiceState2 = rTKServiceState;
                    GpsSignalWidgetModel gpsSignalWidgetModel = this.this$0;
                    RTKServiceState it = rTKServiceState2;
                    boolean bl = false;
                    if (GpsSignalWidgetModel.access$getRtkServiceState$p(gpsSignalWidgetModel) != state) {
                        GpsSignalWidgetModel.access$setRtkServiceState$p(gpsSignalWidgetModel, state);
                        GpsSignalWidgetModel.access$updateRtkOverview(gpsSignalWidgetModel);
                    }
                }
            }

            public void onErrorCodeUpdate(IDJIError error) {
                Object[] objectArray = new Object[]{"networkServiceInfoListener onErrorCodeUpdate:" + error};
                LogUtils.e((String)this.this$0.tag, (Object[])objectArray);
            }
        };
    }

    @NotNull
    public final IRTKCenter getRtkCenter() {
        return this.rtkCenter;
    }

    @NotNull
    public final Flowable<Integer> getGpsSatelliteCount() {
        Flowable<Integer> flowable = this.gpsSatelliteCountProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<Integer> getRtkSatelliteCount() {
        Flowable<Integer> flowable = this.rtkSatelliteCountProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<RtkOverview> getRtkOverview() {
        Flowable<RtkOverview> flowable = this.rtkOverviewProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<SignalLevel> getGpsSignalLevel() {
        Flowable<SignalLevel> flowable = this.gpsSignalLevelProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyGPSSatelliteCount), this.gpsSatelliteCountProcessor);
        this.rtkCenter.addRTKSystemStateListener(this.rtkSystemStateListener);
        this.rtkCenter.getRTKStationManager().addRTKStationConnectStatusListener(this.connectStatusListener);
        this.rtkCenter.getQXRTKManager().addNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
        this.rtkCenter.getCustomRTKManager().addNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
        this.rtkCenter.getCMCCRTKManager().addNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
        DJIKeyInfo dJIKeyInfo = FlightControllerKey.KeyGPSSignalLevel;
        Intrinsics.checkNotNullExpressionValue((Object)dJIKeyInfo, (String)"KeyGPSSignalLevel");
        DJIKeyEtKt.listen$default((DJIKey)DJIKeyInfoEtKt.create((DJIKeyInfo)dJIKeyInfo), (Object)this, (boolean)false, arg_0 -> GpsSignalWidgetModel.inSetup$lambda$3(this, arg_0), (int)2, null);
        DJIKeyInfo dJIKeyInfo2 = FlightControllerKey.KeyConnection;
        Intrinsics.checkNotNullExpressionValue((Object)dJIKeyInfo2, (String)"KeyConnection");
        DJIKeyEtKt.listen$default((DJIKey)DJIKeyInfoEtKt.create((DJIKeyInfo)dJIKeyInfo2), (Object)this, (boolean)false, arg_0 -> GpsSignalWidgetModel.inSetup$lambda$4(this, arg_0), (int)2, null);
        RTKStartServiceHelper.INSTANCE.getRtkModuleAvailable().subscribe(new Consumer(this){
            final /* synthetic */ GpsSignalWidgetModel this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Boolean it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GpsSignalWidgetModel.access$setRtkModuleAvailable$p(this.this$0, it);
                GpsSignalWidgetModel.access$updateRtkOverview(this.this$0);
            }
        });
        DJIKeyInfo dJIKeyInfo3 = RtkMobileStationKey.KeyRTKkeepStatus;
        Intrinsics.checkNotNullExpressionValue((Object)dJIKeyInfo3, (String)"KeyRTKkeepStatus");
        DJIKeyEtKt.listen$default((DJIKey)DJIKeyInfoEtKt.create((DJIKeyInfo)dJIKeyInfo3), (Object)this, (boolean)false, arg_0 -> GpsSignalWidgetModel.inSetup$lambda$5(this, arg_0), (int)2, null);
    }

    @Override
    protected void inCleanup() {
        this.rtkCenter.removeRTKSystemStateListener(this.rtkSystemStateListener);
        this.rtkCenter.getQXRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
        this.rtkCenter.getCustomRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
        this.rtkCenter.getCMCCRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
        this.rtkCenter.getRTKStationManager().removeRTKStationConnectStatusListener(this.connectStatusListener);
        KeyManager.getInstance().cancelListen((Object)this);
    }

    public final void setRTKEnable(boolean bl) {
        this.rtkCenter.setAircraftRTKModuleEnabled(bl, new CommonCallbacks.CompletionCallback(this, bl){
            final /* synthetic */ GpsSignalWidgetModel this$0;
            final /* synthetic */ boolean $boolean;
            {
                this.this$0 = $receiver;
                this.$boolean = $boolean;
            }

            public void onSuccess() {
                if (!GpsSignalWidgetModel.access$getRtkSystemState$p(this.this$0).getRTKMaintainAccuracyEnabled() && this.$boolean) {
                    this.this$0.getRtkCenter().setRTKMaintainAccuracyEnabled(true, null);
                }
                GpsSignalWidgetModel.access$updateSignalLevel(this.this$0, GpsSignalWidgetModel.access$getCurrentGpsSignalLevel$p(this.this$0));
            }

            public void onFailure(IDJIError djiError) {
                Intrinsics.checkNotNullParameter((Object)djiError, (String)"djiError");
            }
        });
    }

    private final void updateRTKListener(RTKReferenceStationSource rtkSource) {
        switch (WhenMappings.$EnumSwitchMapping$0[rtkSource.ordinal()]) {
            case 1: {
                this.rtkCenter.getCustomRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                this.rtkCenter.getCMCCRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                this.rtkCenter.getRTKStationManager().removeRTKStationConnectStatusListener(this.connectStatusListener);
                this.rtkCenter.getQXRTKManager().addNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                break;
            }
            case 2: {
                this.rtkCenter.getQXRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                this.rtkCenter.getCMCCRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                this.rtkCenter.getRTKStationManager().removeRTKStationConnectStatusListener(this.connectStatusListener);
                this.rtkCenter.getCustomRTKManager().addNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                break;
            }
            case 3: {
                this.rtkCenter.getQXRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                this.rtkCenter.getCustomRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                this.rtkCenter.getRTKStationManager().removeRTKStationConnectStatusListener(this.connectStatusListener);
                this.rtkCenter.getCMCCRTKManager().addNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                break;
            }
            case 4: {
                this.rtkCenter.getQXRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                this.rtkCenter.getCustomRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                this.rtkCenter.getCMCCRTKManager().removeNetworkRTKServiceInfoListener(this.networkServiceInfoListener);
                this.rtkCenter.getRTKStationManager().addRTKStationConnectStatusListener(this.connectStatusListener);
            }
        }
    }

    private final void updateRtkOverview() {
        RtkState currentRtkState = null;
        currentRtkState = RtkState.NOT_CONNECT;
        RTKSystemState $this$updateRtkOverview_u24lambda_u246 = this.rtkSystemState;
        boolean bl = false;
        if ($this$updateRtkOverview_u24lambda_u246.getIsRTKEnabled()) {
            if ($this$updateRtkOverview_u24lambda_u246.getRtkReferenceStationSource() == RTKReferenceStationSource.NONE) {
                currentRtkState = RtkState.NOT_CONNECT;
            } else if ($this$updateRtkOverview_u24lambda_u246.getRtkReferenceStationSource() == RTKReferenceStationSource.BASE_STATION) {
                currentRtkState = this.updateBaseRtkState();
            } else if (RTKStartServiceHelper.INSTANCE.isNetworkRTK($this$updateRtkOverview_u24lambda_u246.getRtkReferenceStationSource())) {
                currentRtkState = this.updateRtcmStatus();
            }
        } else {
            currentRtkState = RtkState.NOT_OPEN;
        }
        boolean bl2 = $this$updateRtkOverview_u24lambda_u246.getIsRTKEnabled();
        boolean bl3 = $this$updateRtkOverview_u24lambda_u246.getRTKHealthy();
        RTKReferenceStationSource rTKReferenceStationSource = $this$updateRtkOverview_u24lambda_u246.getRtkReferenceStationSource();
        Intrinsics.checkNotNullExpressionValue((Object)rTKReferenceStationSource, (String)"getRtkReferenceStationSource(...)");
        RtkOverview rtkOverview = new RtkOverview(this.isRtkModuleAvailable, bl2, bl3, currentRtkState, rTKReferenceStationSource, this.isUsingRtkKeeping);
        this.rtkOverviewProcessor.onNext(rtkOverview);
        Object[] objectArray = new Object[]{"rtkOverview=" + rtkOverview};
        LogUtils.d((String)this.tag, (Object[])objectArray);
    }

    private final void resetData() {
        this.baseStationConnectStatus = RTKStationConnetState.UNKNOWN;
        this.rtkSystemState = new RTKSystemState();
        this.isRtkModuleAvailable = false;
        this.rtkServiceState = RTKServiceState.UNKNOWN;
    }

    private final RtkState updateBaseRtkState() {
        return this.baseStationConnectStatus == RTKStationConnetState.CONNECTED ? (this.rtkSystemState.getRTKHealthy() ? RtkState.CONNECTED : RtkState.CONVERGING) : RtkState.NOT_CONNECT;
    }

    private final void updateSignalLevel(GPSSignalLevel gpsSignalLevel) {
        this.gpsSignalLevelProcessor.onNext(switch (WhenMappings.$EnumSwitchMapping$1[gpsSignalLevel.ordinal()]) {
            case 1, 2, 3 -> SignalLevel.LEVEL_3;
            case 4 -> SignalLevel.LEVEL_2;
            default -> SignalLevel.LEVEL_1;
        });
    }

    private final RtkState updateRtcmStatus() {
        return switch (WhenMappings.$EnumSwitchMapping$2[this.rtkServiceState.ordinal()]) {
            case 1, 2, 3, 4, 5, 6 -> {
                if (this.rtkSystemState.getRTKHealthy()) {
                    yield RtkState.CONNECTED;
                }
                yield RtkState.CONVERGING;
            }
            case 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20 -> RtkState.ERROR;
            default -> RtkState.NOT_CONNECT;
        };
    }

    /*
     * WARNING - void declaration
     */
    private final int getRtkSatelliteCount(RTKSystemState rtkSystemState) {
        int n;
        if (!rtkSystemState.getIsRTKEnabled()) {
            n = 0;
        } else {
            RTKSystemState $this$getRtkSatelliteCount_u24lambda_u249 = rtkSystemState;
            boolean bl = false;
            RTKSatelliteInfo rTKSatelliteInfo = $this$getRtkSatelliteCount_u24lambda_u249.getSatelliteInfo();
            if (rTKSatelliteInfo != null) {
                void $this$mapTo$iv$iv;
                RTKSatelliteInfo $this$getRtkSatelliteCount_u24lambda_u249_u24lambda_u248 = rTKSatelliteInfo;
                boolean bl2 = false;
                List list = $this$getRtkSatelliteCount_u24lambda_u249_u24lambda_u248.getMobileStationReceiver1Info();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMobileStationReceiver1Info(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    RTKReceiverInfo rTKReceiverInfo = (RTKReceiverInfo)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(it.getCount());
                }
                n = CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
            } else {
                n = 0;
            }
        }
        return n;
    }

    private static final void rtkSystemStateListener$lambda$0(GpsSignalWidgetModel this$0, RTKSystemState it) {
        this$0.rtkSystemState = it;
        this$0.updateRtkOverview();
        DataProcessor<Integer> dataProcessor = this$0.rtkSatelliteCountProcessor;
        Intrinsics.checkNotNull((Object)it);
        dataProcessor.onNext(this$0.getRtkSatelliteCount(it));
        RTKReferenceStationSource rTKReferenceStationSource = it.getRtkReferenceStationSource();
        Intrinsics.checkNotNullExpressionValue((Object)rTKReferenceStationSource, (String)"getRtkReferenceStationSource(...)");
        this$0.updateRTKListener(rTKReferenceStationSource);
    }

    private static final void connectStatusListener$lambda$1(GpsSignalWidgetModel this$0, RTKStationConnetState it) {
        this$0.baseStationConnectStatus = it;
        this$0.updateRtkOverview();
    }

    private static final Unit inSetup$lambda$3(GpsSignalWidgetModel this$0, GPSSignalLevel it) {
        block0: {
            GPSSignalLevel gPSSignalLevel = it;
            if (gPSSignalLevel == null) break block0;
            GPSSignalLevel it2 = gPSSignalLevel;
            boolean bl = false;
            this$0.currentGpsSignalLevel = it2;
            this$0.updateSignalLevel(it2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit inSetup$lambda$4(GpsSignalWidgetModel this$0, Boolean it) {
        if (Intrinsics.areEqual((Object)it, (Object)false)) {
            this$0.resetData();
            this$0.updateRtkOverview();
            this$0.rtkSatelliteCountProcessor.onNext(0);
            this$0.gpsSatelliteCountProcessor.onNext(0);
        }
        return Unit.INSTANCE;
    }

    private static final Unit inSetup$lambda$5(GpsSignalWidgetModel this$0, Boolean it) {
        if (it == null) {
            return Unit.INSTANCE;
        }
        this$0.isUsingRtkKeeping = it;
        this$0.updateRtkOverview();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$setRtkModuleAvailable$p(GpsSignalWidgetModel $this, boolean bl) {
        $this.isRtkModuleAvailable = bl;
    }

    public static final /* synthetic */ void access$updateRtkOverview(GpsSignalWidgetModel $this) {
        $this.updateRtkOverview();
    }

    public static final /* synthetic */ RTKSystemState access$getRtkSystemState$p(GpsSignalWidgetModel $this) {
        return $this.rtkSystemState;
    }

    public static final /* synthetic */ void access$updateSignalLevel(GpsSignalWidgetModel $this, GPSSignalLevel gpsSignalLevel) {
        $this.updateSignalLevel(gpsSignalLevel);
    }

    public static final /* synthetic */ GPSSignalLevel access$getCurrentGpsSignalLevel$p(GpsSignalWidgetModel $this) {
        return $this.currentGpsSignalLevel;
    }

    public static final /* synthetic */ RTKServiceState access$getRtkServiceState$p(GpsSignalWidgetModel $this) {
        return $this.rtkServiceState;
    }

    public static final /* synthetic */ void access$setRtkServiceState$p(GpsSignalWidgetModel $this, RTKServiceState rTKServiceState) {
        $this.rtkServiceState = rTKServiceState;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\u00032\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006#"}, d2={"Ldji/v5/ux/core/widget/gpssignal/GpsSignalWidgetModel$RtkOverview;", "", "connected", "", "enabled", "rtkHealthy", "rtkState", "Ldji/v5/ux/core/widget/gpssignal/GpsSignalWidgetModel$RtkState;", "rtkSource", "Ldji/sdk/keyvalue/value/rtkbasestation/RTKReferenceStationSource;", "rtkKeepingStatus", "<init>", "(ZZZLdji/v5/ux/core/widget/gpssignal/GpsSignalWidgetModel$RtkState;Ldji/sdk/keyvalue/value/rtkbasestation/RTKReferenceStationSource;Z)V", "getConnected", "()Z", "getEnabled", "getRtkHealthy", "getRtkState", "()Ldji/v5/ux/core/widget/gpssignal/GpsSignalWidgetModel$RtkState;", "getRtkSource", "()Ldji/sdk/keyvalue/value/rtkbasestation/RTKReferenceStationSource;", "getRtkKeepingStatus", "toString", "", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "android-sdk-v5-uxsdk_debug"})
    public static final class RtkOverview {
        private final boolean connected;
        private final boolean enabled;
        private final boolean rtkHealthy;
        @NotNull
        private final RtkState rtkState;
        @NotNull
        private final RTKReferenceStationSource rtkSource;
        private final boolean rtkKeepingStatus;

        public RtkOverview(boolean connected, boolean enabled, boolean rtkHealthy, @NotNull RtkState rtkState, @NotNull RTKReferenceStationSource rtkSource, boolean rtkKeepingStatus) {
            Intrinsics.checkNotNullParameter((Object)((Object)rtkState), (String)"rtkState");
            Intrinsics.checkNotNullParameter((Object)rtkSource, (String)"rtkSource");
            this.connected = connected;
            this.enabled = enabled;
            this.rtkHealthy = rtkHealthy;
            this.rtkState = rtkState;
            this.rtkSource = rtkSource;
            this.rtkKeepingStatus = rtkKeepingStatus;
        }

        public /* synthetic */ RtkOverview(boolean bl, boolean bl2, boolean bl3, RtkState rtkState, RTKReferenceStationSource rTKReferenceStationSource, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                bl3 = false;
            }
            if ((n & 8) != 0) {
                rtkState = RtkState.NOT_OPEN;
            }
            if ((n & 0x10) != 0) {
                rTKReferenceStationSource = RTKReferenceStationSource.NONE;
            }
            if ((n & 0x20) != 0) {
                bl4 = false;
            }
            this(bl, bl2, bl3, rtkState, rTKReferenceStationSource, bl4);
        }

        public final boolean getConnected() {
            return this.connected;
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        public final boolean getRtkHealthy() {
            return this.rtkHealthy;
        }

        @NotNull
        public final RtkState getRtkState() {
            return this.rtkState;
        }

        @NotNull
        public final RTKReferenceStationSource getRtkSource() {
            return this.rtkSource;
        }

        public final boolean getRtkKeepingStatus() {
            return this.rtkKeepingStatus;
        }

        @NotNull
        public String toString() {
            return "RtkOverview(connected=" + this.connected + ", enabled=" + this.enabled + ", rtkHealthy=" + this.rtkHealthy + ", rtkState=" + this.rtkState + ", rtkSource=" + this.rtkSource + ", rtkKeepingStatus=" + this.rtkKeepingStatus + ")";
        }

        public final boolean component1() {
            return this.connected;
        }

        public final boolean component2() {
            return this.enabled;
        }

        public final boolean component3() {
            return this.rtkHealthy;
        }

        @NotNull
        public final RtkState component4() {
            return this.rtkState;
        }

        @NotNull
        public final RTKReferenceStationSource component5() {
            return this.rtkSource;
        }

        public final boolean component6() {
            return this.rtkKeepingStatus;
        }

        @NotNull
        public final RtkOverview copy(boolean connected, boolean enabled, boolean rtkHealthy, @NotNull RtkState rtkState, @NotNull RTKReferenceStationSource rtkSource, boolean rtkKeepingStatus) {
            Intrinsics.checkNotNullParameter((Object)((Object)rtkState), (String)"rtkState");
            Intrinsics.checkNotNullParameter((Object)rtkSource, (String)"rtkSource");
            return new RtkOverview(connected, enabled, rtkHealthy, rtkState, rtkSource, rtkKeepingStatus);
        }

        public static /* synthetic */ RtkOverview copy$default(RtkOverview rtkOverview, boolean bl, boolean bl2, boolean bl3, RtkState rtkState, RTKReferenceStationSource rTKReferenceStationSource, boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                bl = rtkOverview.connected;
            }
            if ((n & 2) != 0) {
                bl2 = rtkOverview.enabled;
            }
            if ((n & 4) != 0) {
                bl3 = rtkOverview.rtkHealthy;
            }
            if ((n & 8) != 0) {
                rtkState = rtkOverview.rtkState;
            }
            if ((n & 0x10) != 0) {
                rTKReferenceStationSource = rtkOverview.rtkSource;
            }
            if ((n & 0x20) != 0) {
                bl4 = rtkOverview.rtkKeepingStatus;
            }
            return rtkOverview.copy(bl, bl2, bl3, rtkState, rTKReferenceStationSource, bl4);
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.connected);
            result = result * 31 + Boolean.hashCode(this.enabled);
            result = result * 31 + Boolean.hashCode(this.rtkHealthy);
            result = result * 31 + this.rtkState.hashCode();
            result = result * 31 + this.rtkSource.hashCode();
            result = result * 31 + Boolean.hashCode(this.rtkKeepingStatus);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RtkOverview)) {
                return false;
            }
            RtkOverview rtkOverview = (RtkOverview)other;
            if (this.connected != rtkOverview.connected) {
                return false;
            }
            if (this.enabled != rtkOverview.enabled) {
                return false;
            }
            if (this.rtkHealthy != rtkOverview.rtkHealthy) {
                return false;
            }
            if (this.rtkState != rtkOverview.rtkState) {
                return false;
            }
            if (this.rtkSource != rtkOverview.rtkSource) {
                return false;
            }
            return this.rtkKeepingStatus == rtkOverview.rtkKeepingStatus;
        }

        public RtkOverview() {
            this(false, false, false, null, null, false, 63, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Ldji/v5/ux/core/widget/gpssignal/GpsSignalWidgetModel$RtkState;", "", "<init>", "(Ljava/lang/String;I)V", "NOT_OPEN", "NOT_CONNECT", "CONVERGING", "CONNECTED", "ERROR", "android-sdk-v5-uxsdk_debug"})
    public static final class RtkState
    extends Enum<RtkState> {
        public static final /* enum */ RtkState NOT_OPEN = new RtkState();
        public static final /* enum */ RtkState NOT_CONNECT = new RtkState();
        public static final /* enum */ RtkState CONVERGING = new RtkState();
        public static final /* enum */ RtkState CONNECTED = new RtkState();
        public static final /* enum */ RtkState ERROR = new RtkState();
        private static final /* synthetic */ RtkState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RtkState[] values() {
            return (RtkState[])$VALUES.clone();
        }

        public static RtkState valueOf(String value) {
            return Enum.valueOf(RtkState.class, value);
        }

        @NotNull
        public static EnumEntries<RtkState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = rtkStateArray = new RtkState[]{RtkState.NOT_OPEN, RtkState.NOT_CONNECT, RtkState.CONVERGING, RtkState.CONNECTED, RtkState.ERROR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Ldji/v5/ux/core/widget/gpssignal/GpsSignalWidgetModel$SignalLevel;", "", "<init>", "(Ljava/lang/String;I)V", "LEVEL_1", "LEVEL_2", "LEVEL_3", "android-sdk-v5-uxsdk_debug"})
    public static final class SignalLevel
    extends Enum<SignalLevel> {
        public static final /* enum */ SignalLevel LEVEL_1 = new SignalLevel();
        public static final /* enum */ SignalLevel LEVEL_2 = new SignalLevel();
        public static final /* enum */ SignalLevel LEVEL_3 = new SignalLevel();
        private static final /* synthetic */ SignalLevel[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SignalLevel[] values() {
            return (SignalLevel[])$VALUES.clone();
        }

        public static SignalLevel valueOf(String value) {
            return Enum.valueOf(SignalLevel.class, value);
        }

        @NotNull
        public static EnumEntries<SignalLevel> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = signalLevelArray = new SignalLevel[]{SignalLevel.LEVEL_1, SignalLevel.LEVEL_2, SignalLevel.LEVEL_3};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[RTKReferenceStationSource.values().length];
            try {
                nArray[RTKReferenceStationSource.QX_NETWORK_SERVICE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKReferenceStationSource.CUSTOM_NETWORK_SERVICE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKReferenceStationSource.NTRIP_NETWORK_SERVICE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKReferenceStationSource.BASE_STATION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[GPSSignalLevel.values().length];
            try {
                nArray[GPSSignalLevel.LEVEL_10.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GPSSignalLevel.LEVEL_5.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GPSSignalLevel.LEVEL_4.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GPSSignalLevel.LEVEL_3.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[RTKServiceState.values().length];
            try {
                nArray[RTKServiceState.RTCM_CONNECTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKServiceState.RTCM_NORMAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKServiceState.RTCM_USER_HAS_ACTIVATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKServiceState.RTCM_USER_ACCOUNT_EXPIRES_SOON.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKServiceState.RTCM_USE_DEFAULT_MOUNT_POINT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKServiceState.TRANSMITTING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKServiceState.RTCM_AUTH_FAILED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKServiceState.RTCM_USER_NOT_BOUNDED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKServiceState.RTCM_USER_NOT_ACTIVATED.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKServiceState.SERVICE_SUSPENSION.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKServiceState.ACCOUNT_EXPIRED.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKServiceState.RTCM_ILLEGAL_UTC_TIME.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKServiceState.NETWORK_NOT_REACHABLE.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKServiceState.RTCM_SET_COORDINATE_FAILURE.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKServiceState.LOGIN_FAILURE.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKServiceState.ACCOUNT_ERROR.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKServiceState.CONNECTING.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKServiceState.INVALID_REQUEST.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKServiceState.SERVER_NOT_REACHABLE.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTKServiceState.UNKNOWN.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

