/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.gpssignal;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.Switch;
import dji.v5.manager.aircraft.rtk.RTKCenter;
import dji.v5.manager.interfaces.IRTKCenter;
import dji.v5.utils.common.AndUtil;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.R;
import dji.v5.ux.accessory.RTKEnabledWidgetModel;
import dji.v5.ux.accessory.item.TitleValueCell;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.FrameLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.extension.ViewExtensions;
import dji.v5.ux.core.util.UxErrorHandle;
import dji.v5.ux.core.widget.gpssignal.GpsSignalWidgetModel;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B'\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010(\u001a\u00020)H\u0014J\b\u0010*\u001a\u00020)H\u0014J\u0010\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020\u001cH\u0002J\u0010\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020\tH\u0002J\u0010\u0010/\u001a\u00020)2\u0006\u00100\u001a\u00020\u0002H\u0002J\u0010\u00101\u001a\u00020)2\u0006\u0010.\u001a\u00020\tH\u0002J\u0010\u00102\u001a\u00020)2\u0006\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020\t2\u0006\u00103\u001a\u000204H\u0002J\u0010\u00106\u001a\u00020\t2\u0006\u00103\u001a\u000204H\u0002J\"\u00107\u001a\u00020)2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\b\u00108\u001a\u00020)H\u0014J\n\u00109\u001a\u0004\u0018\u00010:H\u0016J\u001a\u0010;\u001a\u00020)2\b\u0010<\u001a\u0004\u0018\u00010=2\u0006\u00100\u001a\u00020\u0002H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b\u001f\u0010 R\u001b\u0010#\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\"\u001a\u0004\b%\u0010&\u00a8\u0006>"}, d2={"Ldji/v5/ux/core/widget/gpssignal/GpsSignalPopoverView;", "Ldji/v5/ux/core/base/widget/FrameLayoutWidget;", "", "Landroid/widget/CompoundButton$OnCheckedChangeListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "rtkTitleWrapper", "Landroid/widget/FrameLayout;", "rtkContentWrapper", "Landroid/widget/LinearLayout;", "gpsTitleWrapper", "gpsContentWrapper", "tvGpsSignal", "Ldji/v5/ux/accessory/item/TitleValueCell;", "tvGpsSatelliteCount", "rtkEnabledSwitch", "Landroid/widget/Switch;", "tvRtkState", "tvRtkSatelliteCount", "tvRtkSignal", "maxWidth", "rtkOverview", "Ldji/v5/ux/core/widget/gpssignal/GpsSignalWidgetModel$RtkOverview;", "rtkEnabledWidgetModel", "Ldji/v5/ux/accessory/RTKEnabledWidgetModel;", "getRtkEnabledWidgetModel", "()Ldji/v5/ux/accessory/RTKEnabledWidgetModel;", "rtkEnabledWidgetModel$delegate", "Lkotlin/Lazy;", "gpsSignalWidgetModel", "Ldji/v5/ux/core/widget/gpssignal/GpsSignalWidgetModel;", "getGpsSignalWidgetModel", "()Ldji/v5/ux/core/widget/gpssignal/GpsSignalWidgetModel;", "gpsSignalWidgetModel$delegate", "onAttachedToWindow", "", "onDetachedFromWindow", "updateRtkState", "overview", "updateRtKSatelliteCount", "count", "setRTKSwitch", "isChecked", "updateGpsSatelliteCount", "updateSignalLevel", "level", "Ldji/v5/ux/core/widget/gpssignal/GpsSignalWidgetModel$SignalLevel;", "mapSignalLevelToStringRes", "mapSignalLevelToColorRes", "initView", "reactToModelChanges", "getIdealDimensionRatioString", "", "onCheckedChanged", "buttonView", "Landroid/widget/CompoundButton;", "android-sdk-v5-uxsdk_debug"})
public final class GpsSignalPopoverView
extends FrameLayoutWidget<Boolean>
implements CompoundButton.OnCheckedChangeListener {
    @NotNull
    private FrameLayout rtkTitleWrapper;
    @NotNull
    private LinearLayout rtkContentWrapper;
    @NotNull
    private FrameLayout gpsTitleWrapper;
    @NotNull
    private LinearLayout gpsContentWrapper;
    @NotNull
    private TitleValueCell tvGpsSignal;
    @NotNull
    private TitleValueCell tvGpsSatelliteCount;
    @NotNull
    private Switch rtkEnabledSwitch;
    @NotNull
    private TitleValueCell tvRtkState;
    @NotNull
    private TitleValueCell tvRtkSatelliteCount;
    @NotNull
    private TitleValueCell tvRtkSignal;
    private int maxWidth;
    @NotNull
    private GpsSignalWidgetModel.RtkOverview rtkOverview;
    @NotNull
    private final Lazy rtkEnabledWidgetModel$delegate;
    @NotNull
    private final Lazy gpsSignalWidgetModel$delegate;

    @JvmOverloads
    public GpsSignalPopoverView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        View view = this.findViewById(R.id.rtk_title_wrapper);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        this.rtkTitleWrapper = (FrameLayout)view;
        View view2 = this.findViewById(R.id.rtk_content_wrapper);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
        this.rtkContentWrapper = (LinearLayout)view2;
        View view3 = this.findViewById(R.id.gps_title_wrapper);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(...)");
        this.gpsTitleWrapper = (FrameLayout)view3;
        View view4 = this.findViewById(R.id.gps_content_wrapper);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(...)");
        this.gpsContentWrapper = (LinearLayout)view4;
        View view5 = this.findViewById(R.id.tv_gps_signal);
        Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"findViewById(...)");
        this.tvGpsSignal = (TitleValueCell)view5;
        View view6 = this.findViewById(R.id.tv_gps_satellite_count);
        Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"findViewById(...)");
        this.tvGpsSatelliteCount = (TitleValueCell)view6;
        View view7 = this.findViewById(R.id.switch_rtk_enable);
        Intrinsics.checkNotNullExpressionValue((Object)view7, (String)"findViewById(...)");
        this.rtkEnabledSwitch = (Switch)view7;
        View view8 = this.findViewById(R.id.tv_rtk_state);
        Intrinsics.checkNotNullExpressionValue((Object)view8, (String)"findViewById(...)");
        this.tvRtkState = (TitleValueCell)view8;
        View view9 = this.findViewById(R.id.tv_rtk_satellite_count);
        Intrinsics.checkNotNullExpressionValue((Object)view9, (String)"findViewById(...)");
        this.tvRtkSatelliteCount = (TitleValueCell)view9;
        View view10 = this.findViewById(R.id.tv_rtk_signal);
        Intrinsics.checkNotNullExpressionValue((Object)view10, (String)"findViewById(...)");
        this.tvRtkSignal = (TitleValueCell)view10;
        this.rtkOverview = new GpsSignalWidgetModel.RtkOverview(false, false, false, null, null, false, 63, null);
        this.rtkEnabledSwitch.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.rtkContentWrapper.measure(0, 0);
        this.gpsContentWrapper.measure(0, 0);
        this.maxWidth = RangesKt.coerceAtLeast((int)this.rtkContentWrapper.getMeasuredWidth(), (int)this.gpsContentWrapper.getMeasuredWidth());
        this.rtkEnabledWidgetModel$delegate = LazyKt.lazy(GpsSignalPopoverView::rtkEnabledWidgetModel_delegate$lambda$0);
        this.gpsSignalWidgetModel$delegate = LazyKt.lazy(GpsSignalPopoverView::gpsSignalWidgetModel_delegate$lambda$1);
    }

    public /* synthetic */ GpsSignalPopoverView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final RTKEnabledWidgetModel getRtkEnabledWidgetModel() {
        Lazy lazy = this.rtkEnabledWidgetModel$delegate;
        return (RTKEnabledWidgetModel)lazy.getValue();
    }

    private final GpsSignalWidgetModel getGpsSignalWidgetModel() {
        Lazy lazy = this.gpsSignalWidgetModel$delegate;
        return (GpsSignalWidgetModel)lazy.getValue();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.getGpsSignalWidgetModel().setup();
            this.getRtkEnabledWidgetModel().setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.getGpsSignalWidgetModel().cleanup();
            this.getRtkEnabledWidgetModel().cleanup();
        }
        super.onDetachedFromWindow();
    }

    private final void updateRtkState(GpsSignalWidgetModel.RtkOverview overview) {
        if (overview.getConnected()) {
            this.rtkTitleWrapper.setVisibility(0);
            this.rtkContentWrapper.setVisibility(0);
            this.gpsTitleWrapper.setVisibility(0);
            this.gpsContentWrapper.setBackgroundResource(R.color.uxsdk_fpv_popover_content_background_color);
            this.gpsContentWrapper.getLayoutParams().width = this.maxWidth;
        } else {
            this.rtkTitleWrapper.setVisibility(8);
            this.rtkContentWrapper.setVisibility(8);
            this.gpsTitleWrapper.setVisibility(8);
            this.gpsContentWrapper.setBackgroundResource(R.color.uxsdk_fpv_popover_title_background_color);
            this.gpsContentWrapper.getLayoutParams().width = -2;
        }
        this.setRTKSwitch(overview.getEnabled());
        if (!overview.getEnabled()) {
            this.tvRtkSatelliteCount.setValue("- -");
            this.tvRtkSignal.setValue("- -");
            this.tvRtkSignal.setValueTextColor(AndUtil.getResColor((int)R.color.uxsdk_white));
            this.tvRtkSatelliteCount.setValueTextColor(AndUtil.getResColor((int)R.color.uxsdk_white));
        }
        if (overview.getRtkKeepingStatus()) {
            this.tvRtkState.setValue(AndUtil.getResString((int)R.string.uxsdk_rtk_keep_status_mode));
            this.tvRtkState.setValueTextColor(AndUtil.getResColor((int)R.color.uxsdk_zone_warning_enhanced));
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[overview.getRtkState().ordinal()]) {
                case 1: {
                    this.tvRtkState.setValue(AndUtil.getResString((int)R.string.uxsdk_checklist_manual_rtk_not_open));
                    this.tvRtkState.setValueTextColor(AndUtil.getResColor((int)R.color.uxsdk_zone_warning_enhanced));
                    break;
                }
                case 2: {
                    this.tvRtkState.setValue(AndUtil.getResString((int)R.string.uxsdk_setting_menu_rtk_state_disconnect));
                    this.tvRtkState.setValueTextColor(AndUtil.getResColor((int)R.color.uxsdk_red_in_dark));
                    break;
                }
                case 3: {
                    this.tvRtkState.setValue(AndUtil.getResString((int)R.string.uxsdk_checklist_rtk_status_converging));
                    this.tvRtkState.setValueTextColor(AndUtil.getResColor((int)R.color.uxsdk_zone_warning_enhanced));
                    break;
                }
                case 4: {
                    this.tvRtkState.setValue(AndUtil.getResString((int)R.string.uxsdk_checklist_rtk_status_connected));
                    this.tvRtkState.setValueTextColor(AndUtil.getResColor((int)R.color.uxsdk_green_in_dark));
                    break;
                }
                case 5: {
                    this.tvRtkState.setValue(AndUtil.getResString((int)R.string.uxsdk_abnormal));
                    this.tvRtkState.setValueTextColor(AndUtil.getResColor((int)R.color.uxsdk_red_in_dark));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    private final void updateRtKSatelliteCount(int count) {
        GpsSignalWidgetModel.RtkOverview it = this.rtkOverview;
        boolean bl = false;
        if (it.getEnabled()) {
            Object[] objectArray = new Object[]{"updateRtKSatelliteCount,it.enabled=" + it.getEnabled() + ",count=" + count};
            LogUtils.i((String)this.getTag(), (Object[])objectArray);
            this.tvRtkSatelliteCount.setValue(String.valueOf(count));
        }
    }

    private final void setRTKSwitch(boolean isChecked) {
        this.rtkEnabledSwitch.setOnCheckedChangeListener(null);
        this.rtkEnabledSwitch.setChecked(isChecked);
        this.rtkEnabledSwitch.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
    }

    private final void updateGpsSatelliteCount(int count) {
        this.tvGpsSatelliteCount.setValue(String.valueOf(count));
    }

    private final void updateSignalLevel(GpsSignalWidgetModel.SignalLevel level) {
        this.tvGpsSignal.setValueTextColor(AndUtil.getResColor((int)this.mapSignalLevelToColorRes(level)));
        this.tvGpsSignal.setValue(AndUtil.getResString((int)this.mapSignalLevelToStringRes(level)));
        this.tvGpsSatelliteCount.setValueTextColor(AndUtil.getResColor((int)this.mapSignalLevelToColorRes(level)));
        if (this.rtkOverview.getEnabled()) {
            this.tvRtkSignal.setValueTextColor(AndUtil.getResColor((int)this.mapSignalLevelToColorRes(level)));
            this.tvRtkSignal.setValue(AndUtil.getResString((int)this.mapSignalLevelToStringRes(level)));
            this.tvRtkSatelliteCount.setValueTextColor(AndUtil.getResColor((int)this.mapSignalLevelToColorRes(level)));
        }
    }

    private final int mapSignalLevelToStringRes(GpsSignalWidgetModel.SignalLevel level) {
        return switch (WhenMappings.$EnumSwitchMapping$1[level.ordinal()]) {
            case 1 -> R.string.uxsdk_fpv_top_bar_gps_signal_state_strong;
            case 2 -> R.string.uxsdk_fpv_top_bar_gps_signal_state_normal;
            case 3 -> R.string.uxsdk_fpv_top_bar_gps_signal_state_weak;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final int mapSignalLevelToColorRes(GpsSignalWidgetModel.SignalLevel level) {
        return switch (WhenMappings.$EnumSwitchMapping$1[level.ordinal()]) {
            case 1 -> R.color.uxsdk_tips_normal_in_dark;
            case 2 -> R.color.uxsdk_tips_caution_in_dark;
            case 3 -> R.color.uxsdk_tips_danger_in_dark;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    protected void initView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        FrameLayout.inflate((Context)context, (int)R.layout.uxsdk_fpv_top_bar_widget_gps_signal_popover_rtk, (ViewGroup)((ViewGroup)this));
    }

    @Override
    protected void reactToModelChanges() {
        Disposable disposable = this.getGpsSignalWidgetModel().getRtkOverview().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ GpsSignalPopoverView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(GpsSignalWidgetModel.RtkOverview it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GpsSignalPopoverView.access$setRtkOverview$p(this.this$0, it);
                GpsSignalPopoverView.access$updateRtkState(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addReaction(disposable);
        Disposable disposable2 = this.getGpsSignalWidgetModel().getGpsSatelliteCount().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ GpsSignalPopoverView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Integer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GpsSignalPopoverView.access$updateGpsSatelliteCount(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"subscribe(...)");
        this.addReaction(disposable2);
        Disposable disposable3 = this.getGpsSignalWidgetModel().getRtkSatelliteCount().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ GpsSignalPopoverView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Integer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GpsSignalPopoverView.access$updateRtKSatelliteCount(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable3, (String)"subscribe(...)");
        this.addReaction(disposable3);
        Disposable disposable4 = this.getGpsSignalWidgetModel().getGpsSignalLevel().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ GpsSignalPopoverView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(GpsSignalWidgetModel.SignalLevel it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                GpsSignalPopoverView.access$updateSignalLevel(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable4, (String)"subscribe(...)");
        this.addReaction(disposable4);
    }

    @Override
    @Nullable
    public String getIdealDimensionRatioString() {
        return ViewExtensions.getString((View)this, R.string.uxsdk_widget_rtk_enabled_ratio, new Object[0]);
    }

    public void onCheckedChanged(@Nullable CompoundButton buttonView, boolean isChecked) {
        Disposable disposable = this.getRtkEnabledWidgetModel().getCanEnableRTK().firstOrError().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this, isChecked){
            final /* synthetic */ GpsSignalPopoverView this$0;
            final /* synthetic */ boolean $isChecked;
            {
                this.this$0 = $receiver;
                this.$isChecked = $isChecked;
            }

            public final void accept(boolean canEnableRTK) {
                if (!canEnableRTK) {
                    GpsSignalPopoverView.access$setRTKSwitch(this.this$0, !this.$isChecked);
                    ViewExtensions.showLongToast((View)this.this$0, R.string.uxsdk_rtk_enabled_motors_running);
                } else {
                    GpsSignalPopoverView.access$getGpsSignalWidgetModel(this.this$0).setRTKEnable(this.$isChecked);
                }
            }
        }, UxErrorHandle.logErrorConsumer(this.getTag(), "canEnableRTK:"));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addDisposable(disposable);
    }

    @JvmOverloads
    public GpsSignalPopoverView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public GpsSignalPopoverView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final RTKEnabledWidgetModel rtkEnabledWidgetModel_delegate$lambda$0() {
        DJISDKModel dJISDKModel = DJISDKModel.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dJISDKModel, (String)"getInstance(...)");
        ObservableInMemoryKeyedStore observableInMemoryKeyedStore = ObservableInMemoryKeyedStore.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)observableInMemoryKeyedStore, (String)"getInstance(...)");
        return new RTKEnabledWidgetModel(dJISDKModel, observableInMemoryKeyedStore);
    }

    private static final GpsSignalWidgetModel gpsSignalWidgetModel_delegate$lambda$1() {
        DJISDKModel dJISDKModel = DJISDKModel.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dJISDKModel, (String)"getInstance(...)");
        ObservableInMemoryKeyedStore observableInMemoryKeyedStore = ObservableInMemoryKeyedStore.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)observableInMemoryKeyedStore, (String)"getInstance(...)");
        IRTKCenter iRTKCenter = RTKCenter.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)iRTKCenter, (String)"getInstance(...)");
        return new GpsSignalWidgetModel(dJISDKModel, observableInMemoryKeyedStore, iRTKCenter);
    }

    public static final /* synthetic */ void access$setRtkOverview$p(GpsSignalPopoverView $this, GpsSignalWidgetModel.RtkOverview rtkOverview) {
        $this.rtkOverview = rtkOverview;
    }

    public static final /* synthetic */ void access$updateRtkState(GpsSignalPopoverView $this, GpsSignalWidgetModel.RtkOverview overview) {
        $this.updateRtkState(overview);
    }

    public static final /* synthetic */ void access$updateGpsSatelliteCount(GpsSignalPopoverView $this, int count) {
        $this.updateGpsSatelliteCount(count);
    }

    public static final /* synthetic */ void access$updateRtKSatelliteCount(GpsSignalPopoverView $this, int count) {
        $this.updateRtKSatelliteCount(count);
    }

    public static final /* synthetic */ void access$updateSignalLevel(GpsSignalPopoverView $this, GpsSignalWidgetModel.SignalLevel level) {
        $this.updateSignalLevel(level);
    }

    public static final /* synthetic */ void access$setRTKSwitch(GpsSignalPopoverView $this, boolean isChecked) {
        $this.setRTKSwitch(isChecked);
    }

    public static final /* synthetic */ GpsSignalWidgetModel access$getGpsSignalWidgetModel(GpsSignalPopoverView $this) {
        return $this.getGpsSignalWidgetModel();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[GpsSignalWidgetModel.RtkState.values().length];
            try {
                nArray[GpsSignalWidgetModel.RtkState.NOT_OPEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GpsSignalWidgetModel.RtkState.NOT_CONNECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GpsSignalWidgetModel.RtkState.CONVERGING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GpsSignalWidgetModel.RtkState.CONNECTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GpsSignalWidgetModel.RtkState.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[GpsSignalWidgetModel.SignalLevel.values().length];
            try {
                nArray[GpsSignalWidgetModel.SignalLevel.LEVEL_3.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GpsSignalWidgetModel.SignalLevel.LEVEL_2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GpsSignalWidgetModel.SignalLevel.LEVEL_1.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

