/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.battery;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.StyleRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.WidgetSizeDescription;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.extension.TypedArrayExtensions;
import dji.v5.ux.core.extension.ViewExtensions;
import dji.v5.ux.core.util.UxErrorHandle;
import dji.v5.ux.core.widget.battery.BatteryWidgetModel;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.processors.PublishProcessor;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 q2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002pqB'\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010@\u001a\u00020A2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010B\u001a\u00020AH\u0014J\b\u0010C\u001a\u00020AH\u0014J\b\u0010D\u001a\u00020AH\u0014J\u0010\u0010E\u001a\u00020A2\u0006\u0010F\u001a\u00020GH\u0002J\b\u0010H\u001a\u00020AH\u0002J\u0010\u0010I\u001a\u00020A2\u0006\u0010F\u001a\u00020JH\u0002J\u0010\u0010K\u001a\u00020A2\u0006\u0010F\u001a\u00020LH\u0002J\u0010\u0010M\u001a\u00020A2\u0006\u0010F\u001a\u00020NH\u0002J\u0018\u0010O\u001a\u00020A2\u0006\u0010P\u001a\u00020\u00172\u0006\u0010Q\u001a\u00020\u001eH\u0002J\u0018\u0010R\u001a\u00020A2\u0006\u0010P\u001a\u00020\u00172\u0006\u0010Q\u001a\u00020\u001eH\u0002J\b\u0010S\u001a\u00020AH\u0002J\b\u0010T\u001a\u00020AH\u0002J\b\u0010U\u001a\u00020AH\u0002J\b\u0010V\u001a\u00020AH\u0002J\u0010\u0010W\u001a\u00020A2\u0006\u0010F\u001a\u00020GH\u0002J\n\u0010X\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010]\u001a\u00020A2\u0006\u0010Q\u001a\u00020\u001e2\b\b\u0001\u0010^\u001a\u00020\bJ \u0010]\u001a\u00020A2\u0006\u0010Q\u001a\u00020\u001e2\b\b\u0001\u0010^\u001a\u00020\b2\u0006\u0010_\u001a\u00020\u0012J\u0016\u0010]\u001a\u00020A2\u0006\u0010Q\u001a\u00020\u001e2\u0006\u0010`\u001a\u00020\"J\u001e\u0010]\u001a\u00020A2\u0006\u0010Q\u001a\u00020\u001e2\u0006\u0010`\u001a\u00020\"2\u0006\u0010_\u001a\u00020\u0012J\u0018\u0010a\u001a\u00020A2\u0006\u0010Q\u001a\u00020\u001e2\b\b\u0001\u0010^\u001a\u00020\bJ \u0010a\u001a\u00020A2\u0006\u0010Q\u001a\u00020\u001e2\b\b\u0001\u0010^\u001a\u00020\b2\u0006\u0010_\u001a\u00020\u0012J\u0016\u0010a\u001a\u00020A2\u0006\u0010Q\u001a\u00020\u001e2\u0006\u0010`\u001a\u00020\"J\u001e\u0010a\u001a\u00020A2\u0006\u0010Q\u001a\u00020\u001e2\u0006\u0010`\u001a\u00020\"2\u0006\u0010_\u001a\u00020\u0012J\u0010\u0010b\u001a\u00020A2\b\b\u0001\u0010c\u001a\u00020\bJ\u0010\u0010d\u001a\u00020A2\b\b\u0001\u0010c\u001a\u00020\bJ\u0010\u0010e\u001a\u00020A2\b\b\u0001\u0010c\u001a\u00020\bJ\u0018\u0010f\u001a\u00020A2\u0006\u0010Q\u001a\u00020\u001e2\b\b\u0001\u0010g\u001a\u00020\bJ\u0016\u0010f\u001a\u00020A2\u0006\u0010Q\u001a\u00020\u001e2\u0006\u0010h\u001a\u00020\u001fJ\u0018\u0010i\u001a\u00020A2\u0006\u0010Q\u001a\u00020\u001e2\b\b\u0001\u0010g\u001a\u00020\bJ\u0016\u0010i\u001a\u00020A2\u0006\u0010Q\u001a\u00020\u001e2\u0006\u0010h\u001a\u00020\u001fJ\u0010\u0010?\u001a\u00020A2\b\b\u0001\u0010j\u001a\u00020\bJ\u0018\u0010k\u001a\u00020A2\u0006\u0010Q\u001a\u00020\u001e2\b\b\u0001\u0010j\u001a\u00020\bJ\u0018\u0010k\u001a\u00020A2\u0006\u0010Q\u001a\u00020\u001e2\b\u0010`\u001a\u0004\u0018\u00010\"J\u0010\u0010l\u001a\u0004\u0018\u00010\"2\u0006\u0010Q\u001a\u00020\u001eJ\u0010\u00105\u001a\u00020A2\b\b\u0001\u0010j\u001a\u00020\bJ\u0018\u0010m\u001a\u00020A2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0003J\u000e\u0010n\u001a\b\u0012\u0004\u0012\u00020\u00020oH\u0016R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0006\u0012\u0004\u0018\u00010\"0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\"0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\"0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010'\u001a\u00020&2\u0006\u0010%\u001a\u00020&@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R&\u0010-\u001a\u00020,2\b\b\u0001\u0010%\u001a\u00020,8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R(\u00102\u001a\u0004\u0018\u00010\"2\b\u0010%\u001a\u0004\u0018\u00010\"8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b3\u00104\"\u0004\b5\u00106R&\u00107\u001a\u00020,2\b\b\u0001\u0010%\u001a\u00020,8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b8\u0010/\"\u0004\b9\u00101R&\u0010:\u001a\u00020,2\b\b\u0001\u0010%\u001a\u00020,8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010/\"\u0004\b<\u00101R(\u0010=\u001a\u0004\u0018\u00010\"2\b\u0010%\u001a\u0004\u0018\u00010\"8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b>\u00104\"\u0004\b?\u00106R\u0014\u0010Y\u001a\u00020ZX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\\\u00a8\u0006r"}, d2={"Ldji/v5/ux/core/widget/battery/BatteryWidget;", "Ldji/v5/ux/core/base/widget/ConstraintLayoutWidget;", "Ldji/v5/ux/core/widget/battery/BatteryWidget$ModelState;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "widgetModel", "Ldji/v5/ux/core/widget/battery/BatteryWidgetModel;", "getWidgetModel", "()Ldji/v5/ux/core/widget/battery/BatteryWidgetModel;", "widgetModel$delegate", "Lkotlin/Lazy;", "singleIconDimensionRatio", "", "dualIconDimensionRatio", "batteryIconImageView", "Landroid/widget/ImageView;", "singleBatteryValueTextView", "Landroid/widget/TextView;", "dualBattery1ValueTextView", "dualBattery2ValueTextView", "dualBattery1VoltageTextView", "dualBattery2VoltageTextView", "percentColorStates", "", "Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryStatus;", "Landroid/content/res/ColorStateList;", "voltageColorStates", "voltageBackgroundStates", "Landroid/graphics/drawable/Drawable;", "singleIconStates", "dualIconStates", "value", "", "voltageVisibility", "getVoltageVisibility", "()Z", "setVoltageVisibility", "(Z)V", "", "singleBatteryPercentageTextSize", "getSingleBatteryPercentageTextSize", "()F", "setSingleBatteryPercentageTextSize", "(F)V", "singleBatteryPercentageBackground", "getSingleBatteryPercentageBackground", "()Landroid/graphics/drawable/Drawable;", "setSingleBatteryPercentageBackground", "(Landroid/graphics/drawable/Drawable;)V", "dualBatteryPercentageTextSize", "getDualBatteryPercentageTextSize", "setDualBatteryPercentageTextSize", "dualBatteryVoltageTextSize", "getDualBatteryVoltageTextSize", "setDualBatteryVoltageTextSize", "dualBatteryPercentageBackground", "getDualBatteryPercentageBackground", "setDualBatteryPercentageBackground", "initView", "", "reactToModelChanges", "onAttachedToWindow", "onDetachedFromWindow", "updateUI", "batteryState", "Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryState;", "updateDisconnectedUI", "updateAggregateState", "Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryState$AggregateBatteryState;", "updateSingleBatteryValues", "Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryState$SingleBatteryState;", "updateDualBatteryValues", "Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryState$DualBatteryState;", "setPercentageTextColorByState", "textView", "batteryStatus", "setVoltageTextColorByState", "setSingleBatteryUI", "setDualBatteryUI", "checkAndUpdateUI", "checkAndUpdateIconDimensionRatio", "updateIconRatio", "getIdealDimensionRatioString", "widgetSizeDescription", "Ldji/v5/ux/core/base/WidgetSizeDescription;", "getWidgetSizeDescription", "()Ldji/v5/ux/core/base/WidgetSizeDescription;", "setSingleIcon", "resource", "ratio", "drawable", "setDualIcon", "setSinglePercentTextAppearance", "textAppearance", "setDualPercentTextAppearance", "setDualVoltageTextAppearance", "setPercentTextColor", "color", "colorStateList", "setVoltageTextColor", "resourceId", "setDualBatteryVoltageBackground", "getDualBatteryVoltageBackground", "initAttributes", "getWidgetStateUpdate", "Lio/reactivex/rxjava3/core/Flowable;", "ModelState", "Companion", "android-sdk-v5-uxsdk_debug"})
@SourceDebugExtension(value={"SMAP\nBatteryWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BatteryWidget.kt\ndji/v5/ux/core/widget/battery/BatteryWidget\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TypedArray.kt\nandroidx/core/content/res/TypedArrayKt\n+ 4 TypedArrayExtensions.kt\ndji/v5/ux/core/extension/TypedArrayExtensions\n*L\n1#1,729:1\n1#2:730\n233#3:731\n234#3,2:912\n125#4,5:732\n88#4,5:737\n125#4,5:742\n125#4,5:747\n125#4,5:752\n125#4,5:757\n125#4,5:762\n125#4,5:767\n125#4,5:772\n88#4,5:777\n64#4,5:782\n64#4,5:787\n64#4,5:792\n64#4,5:797\n64#4,5:802\n64#4,5:807\n125#4,5:812\n88#4,5:817\n64#4,5:822\n64#4,5:827\n64#4,5:832\n64#4,5:837\n64#4,5:842\n64#4,5:847\n125#4,5:852\n125#4,5:857\n125#4,5:862\n125#4,5:867\n125#4,5:872\n125#4,5:877\n125#4,5:882\n125#4,5:887\n125#4,5:892\n125#4,5:897\n125#4,5:902\n125#4,5:907\n*S KotlinDebug\n*F\n+ 1 BatteryWidget.kt\ndji/v5/ux/core/widget/battery/BatteryWidget\n*L\n567#1:731\n567#1:912,2\n571#1:732,5\n575#1:737,5\n579#1:742,5\n582#1:747,5\n585#1:752,5\n588#1:757,5\n591#1:762,5\n594#1:767,5\n598#1:772,5\n602#1:777,5\n606#1:782,5\n609#1:787,5\n612#1:792,5\n615#1:797,5\n618#1:802,5\n621#1:807,5\n625#1:812,5\n629#1:817,5\n633#1:822,5\n636#1:827,5\n639#1:832,5\n642#1:837,5\n645#1:842,5\n648#1:847,5\n652#1:852,5\n655#1:857,5\n658#1:862,5\n661#1:867,5\n664#1:872,5\n667#1:877,5\n671#1:882,5\n674#1:887,5\n677#1:892,5\n680#1:897,5\n683#1:902,5\n686#1:907,5\n*E\n"})
public class BatteryWidget
extends ConstraintLayoutWidget<ModelState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy widgetModel$delegate;
    @NotNull
    private String singleIconDimensionRatio;
    @NotNull
    private String dualIconDimensionRatio;
    @NotNull
    private final ImageView batteryIconImageView;
    @NotNull
    private final TextView singleBatteryValueTextView;
    @NotNull
    private final TextView dualBattery1ValueTextView;
    @NotNull
    private final TextView dualBattery2ValueTextView;
    @NotNull
    private final TextView dualBattery1VoltageTextView;
    @NotNull
    private final TextView dualBattery2VoltageTextView;
    @NotNull
    private Map<BatteryWidgetModel.BatteryStatus, ColorStateList> percentColorStates;
    @NotNull
    private Map<BatteryWidgetModel.BatteryStatus, ColorStateList> voltageColorStates;
    @NotNull
    private Map<BatteryWidgetModel.BatteryStatus, Drawable> voltageBackgroundStates;
    @NotNull
    private Map<BatteryWidgetModel.BatteryStatus, Drawable> singleIconStates;
    @NotNull
    private Map<BatteryWidgetModel.BatteryStatus, Drawable> dualIconStates;
    private boolean voltageVisibility;
    @NotNull
    private final WidgetSizeDescription widgetSizeDescription;
    @NotNull
    private static final String TAG = "BatteryWidget";

    @JvmOverloads
    public BatteryWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.widgetModel$delegate = LazyKt.lazy(BatteryWidget::widgetModel_delegate$lambda$0);
        this.singleIconDimensionRatio = ViewExtensions.getString((View)this, R.string.uxsdk_icon_single_battery_ratio, new Object[0]);
        this.dualIconDimensionRatio = ViewExtensions.getString((View)this, R.string.uxsdk_icon_dual_battery_ratio, new Object[0]);
        View view = this.findViewById(R.id.imageview_battery_icon);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        this.batteryIconImageView = (ImageView)view;
        View view2 = this.findViewById(R.id.textview_battery_value);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
        this.singleBatteryValueTextView = (TextView)view2;
        View view3 = this.findViewById(R.id.textview_battery1_value);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(...)");
        this.dualBattery1ValueTextView = (TextView)view3;
        View view4 = this.findViewById(R.id.textview_battery2_value);
        Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"findViewById(...)");
        this.dualBattery2ValueTextView = (TextView)view4;
        View view5 = this.findViewById(R.id.textview_battery1_voltage);
        Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"findViewById(...)");
        this.dualBattery1VoltageTextView = (TextView)view5;
        View view6 = this.findViewById(R.id.textview_battery2_voltage);
        Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"findViewById(...)");
        this.dualBattery2VoltageTextView = (TextView)view6;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.NORMAL), (Object)ColorStateList.valueOf((int)ViewExtensions.getColor((View)this, R.color.uxsdk_battery_healthy))), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.UNKNOWN), (Object)ColorStateList.valueOf((int)ViewExtensions.getColor((View)this, R.color.uxsdk_battery_healthy))), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.OVERHEATING), (Object)ColorStateList.valueOf((int)ViewExtensions.getColor((View)this, R.color.uxsdk_battery_overheating))), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.WARNING_LEVEL_1), (Object)ColorStateList.valueOf((int)ViewExtensions.getColor((View)this, R.color.uxsdk_battery_danger))), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.WARNING_LEVEL_2), (Object)ColorStateList.valueOf((int)ViewExtensions.getColor((View)this, R.color.uxsdk_battery_danger))), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.ERROR), (Object)ColorStateList.valueOf((int)ViewExtensions.getColor((View)this, R.color.uxsdk_battery_danger)))};
        this.percentColorStates = MapsKt.mutableMapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.NORMAL), (Object)ColorStateList.valueOf((int)ViewExtensions.getColor((View)this, R.color.uxsdk_battery_healthy))), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.UNKNOWN), (Object)ColorStateList.valueOf((int)ViewExtensions.getColor((View)this, R.color.uxsdk_battery_healthy))), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.OVERHEATING), (Object)ColorStateList.valueOf((int)ViewExtensions.getColor((View)this, R.color.uxsdk_battery_overheating))), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.WARNING_LEVEL_1), (Object)ColorStateList.valueOf((int)ViewExtensions.getColor((View)this, R.color.uxsdk_battery_danger))), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.WARNING_LEVEL_2), (Object)ColorStateList.valueOf((int)ViewExtensions.getColor((View)this, R.color.uxsdk_battery_danger))), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.ERROR), (Object)ColorStateList.valueOf((int)ViewExtensions.getColor((View)this, R.color.uxsdk_battery_danger)))};
        this.voltageColorStates = MapsKt.mutableMapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.NORMAL), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_background_battery_voltage_bg_normal)), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.UNKNOWN), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_background_battery_voltage_bg_normal)), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.OVERHEATING), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_background_battery_voltage_bg_overheating)), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.WARNING_LEVEL_1), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_background_battery_voltage_bg_danger)), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.WARNING_LEVEL_2), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_background_battery_voltage_bg_danger)), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.ERROR), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_background_battery_voltage_bg_danger))};
        this.voltageBackgroundStates = MapsKt.mutableMapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.NORMAL), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_topbar_battery_single_nor)), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.UNKNOWN), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_topbar_battery_single_nor)), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.OVERHEATING), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_topbar_battery_single_overheating)), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.WARNING_LEVEL_1), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_topbar_battery_single_warning)), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.WARNING_LEVEL_2), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_topbar_battery_single_land_immediately)), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.ERROR), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_topbar_battery_single_error))};
        this.singleIconStates = MapsKt.mutableMapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.NORMAL), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_topbar_battery_double_nor)), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.UNKNOWN), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_topbar_battery_double_nor)), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.OVERHEATING), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_topbar_battery_double_overheating)), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.WARNING_LEVEL_1), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_topbar_battery_double_warning)), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.WARNING_LEVEL_2), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_topbar_battery_double_land_immediately)), TuplesKt.to((Object)((Object)BatteryWidgetModel.BatteryStatus.ERROR), (Object)ViewExtensions.getDrawable((View)this, R.drawable.uxsdk_ic_topbar_battery_double_warning))};
        this.dualIconStates = MapsKt.mutableMapOf((Pair[])pairArray);
        this.voltageVisibility = true;
        AttributeSet attributeSet = attrs;
        if (attributeSet != null) {
            AttributeSet it = attributeSet;
            boolean bl = false;
            this.initAttributes(context, it);
        }
        this.widgetSizeDescription = new WidgetSizeDescription(WidgetSizeDescription.SizeType.OTHER, WidgetSizeDescription.Dimension.WRAP, WidgetSizeDescription.Dimension.EXPAND);
    }

    public /* synthetic */ BatteryWidget(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final BatteryWidgetModel getWidgetModel() {
        Lazy lazy = this.widgetModel$delegate;
        return (BatteryWidgetModel)lazy.getValue();
    }

    public final boolean getVoltageVisibility() {
        return this.voltageVisibility;
    }

    public final void setVoltageVisibility(boolean value) {
        this.voltageVisibility = value;
        this.checkAndUpdateUI();
    }

    public final float getSingleBatteryPercentageTextSize() {
        return this.singleBatteryValueTextView.getTextSize();
    }

    public final void setSingleBatteryPercentageTextSize(@Dimension float value) {
        this.singleBatteryValueTextView.setTextSize(value);
    }

    @Nullable
    public final Drawable getSingleBatteryPercentageBackground() {
        return this.singleBatteryValueTextView.getBackground();
    }

    public final void setSingleBatteryPercentageBackground(@Nullable Drawable value) {
        this.singleBatteryValueTextView.setBackground(value);
    }

    public final float getDualBatteryPercentageTextSize() {
        return this.dualBattery1ValueTextView.getTextSize();
    }

    public final void setDualBatteryPercentageTextSize(@Dimension float value) {
        this.dualBattery1ValueTextView.setTextSize(value);
        this.dualBattery2ValueTextView.setTextSize(value);
    }

    public final float getDualBatteryVoltageTextSize() {
        return this.dualBattery1VoltageTextView.getTextSize();
    }

    public final void setDualBatteryVoltageTextSize(@Dimension float value) {
        this.dualBattery1VoltageTextView.setTextSize(value);
        this.dualBattery2VoltageTextView.setTextSize(value);
    }

    @Nullable
    public final Drawable getDualBatteryPercentageBackground() {
        return this.dualBattery1ValueTextView.getBackground();
    }

    public final void setDualBatteryPercentageBackground(@Nullable Drawable value) {
        this.dualBattery1ValueTextView.setBackground(value);
        this.dualBattery2ValueTextView.setBackground(value);
    }

    @Override
    protected void initView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        View.inflate((Context)context, (int)R.layout.uxsdk_widget_battery, (ViewGroup)((ViewGroup)this));
    }

    @Override
    protected void reactToModelChanges() {
        Disposable disposable = this.getWidgetModel().getBatteryState().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ BatteryWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(BatteryWidgetModel.BatteryState it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                BatteryWidget.access$updateUI(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addReaction(disposable);
        Disposable disposable2 = this.getWidgetModel().getProductConnection().observeOn(SchedulerProvider.ui()).subscribe(new Consumer(this){
            final /* synthetic */ BatteryWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Boolean it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                BatteryWidget.access$getWidgetStateDataProcessor(this.this$0).onNext((Object)new ModelState.ProductConnected(it));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"subscribe(...)");
        this.addReaction(disposable2);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.getWidgetModel().setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.getWidgetModel().cleanup();
        }
        super.onDetachedFromWindow();
    }

    private final void updateUI(BatteryWidgetModel.BatteryState batteryState) {
        this.getWidgetStateDataProcessor().onNext((Object)new ModelState.BatteryStateUpdated(batteryState));
        BatteryWidgetModel.BatteryState batteryState2 = batteryState;
        if (batteryState2 instanceof BatteryWidgetModel.BatteryState.DualBatteryState) {
            this.setDualBatteryUI();
            this.updateDualBatteryValues((BatteryWidgetModel.BatteryState.DualBatteryState)batteryState);
        } else if (batteryState2 instanceof BatteryWidgetModel.BatteryState.SingleBatteryState) {
            this.setSingleBatteryUI();
            this.updateSingleBatteryValues((BatteryWidgetModel.BatteryState.SingleBatteryState)batteryState);
        } else if (batteryState2 instanceof BatteryWidgetModel.BatteryState.AggregateBatteryState) {
            this.setSingleBatteryUI();
            this.updateAggregateState((BatteryWidgetModel.BatteryState.AggregateBatteryState)batteryState);
        } else if (batteryState2 instanceof BatteryWidgetModel.BatteryState.DisconnectedState) {
            this.setSingleBatteryUI();
            this.updateDisconnectedUI();
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void updateDisconnectedUI() {
        this.setSingleBatteryUI();
        this.singleBatteryValueTextView.setText((CharSequence)ViewExtensions.getString((View)this, R.string.uxsdk_string_default_value, new Object[0]));
        ViewExtensions.setTextColor(this.singleBatteryValueTextView, ViewExtensions.getColor((View)this, R.color.uxsdk_white_60_percent));
        ViewExtensions.setImageDrawable(this.batteryIconImageView, this.singleIconStates.get((Object)BatteryWidgetModel.BatteryStatus.NORMAL));
        this.batteryIconImageView.setColorFilter(ViewExtensions.getColor((View)this, R.color.uxsdk_white_60_percent), PorterDuff.Mode.SRC_IN);
    }

    private final void updateAggregateState(BatteryWidgetModel.BatteryState.AggregateBatteryState batteryState) {
        block0: {
            Object[] objectArray = new Object[]{batteryState.getAggregatePercentage()};
            this.singleBatteryValueTextView.setText((CharSequence)this.getResources().getString(R.string.uxsdk_battery_percent, objectArray));
            this.setPercentageTextColorByState(this.singleBatteryValueTextView, batteryState.getAggregateBatteryStatus());
            Drawable drawable2 = this.singleIconStates.get((Object)batteryState.getAggregateBatteryStatus());
            if (drawable2 == null) break block0;
            Drawable it = drawable2;
            boolean bl = false;
            ViewExtensions.setImageDrawable(this.batteryIconImageView, it);
        }
    }

    private final void updateSingleBatteryValues(BatteryWidgetModel.BatteryState.SingleBatteryState batteryState) {
        block0: {
            Object[] objectArray = new Object[]{batteryState.getPercentageRemaining()};
            this.singleBatteryValueTextView.setText((CharSequence)this.getResources().getString(R.string.uxsdk_battery_percent, objectArray));
            this.setPercentageTextColorByState(this.singleBatteryValueTextView, batteryState.getBatteryStatus());
            Drawable drawable2 = this.singleIconStates.get((Object)batteryState.getBatteryStatus());
            if (drawable2 == null) break block0;
            Drawable it = drawable2;
            boolean bl = false;
            ViewExtensions.setImageDrawable(this.batteryIconImageView, it);
        }
    }

    private final void updateDualBatteryValues(BatteryWidgetModel.BatteryState.DualBatteryState batteryState) {
        block0: {
            Object[] objectArray = new Object[]{batteryState.getPercentageRemaining1()};
            this.dualBattery1ValueTextView.setText((CharSequence)this.getResources().getString(R.string.uxsdk_battery_percent, objectArray));
            objectArray = new Object[]{batteryState.getPercentageRemaining2()};
            this.dualBattery2ValueTextView.setText((CharSequence)this.getResources().getString(R.string.uxsdk_battery_percent, objectArray));
            objectArray = new Object[]{Float.valueOf(batteryState.getVoltageLevel1())};
            this.dualBattery1VoltageTextView.setText((CharSequence)this.getResources().getString(R.string.uxsdk_battery_voltage_unit, objectArray));
            objectArray = new Object[]{Float.valueOf(batteryState.getVoltageLevel2())};
            this.dualBattery2VoltageTextView.setText((CharSequence)this.getResources().getString(R.string.uxsdk_battery_voltage_unit, objectArray));
            this.setPercentageTextColorByState(this.dualBattery1ValueTextView, batteryState.getBatteryStatus1());
            this.setPercentageTextColorByState(this.dualBattery2ValueTextView, batteryState.getBatteryStatus2());
            this.setVoltageTextColorByState(this.dualBattery1VoltageTextView, batteryState.getBatteryStatus1());
            this.setVoltageTextColorByState(this.dualBattery2VoltageTextView, batteryState.getBatteryStatus2());
            this.dualBattery1VoltageTextView.setBackground(this.voltageBackgroundStates.get((Object)batteryState.getBatteryStatus1()));
            this.dualBattery2VoltageTextView.setBackground(this.voltageBackgroundStates.get((Object)batteryState.getBatteryStatus2()));
            BatteryWidgetModel.BatteryStatus priorityStatus = batteryState.getBatteryStatus1().getIndex() > batteryState.getBatteryStatus2().getIndex() ? batteryState.getBatteryStatus1() : batteryState.getBatteryStatus2();
            Drawable drawable2 = this.dualIconStates.get((Object)priorityStatus);
            if (drawable2 == null) break block0;
            Drawable it = drawable2;
            boolean bl = false;
            ViewExtensions.setImageDrawable(this.batteryIconImageView, it);
        }
    }

    private final void setPercentageTextColorByState(TextView textView, BatteryWidgetModel.BatteryStatus batteryStatus) {
        block0: {
            ColorStateList colorStateList = this.percentColorStates.get((Object)batteryStatus);
            if (colorStateList == null) break block0;
            ColorStateList it = colorStateList;
            boolean bl = false;
            ViewExtensions.setTextColorStateList(textView, it);
        }
    }

    private final void setVoltageTextColorByState(TextView textView, BatteryWidgetModel.BatteryStatus batteryStatus) {
        block0: {
            ColorStateList colorStateList = this.voltageColorStates.get((Object)batteryStatus);
            if (colorStateList == null) break block0;
            ColorStateList it = colorStateList;
            boolean bl = false;
            ViewExtensions.setTextColorStateList(textView, it);
        }
    }

    private final void setSingleBatteryUI() {
        this.batteryIconImageView.clearColorFilter();
        this.singleBatteryValueTextView.setVisibility(0);
        this.dualBattery1ValueTextView.setVisibility(8);
        this.dualBattery2ValueTextView.setVisibility(8);
        this.dualBattery1VoltageTextView.setVisibility(8);
        this.dualBattery2VoltageTextView.setVisibility(8);
    }

    private final void setDualBatteryUI() {
        this.batteryIconImageView.clearColorFilter();
        this.singleBatteryValueTextView.setVisibility(8);
        this.dualBattery1ValueTextView.setVisibility(0);
        this.dualBattery2ValueTextView.setVisibility(0);
        this.dualBattery1VoltageTextView.setVisibility(this.voltageVisibility ? 0 : 8);
        this.dualBattery2VoltageTextView.setVisibility(this.voltageVisibility ? 0 : 8);
    }

    private final void checkAndUpdateUI() {
        if (!this.isInEditMode()) {
            Disposable disposable = this.getWidgetModel().getBatteryState().firstOrError().observeOn(SchedulerProvider.ui()).subscribe(arg_0 -> BatteryWidget.checkAndUpdateUI$lambda$7(this, arg_0), UxErrorHandle.logErrorConsumer(TAG, "Update UI "));
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
            this.addDisposable(disposable);
        }
    }

    private final void checkAndUpdateIconDimensionRatio() {
        if (!this.isInEditMode()) {
            Disposable disposable = this.getWidgetModel().getBatteryState().firstOrError().observeOn(SchedulerProvider.ui()).subscribe(arg_0 -> BatteryWidget.checkAndUpdateIconDimensionRatio$lambda$8(this, arg_0), UxErrorHandle.logErrorConsumer(TAG, "Update icon dimension ratio "));
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
            this.addDisposable(disposable);
        }
    }

    private final void updateIconRatio(BatteryWidgetModel.BatteryState batteryState) {
        ConstraintSet set = new ConstraintSet();
        set.clone((ConstraintLayout)this);
        set.setDimensionRatio(this.batteryIconImageView.getId(), batteryState instanceof BatteryWidgetModel.BatteryState.DualBatteryState ? this.dualIconDimensionRatio : this.singleIconDimensionRatio);
        set.applyTo((ConstraintLayout)this);
    }

    @Override
    @Nullable
    public String getIdealDimensionRatioString() {
        return null;
    }

    @Override
    @NotNull
    public WidgetSizeDescription getWidgetSizeDescription() {
        return this.widgetSizeDescription;
    }

    public final void setSingleIcon(@NotNull BatteryWidgetModel.BatteryStatus batteryStatus, @DrawableRes int resource) {
        Intrinsics.checkNotNullParameter((Object)((Object)batteryStatus), (String)"batteryStatus");
        this.setSingleIcon(batteryStatus, ViewExtensions.getDrawable((View)this, resource));
    }

    public final void setSingleIcon(@NotNull BatteryWidgetModel.BatteryStatus batteryStatus, @DrawableRes int resource, @NotNull String ratio) {
        Intrinsics.checkNotNullParameter((Object)((Object)batteryStatus), (String)"batteryStatus");
        Intrinsics.checkNotNullParameter((Object)ratio, (String)"ratio");
        this.setSingleIcon(batteryStatus, ViewExtensions.getDrawable((View)this, resource), ratio);
    }

    public final void setSingleIcon(@NotNull BatteryWidgetModel.BatteryStatus batteryStatus, @NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)((Object)batteryStatus), (String)"batteryStatus");
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        this.singleIconStates.put(batteryStatus, drawable2);
        this.checkAndUpdateUI();
    }

    public final void setSingleIcon(@NotNull BatteryWidgetModel.BatteryStatus batteryStatus, @NotNull Drawable drawable2, @NotNull String ratio) {
        Intrinsics.checkNotNullParameter((Object)((Object)batteryStatus), (String)"batteryStatus");
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)ratio, (String)"ratio");
        this.setSingleIcon(batteryStatus, drawable2);
        this.singleIconDimensionRatio = ratio;
        this.checkAndUpdateIconDimensionRatio();
    }

    public final void setDualIcon(@NotNull BatteryWidgetModel.BatteryStatus batteryStatus, @DrawableRes int resource) {
        Intrinsics.checkNotNullParameter((Object)((Object)batteryStatus), (String)"batteryStatus");
        this.setDualIcon(batteryStatus, ViewExtensions.getDrawable((View)this, resource));
    }

    public final void setDualIcon(@NotNull BatteryWidgetModel.BatteryStatus batteryStatus, @DrawableRes int resource, @NotNull String ratio) {
        Intrinsics.checkNotNullParameter((Object)((Object)batteryStatus), (String)"batteryStatus");
        Intrinsics.checkNotNullParameter((Object)ratio, (String)"ratio");
        this.setDualIcon(batteryStatus, ViewExtensions.getDrawable((View)this, resource), ratio);
    }

    public final void setDualIcon(@NotNull BatteryWidgetModel.BatteryStatus batteryStatus, @NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)((Object)batteryStatus), (String)"batteryStatus");
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        this.dualIconStates.put(batteryStatus, drawable2);
        this.checkAndUpdateUI();
    }

    public final void setDualIcon(@NotNull BatteryWidgetModel.BatteryStatus batteryStatus, @NotNull Drawable drawable2, @NotNull String ratio) {
        Intrinsics.checkNotNullParameter((Object)((Object)batteryStatus), (String)"batteryStatus");
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)ratio, (String)"ratio");
        this.setDualIcon(batteryStatus, drawable2);
        this.dualIconDimensionRatio = ratio;
        this.checkAndUpdateIconDimensionRatio();
    }

    public final void setSinglePercentTextAppearance(@StyleRes int textAppearance) {
        this.singleBatteryValueTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    public final void setDualPercentTextAppearance(@StyleRes int textAppearance) {
        this.dualBattery1ValueTextView.setTextAppearance(this.getContext(), textAppearance);
        this.dualBattery2ValueTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    public final void setDualVoltageTextAppearance(@StyleRes int textAppearance) {
        this.dualBattery1VoltageTextView.setTextAppearance(this.getContext(), textAppearance);
        this.dualBattery2VoltageTextView.setTextAppearance(this.getContext(), textAppearance);
    }

    public final void setPercentTextColor(@NotNull BatteryWidgetModel.BatteryStatus batteryStatus, @ColorInt int color2) {
        Intrinsics.checkNotNullParameter((Object)((Object)batteryStatus), (String)"batteryStatus");
        ColorStateList colorStateList = ColorStateList.valueOf((int)color2);
        Intrinsics.checkNotNullExpressionValue((Object)colorStateList, (String)"valueOf(...)");
        this.setPercentTextColor(batteryStatus, colorStateList);
    }

    public final void setPercentTextColor(@NotNull BatteryWidgetModel.BatteryStatus batteryStatus, @NotNull ColorStateList colorStateList) {
        Intrinsics.checkNotNullParameter((Object)((Object)batteryStatus), (String)"batteryStatus");
        Intrinsics.checkNotNullParameter((Object)colorStateList, (String)"colorStateList");
        this.percentColorStates.put(batteryStatus, colorStateList);
        this.checkAndUpdateUI();
    }

    public final void setVoltageTextColor(@NotNull BatteryWidgetModel.BatteryStatus batteryStatus, @ColorInt int color2) {
        Intrinsics.checkNotNullParameter((Object)((Object)batteryStatus), (String)"batteryStatus");
        ColorStateList colorStateList = ColorStateList.valueOf((int)color2);
        Intrinsics.checkNotNullExpressionValue((Object)colorStateList, (String)"valueOf(...)");
        this.setVoltageTextColor(batteryStatus, colorStateList);
    }

    public final void setVoltageTextColor(@NotNull BatteryWidgetModel.BatteryStatus batteryStatus, @NotNull ColorStateList colorStateList) {
        Intrinsics.checkNotNullParameter((Object)((Object)batteryStatus), (String)"batteryStatus");
        Intrinsics.checkNotNullParameter((Object)colorStateList, (String)"colorStateList");
        this.voltageColorStates.put(batteryStatus, colorStateList);
        this.checkAndUpdateUI();
    }

    public final void setDualBatteryPercentageBackground(@DrawableRes int resourceId) {
        this.setDualBatteryPercentageBackground(ViewExtensions.getDrawable((View)this, resourceId));
    }

    public final void setDualBatteryVoltageBackground(@NotNull BatteryWidgetModel.BatteryStatus batteryStatus, @DrawableRes int resourceId) {
        Intrinsics.checkNotNullParameter((Object)((Object)batteryStatus), (String)"batteryStatus");
        this.setDualBatteryVoltageBackground(batteryStatus, ViewExtensions.getDrawable((View)this, resourceId));
    }

    public final void setDualBatteryVoltageBackground(@NotNull BatteryWidgetModel.BatteryStatus batteryStatus, @Nullable Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)((Object)batteryStatus), (String)"batteryStatus");
        this.voltageBackgroundStates.put(batteryStatus, drawable2);
        this.checkAndUpdateUI();
    }

    @Nullable
    public final Drawable getDualBatteryVoltageBackground(@NotNull BatteryWidgetModel.BatteryStatus batteryStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)batteryStatus), (String)"batteryStatus");
        return this.voltageBackgroundStates.get((Object)batteryStatus);
    }

    public final void setSingleBatteryPercentageBackground(@DrawableRes int resourceId) {
        this.setSingleBatteryPercentageBackground(ViewExtensions.getDrawable((View)this, resourceId));
    }

    @SuppressLint(value={"Recycle"})
    private final void initAttributes(Context context, AttributeSet attrs) {
        Unit unit;
        TypedArray $this$getColorAndUse$iv;
        TypedArray $this$getDimensionAndUse$iv;
        int it;
        TypedArray $this$getResourceIdAndUse$iv;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BatteryWidget);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray $this$use$iv = typedArray;
        boolean $i$f$use = false;
        TypedArray typedArray2 = $this$use$iv;
        boolean bl = false;
        this.setVoltageVisibility(typedArray2.getBoolean(R.styleable.BatteryWidget_uxsdk_voltageVisibility, true));
        TypedArray typedArray3 = typedArray2;
        int index$iv = R.styleable.BatteryWidget_uxsdk_singlePercentAppearance;
        boolean $i$f$getResourceIdAndUse = false;
        int resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            it = resourceId$iv;
            boolean bl2 = false;
            this.setSinglePercentTextAppearance(it);
        }
        $this$getResourceIdAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_singlePercentTextSize;
        boolean $i$f$getDimensionAndUse = false;
        float dimension$iv = $this$getDimensionAndUse$iv.getDimension(index$iv, -1.0f);
        if (!(dimension$iv == -1.0f)) {
            float it2 = dimension$iv;
            boolean bl3 = false;
            this.setSingleBatteryPercentageTextSize(it2);
        }
        $this$getDimensionAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_singleIconUnknown;
        $i$f$getResourceIdAndUse = false;
        resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            it = resourceId$iv;
            boolean bl4 = false;
            this.setSingleIcon(BatteryWidgetModel.BatteryStatus.UNKNOWN, it);
        }
        $this$getResourceIdAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_singleIconNormal;
        $i$f$getResourceIdAndUse = false;
        resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            it = resourceId$iv;
            boolean bl5 = false;
            this.setSingleIcon(BatteryWidgetModel.BatteryStatus.NORMAL, it);
        }
        $this$getResourceIdAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_singleIconOverheating;
        $i$f$getResourceIdAndUse = false;
        resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            it = resourceId$iv;
            boolean bl6 = false;
            this.setSingleIcon(BatteryWidgetModel.BatteryStatus.OVERHEATING, it);
        }
        $this$getResourceIdAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_singleIconWarningLevel1;
        $i$f$getResourceIdAndUse = false;
        resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            it = resourceId$iv;
            boolean bl7 = false;
            this.setSingleIcon(BatteryWidgetModel.BatteryStatus.WARNING_LEVEL_1, it);
        }
        $this$getResourceIdAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_singleIconWarningLevel2;
        $i$f$getResourceIdAndUse = false;
        resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            it = resourceId$iv;
            boolean bl8 = false;
            this.setSingleIcon(BatteryWidgetModel.BatteryStatus.WARNING_LEVEL_2, it);
        }
        $this$getResourceIdAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_singleIconError;
        $i$f$getResourceIdAndUse = false;
        resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            it = resourceId$iv;
            boolean bl9 = false;
            this.setSingleIcon(BatteryWidgetModel.BatteryStatus.ERROR, it);
        }
        $this$getResourceIdAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_dualPercentAppearance;
        $i$f$getResourceIdAndUse = false;
        resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            it = resourceId$iv;
            boolean bl10 = false;
            this.setDualPercentTextAppearance(it);
        }
        $this$getResourceIdAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_dualPercentTextSize;
        $i$f$getDimensionAndUse = false;
        dimension$iv = $this$getDimensionAndUse$iv.getDimension(index$iv, -1.0f);
        if (!(dimension$iv == -1.0f)) {
            float it3 = dimension$iv;
            boolean bl11 = false;
            this.setDualBatteryPercentageTextSize(it3);
        }
        $this$getDimensionAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_percentTextColorUnknown;
        boolean $i$f$getColorAndUse = false;
        int colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            int it4 = colorInt$iv;
            boolean bl12 = false;
            this.setPercentTextColor(BatteryWidgetModel.BatteryStatus.UNKNOWN, it4);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_percentTextColorNormal;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            int it5 = colorInt$iv;
            boolean bl13 = false;
            this.setPercentTextColor(BatteryWidgetModel.BatteryStatus.NORMAL, it5);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_percentTextColorOverheating;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            int it6 = colorInt$iv;
            boolean bl14 = false;
            this.setPercentTextColor(BatteryWidgetModel.BatteryStatus.OVERHEATING, it6);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_percentTextColorWarningLevel1;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            int it7 = colorInt$iv;
            boolean bl15 = false;
            this.setPercentTextColor(BatteryWidgetModel.BatteryStatus.WARNING_LEVEL_1, it7);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_percentTextColorWarningLevel2;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            int it8 = colorInt$iv;
            boolean bl16 = false;
            this.setPercentTextColor(BatteryWidgetModel.BatteryStatus.WARNING_LEVEL_2, it8);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_percentTextColorError;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            int it9 = colorInt$iv;
            boolean bl17 = false;
            this.setPercentTextColor(BatteryWidgetModel.BatteryStatus.ERROR, it9);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_dualVoltageAppearance;
        $i$f$getResourceIdAndUse = false;
        resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            int it10 = resourceId$iv;
            boolean bl18 = false;
            this.setDualVoltageTextAppearance(it10);
        }
        $this$getResourceIdAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_dualPercentTextSize;
        $i$f$getDimensionAndUse = false;
        dimension$iv = $this$getDimensionAndUse$iv.getDimension(index$iv, -1.0f);
        if (!(dimension$iv == -1.0f)) {
            float it11 = dimension$iv;
            boolean bl19 = false;
            this.setDualBatteryVoltageTextSize(it11);
        }
        $this$getDimensionAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_voltageTextColorUnknown;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            int it12 = colorInt$iv;
            boolean bl20 = false;
            this.setVoltageTextColor(BatteryWidgetModel.BatteryStatus.UNKNOWN, it12);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_voltageTextColorNormal;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            int it13 = colorInt$iv;
            boolean bl21 = false;
            this.setVoltageTextColor(BatteryWidgetModel.BatteryStatus.NORMAL, it13);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_voltageTextColorOverheating;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            int it14 = colorInt$iv;
            boolean bl22 = false;
            this.setVoltageTextColor(BatteryWidgetModel.BatteryStatus.OVERHEATING, it14);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_voltageTextColorWarningLevel1;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            int it15 = colorInt$iv;
            boolean bl23 = false;
            this.setVoltageTextColor(BatteryWidgetModel.BatteryStatus.WARNING_LEVEL_1, it15);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_voltageTextColorWarningLevel2;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            int it16 = colorInt$iv;
            boolean bl24 = false;
            this.setVoltageTextColor(BatteryWidgetModel.BatteryStatus.WARNING_LEVEL_2, it16);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_voltageTextColorError;
        $i$f$getColorAndUse = false;
        colorInt$iv = $this$getColorAndUse$iv.getColor(index$iv, -1);
        if (colorInt$iv != -1) {
            int it17 = colorInt$iv;
            boolean bl25 = false;
            this.setVoltageTextColor(BatteryWidgetModel.BatteryStatus.ERROR, it17);
        }
        $this$getColorAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_voltageBackgroundUnknown;
        $i$f$getResourceIdAndUse = false;
        resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            int it18 = resourceId$iv;
            boolean bl26 = false;
            this.setDualBatteryVoltageBackground(BatteryWidgetModel.BatteryStatus.UNKNOWN, it18);
        }
        $this$getResourceIdAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_voltageBackgroundNormal;
        $i$f$getResourceIdAndUse = false;
        resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            int it19 = resourceId$iv;
            boolean bl27 = false;
            this.setDualBatteryVoltageBackground(BatteryWidgetModel.BatteryStatus.NORMAL, it19);
        }
        $this$getResourceIdAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_voltageBackgroundOverheating;
        $i$f$getResourceIdAndUse = false;
        resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            int it20 = resourceId$iv;
            boolean bl28 = false;
            this.setDualBatteryVoltageBackground(BatteryWidgetModel.BatteryStatus.OVERHEATING, it20);
        }
        $this$getResourceIdAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_voltageBackgroundWarningLevel1;
        $i$f$getResourceIdAndUse = false;
        resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            int it21 = resourceId$iv;
            boolean bl29 = false;
            this.setDualBatteryVoltageBackground(BatteryWidgetModel.BatteryStatus.WARNING_LEVEL_1, it21);
        }
        $this$getResourceIdAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_voltageBackgroundWarningLevel2;
        $i$f$getResourceIdAndUse = false;
        resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            int it22 = resourceId$iv;
            boolean bl30 = false;
            this.setDualBatteryVoltageBackground(BatteryWidgetModel.BatteryStatus.WARNING_LEVEL_2, it22);
        }
        $this$getResourceIdAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_voltageBackgroundError;
        $i$f$getResourceIdAndUse = false;
        resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            int it23 = resourceId$iv;
            boolean bl31 = false;
            this.setDualBatteryVoltageBackground(BatteryWidgetModel.BatteryStatus.ERROR, it23);
        }
        $this$getResourceIdAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_dualIconUnknown;
        $i$f$getResourceIdAndUse = false;
        resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            int it24 = resourceId$iv;
            boolean bl32 = false;
            this.setDualIcon(BatteryWidgetModel.BatteryStatus.UNKNOWN, it24);
        }
        $this$getResourceIdAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_dualIconNormal;
        $i$f$getResourceIdAndUse = false;
        resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            int it25 = resourceId$iv;
            boolean bl33 = false;
            this.setDualIcon(BatteryWidgetModel.BatteryStatus.NORMAL, it25);
        }
        $this$getResourceIdAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_dualIconOverheating;
        $i$f$getResourceIdAndUse = false;
        resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            int it26 = resourceId$iv;
            boolean bl34 = false;
            this.setDualIcon(BatteryWidgetModel.BatteryStatus.OVERHEATING, it26);
        }
        $this$getResourceIdAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_dualIconWarningLevel1;
        $i$f$getResourceIdAndUse = false;
        resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            int it27 = resourceId$iv;
            boolean bl35 = false;
            this.setDualIcon(BatteryWidgetModel.BatteryStatus.WARNING_LEVEL_1, it27);
        }
        $this$getResourceIdAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_dualIconWarningLevel2;
        $i$f$getResourceIdAndUse = false;
        resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            int it28 = resourceId$iv;
            boolean bl36 = false;
            this.setDualIcon(BatteryWidgetModel.BatteryStatus.WARNING_LEVEL_2, it28);
        }
        $this$getResourceIdAndUse$iv = typedArray2;
        index$iv = R.styleable.BatteryWidget_uxsdk_dualIconError;
        $i$f$getResourceIdAndUse = false;
        resourceId$iv = $this$getResourceIdAndUse$iv.getResourceId(index$iv, -1);
        if (resourceId$iv != -1) {
            int it29 = resourceId$iv;
            boolean bl37 = false;
            this.setDualIcon(BatteryWidgetModel.BatteryStatus.ERROR, it29);
        }
        this.singleIconDimensionRatio = TypedArrayExtensions.getString(typedArray2, R.styleable.BatteryWidget_uxsdk_singleIconDimensionRatio, this.singleIconDimensionRatio);
        this.dualIconDimensionRatio = TypedArrayExtensions.getString(typedArray2, R.styleable.BatteryWidget_uxsdk_dualIconDimensionRatio, this.dualIconDimensionRatio);
        Unit it$iv = unit = Unit.INSTANCE;
        boolean bl38 = false;
        $this$use$iv.recycle();
    }

    @Override
    @NotNull
    public Flowable<ModelState> getWidgetStateUpdate() {
        return super.getWidgetStateUpdate();
    }

    @JvmOverloads
    public BatteryWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public BatteryWidget(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final BatteryWidgetModel widgetModel_delegate$lambda$0() {
        DJISDKModel dJISDKModel = DJISDKModel.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dJISDKModel, (String)"getInstance(...)");
        ObservableInMemoryKeyedStore observableInMemoryKeyedStore = ObservableInMemoryKeyedStore.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)observableInMemoryKeyedStore, (String)"getInstance(...)");
        return new BatteryWidgetModel(dJISDKModel, observableInMemoryKeyedStore);
    }

    private static final void checkAndUpdateUI$lambda$7(BatteryWidget this$0, BatteryWidgetModel.BatteryState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateUI(it);
    }

    private static final void checkAndUpdateIconDimensionRatio$lambda$8(BatteryWidget this$0, BatteryWidgetModel.BatteryState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateIconRatio(it);
    }

    public static final /* synthetic */ void access$updateUI(BatteryWidget $this, BatteryWidgetModel.BatteryState batteryState) {
        $this.updateUI(batteryState);
    }

    public static final /* synthetic */ PublishProcessor access$getWidgetStateDataProcessor(BatteryWidget $this) {
        return $this.getWidgetStateDataProcessor();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldji/v5/ux/core/widget/battery/BatteryWidget$Companion;", "", "<init>", "()V", "TAG", "", "android-sdk-v5-uxsdk_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Ldji/v5/ux/core/widget/battery/BatteryWidget$ModelState;", "", "<init>", "()V", "ProductConnected", "BatteryStateUpdated", "Ldji/v5/ux/core/widget/battery/BatteryWidget$ModelState$BatteryStateUpdated;", "Ldji/v5/ux/core/widget/battery/BatteryWidget$ModelState$ProductConnected;", "android-sdk-v5-uxsdk_debug"})
    public static abstract class ModelState {
        private ModelState() {
        }

        public /* synthetic */ ModelState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Ldji/v5/ux/core/widget/battery/BatteryWidget$ModelState$BatteryStateUpdated;", "Ldji/v5/ux/core/widget/battery/BatteryWidget$ModelState;", "batteryState", "Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryState;", "<init>", "(Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryState;)V", "getBatteryState", "()Ldji/v5/ux/core/widget/battery/BatteryWidgetModel$BatteryState;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_debug"})
        public static final class BatteryStateUpdated
        extends ModelState {
            @NotNull
            private final BatteryWidgetModel.BatteryState batteryState;

            public BatteryStateUpdated(@NotNull BatteryWidgetModel.BatteryState batteryState) {
                Intrinsics.checkNotNullParameter((Object)batteryState, (String)"batteryState");
                super(null);
                this.batteryState = batteryState;
            }

            @NotNull
            public final BatteryWidgetModel.BatteryState getBatteryState() {
                return this.batteryState;
            }

            @NotNull
            public final BatteryWidgetModel.BatteryState component1() {
                return this.batteryState;
            }

            @NotNull
            public final BatteryStateUpdated copy(@NotNull BatteryWidgetModel.BatteryState batteryState) {
                Intrinsics.checkNotNullParameter((Object)batteryState, (String)"batteryState");
                return new BatteryStateUpdated(batteryState);
            }

            public static /* synthetic */ BatteryStateUpdated copy$default(BatteryStateUpdated batteryStateUpdated, BatteryWidgetModel.BatteryState batteryState, int n, Object object) {
                if ((n & 1) != 0) {
                    batteryState = batteryStateUpdated.batteryState;
                }
                return batteryStateUpdated.copy(batteryState);
            }

            @NotNull
            public String toString() {
                return "BatteryStateUpdated(batteryState=" + this.batteryState + ")";
            }

            public int hashCode() {
                return this.batteryState.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof BatteryStateUpdated)) {
                    return false;
                }
                BatteryStateUpdated batteryStateUpdated = (BatteryStateUpdated)other;
                return Intrinsics.areEqual((Object)this.batteryState, (Object)batteryStateUpdated.batteryState);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u00a8\u0006\u0010"}, d2={"Ldji/v5/ux/core/widget/battery/BatteryWidget$ModelState$ProductConnected;", "Ldji/v5/ux/core/widget/battery/BatteryWidget$ModelState;", "isConnected", "", "<init>", "(Z)V", "()Z", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "android-sdk-v5-uxsdk_debug"})
        public static final class ProductConnected
        extends ModelState {
            private final boolean isConnected;

            public ProductConnected(boolean isConnected) {
                super(null);
                this.isConnected = isConnected;
            }

            public final boolean isConnected() {
                return this.isConnected;
            }

            public final boolean component1() {
                return this.isConnected;
            }

            @NotNull
            public final ProductConnected copy(boolean isConnected) {
                return new ProductConnected(isConnected);
            }

            public static /* synthetic */ ProductConnected copy$default(ProductConnected productConnected, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = productConnected.isConnected;
                }
                return productConnected.copy(bl);
            }

            @NotNull
            public String toString() {
                return "ProductConnected(isConnected=" + this.isConnected + ")";
            }

            public int hashCode() {
                return Boolean.hashCode(this.isConnected);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ProductConnected)) {
                    return false;
                }
                ProductConnected productConnected = (ProductConnected)other;
                return this.isConnected == productConnected.isConnected;
            }
        }
    }
}

