/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.util;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import dji.v5.utils.common.ContextUtil;
import dji.v5.utils.common.LogUtils;
import java.util.ArrayList;
import java.util.List;

public class MobileGPSLocationUtil {
    private static final long MIN_DISTANCE_CHANGE_FOR_UPDATES = 1L;
    private static final long MIN_TIME_BW_UPDATES = 1000L;
    private static final String TAG = "MobileGPSLocationUtil";
    private final List<LocationListener> locationListeners = new ArrayList<LocationListener>();
    private final LocationListener locationManagerListener = new LocationListener(){

        public void onLocationChanged(Location location) {
            for (LocationListener listener2 : MobileGPSLocationUtil.this.locationListeners) {
                listener2.onLocationChanged(location);
            }
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
            for (LocationListener listener2 : MobileGPSLocationUtil.this.locationListeners) {
                listener2.onStatusChanged(provider, status, extras);
            }
        }

        public void onProviderEnabled(String provider) {
            for (LocationListener listener2 : MobileGPSLocationUtil.this.locationListeners) {
                listener2.onProviderEnabled(provider);
            }
        }

        public void onProviderDisabled(String provider) {
            for (LocationListener listener2 : MobileGPSLocationUtil.this.locationListeners) {
                listener2.onProviderDisabled(provider);
            }
        }
    };

    public static MobileGPSLocationUtil getInstance() {
        return LazyHolder.INSTANCE;
    }

    private MobileGPSLocationUtil() {
    }

    public void addLocationListener(LocationListener listener2) {
        if (listener2 != null) {
            this.locationListeners.add(listener2);
        }
    }

    public void removeLocationListener(LocationListener listener2) {
        this.locationListeners.remove(listener2);
    }

    public void clearAllLocationListener() {
        this.locationListeners.clear();
    }

    public void startUpdateLocation() {
        Context context = ContextUtil.getContext();
        if (context == null) {
            return;
        }
        try {
            LocationManager locationManager = (LocationManager)context.getSystemService("location");
            if (locationManager == null) {
                return;
            }
            boolean isGPSEnabled = locationManager.isProviderEnabled("gps");
            if (isGPSEnabled) {
                locationManager.removeUpdates(this.locationManagerListener);
                locationManager.requestLocationUpdates("gps", 1000L, 1.0f, this.locationManagerListener);
            }
        }
        catch (SecurityException e) {
            LogUtils.e((String)TAG, (Object[])new Object[]{e.getMessage()});
        }
    }

    private static class LazyHolder {
        private static final MobileGPSLocationUtil INSTANCE = new MobileGPSLocationUtil();

        private LazyHolder() {
        }
    }
}

