/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.setting.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import androidx.annotation.UiThread;
import androidx.annotation.WorkerThread;
import androidx.fragment.app.Fragment;
import dji.v5.utils.common.LogUtils;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import org.reactivestreams.Publisher;

public class Loader {
    private static final String TAG = Loader.class.getSimpleName();
    private LoaderListener listener;
    private boolean isStopLoad = false;

    private Loader() {
    }

    public static Loader createLoader() {
        return new Loader();
    }

    public Loader setListener(LoaderListener listener2) {
        this.listener = listener2;
        return this;
    }

    @SuppressLint(value={"CheckResult"})
    public void start() {
        if (this.listener == null) {
            LogUtils.e((String)TAG, (Object[])new Object[]{"loader listener is not set!!!"});
            return;
        }
        Flowable uiTask = Flowable.fromCallable(() -> {
            if (this.hostIsDead()) {
                this.cancel();
                return 0;
            }
            this.listener.onCreateView();
            return 1;
        }).subscribeOn(AndroidSchedulers.mainThread());
        Flowable dataTask = Flowable.fromCallable(() -> {
            if (this.hostIsDead()) {
                this.cancel();
                return 0;
            }
            this.listener.onCreateData();
            return 1;
        }).subscribeOn(Schedulers.io());
        Flowable.zip((Publisher)uiTask, (Publisher)dataTask, (o1, o2) -> o1 + o2).observeOn(AndroidSchedulers.mainThread()).subscribe(o -> {
            if (this.hostIsDead()) {
                this.cancel();
                return;
            }
            this.listener.onRefreshView();
            this.cancel();
        });
    }

    private boolean hostIsDead() {
        if (this.listener == null) {
            return true;
        }
        LoaderListener l = this.listener;
        if (l instanceof Fragment) {
            return ((Fragment)l).isDetached();
        }
        if (l instanceof Activity) {
            return ((Activity)l).isFinishing() || ((Activity)l).isDestroyed();
        }
        return this.isStopLoad;
    }

    public void cancel() {
        this.listener = null;
        this.isStopLoad = true;
    }

    public static interface LoaderListener {
        @UiThread
        public void onCreateView();

        @WorkerThread
        public void onCreateData();

        @UiThread
        public void onRefreshView();
    }
}

