/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.setting.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import dji.v5.utils.common.AndUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.base.CompassStatusWidget;
import dji.v5.ux.core.base.ImuStatusWidget;
import dji.v5.ux.core.base.TabGroupWidget;
import dji.v5.ux.core.ui.setting.ui.MenuFragment;

public class SensorsMenuFragment
extends MenuFragment {
    private static final String CURRENT_INDEX = "current_sensor_index";
    private static final int INDEX_IMU = 0;
    TabGroupWidget mSettingMenuSensorsTab;
    ImuStatusWidget mSettingMenuSensorsImu;
    CompassStatusWidget mSettingMenuSensorsCompass;

    @Override
    protected int getLayoutId() {
        return R.layout.uxsdk_setting_menu_sensors_layout;
    }

    @Override
    protected String getPreferencesTitle() {
        return AndUtil.getResString((int)R.string.uxsdk_setting_menu_title_sensors_state);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        this.mSettingMenuSensorsTab = (TabGroupWidget)this.mFragmentRoot.findViewById(R.id.setting_menu_sensors_tab);
        this.mSettingMenuSensorsImu = (ImuStatusWidget)this.mFragmentRoot.findViewById(R.id.setting_menu_sensors_imu);
        this.mSettingMenuSensorsCompass = (CompassStatusWidget)this.mFragmentRoot.findViewById(R.id.setting_menu_sensors_compass);
        if (savedInstanceState != null) {
            this.mSettingMenuSensorsTab.setCheckedIndex(savedInstanceState.getInt(CURRENT_INDEX, 0));
        }
        this.initView();
        this.mSettingMenuSensorsTab.setOnTabChangeListener((oldIndex, newIndex) -> {
            if (newIndex == 0) {
                this.mSettingMenuSensorsImu.setVisibility(0);
                this.mSettingMenuSensorsCompass.setVisibility(8);
            } else {
                this.mSettingMenuSensorsImu.setVisibility(8);
                this.mSettingMenuSensorsCompass.setVisibility(0);
            }
        });
        return this.mFragmentRoot;
    }

    public void onSaveInstanceState(Bundle outState) {
        if (this.mSettingMenuSensorsTab != null) {
            outState.putInt(CURRENT_INDEX, this.mSettingMenuSensorsTab.getCheckedIndex());
        }
        super.onSaveInstanceState(outState);
    }

    private void initView() {
        boolean visible = 0 == this.mSettingMenuSensorsTab.getVisibility();
        this.mSettingMenuSensorsTab.setVisibility(0);
        if (!visible) {
            this.mSettingMenuSensorsImu.setVisibility(0);
            this.mSettingMenuSensorsTab.setCheckedIndex(0);
        }
    }
}

