/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.setting.dialog;

import android.app.Activity;
import android.app.Application;
import android.app.Dialog;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.DialogInterface;
import android.os.Looper;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import dji.v5.utils.common.AndUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.ui.setting.dialog.ActivityLifecycleCallbacksAdapter;
import dji.v5.ux.core.ui.setting.dialog.DispatchDialogKeyEventToActivityListener;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;

public class BaseDialog
extends Dialog {
    private static boolean sCanShowDialog = true;
    @Nullable
    private DialogInterface.OnDismissListener mOnDismissListener;
    @Nullable
    private DialogInterface.OnShowListener mOnShowListener;
    private Application.ActivityLifecycleCallbacks mActivityLifecycleCallbacks;

    public BaseDialog(Context context) {
        super(context);
        this.initListeners();
    }

    public BaseDialog(Context context, int themeResId) {
        super(context, themeResId);
        this.initListeners();
    }

    protected BaseDialog(Context context, boolean cancelable, DialogInterface.OnCancelListener cancelListener) {
        super(context, cancelable, cancelListener);
        this.initListeners();
    }

    private void initListeners() {
        super.setOnDismissListener(dialog -> {
            this.unregisterActivityLifecycleCallbacks(this.getBaseContext());
            if (this.mOnDismissListener != null) {
                this.mOnDismissListener.onDismiss(dialog);
            }
        });
        super.setOnShowListener(dialog -> {
            this.registerActivityLifecycleCallbacks(this.getBaseContext());
            if (this.mOnShowListener != null) {
                this.mOnShowListener.onShow(dialog);
            }
        });
        this.setOnKeyListener(new DispatchDialogKeyEventToActivityListener(this.getContext()));
    }

    public void setOnDismissListener(@Nullable DialogInterface.OnDismissListener listener2) {
        this.mOnDismissListener = listener2;
    }

    public void setOnShowListener(@Nullable DialogInterface.OnShowListener listener2) {
        this.mOnShowListener = listener2;
    }

    protected void onStart() {
        Window window = this.getWindow();
        if (window != null) {
            window.setFlags(1024, 1024);
            this.hideSystemUI(window);
        }
        super.onStart();
    }

    protected void hideSystemUI(Window window) {
        if (window == null) {
            return;
        }
        int uiOptions = 2822;
        window.getDecorView().setSystemUiVisibility(uiOptions);
    }

    protected void resizeWindow() {
        Window window = this.getWindow();
        if (window != null) {
            WindowManager.LayoutParams params = window.getAttributes();
            params.width = this.getDialogWidth();
            params.height = this.getDialogHeight();
            params.gravity = 16;
            window.setAttributes(params);
        }
        this.checkIsSuitableHeight();
    }

    protected void checkIsSuitableHeight() {
        Window window = this.getWindow();
        if (window != null) {
            View view = window.getDecorView();
            view.measure(-2, -2);
            int dialogH = view.getMeasuredHeight();
            int dialogMaxH = this.getDialogMaxHeight();
            if (dialogH > dialogMaxH) {
                WindowManager.LayoutParams params = window.getAttributes();
                params.height = -2;
                params.gravity = 16;
                window.setAttributes(params);
            }
        }
    }

    public int getDialogWidth() {
        return (int)this.getContext().getResources().getDimension(R.dimen.uxsdk_320_dp);
    }

    public int getDialogHeight() {
        return -2;
    }

    public int getDialogMaxHeight() {
        return AndUtil.getLandScreenHeight((Context)this.getContext());
    }

    public void setContentView(int layoutResID) {
        super.setContentView(layoutResID);
        this.resizeWindow();
    }

    public void setContentView(View view) {
        super.setContentView(view);
        this.resizeWindow();
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        super.setContentView(view, params);
        this.resizeWindow();
    }

    public void show() {
        if (BaseDialog.isCanShowDialog() && !this.isActivityFinish()) {
            super.show();
        }
    }

    public void dismiss() {
        try {
            if (Looper.getMainLooper() != Looper.myLooper()) {
                AndroidSchedulers.mainThread().scheduleDirect(() -> this.dismiss());
                return;
            }
            super.dismiss();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isActivityFinish() {
        Context context;
        return this.getContext() instanceof Activity ? ((Activity)this.getContext()).isFinishing() : this.getContext() instanceof ContextWrapper && (context = ((ContextWrapper)this.getContext()).getBaseContext()) instanceof Activity && ((Activity)context).isFinishing();
    }

    public static boolean isCanShowDialog() {
        return sCanShowDialog;
    }

    public static void setCanShowDialog(boolean sCanShowDialog) {
        BaseDialog.sCanShowDialog = sCanShowDialog;
    }

    private Context getBaseContext() {
        Context context = this.getContext();
        if (context instanceof ContextThemeWrapper) {
            context = ((ContextThemeWrapper)context).getBaseContext();
        }
        return context;
    }

    private Application getApplication(Context context) {
        Application app = null;
        if (context instanceof AppCompatActivity) {
            app = ((AppCompatActivity)context).getApplication();
        } else if (context instanceof Activity) {
            app = ((Activity)context).getApplication();
        }
        return app;
    }

    private void unregisterActivityLifecycleCallbacks(Context context) {
        Application app = this.getApplication(context);
        if (app == null) {
            return;
        }
        if (this.mActivityLifecycleCallbacks != null) {
            app.unregisterActivityLifecycleCallbacks(this.mActivityLifecycleCallbacks);
            this.mActivityLifecycleCallbacks = null;
        }
    }

    private void registerActivityLifecycleCallbacks(final Context context) {
        Application app = this.getApplication(context);
        if (app == null) {
            return;
        }
        final Application finalApp = app;
        this.unregisterActivityLifecycleCallbacks(context);
        this.mActivityLifecycleCallbacks = new ActivityLifecycleCallbacksAdapter(){

            @Override
            public void onActivityDestroyed(@NonNull Activity activity) {
                if (context == activity) {
                    if (BaseDialog.this.isShowing()) {
                        BaseDialog.this.dismiss();
                    }
                    finalApp.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
                }
            }
        };
        app.registerActivityLifecycleCallbacks(this.mActivityLifecycleCallbacks);
    }
}

