/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.hsi.dashboard;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import dji.v5.common.utils.UnitUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.ui.hsi.dashboard.ScrollableAttributeDashBoard;
import dji.v5.ux.core.widget.hsi.SpeedDisplayModel;
import io.reactivex.rxjava3.disposables.CompositeDisposable;

public class SpeedDashBoard
extends ScrollableAttributeDashBoard {
    private float mSpeedX;
    private float mSpeedY;
    private float mSpeed;
    private SpeedDisplayModel widgetModel;
    private CompositeDisposable mCompositeDisposable = new CompositeDisposable();

    public SpeedDashBoard(Context context) {
        this(context, null);
    }

    public SpeedDashBoard(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SpeedDashBoard(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mWaypointIcon = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.uxsdk_fpv_pfd_waypoint_left);
    }

    public void setModel(SpeedDisplayModel model) {
        this.widgetModel = model;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isInEditMode()) {
            return;
        }
        this.mCompositeDisposable.add(this.widgetModel.getVelocityProcessor().toFlowable().observeOn(SchedulerProvider.ui()).subscribe(speed -> {
            this.mSpeedX = speed.getX().floatValue();
            this.mSpeedY = speed.getY().floatValue();
            this.mSpeed = this.updateSpeed();
            this.setCurrentValue(this.mSpeed);
        }));
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawSpeedIndicator(canvas);
    }

    private void drawSpeedIndicator(Canvas canvas) {
        int frameworkHeight;
        float ratio;
        Drawable icon = this.mWaypointIcon;
        float speed = 23.0f;
        float current = this.getCurrentValue();
        float delta = speed - current;
        float y = delta * (ratio = (float)(frameworkHeight = this.getFrameworkHeight()) / (float)this.mVisibleCalibrationUnitCount / this.mAttributeOffsetPerUnit);
        if (Math.abs(y) >= (float)this.getFrameworkHeight() / 2.0f) {
            return;
        }
        canvas.save();
        int iconWidth = icon.getMinimumWidth();
        int iconHeight = icon.getMinimumHeight();
        int left = Math.round((float)(this.getWidth() - this.mFrameworkPaddingStart) + this.mWaypointIconPadding);
        int top = Math.round(-y - (float)icon.getMinimumHeight() / 2.0f + (float)this.getHeight() / 2.0f);
        int right = left + iconWidth;
        int bottom = top + iconHeight;
        icon.setBounds(left, top, right, bottom);
        icon.draw(canvas);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mCompositeDisposable.dispose();
    }

    private float updateSpeed() {
        double tmp = Math.pow(this.mSpeedX, 2.0) + Math.pow(this.mSpeedY, 2.0);
        if (tmp < 0.0) {
            tmp = 0.0;
        }
        return (float)Math.sqrt(tmp);
    }

    @Override
    protected String getCurrentValueDisplayFormat(boolean shorthand) {
        return "%04.1f";
    }

    @Override
    protected String getAttributeUnit() {
        return UnitUtils.getSpeedUnit();
    }

    @Override
    protected float getDisplayValue(float value) {
        return UnitUtils.transFormSpeedIntoDifferentUnit((float)value);
    }
}

