/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import dji.v5.ux.R;
import java.util.LinkedList;
import java.util.List;

public class HorizontalSeekBar
extends ConstraintLayout
implements View.OnTouchListener,
View.OnClickListener {
    private ImageView seekBarTrackImage;
    private TextView seekBarValueText;
    private List<OnSeekBarChangeListener> onSeekBarChangeListeners;
    private int progressMax;
    private int currentProgress;
    private int previousProgress;
    private float boundaryLeft;
    private float boundaryRight;
    private float xThumbStartCenter;
    private float xMoveStart;
    private ImageView seekBarThumbImage;
    private boolean minValueVisibility = false;
    private boolean maxValueVisibility = false;
    private TextView seekBarMinText;
    private TextView seekBarMaxText;
    private boolean minusVisibility = false;
    private boolean plusVisibility = false;
    private ImageView seekBarMinus;
    private ImageView seekBarPlus;
    private boolean baselineVisibility = false;
    private int baselineProgress = -1;
    private View seekBarBaseline;
    private int seekBarBaselineColor;

    public HorizontalSeekBar(@NonNull Context context) {
        super(context);
        this.initView(context);
    }

    public HorizontalSeekBar(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
        this.initAttributes(context, attrs);
    }

    public HorizontalSeekBar(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
        this.initAttributes(context, attrs);
    }

    public void initView(@NonNull Context context) {
        HorizontalSeekBar.inflate((Context)context, (int)R.layout.uxsdk_view_seek_bar, (ViewGroup)this);
        this.seekBarTrackImage = (ImageView)this.findViewById(R.id.imageview_track);
        this.seekBarThumbImage = (ImageView)this.findViewById(R.id.imageview_thumb);
        this.seekBarValueText = (TextView)this.findViewById(R.id.textview_value);
        this.seekBarMinText = (TextView)this.findViewById(R.id.textview_min_value);
        this.seekBarMaxText = (TextView)this.findViewById(R.id.textview_max_value);
        this.seekBarBaseline = this.findViewById(R.id.imageview_baseline);
        this.seekBarMinus = (ImageView)this.findViewById(R.id.imageview_minus);
        this.seekBarPlus = (ImageView)this.findViewById(R.id.imageview_plus);
        this.seekBarBaselineColor = this.getResources().getColor(R.color.uxsdk_green);
    }

    private void initAttributes(@NonNull Context context, @Nullable AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SeekBarView);
        this.setMinValueVisibility(typedArray.getBoolean(R.styleable.SeekBarView_uxsdk_minValueVisible, false));
        this.setMaxValueVisibility(typedArray.getBoolean(R.styleable.SeekBarView_uxsdk_maxValueVisible, false));
        this.setMinusVisibility(typedArray.getBoolean(R.styleable.SeekBarView_uxsdk_minusVisible, false));
        this.setPlusVisibility(typedArray.getBoolean(R.styleable.SeekBarView_uxsdk_plusVisible, false));
        this.setBaselineVisibility(typedArray.getBoolean(R.styleable.SeekBarView_uxsdk_baselineVisible, false));
        typedArray.recycle();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.boundaryLeft = this.seekBarTrackImage.getLeft();
        this.boundaryRight = this.seekBarTrackImage.getRight();
        this.updateTextAndThumbInProgress(this.currentProgress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMax() {
        HorizontalSeekBar horizontalSeekBar = this;
        synchronized (horizontalSeekBar) {
            return this.progressMax;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMax(@IntRange(from=0L) int max) {
        HorizontalSeekBar horizontalSeekBar = this;
        synchronized (horizontalSeekBar) {
            this.progressMax = max;
        }
    }

    public void enable(boolean status) {
        this.seekBarValueText.setEnabled(status);
        this.seekBarThumbImage.setEnabled(status);
        if (status) {
            this.setOnTouchListener(this);
            this.seekBarMinus.setOnClickListener((View.OnClickListener)this);
            this.seekBarPlus.setOnClickListener((View.OnClickListener)this);
        } else {
            this.setOnTouchListener(null);
            this.seekBarMinus.setOnClickListener(null);
            this.seekBarPlus.setOnClickListener(null);
        }
    }

    public void addOnSeekBarChangeListener(@NonNull OnSeekBarChangeListener listener2) {
        if (this.onSeekBarChangeListeners == null) {
            this.onSeekBarChangeListeners = new LinkedList<OnSeekBarChangeListener>();
        }
        this.onSeekBarChangeListeners.add(listener2);
    }

    public void removeOnSeekBarChangeListener(@NonNull OnSeekBarChangeListener listener2) {
        if (this.onSeekBarChangeListeners != null) {
            this.onSeekBarChangeListeners.remove(listener2);
        }
    }

    public void removeAllOnSeekBarChangeListeners() {
        if (this.onSeekBarChangeListeners != null) {
            this.onSeekBarChangeListeners.clear();
        }
    }

    public void setText(@Nullable String text) {
        this.seekBarValueText.setText((CharSequence)text);
    }

    public String getText() {
        return this.seekBarValueText.getText().toString();
    }

    public void setMinValueText(@Nullable String text) {
        this.seekBarMinText.setText((CharSequence)text);
    }

    public void setMaxValueText(@Nullable String text) {
        this.seekBarMaxText.setText((CharSequence)text);
    }

    public int getProgress() {
        return this.currentProgress;
    }

    public void setProgress(@IntRange(from=0L) int progress) {
        this.updateSeekBarProgress(progress, false);
    }

    public void restorePreviousProgress() {
        this.setProgress(this.previousProgress);
        this.updateTextAndThumbInProgress(this.previousProgress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSeekBarProgress(int progress, boolean isFromUI) {
        HorizontalSeekBar horizontalSeekBar = this;
        synchronized (horizontalSeekBar) {
            this.currentProgress = progress >= this.progressMax ? this.progressMax : (progress < 0 ? 0 : progress);
            if (this.onSeekBarChangeListeners != null) {
                for (int i = 0; i < this.onSeekBarChangeListeners.size(); ++i) {
                    this.onSeekBarChangeListeners.get(i).onProgressChanged(this, this.currentProgress, isFromUI);
                }
            }
            this.updateTextAndThumbInProgress(this.currentProgress);
        }
    }

    private void updateTextAndThumbInProgress(int progress) {
        float newX = this.boundaryLeft + this.getIncrement() * (float)progress;
        this.updateTextAndThumbPosition(newX);
    }

    private void updateTextAndThumbPosition(float newX) {
        float xPosition = newX < this.boundaryLeft ? this.boundaryLeft : (newX > this.boundaryRight ? this.boundaryRight : newX);
        this.setSeekbarTextPosition(xPosition);
        this.setSeekbarThumbPosition(xPosition);
    }

    private void setSeekbarTextPosition(float newX) {
        this.seekBarValueText.setX(newX - (float)this.seekBarValueText.getWidth() / 2.0f);
    }

    private void setSeekbarThumbPosition(float newX) {
        this.seekBarThumbImage.setX(newX - (float)this.seekBarThumbImage.getWidth() / 2.0f);
    }

    private float getIncrement() {
        return (this.boundaryRight - this.boundaryLeft) / (float)this.progressMax;
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.onStartTracking(event);
                break;
            }
            case 1: 
            case 3: {
                this.onEndTracking();
                break;
            }
            case 2: {
                this.onTrackMoving(event);
                break;
            }
        }
        return true;
    }

    private void onStartTracking(@NonNull MotionEvent event) {
        this.xMoveStart = event.getX();
        this.xThumbStartCenter = this.seekBarThumbImage.getX() + (float)this.seekBarThumbImage.getWidth() / 2.0f;
        this.previousProgress = this.currentProgress;
        if (this.onSeekBarChangeListeners != null) {
            for (int i = 0; i < this.onSeekBarChangeListeners.size(); ++i) {
                this.onSeekBarChangeListeners.get(i).onStartTrackingTouch(this, this.currentProgress);
            }
        }
    }

    private void onTrackMoving(@NonNull MotionEvent event) {
        float xDelta = event.getX() - this.xMoveStart;
        float newX = this.xThumbStartCenter + xDelta;
        this.updateSeekBarProgress((int)((newX - this.boundaryLeft) / this.getIncrement()), true);
    }

    private void onEndTracking() {
        if (this.onSeekBarChangeListeners != null) {
            for (int i = 0; i < this.onSeekBarChangeListeners.size(); ++i) {
                this.onSeekBarChangeListeners.get(i).onStopTrackingTouch(this, this.currentProgress);
            }
        }
    }

    public void onClick(View v) {
        block2: {
            block3: {
                if (this.onSeekBarChangeListeners == null) break block2;
                if (!v.equals(this.seekBarMinus)) break block3;
                for (int i = 0; i < this.onSeekBarChangeListeners.size(); ++i) {
                    this.onSeekBarChangeListeners.get(i).onMinusClicked(this);
                }
                break block2;
            }
            if (!v.equals(this.seekBarPlus)) break block2;
            for (int i = 0; i < this.onSeekBarChangeListeners.size(); ++i) {
                this.onSeekBarChangeListeners.get(i).onPlusClicked(this);
            }
        }
    }

    public boolean isMinValueVisible() {
        return this.minValueVisibility;
    }

    public void setMinValueVisibility(boolean minValueVisibility) {
        this.minValueVisibility = minValueVisibility;
        this.seekBarMinText.setVisibility(minValueVisibility ? 0 : 8);
    }

    public boolean isMaxValueVisible() {
        return this.maxValueVisibility;
    }

    public void setMaxValueVisibility(boolean maxValueVisibility) {
        this.maxValueVisibility = maxValueVisibility;
        this.seekBarMaxText.setVisibility(maxValueVisibility ? 0 : 8);
    }

    public boolean isMinusVisible() {
        return this.minusVisibility;
    }

    public void setMinusVisibility(boolean minusVisibility) {
        this.minusVisibility = minusVisibility;
        this.seekBarMinus.setVisibility(minusVisibility ? 0 : 8);
    }

    public boolean isPlusVisible() {
        return this.plusVisibility;
    }

    public void setPlusVisibility(boolean plusVisibility) {
        this.plusVisibility = plusVisibility;
        this.seekBarPlus.setVisibility(plusVisibility ? 0 : 8);
    }

    public boolean isBaselineVisibility() {
        return this.baselineVisibility;
    }

    public void setBaselineVisibility(boolean baselineVisibility) {
        this.baselineVisibility = baselineVisibility;
        this.seekBarBaseline.setVisibility(baselineVisibility ? 0 : 8);
    }

    public int getBaselineProgress() {
        return this.baselineProgress;
    }

    public void setBaselineProgress(int baselineProgress) {
        this.baselineProgress = baselineProgress;
        float newX = this.boundaryLeft + this.getIncrement() * (float)baselineProgress;
        this.seekBarBaseline.setX(newX - (float)this.seekBarBaseline.getWidth() / 2.0f);
    }

    @Nullable
    public Drawable getTrackIcon() {
        return this.seekBarTrackImage.getDrawable();
    }

    public void setTrackIcon(@DrawableRes int resourceId) {
        this.setTrackIcon(this.getResources().getDrawable(resourceId));
    }

    public void setTrackIcon(@Nullable Drawable icon) {
        this.seekBarTrackImage.setImageDrawable(icon);
    }

    @Nullable
    public Drawable getTrackIconBackground() {
        return this.seekBarTrackImage.getBackground();
    }

    public void setTrackIconBackground(@DrawableRes int resourceId) {
        this.seekBarTrackImage.setBackgroundResource(resourceId);
    }

    public void setTrackIconBackground(@Nullable Drawable icon) {
        this.seekBarTrackImage.setBackground(icon);
    }

    @Nullable
    public Drawable getThumbIcon() {
        return this.seekBarThumbImage.getDrawable();
    }

    public void setThumbIcon(@DrawableRes int resourceId) {
        this.setThumbIcon(this.getResources().getDrawable(resourceId));
    }

    public void setThumbIcon(@Nullable Drawable icon) {
        this.seekBarThumbImage.setImageDrawable(icon);
    }

    @Nullable
    public Drawable getThumbIconBackground() {
        return this.seekBarThumbImage.getBackground();
    }

    public void setThumbIconBackground(@DrawableRes int resourceId) {
        this.seekBarThumbImage.setBackgroundResource(resourceId);
    }

    public void setThumbIconBackground(@Nullable Drawable icon) {
        this.seekBarThumbImage.setBackground(icon);
    }

    @Nullable
    public Drawable getMinusIcon() {
        return this.seekBarMinus.getDrawable();
    }

    public void setMinusIcon(@DrawableRes int resourceId) {
        this.setMinusIcon(this.getResources().getDrawable(resourceId));
    }

    public void setMinusIcon(@Nullable Drawable icon) {
        this.seekBarMinus.setImageDrawable(icon);
    }

    @Nullable
    public Drawable getMinusIconBackground() {
        return this.seekBarMinus.getBackground();
    }

    public void setMinusIconBackground(@DrawableRes int resourceId) {
        this.seekBarMinus.setBackgroundResource(resourceId);
    }

    public void setMinusIconBackground(@Nullable Drawable icon) {
        this.seekBarMinus.setBackground(icon);
    }

    @Nullable
    public Drawable getPlusIcon() {
        return this.seekBarPlus.getDrawable();
    }

    public void setPlusIcon(@DrawableRes int resourceId) {
        this.setPlusIcon(this.getResources().getDrawable(resourceId));
    }

    public void setPlusIcon(@Nullable Drawable icon) {
        this.seekBarPlus.setImageDrawable(icon);
    }

    @Nullable
    public Drawable getPlusIconBackground() {
        return this.seekBarPlus.getBackground();
    }

    public void setPlusIconBackground(@DrawableRes int resourceId) {
        this.seekBarPlus.setBackgroundResource(resourceId);
    }

    public void setPlusIconBackground(@Nullable Drawable icon) {
        this.seekBarPlus.setBackground(icon);
    }

    public void setValueTextAppearance(@StyleRes int textAppearanceResId) {
        this.seekBarValueText.setTextAppearance(this.getContext(), textAppearanceResId);
    }

    @ColorInt
    public int getValueTextColor() {
        return this.seekBarValueText.getCurrentTextColor();
    }

    public void setValueTextColor(@ColorInt int color2) {
        this.seekBarValueText.setTextColor(color2);
    }

    public void setValueTextColor(@NonNull ColorStateList colorStateList) {
        this.seekBarValueText.setTextColor(colorStateList);
    }

    @NonNull
    public ColorStateList getValueTextColors() {
        return this.seekBarValueText.getTextColors();
    }

    @Nullable
    public Drawable getValueTextBackground() {
        return this.seekBarValueText.getBackground();
    }

    public void setValueTextBackground(@DrawableRes int resourceId) {
        this.seekBarValueText.setBackgroundResource(resourceId);
    }

    public void setValueTextBackground(@Nullable Drawable background) {
        this.seekBarValueText.setBackground(background);
    }

    @Dimension
    public float getValueTextSize() {
        return this.seekBarValueText.getTextSize();
    }

    public void setValueTextSize(@Dimension float textSize) {
        this.seekBarValueText.setTextSize(textSize);
    }

    public void setMinValueTextAppearance(@StyleRes int textAppearanceResId) {
        this.seekBarMinText.setTextAppearance(this.getContext(), textAppearanceResId);
    }

    @ColorInt
    public int getMinValueTextColor() {
        return this.seekBarMinText.getCurrentTextColor();
    }

    public void setMinValueTextColor(@ColorInt int color2) {
        this.seekBarMinText.setTextColor(color2);
    }

    public void setMinValueTextColor(@NonNull ColorStateList colorStateList) {
        this.seekBarMinText.setTextColor(colorStateList);
    }

    @NonNull
    public ColorStateList getMinValueTextColors() {
        return this.seekBarMinText.getTextColors();
    }

    @Nullable
    public Drawable getMinValueTextBackground() {
        return this.seekBarMinText.getBackground();
    }

    public void setMinValueTextBackground(@DrawableRes int resourceId) {
        this.seekBarMinText.setBackgroundResource(resourceId);
    }

    public void setMinValueTextBackground(@Nullable Drawable background) {
        this.seekBarMinText.setBackground(background);
    }

    @Dimension
    public float getMinValueTextSize() {
        return this.seekBarMinText.getTextSize();
    }

    public void setMinValueTextSize(@Dimension float textSize) {
        this.seekBarMinText.setTextSize(textSize);
    }

    public void setMaxValueTextAppearance(@StyleRes int textAppearanceResId) {
        this.seekBarMaxText.setTextAppearance(this.getContext(), textAppearanceResId);
    }

    @ColorInt
    public int getMaxValueTextColor() {
        return this.seekBarMaxText.getCurrentTextColor();
    }

    public void setMaxValueTextColor(@ColorInt int color2) {
        this.seekBarMaxText.setTextColor(color2);
    }

    public void setMaxValueTextColor(@NonNull ColorStateList colorStateList) {
        this.seekBarMaxText.setTextColor(colorStateList);
    }

    @NonNull
    public ColorStateList getMaxValueTextColors() {
        return this.seekBarMaxText.getTextColors();
    }

    @Nullable
    public Drawable getMaxValueTextBackground() {
        return this.seekBarMaxText.getBackground();
    }

    public void setMaxValueTextBackground(@DrawableRes int resourceId) {
        this.seekBarMaxText.setBackgroundResource(resourceId);
    }

    public void setMaxValueTextBackground(@Nullable Drawable background) {
        this.seekBarMaxText.setBackground(background);
    }

    @Dimension
    public float getMaxValueTextSize() {
        return this.seekBarMaxText.getTextSize();
    }

    public void setMaxValueTextSize(@Dimension float textSize) {
        this.seekBarMaxText.setTextSize(textSize);
    }

    @ColorInt
    public int getBaselineColor() {
        return this.seekBarBaselineColor;
    }

    public void setBaselineColor(@ColorInt int color2) {
        this.seekBarBaselineColor = color2;
        this.seekBarBaseline.setBackgroundColor(color2);
    }

    public static interface OnSeekBarChangeListener {
        public void onProgressChanged(@NonNull HorizontalSeekBar var1, @IntRange(from=0L) int var2, boolean var3);

        public void onStartTrackingTouch(@NonNull HorizontalSeekBar var1, @IntRange(from=0L) int var2);

        public void onStopTrackingTouch(@NonNull HorizontalSeekBar var1, @IntRange(from=0L) int var2);

        public void onPlusClicked(@NonNull HorizontalSeekBar var1);

        public void onMinusClicked(@NonNull HorizontalSeekBar var1);
    }
}

