/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.communication;

import androidx.annotation.CheckResult;
import androidx.annotation.NonNull;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.core.communication.UXKey;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UXKeys {
    private static final String TAG = "UXKeys";
    private static final int DEFAULT_INDEX = 0;
    private static final Map<String, UXKey> keysPathMap = new ConcurrentHashMap<String, UXKey>();
    private static final Map<String, Class<?>> keyValueMap = new ConcurrentHashMap();
    private static final Map<String, UpdateType> keyUpdateTypeMap = new ConcurrentHashMap<String, UpdateType>();

    protected UXKeys() {
    }

    private static void initializeKeyValueTypes(Class<? extends UXKeys> clazz) {
        Field[] fields;
        if (clazz == null) {
            return;
        }
        for (Field field : fields = clazz.getFields()) {
            if (field.getType() != String.class || !UXKeys.isStatic(field.getModifiers()) || !field.isAnnotationPresent(UXParamKey.class)) continue;
            try {
                String paramKey = (String)field.get(null);
                UXParamKey paramKeyAnnotation = field.getAnnotation(UXParamKey.class);
                if (paramKey == null || paramKeyAnnotation == null) continue;
                UXKeys.addKeyValueTypeToMap(paramKey, paramKeyAnnotation.type());
                UXKeys.addKeyUpdateTypeToMap(paramKey, paramKeyAnnotation.updateType());
            }
            catch (Exception e) {
                LogUtils.e((String)TAG, (Object[])new Object[]{e.getMessage()});
            }
        }
    }

    public static void addNewKeyClass(@NonNull Class<? extends UXKeys> componentClass) {
        UXKeys.initializeKeyValueTypes(componentClass);
    }

    public static UXKey create(@NonNull String key) {
        return UXKeys.create(key, 0);
    }

    @CheckResult
    public static UXKey create(@NonNull String key, int index) {
        String keyPath = UXKeys.producePathFromElements(key, index);
        UXKey uxKey = UXKeys.getCache(keyPath);
        if (uxKey == null) {
            Class<?> valueType = keyValueMap.get(key);
            UpdateType updateType = keyUpdateTypeMap.get(key);
            if (valueType != null && updateType != null) {
                uxKey = new UXKey(key, valueType, keyPath, updateType);
                UXKeys.putCache(keyPath, uxKey);
            }
        }
        return uxKey;
    }

    private static void addKeyValueTypeToMap(@NonNull String key, @NonNull Class<?> valueType) {
        keyValueMap.put(key, valueType);
    }

    private static void addKeyUpdateTypeToMap(@NonNull String key, @NonNull UpdateType updateType) {
        keyUpdateTypeMap.put(key, updateType);
    }

    private static String producePathFromElements(@NonNull String param, int index) {
        return param + "/" + index;
    }

    private static UXKey getCache(String keyStr) {
        if (keyStr != null) {
            return keysPathMap.get(keyStr);
        }
        return null;
    }

    private static void putCache(String keyStr, UXKey key) {
        if (keyStr != null && key != null) {
            keysPathMap.put(keyStr, key);
        }
    }

    private static boolean isStatic(int modifiers) {
        return (modifiers & 8) != 0;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER})
    protected static @interface UXParamKey {
        @NonNull
        public Class<?> type();

        @NonNull
        public UpdateType updateType();
    }

    public static enum UpdateType {
        ON_CHANGE,
        ON_EVENT;

    }
}

