/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import dji.v5.utils.common.AndUtil;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DividerConstraintLayout;

public class EditorCell
extends DividerConstraintLayout {
    protected EditText mEditor;
    protected TextView mSummary;
    protected TextView mTitle;
    protected TextView mTips;
    private int min;
    private int max;
    private boolean needChangeValue = false;
    private String mOldValue;
    private OnValueChangedListener mListener;
    private boolean isFocusChangeValueCallBack = true;

    public EditorCell(Context context) {
        this(context, null);
    }

    public EditorCell(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EditorCell(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs, defStyleAttr);
    }

    private void initialize(Context context, AttributeSet attrs, int defStyleAttr) {
        int layout2;
        LayoutInflater.from((Context)context).inflate(R.layout.uxsdk_cell_editor_layout, (ViewGroup)this, true);
        TypedArray ta = context.getTheme().obtainStyledAttributes(attrs, R.styleable.EditorCell, defStyleAttr, 0);
        this.mEditor = (EditText)this.findViewById(R.id.editor);
        this.mEditor.setSaveEnabled(false);
        this.mSummary = (TextView)this.findViewById(R.id.summary);
        this.mTitle = (TextView)this.findViewById(R.id.title);
        this.mTips = (TextView)this.findViewById(R.id.tips);
        if (ta.hasValue(R.styleable.EditorCell_uxsdk_title)) {
            this.mTitle.setText((CharSequence)ta.getString(R.styleable.EditorCell_uxsdk_title));
        } else {
            this.mTitle.setVisibility(8);
        }
        if (ta.hasValue(R.styleable.EditorCell_uxsdk_summary)) {
            this.mSummary.setText((CharSequence)ta.getString(R.styleable.EditorCell_uxsdk_summary));
        } else {
            this.mSummary.setVisibility(8);
        }
        if (ta.hasValue(R.styleable.EditorCell_uxsdk_tips)) {
            this.mTips.setText((CharSequence)ta.getString(R.styleable.EditorCell_uxsdk_tips));
        } else {
            this.mTips.setVisibility(8);
        }
        if (ta.hasValue(R.styleable.EditorCell_uxsdk_tipsTextSize)) {
            this.mTips.setTextSize(0, (float)ta.getDimensionPixelSize(R.styleable.EditorCell_uxsdk_tipsTextSize, this.getResources().getDimensionPixelSize(R.dimen.uxsdk_horizontal_margin_medium)));
        }
        if (ta.hasValue(R.styleable.EditorCell_uxsdk_titleTextSize)) {
            this.mTitle.setTextSize(0, (float)ta.getDimensionPixelSize(R.styleable.EditorCell_uxsdk_titleTextSize, this.getResources().getDimensionPixelSize(R.dimen.uxsdk_dic_text_size_18sp)));
        }
        if (ta.hasValue(R.styleable.EditorCell_uxsdk_summaryTextSize)) {
            this.mTips.setTextSize(0, (float)ta.getDimensionPixelSize(R.styleable.EditorCell_uxsdk_summaryTextSize, this.getResources().getDimensionPixelSize(R.dimen.uxsdk_dic_text_size_16sp)));
        }
        this.min = ta.getInt(R.styleable.EditorCell_uxsdk_minValue, -1);
        this.max = ta.getInt(R.styleable.EditorCell_uxsdk_maxValue, -1);
        if (ta.hasValue(R.styleable.EditorCell_uxsdk_value)) {
            this.mEditor.setText((CharSequence)ta.getString(R.styleable.EditorCell_uxsdk_value));
        }
        if (ta.hasValue(R.styleable.EditorCell_uxsdk_layout) && (layout2 = ta.getResourceId(R.styleable.EditorCell_uxsdk_layout, 0)) > 0) {
            View view = LayoutInflater.from((Context)context).inflate(layout2, null);
            this.addView(view);
        }
        ta.recycle();
        this.setRegion();
        this.setMinHeight((int)AndUtil.getItemHeight((Context)this.getContext()));
    }

    public void setValue(int value) {
        this.mEditor.setText((CharSequence)String.valueOf(value));
        this.mOldValue = null;
    }

    public int getValue() {
        try {
            return Integer.parseInt(this.mEditor.getText().toString());
        }
        catch (Exception e) {
            return 0;
        }
    }

    protected void setRegion() {
        this.mEditor.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                if (EditorCell.this.mOldValue == null) {
                    EditorCell.this.mOldValue = s.toString();
                }
            }

            public void afterTextChanged(Editable s) {
                if (!(s == null || "".equals(s.toString()) || EditorCell.this.min == -1 && EditorCell.this.max == -1)) {
                    int num;
                    try {
                        num = Integer.parseInt(s.toString());
                    }
                    catch (NumberFormatException e) {
                        num = EditorCell.this.min - 1;
                    }
                    if (num < EditorCell.this.min || num > EditorCell.this.max) {
                        EditorCell.this.mEditor.setTextColor(ContextCompat.getColor((Context)EditorCell.this.getContext(), (int)R.color.uxsdk_dic_color_c13_red));
                    } else {
                        EditorCell.this.mEditor.setTextColor(ContextCompat.getColor((Context)EditorCell.this.getContext(), (int)R.color.uxsdk_edit_cell_text_color));
                    }
                }
            }
        });
        this.setClickLister();
        this.setOnfocusChange();
    }

    private void setOnfocusChange() {
        this.mEditor.setOnFocusChangeListener((v, hasFocus) -> {
            if (!hasFocus && this.mOldValue != null && this.isFocusChangeValueCallBack) {
                this.mEditor.setText((CharSequence)this.mOldValue);
                this.mOldValue = null;
            }
        });
    }

    public void setClickLister() {
        this.mEditor.setOnEditorActionListener((v, actionId, event) -> {
            if (actionId == 6) {
                int markVal;
                AndUtil.hideSoftInput((View)v);
                try {
                    markVal = Integer.parseInt(this.mEditor.getText().toString());
                }
                catch (NumberFormatException e) {
                    markVal = 0;
                }
                this.setEditText(markVal);
                this.mEditor.setSelection(this.mEditor.getText().length());
                if (this.mListener != null) {
                    this.mListener.onValueChanged(this, markVal, this.getValue());
                }
                this.mOldValue = null;
                this.mEditor.clearFocus();
            }
            return false;
        });
    }

    private void setEditText(int markVal) {
        if (this.needChangeValue) {
            if (markVal < this.min) {
                this.mEditor.setText((CharSequence)String.valueOf(this.min));
            } else if (markVal > this.max) {
                this.mEditor.setText((CharSequence)String.valueOf(this.max));
            }
        }
    }

    public void needChangeValueWhenOutofLimit(boolean enable) {
        this.needChangeValue = enable;
    }

    public void setTips(String tips) {
        this.mTips.setText((CharSequence)tips);
    }

    public void setMaxValue(int max) {
        this.max = max;
    }

    public int getMaxValue() {
        return this.max;
    }

    public void setMinValue(int min) {
        this.min = min;
    }

    public int getMinValue() {
        return this.min;
    }

    public void setOnValueChangedListener(OnValueChangedListener listener2) {
        this.mListener = listener2;
    }

    public boolean isFocusChangeValueCallBack() {
        return this.isFocusChangeValueCallBack;
    }

    public void setEnable(boolean enable) {
        this.mEditor.setEnabled(enable);
    }

    public void setFocusChangeValueCallBack(boolean isFocusChangeValueCallBack) {
        this.isFocusChangeValueCallBack = isFocusChangeValueCallBack;
    }

    public static interface OnValueChangedListener {
        public void onValueChanged(EditorCell var1, int var2, int var3);
    }
}

