/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.widget.fpvinteraction;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorSet;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import androidx.annotation.AnimatorRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.v5.ux.R;
import dji.v5.ux.core.util.SettingDefinitions;
import java.util.HashMap;
import java.util.Map;

public class FocusTargetView
extends FrameLayout {
    protected static final int DEFAULT_FOCUS_TARGET_DURATION = 2500;
    private long focusTargetDuration;
    private AnimatorSet scaleAnimatorSet;
    private SettingDefinitions.ControlMode controlMode;
    private Map<SettingDefinitions.ControlMode, Drawable> iconMap;

    public FocusTargetView(@NonNull Context context) {
        super(context);
        this.initView();
    }

    public FocusTargetView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public FocusTargetView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        this.focusTargetDuration = 2500L;
        this.setAutoFocusAnimator(R.animator.uxsdk_animator_scale);
        this.iconMap = new HashMap<SettingDefinitions.ControlMode, Drawable>();
        this.iconMap.put(SettingDefinitions.ControlMode.AUTO_FOCUS, this.getResources().getDrawable(R.drawable.uxsdk_ic_focus_target_auto));
        this.iconMap.put(SettingDefinitions.ControlMode.AUTO_FOCUS_CONTINUE, this.getResources().getDrawable(R.drawable.uxsdk_ic_focus_target_auto));
        this.iconMap.put(SettingDefinitions.ControlMode.MANUAL_FOCUS, this.getResources().getDrawable(R.drawable.uxsdk_ic_focus_target_manual));
    }

    public void clickEvent(float x, float y) {
        this.addImageBackground(this.controlMode);
        if (this.getHandler() != null) {
            if (this.controlMode != SettingDefinitions.ControlMode.MANUAL_FOCUS && this.scaleAnimatorSet != null) {
                this.getHandler().post(() -> ((AnimatorSet)this.scaleAnimatorSet).start());
            } else {
                this.getHandler().postDelayed(this::removeImageBackground, this.focusTargetDuration);
            }
        }
        this.setX(x - (float)this.getWidth() / 2.0f);
        this.setY(y - (float)this.getHeight() / 2.0f);
    }

    public void setControlMode(@NonNull SettingDefinitions.ControlMode controlMode) {
        this.controlMode = controlMode;
    }

    @Nullable
    public Drawable getFocusTargetIcon(@NonNull SettingDefinitions.ControlMode controlMode) {
        return this.iconMap.get((Object)controlMode);
    }

    public void setFocusTargetIcon(@NonNull SettingDefinitions.ControlMode controlMode, @Nullable Drawable drawable2) {
        this.iconMap.put(controlMode, drawable2);
        if (this.controlMode == controlMode && this.getBackground() != null) {
            this.addImageBackground(controlMode);
        }
    }

    public void setAutoFocusAnimator(@AnimatorRes int animatorId) {
        if (animatorId == 0) {
            this.scaleAnimatorSet = null;
        } else {
            this.scaleAnimatorSet = (AnimatorSet)AnimatorInflater.loadAnimator((Context)this.getContext(), (int)animatorId);
            this.scaleAnimatorSet.setTarget((Object)this);
            this.scaleAnimatorSet.addListener((Animator.AnimatorListener)new AnimListener());
        }
    }

    public long getFocusTargetDuration() {
        return this.focusTargetDuration;
    }

    public void setFocusTargetDuration(long duration) {
        this.focusTargetDuration = duration;
    }

    public void removeImageBackground() {
        int sdk = Build.VERSION.SDK_INT;
        if (sdk < 16) {
            this.setBackgroundDrawable(null);
        } else {
            this.setBackground(null);
        }
    }

    private void addImageBackground(SettingDefinitions.ControlMode controlMode) {
        this.setBackground(this.iconMap.get((Object)controlMode));
    }

    private class AnimListener
    implements Animator.AnimatorListener {
        private AnimListener() {
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            if (FocusTargetView.this.getHandler() != null) {
                FocusTargetView.this.getHandler().postDelayed(FocusTargetView.this::removeImageBackground, FocusTargetView.this.focusTargetDuration);
            }
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }
}

