/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.widget.cameracontrols.photovideoswitch;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.CameraKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.camera.CameraMode;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.module.FlatCameraModule;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;

public class PhotoVideoSwitchWidgetModel
extends WidgetModel
implements ICameraIndex {
    private final DataProcessor<Boolean> isCameraConnectedDataProcessor;
    private final DataProcessor<Boolean> isRecordingDataProcessor;
    private final DataProcessor<Boolean> isShootingDataProcessor;
    private final DataProcessor<Boolean> isShootingIntervalDataProcessor;
    private final DataProcessor<Boolean> isShootingBurstDataProcessor;
    private final DataProcessor<Boolean> isShootingRawBurstDataProcessor;
    private final DataProcessor<Boolean> isShootingPanoramaDataProcessor;
    private final DataProcessor<Boolean> isEnabledDataProcessor;
    private ComponentIndexType cameraIndex = ComponentIndexType.LEFT_OR_MAIN;
    private CameraLensType lensType = CameraLensType.UNKNOWN;
    private final FlatCameraModule flatCameraModule;

    public PhotoVideoSwitchWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore keyedStore) {
        super(djiSdkModel, keyedStore);
        this.isCameraConnectedDataProcessor = DataProcessor.create(false);
        this.isRecordingDataProcessor = DataProcessor.create(false);
        this.isShootingDataProcessor = DataProcessor.create(false);
        this.isShootingIntervalDataProcessor = DataProcessor.create(false);
        this.isShootingBurstDataProcessor = DataProcessor.create(false);
        this.isShootingRawBurstDataProcessor = DataProcessor.create(false);
        this.isShootingPanoramaDataProcessor = DataProcessor.create(false);
        this.isEnabledDataProcessor = DataProcessor.create(false);
        this.flatCameraModule = new FlatCameraModule();
        this.addModule(this.flatCameraModule);
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyConnection, (ComponentIndexType)this.cameraIndex), this.isCameraConnectedDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyIsRecording, (ComponentIndexType)this.cameraIndex), this.isRecordingDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyIsShootingPhoto, (ComponentIndexType)this.cameraIndex), this.isShootingDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyCameraShootingContinuousPhotos, (ComponentIndexType)this.cameraIndex), this.isShootingIntervalDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyIsShootingBurstPhoto, (ComponentIndexType)this.cameraIndex), this.isShootingBurstDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyIsShootingRAWBurstPhoto, (ComponentIndexType)this.cameraIndex), this.isShootingRawBurstDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)CameraKey.KeyIsShootingPhotoPanorama, (ComponentIndexType)this.cameraIndex), this.isShootingPanoramaDataProcessor);
    }

    @Override
    protected void inCleanup() {
    }

    @Override
    protected void updateStates() {
        boolean isEnabled = (Boolean)this.productConnectionProcessor.getValue() != false && this.isCameraConnectedDataProcessor.getValue() != false && this.isRecordingDataProcessor.getValue() == false && this.isShootingDataProcessor.getValue() == false && this.isShootingBurstDataProcessor.getValue() == false && this.isShootingIntervalDataProcessor.getValue() == false && this.isShootingRawBurstDataProcessor.getValue() == false && this.isShootingPanoramaDataProcessor.getValue() == false;
        this.isEnabledDataProcessor.onNext(isEnabled);
    }

    public Flowable<Boolean> isEnabled() {
        return this.isEnabledDataProcessor.toFlowable();
    }

    public Flowable<Boolean> isPictureMode() {
        return this.flatCameraModule.getCameraModeDataProcessor().toFlowable().map(cameraMode -> cameraMode == CameraMode.PHOTO_NORMAL);
    }

    public Completable toggleCameraMode() {
        if (this.flatCameraModule.getCameraModeDataProcessor().getValue() == CameraMode.PHOTO_NORMAL) {
            return this.flatCameraModule.setCameraMode(this.djiSdkModel, CameraMode.VIDEO_NORMAL);
        }
        return this.flatCameraModule.setCameraMode(this.djiSdkModel, CameraMode.PHOTO_NORMAL);
    }

    public void changeToPhotoMode() {
        CameraMode currentMode = this.flatCameraModule.getCameraModeDataProcessor().getValue();
        if (currentMode.isPhotoMode() || this.isSupportChangeMode()) {
            return;
        }
        this.flatCameraModule.setCameraMode(this.djiSdkModel, CameraMode.PHOTO_NORMAL).subscribe();
    }

    public void changeToVideoMode() {
        CameraMode currentMode = this.flatCameraModule.getCameraModeDataProcessor().getValue();
        if (currentMode.isVideoMode()) {
            return;
        }
        this.flatCameraModule.setCameraMode(this.djiSdkModel, CameraMode.VIDEO_NORMAL).subscribe();
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.cameraIndex;
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.lensType;
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        this.cameraIndex = cameraIndex;
        this.lensType = lensType;
        this.flatCameraModule.updateCameraSource(cameraIndex, lensType);
        this.restart();
    }

    private boolean isSupportChangeMode() {
        CameraMode currentMode = this.flatCameraModule.getCameraModeDataProcessor().getValue();
        return currentMode.isVideoMode() && this.isRecordingDataProcessor.getValue() != false;
    }
}

