/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.cameracore.widget.cameracapture;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.Constraints;
import dji.sdk.keyvalue.value.camera.CameraMode;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.ux.R;
import dji.v5.ux.cameracore.widget.cameracapture.CameraCaptureWidgetModel;
import dji.v5.ux.cameracore.widget.cameracapture.recordvideo.RecordVideoWidget;
import dji.v5.ux.cameracore.widget.cameracapture.shootphoto.ShootPhotoWidget;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.UxErrorHandle;
import java.util.HashMap;
import java.util.Map;

public class CameraCaptureWidget
extends ConstraintLayoutWidget<Object>
implements ICameraIndex {
    private static final String TAG = "CameraCaptureWidget";
    private CameraCaptureWidgetModel widgetModel;
    private Map<CameraMode, View> widgetMap;

    public CameraCaptureWidget(Context context) {
        super(context);
    }

    public CameraCaptureWidget(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CameraCaptureWidget(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this.widgetMap = new HashMap<CameraMode, View>();
        if (!this.isInEditMode()) {
            this.addViewByMode(CameraMode.PHOTO_NORMAL, (View)new ShootPhotoWidget(context));
            this.addViewByMode(CameraMode.VIDEO_NORMAL, (View)new RecordVideoWidget(context));
            this.widgetModel = new CameraCaptureWidgetModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
        super.onDetachedFromWindow();
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.getCameraMode().observeOn(SchedulerProvider.ui()).subscribe(this::onCameraModeChange, UxErrorHandle.logErrorConsumer(TAG, "Camera Mode Change: ")));
    }

    @Override
    @NonNull
    public String getIdealDimensionRatioString() {
        return this.getResources().getString(R.string.uxsdk_widget_default_ratio);
    }

    @Override
    @NonNull
    public ComponentIndexType getCameraIndex() {
        return this.widgetModel.getCameraIndex();
    }

    @Override
    @NonNull
    public CameraLensType getLensType() {
        return this.widgetModel.getLensType();
    }

    @Override
    public void updateCameraSource(@NonNull ComponentIndexType cameraIndex, @NonNull CameraLensType lensType) {
        RecordVideoWidget recordVideoWidget;
        this.widgetModel.updateCameraSource(cameraIndex, lensType);
        ShootPhotoWidget shootPhotoWidget = this.getShootPhotoWidget();
        if (shootPhotoWidget != null) {
            shootPhotoWidget.updateCameraSource(cameraIndex, lensType);
        }
        if ((recordVideoWidget = this.getRecordVideoWidget()) != null) {
            recordVideoWidget.updateCameraSource(cameraIndex, lensType);
        }
    }

    private void onCameraModeChange(CameraMode cameraMode) {
        for (View view : this.widgetMap.values()) {
            if (view == null) continue;
            view.setVisibility(4);
        }
        View currentView = this.widgetMap.get(cameraMode);
        if (currentView != null) {
            this.widgetMap.get(cameraMode).setVisibility(0);
        }
    }

    public void addViewByMode(@NonNull CameraMode cameraMode, @NonNull View view) {
        if (this.widgetMap.get(cameraMode) != null) {
            this.removeView(this.widgetMap.get(cameraMode));
        }
        this.widgetMap.put(cameraMode, view);
        view.setVisibility(4);
        this.addView(view);
        Constraints.LayoutParams lp = new Constraints.LayoutParams(-1, -1);
        view.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    public void removeViewByMode(@NonNull CameraMode cameraMode) {
        if (this.widgetMap.get(cameraMode) == null) {
            return;
        }
        this.removeView(this.widgetMap.get(cameraMode));
        this.widgetMap.remove(cameraMode);
    }

    @Nullable
    public View getViewByMode(@NonNull CameraMode cameraMode) {
        return this.widgetMap.get(cameraMode);
    }

    @Nullable
    public ShootPhotoWidget getShootPhotoWidget() {
        if (this.widgetMap.get(CameraMode.PHOTO_NORMAL) == null || !(this.widgetMap.get(CameraMode.PHOTO_NORMAL) instanceof ShootPhotoWidget)) {
            return null;
        }
        return (ShootPhotoWidget)this.widgetMap.get(CameraMode.PHOTO_NORMAL);
    }

    @Nullable
    public RecordVideoWidget getRecordVideoWidget() {
        if (this.widgetMap.get(CameraMode.VIDEO_NORMAL) == null || !(this.widgetMap.get(CameraMode.VIDEO_NORMAL) instanceof RecordVideoWidget)) {
            return null;
        }
        return (RecordVideoWidget)this.widgetMap.get(CameraMode.VIDEO_NORMAL);
    }
}

