/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.accessory.item;

import android.animation.Animator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.Constraints;
import com.airbnb.lottie.LottieAnimationView;
import dji.v5.utils.common.StringUtils;
import dji.v5.ux.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class RtkGuidanceView
extends ConstraintLayout
implements View.OnClickListener {
    private View mNavigationLayout;
    private TextView mStepFirstTv;
    private TextView mStepSecondTv;
    private TextView mStepThirdTv;
    private ImageView mStepFirstIv;
    private ImageView mStepSecondIv;
    private View mStepStartDivider;
    private View mStepEndDivider;
    private LottieAnimationView mLottieAnimationView;
    private View mReplayView;
    private Button mReplayBtn;
    private TextView mLottieTip;
    private TextView mTitleTv;
    private TextView mContentTv;
    private View mImageView;
    private TextView mImageDescTv;
    private Button mPreviousBtn;
    private Button mNextBtn;
    private PopupWindow mPopupWindow;
    private int mStep;
    private String[] mTitleStr;
    private String[] mContentStr;
    private int[] mAnimationRes;
    private String[] mImageAssetsFolderStr;
    private boolean mStartAnimation;
    private Runnable mTipRunnable;

    public RtkGuidanceView(Context context) {
        this(context, null);
    }

    public RtkGuidanceView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RtkGuidanceView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.uxsdk_rtk_guidance_layout, (ViewGroup)this, true);
        this.initView();
        this.initWidgetParams();
        this.initParams(context);
        this.initListener();
    }

    private void initView() {
        this.mNavigationLayout = this.findViewById(R.id.rtk_guidance_step_navigation);
        this.mStepFirstTv = (TextView)this.findViewById(R.id.rtk_guidance_step_first_number);
        this.mStepSecondTv = (TextView)this.findViewById(R.id.rtk_guidance_step_second_number);
        this.mStepThirdTv = (TextView)this.findViewById(R.id.rtk_guidance_step_third_number);
        this.mStepFirstIv = (ImageView)this.findViewById(R.id.rtk_guidance_step_first_image);
        this.mStepSecondIv = (ImageView)this.findViewById(R.id.rtk_guidance_step_second_image);
        this.mStepStartDivider = this.findViewById(R.id.rtk_guidance_start_divider);
        this.mStepEndDivider = this.findViewById(R.id.rtk_guidance_end_divider);
        this.mLottieAnimationView = (LottieAnimationView)this.findViewById(R.id.rtk_guidance_lottie_animation);
        this.mReplayView = this.findViewById(R.id.rtk_guidance_replay_view);
        this.mReplayBtn = (Button)this.findViewById(R.id.rtk_guidance_replay_btn);
        this.mLottieTip = (TextView)this.findViewById(R.id.rtk_guidance_lottie_tip);
        this.mTitleTv = (TextView)this.findViewById(R.id.rtk_guidance_step_title);
        this.mContentTv = (TextView)this.findViewById(R.id.rtk_guidance_step_content);
        this.mImageView = this.findViewById(R.id.rtk_guidance_step_image);
        this.mImageDescTv = (TextView)this.findViewById(R.id.rtk_guidance_step_image_desc);
        this.mPreviousBtn = (Button)this.findViewById(R.id.rtk_guidance_step_previous);
        this.mNextBtn = (Button)this.findViewById(R.id.rtk_guidance_step_next);
    }

    private void initListener() {
        this.findViewById(R.id.rtk_guidance_close).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.rtk_guidance_step_previous).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.rtk_guidance_step_next).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.rtk_guidance_replay_btn).setOnClickListener((View.OnClickListener)this);
    }

    private void initWidgetParams() {
        this.setLayoutParams((ViewGroup.LayoutParams)new Constraints.LayoutParams(-1, -1));
        this.setBackgroundResource(R.color.uxsdk_white);
        this.mLottieAnimationView.addAnimatorListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                RtkGuidanceView.this.updateReplayView(false);
            }

            public void onAnimationEnd(Animator animation) {
                RtkGuidanceView.this.updateReplayView(true);
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
                RtkGuidanceView.this.updateReplayView(false);
            }
        });
    }

    private void initParams(Context context) {
        this.mStep = 1;
        this.mTitleStr = context.getResources().getStringArray(R.array.uxsdk_rtk_guidance_title);
        this.mContentStr = context.getResources().getStringArray(R.array.uxsdk_rtk_guidance_content);
        this.mAnimationRes = new int[]{R.raw.uxsdk_rtk_guidance_reset, R.raw.uxsdk_rtk_guidance_step1, R.raw.uxsdk_rtk_guidance_step2, R.raw.uxsdk_rtk_guidance_step3};
        this.mImageAssetsFolderStr = new String[]{"rtk_guidance_reset_images", "rtk_guidance_step1_images", "rtk_guidance_step2_images", "rtk_guidance_step3_images"};
    }

    private void updateView() {
        this.updateVisibility();
        if (this.mStep != 0) {
            this.mStepFirstTv.setVisibility(this.mStep <= 1 ? 0 : 8);
            this.mStepSecondTv.setVisibility(this.mStep <= 2 ? 0 : 8);
            this.updateSelectedTopView(this.mStepSecondTv, this.mStep < 2);
            this.updateSelectedTopView(this.mStepThirdTv, this.mStep < 3);
            this.mStepFirstIv.setVisibility(this.mStep > 1 ? 0 : 8);
            this.mStepSecondIv.setVisibility(this.mStep > 2 ? 0 : 8);
            this.mStepStartDivider.setBackgroundResource(this.mStep == 1 ? R.color.uxsdk_gray : R.color.uxsdk_blue);
            this.mStepEndDivider.setBackgroundResource(this.mStep <= 2 ? R.color.uxsdk_gray : R.color.uxsdk_blue);
        }
        this.mLottieAnimationView.setImageAssetsFolder(this.mImageAssetsFolderStr[this.mStep]);
        this.mLottieAnimationView.setAnimation(this.mAnimationRes[this.mStep]);
        this.mLottieAnimationView.playAnimation();
        this.updateLottieTipView();
        this.mTitleTv.setText((CharSequence)this.mTitleStr[this.mStep]);
        this.mContentTv.setText((CharSequence)this.mContentStr[this.mStep]);
        this.mNextBtn.setText((CharSequence)StringUtils.getResStr((int)(this.mStep == 0 || this.mStep == 3 ? R.string.uxsdk_rtk_guidance_btn_finish : R.string.uxsdk_rtk_guidance_btn_next), (Object[])new Object[0]));
    }

    private void updateVisibility() {
        this.mNavigationLayout.setVisibility(this.mStep == 0 ? 4 : 0);
        this.mImageView.setVisibility(this.mStep == 2 ? 0 : 4);
        this.mImageDescTv.setVisibility(this.mStep == 2 ? 0 : 4);
        this.mPreviousBtn.setVisibility(this.mStep == 0 || this.mStep == 1 ? 8 : 0);
    }

    private void updateSelectedTopView(TextView textView, boolean isSelected) {
        textView.setBackgroundResource(isSelected ? R.drawable.uxsdk_bg_rtk_guidance_step_oval_gray : R.drawable.uxsdk_bg_rtk_guidance_step_oval_blue_solid);
        textView.setTextColor(isSelected ? this.getResColor(R.color.uxsdk_black) : this.getResColor(R.color.uxsdk_white));
    }

    private void updateLottieTipView() {
        this.removeCallbacks(this.mTipRunnable);
        this.mLottieTip.setVisibility(8);
        if (this.mStep == 0) {
            this.delayedUpdateResetTipView();
        }
    }

    private void delayedUpdateResetTipView() {
        this.mTipRunnable = () -> {
            this.mLottieTip.setText(R.string.uxsdk_rtk_guidance_reset_tip);
            this.mLottieTip.setVisibility(this.mStartAnimation ? 0 : 8);
            if (this.mStartAnimation) {
                this.mStartAnimation = false;
                this.postDelayed(this.mTipRunnable, 2500L);
            }
        };
        this.mStartAnimation = true;
        this.postDelayed(this.mTipRunnable, 14000L);
    }

    public void updateReplayView(boolean isShow) {
        int visible = isShow ? 0 : 8;
        this.mReplayView.setVisibility(visible);
        this.mReplayBtn.setVisibility(visible);
    }

    protected void onDetachedFromWindow() {
        this.removeCallbacks(this.mTipRunnable);
        this.mStep = 1;
        if (this.mLottieAnimationView != null && this.mLottieAnimationView.isAnimating()) {
            this.mLottieAnimationView.cancelAnimation();
        }
        super.onDetachedFromWindow();
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.rtk_guidance_close) {
            this.closePopupWindow();
        } else if (id2 == R.id.rtk_guidance_step_previous) {
            --this.mStep;
            this.updateView();
        } else if (id2 == R.id.rtk_guidance_step_next) {
            if (this.mStep != 0 && this.mStep != 3) {
                ++this.mStep;
                this.updateView();
            } else {
                this.closePopupWindow();
            }
        } else if (id2 == R.id.rtk_guidance_replay_btn) {
            this.mLottieAnimationView.playAnimation();
            this.updateLottieTipView();
        }
    }

    private void closePopupWindow() {
        if (this.mPopupWindow != null) {
            this.mPopupWindow.dismiss();
        }
    }

    public void showPopupWindow(View parent) {
        this.showPopupWindow(parent, 1);
    }

    public void showPopupWindow(View parent, int guidanceMode) {
        if (guidanceMode < 0 || guidanceMode > 3) {
            return;
        }
        this.mStep = guidanceMode;
        if (this.mPopupWindow == null) {
            this.mPopupWindow = new PopupWindow((View)this, -1, -1, true);
        }
        this.updateView();
        this.mPopupWindow.setClippingEnabled(false);
        this.mPopupWindow.showAtLocation(parent, 0, 0, 0);
    }

    public int getResColor(@ColorRes int resId) {
        if (this.getContext() != null) {
            return this.getContext().getResources().getColor(resId);
        }
        return 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface GuidanceMode {
        public static final int STEP_RESET = 0;
        public static final int STEP_FIRST = 1;
        public static final int STEP_SECOND = 2;
        public static final int STEP_THIRD = 3;
    }
}

