/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.util;

import android.content.res.Resources;
import androidx.annotation.NonNull;
import dji.sdk.keyvalue.value.camera.CameraAperture;
import dji.sdk.keyvalue.value.camera.CameraExposureCompensation;
import dji.sdk.keyvalue.value.camera.CameraFlatMode;
import dji.sdk.keyvalue.value.camera.CameraISO;
import dji.sdk.keyvalue.value.camera.CameraShutterSpeed;
import dji.sdk.keyvalue.value.camera.CameraType;
import dji.sdk.keyvalue.value.camera.CameraVideoStreamSourceType;
import dji.sdk.keyvalue.value.camera.PhotoFileFormat;
import dji.sdk.keyvalue.value.camera.VideoFrameRate;
import dji.sdk.keyvalue.value.camera.VideoResolution;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.sdk.keyvalue.value.payload.PayloadCameraType;
import dji.v5.ux.R;
import dji.v5.ux.core.util.UnitConversionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CameraUtil {
    private static final String SHUTTER_SUBSTITUENT1 = "SHUTTER_SPEED1_";
    private static final String SHUTTER_SUPPLANTER1 = "";
    private static final String SHUTTER_WIFI_REGEX_2 = "(\\d+)_DOT_(\\d+)";
    private static final String SHUTTER_WIFI_REPLACE_2 = "$1.$2";
    private static final String SHUTTER_SUBSTITUENT3 = "SHUTTER_SPEED_([0-9.]+)";
    private static final String SHUTTER_SUPPLANTER3 = "$1\"";
    private static final String SHUTTER_SUBSTITUENT4 = "DOT_(\\d+)";
    private static final String SHUTTER_SUPPLANTER4 = "1.$1\"";
    private static final String EV_SUBSTITUENT1 = "EV";
    private static final String EV_SUPPLANTER1 = "";
    private static final String EV_SUBSTITUENT2 = "NEG_";
    private static final String EV_SUPPLANTER2 = "-";
    private static final String EV_SUBSTITUENT3 = "POS_";
    private static final String EV_SUPPLANTER3 = "+";
    private static final String EV_SUBSTITUENT4 = "P";
    private static final String EV_SUPPLANTER4 = ".";
    private static final String DEFAULT_PAYLOAD_NAME = "Payload Camera";
    private static final Map<CameraType, String> CAMERA_TYPE_STRING_MAP = new HashMap<CameraType, String>();

    private CameraUtil() {
    }

    @NonNull
    public static String resolutionShortDisplayName(@NonNull VideoResolution resolution) {
        return switch (resolution) {
            case VideoResolution.RESOLUTION_336x256 -> "256P";
            case VideoResolution.RESOLUTION_640x480 -> "480P";
            case VideoResolution.RESOLUTION_640x512 -> "512P";
            case VideoResolution.RESOLUTION_1280x720 -> "720P";
            case VideoResolution.RESOLUTION_1920x1080 -> "1080P";
            case VideoResolution.RESOLUTION_2048x1080 -> "2K";
            case VideoResolution.RESOLUTION_2688x1512, VideoResolution.RESOLUTION_2704x1520, VideoResolution.RESOLUTION_2720x1530 -> "2.7K";
            case VideoResolution.RESOLUTION_3840x1572, VideoResolution.RESOLUTION_3840x2160, VideoResolution.RESOLUTION_4096x2160 -> "4K";
            case VideoResolution.RESOLUTION_4608x2160, VideoResolution.RESOLUTION_4608x2592 -> "4.5K";
            case VideoResolution.RESOLUTION_5280x2160, VideoResolution.RESOLUTION_5280x2972 -> "5K";
            case VideoResolution.RESOLUTION_5760x3240, VideoResolution.RESOLUTION_6016x3200 -> "6K";
            default -> "Unknown";
        };
    }

    @NonNull
    public static String frameRateDisplayName(@NonNull VideoFrameRate frameRate) {
        String processedFrameRateString;
        String originalFrameRateString = frameRate.toString();
        Matcher matcher = Pattern.compile("RATE_(\\d{2,3})DOT_.*").matcher(originalFrameRateString);
        if (matcher.find()) {
            String tempRate = matcher.group(1);
            processedFrameRateString = Integer.toString(Integer.parseInt(tempRate) + 1);
        } else {
            matcher = Pattern.compile("RATE_(\\d{2,3})FPS").matcher(originalFrameRateString);
            processedFrameRateString = matcher.find() ? matcher.group(1) : "Null";
        }
        return processedFrameRateString;
    }

    @NonNull
    public static String convertPhotoFileFormatToString(@NonNull Resources resources, @NonNull PhotoFileFormat photoFileFormat) {
        String formatString = photoFileFormat.value() == PhotoFileFormat.RAW.value() ? resources.getString(R.string.uxsdk_camera_picture_format_raw) : (photoFileFormat.value() == PhotoFileFormat.JPEG.value() ? resources.getString(R.string.uxsdk_camera_picture_format_jpeg) : (photoFileFormat.value() == PhotoFileFormat.RAW_JPEG.value() ? resources.getString(R.string.uxsdk_camera_picture_format_jpegraw) : (photoFileFormat.value() == PhotoFileFormat.TIFF_14_BIT.value() ? resources.getString(R.string.uxsdk_camera_picture_format_tiff) : (photoFileFormat.value() == PhotoFileFormat.RADIOMETRIC_JPEG.value() ? resources.getString(R.string.uxsdk_camera_picture_format_radiometic_jpeg) : (photoFileFormat.value() == PhotoFileFormat.TIFF_14_BIT_LINEAR_LOW_TEMP_RESOLUTION.value() ? resources.getString(R.string.uxsdk_camera_picture_format_low_tiff) : (photoFileFormat.value() == PhotoFileFormat.TIFF_14_BIT_LINEAR_HIGH_TEMP_RESOLUTION.value() ? resources.getString(R.string.uxsdk_camera_picture_format_high_tiff) : photoFileFormat.toString()))))));
        return formatString;
    }

    @NonNull
    public static String formatVideoTime(@NonNull Resources resources, int flyTime) {
        int[] time = UnitConversionUtil.formatSecondToHour(flyTime);
        String result = time[2] > 0 ? resources.getString(R.string.uxsdk_video_time_hours, new Object[]{time[2], time[1], time[0]}) : resources.getString(R.string.uxsdk_video_time, new Object[]{time[1], time[0]});
        return result;
    }

    public static String apertureDisplayName(@NonNull Resources resources, @NonNull CameraAperture aperture) {
        String displayName;
        if (aperture == CameraAperture.UNKNOWN) {
            displayName = resources.getString(R.string.uxsdk_string_default_value);
        } else {
            int apertureValue = aperture.value();
            int apertureInteger = apertureValue / 100;
            int apertureDecimal = apertureValue % 100 / 10;
            displayName = apertureDecimal == 0 ? String.format(Locale.US, "%d", apertureInteger) : String.format(Locale.US, "%d.%d", apertureInteger, apertureDecimal);
        }
        return displayName;
    }

    @NonNull
    public static String shutterSpeedDisplayName(@NonNull CameraShutterSpeed shutterSpeed) {
        String shutterName = shutterSpeed.name();
        shutterName = shutterName.replace(SHUTTER_SUBSTITUENT1, "").replace(SHUTTER_WIFI_REGEX_2, SHUTTER_WIFI_REPLACE_2).replace(SHUTTER_SUBSTITUENT3, SHUTTER_SUPPLANTER3).replace(SHUTTER_SUBSTITUENT4, SHUTTER_SUPPLANTER4);
        return shutterName;
    }

    @NonNull
    public static String exposureValueDisplayName(@NonNull CameraExposureCompensation ev) {
        if (ev == CameraExposureCompensation.NEG_0EV) {
            return "0";
        }
        String enumName = ev.name();
        return enumName.replace(EV_SUBSTITUENT1, "").replace(EV_SUBSTITUENT2, EV_SUPPLANTER2).replace(EV_SUBSTITUENT3, EV_SUPPLANTER3).replace(EV_SUBSTITUENT4, EV_SUPPLANTER4);
    }

    public static int convertISOToInt(CameraISO iso) {
        if (iso == CameraISO.ISO_AUTO || iso == CameraISO.UNKNOWN) {
            return 0;
        }
        String name = iso.toString();
        String[] isoValue = name.split("_");
        return Integer.parseInt(isoValue[1]);
    }

    @NonNull
    public static CameraISO convertIntToISO(int isoValue) {
        if (isoValue > 0 && isoValue < 200) {
            return CameraISO.ISO_100;
        }
        if (isoValue >= 200 && isoValue < 400) {
            return CameraISO.ISO_200;
        }
        if (isoValue >= 400 && isoValue < 800) {
            return CameraISO.ISO_400;
        }
        if (isoValue >= 800 && isoValue < 1600) {
            return CameraISO.ISO_800;
        }
        return CameraUtil.convertInt2ISO(isoValue);
    }

    private static CameraISO convertInt2ISO(int isoValue) {
        if (isoValue >= 1600 && isoValue < 3200) {
            return CameraISO.ISO_1600;
        }
        if (isoValue >= 3200 && isoValue < 6400) {
            return CameraISO.ISO_3200;
        }
        if (isoValue >= 6400 && isoValue < 12800) {
            return CameraISO.ISO_6400;
        }
        if (isoValue >= 12800 && isoValue < 25600) {
            return CameraISO.ISO_12800;
        }
        if (isoValue >= 25600) {
            return CameraISO.ISO_25600;
        }
        return CameraISO.UNKNOWN;
    }

    public static CameraLensType getLensIndex(CameraVideoStreamSourceType streamSource) {
        if (streamSource == CameraVideoStreamSourceType.WIDE_CAMERA) {
            return CameraLensType.CAMERA_LENS_WIDE;
        }
        if (streamSource == CameraVideoStreamSourceType.INFRARED_CAMERA) {
            return CameraLensType.CAMERA_LENS_THERMAL;
        }
        return CameraLensType.CAMERA_LENS_ZOOM;
    }

    public static boolean isPictureMode(CameraFlatMode flatCameraMode) {
        return flatCameraMode == CameraFlatMode.VIDEO_TIMELAPSE || flatCameraMode == CameraFlatMode.PHOTO_AEB || flatCameraMode == CameraFlatMode.PHOTO_NORMAL || flatCameraMode == CameraFlatMode.PHOTO_BURST || flatCameraMode == CameraFlatMode.PHOTO_HDR || flatCameraMode == CameraFlatMode.PHOTO_INTERVAL || flatCameraMode == CameraFlatMode.PHOTO_HYPERLIGHT || flatCameraMode == CameraFlatMode.PHOTO_PANO || flatCameraMode == CameraFlatMode.PHOTO_EHDR;
    }

    public static boolean isAutoISOSupportedByProduct() {
        return true;
    }

    public static boolean isSupportForNDVI(CameraLensType lensType) {
        return lensType == CameraLensType.CAMERA_LENS_MS_G || lensType == CameraLensType.CAMERA_LENS_MS_R || lensType == CameraLensType.CAMERA_LENS_MS_RE || lensType == CameraLensType.CAMERA_LENS_MS_NIR || lensType == CameraLensType.CAMERA_LENS_MS_NDVI;
    }

    public static boolean isFPVTypeView(ComponentIndexType devicePosition) {
        return devicePosition == ComponentIndexType.FPV || devicePosition == ComponentIndexType.VISION_ASSIST;
    }

    public static String getCameraDisplayName(CameraType cameraType) {
        String name = CAMERA_TYPE_STRING_MAP.get(cameraType);
        if (name == null) {
            name = "";
        }
        return name;
    }

    public static String getPayloadCameraName(PayloadCameraType payloadCameraType) {
        String name = "UNKNOWN";
        switch (payloadCameraType) {
            case EP600: {
                name = "P1";
                break;
            }
            case EP800: {
                name = "L1";
                break;
            }
        }
        return name;
    }

    public static List<ComponentIndexType> getConnectionCameraList(boolean cameraConnection1, boolean cameraConnection2, boolean cameraConnection3) {
        ArrayList<ComponentIndexType> list = new ArrayList<ComponentIndexType>();
        if (cameraConnection1) {
            list.add(ComponentIndexType.LEFT_OR_MAIN);
        }
        if (cameraConnection2) {
            list.add(ComponentIndexType.RIGHT);
        }
        if (cameraConnection3) {
            list.add(ComponentIndexType.UP);
        }
        return list;
    }

    static {
        CAMERA_TYPE_STRING_MAP.put(CameraType.ZENMUSE_XT, "XT");
        CAMERA_TYPE_STRING_MAP.put(CameraType.ZENMUSE_X30, "X30");
        CAMERA_TYPE_STRING_MAP.put(CameraType.ZENMUSE_XT2, "XT2");
        CAMERA_TYPE_STRING_MAP.put(CameraType.PAYLOAD, DEFAULT_PAYLOAD_NAME);
        CAMERA_TYPE_STRING_MAP.put(CameraType.ZENMUSE_XTS, "XT S");
        CAMERA_TYPE_STRING_MAP.put(CameraType.ZENMUSE_H20, "H20");
        CAMERA_TYPE_STRING_MAP.put(CameraType.ZENMUSE_H20T, "H20T");
        CAMERA_TYPE_STRING_MAP.put(CameraType.ZENMUSE_H20N, "H20N");
        CAMERA_TYPE_STRING_MAP.put(CameraType.M200_V2_CAMERA, "FPV");
        CAMERA_TYPE_STRING_MAP.put(CameraType.M30, "M30");
        CAMERA_TYPE_STRING_MAP.put(CameraType.M30T, "M30T");
        CAMERA_TYPE_STRING_MAP.put(CameraType.M3E, "M3E");
        CAMERA_TYPE_STRING_MAP.put(CameraType.M3T, "M3T");
        CAMERA_TYPE_STRING_MAP.put(CameraType.M3M, "M3M");
        CAMERA_TYPE_STRING_MAP.put(CameraType.ZENMUSE_L1, "L1");
        CAMERA_TYPE_STRING_MAP.put(CameraType.ZENMUSE_P1, "P1");
    }
}

