/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.base.panel;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.IntRange;
import dji.sdk.keyvalue.value.product.ProductType;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.SchedulerProvider;
import dji.v5.ux.core.base.panel.ListPanelWidgetBaseModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.panel.systemstatus.SmartListInternalModel;
import dji.v5.ux.core.util.UxErrorHandle;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.processors.PublishProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B3\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\b\u0012\u00060\bj\u0002`\t\u0018\u00010\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u000200J\b\u00102\u001a\u000200H$J\b\u00103\u001a\u000200H$J\u0010\u00104\u001a\u0002002\u0006\u00105\u001a\u000206H$J\u0010\u00107\u001a\u0002002\u0006\u00108\u001a\u000209H$J\u001a\u0010:\u001a\u0002002\u0010\u0010;\u001a\f\u0012\b\u0012\u00060\bj\u0002`\t0\u0007H\u0004J\u0014\u0010<\u001a\u00020\u001e2\n\u0010=\u001a\u00060\bj\u0002`\tH$J\u000e\u0010>\u001a\u0002002\u0006\u0010)\u001a\u00020*J\u0012\u0010?\u001a\u0004\u0018\u00010\u001e2\b\b\u0001\u0010@\u001a\u00020\u0016J\u0014\u0010?\u001a\u0004\u0018\u00010\u001e2\n\u0010=\u001a\u00060\bj\u0002`\tJ\u0018\u0010A\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t2\b\b\u0001\u0010@\u001a\u00020\u0016J\u0014\u0010B\u001a\u0004\u0018\u00010\u001e2\n\u0010=\u001a\u00060\bj\u0002`\tJ\u0012\u0010C\u001a\u00020\u00162\n\u0010=\u001a\u00060\bj\u0002`\tJ\u001c\u0010D\u001a\u0002002\b\b\u0001\u0010@\u001a\u00020\u00162\n\u0010=\u001a\u00060\bj\u0002`\tJ\u001a\u0010D\u001a\u0002002\b\b\u0001\u0010E\u001a\u00020\u00162\b\b\u0001\u0010F\u001a\u00020\u0016J%\u0010G\u001a\u0002002\u0016\u0010H\u001a\u000e\u0012\n\b\u0001\u0012\u00060\bj\u0002`\t0I\"\u00020\bH\u0004\u00a2\u0006\u0002\u0010JJ%\u0010K\u001a\u0002002\u0016\u0010L\u001a\u000e\u0012\n\b\u0001\u0012\u00060\bj\u0002`\t0I\"\u00020\bH\u0004\u00a2\u0006\u0002\u0010JJ\u0010\u0010M\u001a\u0002002\u0006\u0010N\u001a\u00020OH\u0004J\b\u0010P\u001a\u000200H\u0002J\b\u0010Q\u001a\u000200H\u0002J\u0010\u0010R\u001a\u000206*\u00060\bj\u0002`\tH\u0002J\u001a\u0010S\u001a\u0002002\u0010\u0010;\u001a\f\u0012\b\u0012\u00060\bj\u0002`\t0\u0007H\u0002J\b\u0010T\u001a\u000200H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\b\u0012\u00060\bj\u0002`\t\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\f\u0012\b\u0012\u00060\bj\u0002`\t0\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\f\u0012\b\u0012\u00060\bj\u0002`\t0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R'\u0010\u001b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\bj\u0002`\t\u0012\u0004\u0012\u00020\u001e0\u001d0\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010#\u001a\f\u0012\b\u0012\u00060\bj\u0002`\t0$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010%\u001a\u0012\u0012\b\u0012\u00060\bj\u0002`\t\u0012\u0004\u0012\u00020\u001e0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010(\u001a\f\u0012\b\u0012\u00060\bj\u0002`\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010+\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\bj\u0002`\t\u0012\u0004\u0012\u00020\u001e0\u001d0,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Ldji/v5/ux/core/base/panel/SmartListModel;", "", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "excludedItems", "", "", "Ldji/v5/ux/core/base/panel/WidgetID;", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;Ljava/util/Set;)V", "getContext", "()Landroid/content/Context;", "registeredWidgetIDList", "", "getRegisteredWidgetIDList", "()Ljava/util/List;", "defaultActiveWidgetSet", "getDefaultActiveWidgetSet", "()Ljava/util/Set;", "activeWidgetSize", "", "getActiveWidgetSize", "()I", "totalWidgetSize", "getTotalWidgetSize", "widgetCreated", "Lio/reactivex/rxjava3/core/Flowable;", "Lkotlin/Pair;", "Landroid/view/View;", "getWidgetCreated", "()Lio/reactivex/rxjava3/core/Flowable;", "widgetModel", "Ldji/v5/ux/core/panel/systemstatus/SmartListInternalModel;", "currentOrderList", "", "createdWidgetsMap", "", "activeWidgetList", "activeWidgetSet", "listPanelWidgetBaseModel", "Ldji/v5/ux/core/base/panel/ListPanelWidgetBaseModel;", "widgetCreatedProcessor", "Lio/reactivex/rxjava3/processors/PublishProcessor;", "compositeDisposable", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "setUp", "", "cleanUp", "inSetUp", "inCleanUp", "onProductConnectionChanged", "isConnected", "", "onAircraftModelChanged", "model", "Ldji/sdk/keyvalue/value/product/ProductType;", "buildAndInstallWidgets", "newActiveWidgetIDs", "createWidget", "widgetID", "setListPanelWidgetHolder", "getActiveWidget", "index", "getWidgetID", "getWidget", "getWidgetIndex", "setIndex", "fromIndex", "toIndex", "updateListMinus", "itemToRemove", "", "([Ljava/lang/String;)V", "updateListPlus", "itemToAdd", "addDisposable", "disposable", "Lio/reactivex/rxjava3/disposables/Disposable;", "disposeAll", "updateHolder", "isNotExcluded", "buildActiveWidgetList", "reorderActiveWidgets", "android-sdk-v5-uxsdk_release"})
@SourceDebugExtension(value={"SMAP\nSmartListModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmartListModel.kt\ndji/v5/ux/core/base/panel/SmartListModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,322:1\n1864#2,3:323\n1864#2,3:326\n766#2:329\n857#2,2:330\n1549#2:332\n1620#2,3:333\n766#2:336\n857#2,2:337\n1549#2:339\n1620#2,3:340\n*S KotlinDebug\n*F\n+ 1 SmartListModel.kt\ndji/v5/ux/core/base/panel/SmartListModel\n*L\n215#1:323,3\n229#1:326,3\n297#1:329\n297#1:330,2\n300#1:332\n300#1:333,3\n314#1:336\n314#1:337,2\n318#1:339\n318#1:340,3\n*E\n"})
public abstract class SmartListModel {
    @NotNull
    private final Context context;
    @Nullable
    private final AttributeSet attrs;
    @Nullable
    private final Set<String> excludedItems;
    @Nullable
    private SmartListInternalModel widgetModel;
    @NotNull
    private List<String> currentOrderList;
    @NotNull
    private final Map<String, View> createdWidgetsMap;
    @NotNull
    private List<? extends View> activeWidgetList;
    @NotNull
    private Set<String> activeWidgetSet;
    @Nullable
    private ListPanelWidgetBaseModel listPanelWidgetBaseModel;
    @NotNull
    private PublishProcessor<Pair<String, View>> widgetCreatedProcessor;
    @Nullable
    private CompositeDisposable compositeDisposable;

    @JvmOverloads
    public SmartListModel(@NotNull Context context, @Nullable AttributeSet attrs, @Nullable Set<String> excludedItems) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.attrs = attrs;
        this.excludedItems = excludedItems;
        this.currentOrderList = new ArrayList();
        this.createdWidgetsMap = new LinkedHashMap();
        this.activeWidgetList = CollectionsKt.emptyList();
        this.activeWidgetSet = SetsKt.emptySet();
        PublishProcessor publishProcessor = PublishProcessor.create();
        Intrinsics.checkNotNullExpressionValue((Object)publishProcessor, (String)"create(...)");
        this.widgetCreatedProcessor = publishProcessor;
    }

    public /* synthetic */ SmartListModel(Context context, AttributeSet attributeSet, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        if ((n & 4) != 0) {
            set = null;
        }
        this(context, attributeSet, set);
    }

    @NotNull
    protected final Context getContext() {
        return this.context;
    }

    @NotNull
    public abstract List<String> getRegisteredWidgetIDList();

    @NotNull
    public abstract Set<String> getDefaultActiveWidgetSet();

    public final int getActiveWidgetSize() {
        return this.activeWidgetList.size();
    }

    public final int getTotalWidgetSize() {
        return this.getRegisteredWidgetIDList().size();
    }

    @NotNull
    public final Flowable<Pair<String, View>> getWidgetCreated() {
        return (Flowable)this.widgetCreatedProcessor;
    }

    public final void setUp() {
        this.currentOrderList = CollectionsKt.toMutableList((Collection)this.getRegisteredWidgetIDList());
        this.buildAndInstallWidgets(this.getDefaultActiveWidgetSet());
        this.compositeDisposable = new CompositeDisposable();
        DJISDKModel dJISDKModel = DJISDKModel.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dJISDKModel, (String)"getInstance(...)");
        ObservableInMemoryKeyedStore observableInMemoryKeyedStore = ObservableInMemoryKeyedStore.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)observableInMemoryKeyedStore, (String)"getInstance(...)");
        SmartListInternalModel smartListInternalModel = this.widgetModel = new SmartListInternalModel(dJISDKModel, observableInMemoryKeyedStore);
        if (smartListInternalModel != null) {
            smartListInternalModel.setup();
        }
        SmartListInternalModel smartListInternalModel2 = this.widgetModel;
        Intrinsics.checkNotNull((Object)smartListInternalModel2);
        Disposable disposable = smartListInternalModel2.getProductConnection().observeOn(SchedulerProvider.ui()).subscribe(arg_0 -> SmartListModel.setUp$lambda$0(this, arg_0), UxErrorHandle.logErrorConsumer("SmartListModel", "Error on Product changed. "));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.addDisposable(disposable);
        SmartListInternalModel smartListInternalModel3 = this.widgetModel;
        Intrinsics.checkNotNull((Object)smartListInternalModel3);
        Disposable disposable2 = smartListInternalModel3.getAircraftModel().observeOn(SchedulerProvider.ui()).subscribe(arg_0 -> SmartListModel.setUp$lambda$1(this, arg_0), UxErrorHandle.logErrorConsumer("SmartListModel", "Error on Aircraft Model Changed. "));
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"subscribe(...)");
        this.addDisposable(disposable2);
        this.inSetUp();
    }

    public final void cleanUp() {
        this.inCleanUp();
        SmartListInternalModel smartListInternalModel = this.widgetModel;
        if (smartListInternalModel != null) {
            smartListInternalModel.cleanup();
        }
        this.disposeAll();
    }

    protected abstract void inSetUp();

    protected abstract void inCleanUp();

    protected abstract void onProductConnectionChanged(boolean var1);

    protected abstract void onAircraftModelChanged(@NotNull ProductType var1);

    protected final void buildAndInstallWidgets(@NotNull Set<String> newActiveWidgetIDs) {
        Intrinsics.checkNotNullParameter(newActiveWidgetIDs, (String)"newActiveWidgetIDs");
        this.buildActiveWidgetList(newActiveWidgetIDs);
        this.updateHolder();
    }

    @NotNull
    protected abstract View createWidget(@NotNull String var1);

    public final void setListPanelWidgetHolder(@NotNull ListPanelWidgetBaseModel listPanelWidgetBaseModel) {
        Intrinsics.checkNotNullParameter((Object)listPanelWidgetBaseModel, (String)"listPanelWidgetBaseModel");
        this.listPanelWidgetBaseModel = listPanelWidgetBaseModel;
    }

    @Nullable
    public final View getActiveWidget(@IntRange(from=0L) int index) {
        return (View)CollectionsKt.getOrNull(this.activeWidgetList, (int)index);
    }

    @Nullable
    public final View getActiveWidget(@NotNull String widgetID) {
        Intrinsics.checkNotNullParameter((Object)widgetID, (String)"widgetID");
        if (this.activeWidgetSet.contains(widgetID)) {
            return this.createdWidgetsMap.get(widgetID);
        }
        return null;
    }

    @Nullable
    public final String getWidgetID(@IntRange(from=0L) int index) {
        return (String)CollectionsKt.getOrNull(this.currentOrderList, (int)index);
    }

    @Nullable
    public final View getWidget(@NotNull String widgetID) {
        Intrinsics.checkNotNullParameter((Object)widgetID, (String)"widgetID");
        return this.createdWidgetsMap.get(widgetID);
    }

    /*
     * WARNING - void declaration
     */
    public final int getWidgetIndex(@NotNull String widgetID) {
        Intrinsics.checkNotNullParameter((Object)widgetID, (String)"widgetID");
        Iterable $this$forEachIndexed$iv = this.currentOrderList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void currWidgetId;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string2 = (String)item$iv;
            int index = n;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)currWidgetId, (Object)widgetID)) continue;
            return index;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setIndex(@IntRange(from=0L) int index, @NotNull String widgetID) {
        Intrinsics.checkNotNullParameter((Object)widgetID, (String)"widgetID");
        if (index >= this.currentOrderList.size()) {
            return;
        }
        int currentIndex = 0;
        currentIndex = -1;
        Iterable $this$forEachIndexed$iv = this.currentOrderList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void value;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string2 = (String)item$iv;
            int i = n;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)value, (Object)widgetID)) continue;
            currentIndex = i;
        }
        if (currentIndex != -1) {
            this.currentOrderList.remove(currentIndex);
            this.currentOrderList.add(index, widgetID);
            this.reorderActiveWidgets();
            this.updateHolder();
        }
    }

    public final void setIndex(@IntRange(from=0L) int fromIndex, @IntRange(from=0L) int toIndex) {
        if (fromIndex >= this.currentOrderList.size() || toIndex >= this.currentOrderList.size()) {
            return;
        }
        String widgetID = this.currentOrderList.remove(fromIndex);
        this.currentOrderList.add(toIndex, widgetID);
        this.reorderActiveWidgets();
        this.updateHolder();
    }

    protected final void updateListMinus(String ... itemToRemove) {
        Intrinsics.checkNotNullParameter((Object)itemToRemove, (String)"itemToRemove");
        Set newOrder = SetsKt.minus(this.activeWidgetSet, (Iterable)ArraysKt.toSet((Object[])itemToRemove));
        this.buildAndInstallWidgets(newOrder);
    }

    protected final void updateListPlus(String ... itemToAdd) {
        Intrinsics.checkNotNullParameter((Object)itemToAdd, (String)"itemToAdd");
        Set newOrder = SetsKt.plus(this.activeWidgetSet, (Iterable)ArraysKt.toSet((Object[])itemToAdd));
        this.buildAndInstallWidgets(newOrder);
    }

    protected final void addDisposable(@NotNull Disposable disposable) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            CompositeDisposable compositeDisposable = this.compositeDisposable;
            if (compositeDisposable == null) break block0;
            compositeDisposable.add(disposable);
        }
    }

    private final void disposeAll() {
        CompositeDisposable compositeDisposable = this.compositeDisposable;
        if (compositeDisposable != null) {
            compositeDisposable.dispose();
        }
        this.compositeDisposable = null;
    }

    private final void updateHolder() {
        block0: {
            ListPanelWidgetBaseModel listPanelWidgetBaseModel = this.listPanelWidgetBaseModel;
            if (listPanelWidgetBaseModel == null) break block0;
            listPanelWidgetBaseModel.addWidgets(this.activeWidgetList);
        }
    }

    private final boolean isNotExcluded(String $this$isNotExcluded) {
        return this.excludedItems == null || !this.excludedItems.contains($this$isNotExcluded);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildActiveWidgetList(Set<String> newActiveWidgetIDs) {
        void $this$mapTo$iv$iv;
        String widgetID;
        Iterable $this$filterTo$iv$iv;
        this.activeWidgetSet = CollectionsKt.intersect((Iterable)newActiveWidgetIDs, (Iterable)this.getRegisteredWidgetIDList());
        Iterable $this$filter$iv = this.activeWidgetSet;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            widgetID = (String)element$iv$iv;
            boolean bl = false;
            if (!(this.isNotExcluded(widgetID) && !this.createdWidgetsMap.containsKey(widgetID))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            widgetID = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            View createdWidget = this.createWidget(widgetID);
            this.widgetCreatedProcessor.onNext((Object)TuplesKt.to((Object)widgetID, (Object)createdWidget));
            this.createdWidgetsMap.put(widgetID, createdWidget);
            collection.add(createdWidget);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        this.reorderActiveWidgets();
    }

    /*
     * WARNING - void declaration
     */
    private final void reorderActiveWidgets() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String widgetID;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = this.currentOrderList;
        SmartListModel smartListModel = this;
        boolean $i$f$filter = false;
        void var3_4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            widgetID = (String)element$iv$iv;
            boolean bl = false;
            if (!(this.isNotExcluded(widgetID) && this.activeWidgetSet.contains(widgetID) && this.createdWidgetsMap.containsKey(widgetID))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void originalIndex;
            widgetID = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            View view = this.createdWidgetsMap.get(originalIndex);
            Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.view.View");
            collection.add(view);
        }
        smartListModel.activeWidgetList = (List)destination$iv$iv;
    }

    @JvmOverloads
    public SmartListModel(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, null, 4, null);
    }

    @JvmOverloads
    public SmartListModel(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, null, 6, null);
    }

    private static final void setUp$lambda$0(SmartListModel this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.onProductConnectionChanged(it);
    }

    private static final void setUp$lambda$1(SmartListModel this$0, ProductType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.onAircraftModelChanged(it);
    }
}

