/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.remotecontroller.calibration.stick;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import dji.v5.utils.common.AndUtil;
import dji.v5.ux.core.ui.BaseView;

public class HallStickCalibrationView
extends BaseView {
    private final int FRONT_SIZE;
    private final int FRONT_WIDTH;
    private final int RECTANGLE_GAP;
    private final int CIRCLE_RADIUS;
    private final int RECTANGLE_LINE_WIDTH = 2;
    private static final int CIRCLE_COLOR = Color.parseColor((String)"#1FA3F6");
    private static final int PROGRESS_STROKE_COLOR = Color.parseColor((String)"#093049");
    private int[] progress = new int[4];
    private int left = 0;
    private int right = 0;
    private int top = 0;
    private int bottom = 0;
    private int segmentNum = 15;
    private int viewWidth;
    private int viewHeight;
    private int movementCircleX;
    private int movementCircleY;
    private int connerNumber;
    private float unitStrokeLength;
    private float topLeftStartX;
    private float topLeftStartY;
    private float topRightStartX;
    private float topRightStartY;
    private float bottomRightStartX;
    private float bottomRightStartY;
    private float bottomLeftStartX;
    private float bottomLeftStartY;
    private RectF outsideRectangle;
    private RectF insideRectangle;
    private Paint fontPaint;
    private Paint rectanglePainter;
    private Paint movementCirclePainter;
    private Paint progressStrokePainter;
    private final int HEAD = 0;
    private final int TAIL = 1;

    public HallStickCalibrationView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.FRONT_SIZE = AndUtil.dip2px((Context)context, (float)10.0f);
        this.FRONT_WIDTH = AndUtil.dip2px((Context)context, (float)35.0f);
        this.RECTANGLE_GAP = AndUtil.dip2px((Context)context, (float)20.0f);
        this.CIRCLE_RADIUS = this.RECTANGLE_GAP / 2;
        this.init();
    }

    public void setProgress(int left, int top, int right, int bottom) {
        this.progress[0] = top;
        this.progress[1] = right;
        this.progress[2] = bottom;
        this.progress[3] = left;
        this.invalidate();
    }

    public void setSegmentNum(int segmentNum) {
        this.segmentNum = segmentNum;
    }

    public void reset() {
        for (int i = 0; i < this.progress.length; ++i) {
            this.progress[i] = 0;
        }
        this.invalidate();
    }

    public boolean hasSegNumSet() {
        return this.segmentNum != -1;
    }

    protected void onDraw(Canvas canvas) {
        int i;
        super.onDraw(canvas);
        int currentProgress = this.progress[0];
        int factor = 1;
        for (i = 0; i <= this.segmentNum - this.connerNumber; ++i) {
            if (i > this.connerNumber && (currentProgress & factor) == factor) {
                if (i == 0) {
                    canvas.drawLine(this.topLeftStartX + (float)this.RECTANGLE_GAP, this.topLeftStartY, this.topLeftStartX + this.unitStrokeLength * (float)i, this.topLeftStartY, this.progressStrokePainter);
                } else {
                    canvas.drawLine(this.topLeftStartX + this.unitStrokeLength * (float)(i - 1), this.topLeftStartY, this.topLeftStartX + this.unitStrokeLength * (float)i, this.topLeftStartY, this.progressStrokePainter);
                }
            }
            factor *= 2;
        }
        currentProgress = this.progress[1];
        factor = 1;
        for (i = 0; i <= this.segmentNum - this.connerNumber; ++i) {
            if (i > this.connerNumber && (currentProgress & factor) == factor) {
                if (i == 0) {
                    canvas.drawLine(this.topRightStartX, this.topRightStartY + (float)this.RECTANGLE_GAP, this.topRightStartX, this.topRightStartY + this.unitStrokeLength * (float)i, this.progressStrokePainter);
                } else {
                    canvas.drawLine(this.topRightStartX, this.topRightStartY + this.unitStrokeLength * (float)(i - 1), this.topRightStartX, this.topRightStartY + this.unitStrokeLength * (float)i, this.progressStrokePainter);
                }
            }
            factor *= 2;
        }
        currentProgress = this.progress[2];
        factor = 1;
        for (i = 0; i <= this.segmentNum - this.connerNumber; ++i) {
            if (i > this.connerNumber && (currentProgress & factor) == factor) {
                if (i == 0) {
                    canvas.drawLine(this.bottomRightStartX - (float)this.RECTANGLE_GAP, this.bottomRightStartY, this.bottomRightStartX - this.unitStrokeLength * (float)i, this.bottomRightStartY, this.progressStrokePainter);
                } else {
                    canvas.drawLine(this.bottomRightStartX - this.unitStrokeLength * (float)(i - 1), this.bottomRightStartY, this.bottomRightStartX - this.unitStrokeLength * (float)i, this.bottomRightStartY, this.progressStrokePainter);
                }
            }
            factor *= 2;
        }
        currentProgress = this.progress[3];
        factor = 1;
        for (i = 0; i <= this.segmentNum - this.connerNumber; ++i) {
            if (i > this.connerNumber && (currentProgress & factor) == factor) {
                if (i == 0) {
                    canvas.drawLine(this.bottomLeftStartX, this.bottomLeftStartY - (float)this.RECTANGLE_GAP, this.bottomLeftStartX, this.bottomLeftStartY - this.unitStrokeLength * (float)i, this.progressStrokePainter);
                } else {
                    canvas.drawLine(this.bottomLeftStartX, this.bottomLeftStartY - this.unitStrokeLength * (float)(i - 1), this.bottomLeftStartX, this.bottomLeftStartY - this.unitStrokeLength * (float)i, this.progressStrokePainter);
                }
            }
            factor *= 2;
        }
        if (this.checkCorner(0, 0) && this.checkCorner(3, 1)) {
            canvas.drawLine(this.topLeftStartX, this.topLeftStartY, this.topLeftStartX + this.unitStrokeLength * (float)this.connerNumber, this.topLeftStartY, this.progressStrokePainter);
        } else {
            this.getCorner(0, 0);
            this.getCorner(3, 1);
        }
        if (this.checkCorner(1, 0) && this.checkCorner(0, 1)) {
            canvas.drawLine(this.topLeftStartX + this.unitStrokeLength * (float)(this.segmentNum - this.connerNumber), this.topLeftStartY, this.topLeftStartX + this.unitStrokeLength * (float)this.segmentNum + 4.0f, this.topLeftStartY, this.progressStrokePainter);
        } else {
            this.getCorner(1, 0);
            this.getCorner(0, 1);
        }
        if (this.checkCorner(3, 0) && this.checkCorner(2, 1)) {
            canvas.drawLine(this.bottomRightStartX - this.unitStrokeLength * (float)(this.segmentNum - this.connerNumber), this.bottomRightStartY, this.bottomRightStartX - this.unitStrokeLength * (float)this.segmentNum - 4.0f, this.bottomRightStartY, this.progressStrokePainter);
        } else {
            this.getCorner(3, 0);
            this.getCorner(2, 1);
        }
        if (this.checkCorner(2, 0) && this.checkCorner(1, 1)) {
            canvas.drawLine(this.bottomRightStartX, this.bottomRightStartY, this.bottomRightStartX - this.unitStrokeLength * (float)this.connerNumber, this.bottomRightStartY, this.progressStrokePainter);
        } else {
            this.getCorner(2, 0);
            this.getCorner(1, 1);
        }
        canvas.drawRect(this.outsideRectangle, this.rectanglePainter);
        canvas.drawRect(this.insideRectangle, this.rectanglePainter);
        canvas.drawCircle((float)this.movementCircleX, (float)this.movementCircleY, (float)this.CIRCLE_RADIUS, this.movementCirclePainter);
        this.drawText(canvas);
    }

    private boolean checkCorner(int segment, int headOrTail) {
        int currentProgress = this.progress[segment];
        if (headOrTail == 0) {
            int factor = 1;
            for (int i = 0; i <= this.connerNumber; ++i) {
                if ((currentProgress & factor) != factor) {
                    return false;
                }
                factor <<= 1;
            }
            return true;
        }
        if (headOrTail == 1) {
            int factor = (int)Math.pow(2.0, (double)this.segmentNum - (double)this.connerNumber - 1.0);
            for (int i = this.segmentNum - this.connerNumber; i < this.segmentNum; ++i) {
                if ((currentProgress & factor) != factor) {
                    return false;
                }
                factor <<= 1;
            }
            return true;
        }
        return false;
    }

    private int getCorner(int segment, int headOrTail) {
        int currentProgress = this.progress[segment];
        if (headOrTail == 0) {
            int factor = 1;
            for (int i = 0; i <= this.connerNumber; ++i) {
                if ((currentProgress & factor) != factor) {
                    return i;
                }
                factor <<= 1;
            }
            return -1;
        }
        if (headOrTail == 1) {
            int factor = (int)Math.pow(2.0, (double)this.segmentNum - (double)this.connerNumber - 1.0);
            for (int i = this.segmentNum - this.connerNumber; i < this.segmentNum; ++i) {
                if ((currentProgress & factor) != factor) {
                    return i;
                }
                factor <<= 1;
            }
            return -1;
        }
        return -1;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.viewWidth = w;
        this.viewHeight = h;
        this.movementCircleX = this.viewWidth / 2;
        this.movementCircleY = this.viewHeight / 2;
        this.unitStrokeLength = (float)(this.viewWidth - 2 * this.FRONT_WIDTH) / (float)this.segmentNum;
        this.connerNumber = (int)((float)this.RECTANGLE_GAP / this.unitStrokeLength);
        this.topLeftStartX = (float)this.FRONT_WIDTH + 2.0f;
        this.topLeftStartY = (float)this.FRONT_WIDTH + (float)this.RECTANGLE_GAP / 2.0f + 2.0f;
        this.topRightStartX = (float)(this.viewWidth - this.FRONT_WIDTH) - (float)this.RECTANGLE_GAP / 2.0f - 2.0f;
        this.topRightStartY = (float)this.FRONT_WIDTH + 2.0f;
        this.bottomRightStartX = (float)this.viewWidth - (float)this.FRONT_WIDTH - 2.0f;
        this.bottomRightStartY = (float)(this.viewHeight - this.FRONT_WIDTH) - (float)this.RECTANGLE_GAP / 2.0f - 2.0f;
        this.bottomLeftStartX = (float)this.FRONT_WIDTH + (float)this.RECTANGLE_GAP / 2.0f + 2.0f;
        this.bottomLeftStartY = (float)this.viewHeight - (float)this.FRONT_WIDTH - 2.0f;
        this.setUpRectangle(this.FRONT_WIDTH, this.outsideRectangle);
        this.setUpRectangle(this.FRONT_WIDTH + this.RECTANGLE_GAP, this.insideRectangle);
    }

    private void init() {
        this.outsideRectangle = new RectF();
        this.insideRectangle = new RectF();
        this.rectanglePainter = new Paint();
        this.rectanglePainter.setAntiAlias(true);
        this.rectanglePainter.setDither(true);
        this.rectanglePainter.setColor(-1);
        this.rectanglePainter.setStyle(Paint.Style.STROKE);
        this.rectanglePainter.setStrokeWidth(2.0f);
        this.fontPaint = new Paint(1);
        this.fontPaint.setStrokeWidth(0.0f);
        this.fontPaint.setTextSize((float)this.FRONT_SIZE);
        this.fontPaint.setColor(-1);
        this.fontPaint.setTextAlign(Paint.Align.CENTER);
        this.movementCirclePainter = new Paint();
        this.movementCirclePainter.setAntiAlias(true);
        this.movementCirclePainter.setDither(true);
        this.movementCirclePainter.setColor(-1);
        this.movementCirclePainter.setStrokeWidth(10.0f);
        this.progressStrokePainter = new Paint();
        this.progressStrokePainter.setAntiAlias(true);
        this.progressStrokePainter.setDither(true);
        this.progressStrokePainter.setColor(PROGRESS_STROKE_COLOR);
        this.progressStrokePainter.setStyle(Paint.Style.STROKE);
        this.progressStrokePainter.setStrokeWidth((float)this.RECTANGLE_GAP);
    }

    private void switchCirclePainter(boolean isOnEdge) {
        if (isOnEdge) {
            this.movementCirclePainter = new Paint();
            this.movementCirclePainter.setAntiAlias(true);
            this.movementCirclePainter.setDither(true);
            this.movementCirclePainter.setColor(CIRCLE_COLOR);
            this.movementCirclePainter.setAlpha(255);
            this.movementCirclePainter.setStrokeWidth(5.0f);
        } else {
            this.movementCirclePainter = new Paint();
            this.movementCirclePainter.setAntiAlias(true);
            this.movementCirclePainter.setDither(true);
            this.movementCirclePainter.setColor(-1);
            this.movementCirclePainter.setStrokeWidth(5.0f);
        }
        this.invalidate();
    }

    private void setUpRectangle(int offset, RectF target) {
        target.set((float)offset, (float)offset, (float)this.viewWidth - (float)offset, (float)this.viewHeight - (float)offset);
    }

    private void drawText(Canvas canvas) {
        int w = this.getWidth();
        this.drawCenterText(canvas, this.left + "", new Rect(0, 0, this.FRONT_WIDTH, w));
        this.drawCenterText(canvas, this.right + "", new Rect(w - this.FRONT_WIDTH, 0, w, w));
        this.drawCenterText(canvas, this.top + "", new Rect(0, 0, w, this.FRONT_WIDTH));
        this.drawCenterText(canvas, this.bottom + "", new Rect(0, w - this.FRONT_WIDTH, w, w));
    }

    private void drawCenterText(Canvas canvas, String text, Rect rect) {
        Paint.FontMetricsInt fontMetrics = this.fontPaint.getFontMetricsInt();
        int baseline = (rect.bottom + rect.top - fontMetrics.bottom - fontMetrics.top) / 2;
        canvas.drawText(text, (float)rect.centerX(), (float)baseline, this.fontPaint);
    }

    public void setCircleCenter(int left, int top, int right, int bottom) {
        this.movementCircleX = this.viewWidth / 2 - left * (this.viewWidth - 2 * this.FRONT_WIDTH - this.RECTANGLE_GAP) / 200 + right * (this.viewWidth - 2 * this.FRONT_WIDTH - this.RECTANGLE_GAP) / 200;
        this.movementCircleY = this.viewHeight / 2 - top * (this.viewHeight - 2 * this.FRONT_WIDTH - this.RECTANGLE_GAP) / 200 + bottom * (this.viewHeight - 2 * this.FRONT_WIDTH - this.RECTANGLE_GAP) / 200;
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        if (bottom == 100 || top == 100 || right == 100 || left == 100) {
            this.switchCirclePainter(true);
        } else {
            this.switchCirclePainter(false);
        }
        this.invalidate();
    }
}

