/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.maplibre.map;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.IconFactory;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.MarkerOptions;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdate;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.style.layers.CircleLayer;
import com.mapbox.mapboxsdk.style.layers.FillLayer;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.LineLayer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.SymbolLayer;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.style.sources.Source;
import dji.v5.ux.mapkit.core.callback.MapScreenShotListener;
import dji.v5.ux.mapkit.core.callback.OnMapTypeLoadedListener;
import dji.v5.ux.mapkit.core.camera.DJICameraUpdate;
import dji.v5.ux.mapkit.core.maps.DJIBaseMap;
import dji.v5.ux.mapkit.core.maps.DJIMap;
import dji.v5.ux.mapkit.core.maps.DJIProjection;
import dji.v5.ux.mapkit.core.maps.DJIUiSettings;
import dji.v5.ux.mapkit.core.models.DJIBitmapDescriptor;
import dji.v5.ux.mapkit.core.models.DJICameraPosition;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.annotations.DJICircle;
import dji.v5.ux.mapkit.core.models.annotations.DJICircleOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIGroupCircle;
import dji.v5.ux.mapkit.core.models.annotations.DJIGroupCircleOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIMarker;
import dji.v5.ux.mapkit.core.models.annotations.DJIMarkerOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolygon;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolygonOptions;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolyline;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolylineOptions;
import dji.v5.ux.mapkit.core.utils.DJIMapkitLog;
import dji.v5.ux.mapkit.maplibre.annotations.MCircle;
import dji.v5.ux.mapkit.maplibre.annotations.MGroupCircle;
import dji.v5.ux.mapkit.maplibre.annotations.MLineLayerPolyline;
import dji.v5.ux.mapkit.maplibre.annotations.MMarkerCircle;
import dji.v5.ux.mapkit.maplibre.annotations.MPolygon;
import dji.v5.ux.mapkit.maplibre.annotations.MSymbolLayerMarker;
import dji.v5.ux.mapkit.maplibre.map.MProjection;
import dji.v5.ux.mapkit.maplibre.map.MUiSettings;
import dji.v5.ux.mapkit.maplibre.utils.MaplibreUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MaplibreMapDelegate
extends DJIBaseMap
implements DJIMap,
MapboxMap.OnMarkerClickListener,
MapboxMap.OnMapClickListener,
MapboxMap.OnInfoWindowClickListener,
Style.OnStyleLoaded,
MapboxMap.OnCameraMoveListener,
MapboxMap.OnMapLongClickListener,
View.OnTouchListener {
    private static final String HEAD_SOURCE_ID = "head-source-id";
    private static final String HEAD_LAYER_ID = "head-layer-id";
    private static final String TAIL_SOURCE_ID = "tail-source-id";
    private static final String TAIL_LAYER_ID = "tail-layer-id";
    private static final String MARKER_SOURCE_ID_PREFIX = "marker-source-";
    private static final String MARKER_LAYER_ID_PREFIX = "marker-layer-";
    private static final String MARKER_BITMAP_ID_PREFIX = "marker-bitmap-";
    private static final String LINE_SOURCE_ID_PREFIX = "line-source-";
    private static final String LINE_LAYER_ID_PREFIX = "line-layer-";
    private static final String SINGLE_CIRCLE_SOURCE_ID_PREFIX = "single-circle-source-";
    private static final String SINGLE_CIRCLE_LAYER_ID_PREFIX = "single-circle-layer-";
    private static final String GROUP_CIRCLE_SOURCE_ID_PREFIX = "group-circle-source-";
    private static final String GROUP_CIRCLE_LAYER_ID_PREFIX = "group-circle-layer-";
    private static final String MARKER_CIRCLE_SOURCE_ID_PREFIX = "marker-circle-source-";
    private static final String MARKER_CIRCLE_LAYER_ID_PREFIX = "marker-circle-layer-";
    private boolean stoppingWorld = false;
    private Context context;
    private MapboxMap mapboxMap;
    private Map<Marker, DJIMarker> markers;
    private Set<DJIPolyline> polylines;
    private Set<DJICircle> singleCircles;
    private Set<DJIGroupCircle> groupCircles;
    private Set<DJICircle> markerCircles;
    private int markerSourcesCount = 0;
    private int markerLayersCount = 0;
    private Set<String> markerBitmaps = new HashSet<String>();
    private int markerBitmapsCount = 0;
    private int lineSourceCount = 0;
    private int lineLayersCount = 0;
    private int singleCircleSourceCount = 0;
    private int singleCircleLayersCount = 0;
    private int groupCircleSourceCount = 0;
    private int groupCircleLayersCount = 0;
    private int markerCircleLayersCount = 0;
    private List<LayerZIndex> sortedLayersByZIndex;
    private Style style;
    private OnMapTypeLoadedListener onMapTypeLoadedListener;
    private boolean isCatchTouch = false;
    private Marker currentSelectedMarker = null;

    public MaplibreMapDelegate(MapboxMap mapboxMap, Context context, MapView view, Style style2) {
        this.context = context;
        this.mapboxMap = mapboxMap;
        this.style = style2;
        view.setOnTouchListener((View.OnTouchListener)this);
        mapboxMap.setOnMarkerClickListener((MapboxMap.OnMarkerClickListener)this);
        mapboxMap.addOnMapClickListener((MapboxMap.OnMapClickListener)this);
        mapboxMap.setOnInfoWindowClickListener((MapboxMap.OnInfoWindowClickListener)this);
        mapboxMap.addOnMapLongClickListener((MapboxMap.OnMapLongClickListener)this);
        mapboxMap.addOnCameraMoveListener((MapboxMap.OnCameraMoveListener)this);
        this.markers = new HashMap<Marker, DJIMarker>();
        this.polylines = new HashSet<DJIPolyline>();
        this.singleCircles = new HashSet<DJICircle>();
        this.groupCircles = new HashSet<DJIGroupCircle>();
        this.markerCircles = new HashSet<DJICircle>();
        this.sortedLayersByZIndex = new LinkedList<LayerZIndex>();
        this.addDummySourcesAndLayers();
    }

    private void addDummySourcesAndLayers() {
        GeoJsonSource headSource = new GeoJsonSource(HEAD_SOURCE_ID);
        SymbolLayer headLayer = new SymbolLayer(HEAD_LAYER_ID, headSource.getId());
        GeoJsonSource tailSource = new GeoJsonSource(TAIL_SOURCE_ID);
        SymbolLayer tailLayer = new SymbolLayer(TAIL_LAYER_ID, tailSource.getId());
        this.sortedLayersByZIndex.add(new LayerZIndex((Layer)headLayer, Long.MIN_VALUE));
        this.sortedLayersByZIndex.add(new LayerZIndex((Layer)tailLayer, Long.MAX_VALUE));
        if (this.style.isFullyLoaded()) {
            this.style.addSource((Source)headSource);
            this.style.addSource((Source)tailSource);
            this.style.addLayer((Layer)headLayer);
            this.style.addLayerAbove((Layer)tailLayer, headLayer.getId());
        }
    }

    private void clearSourcesAndLayers() {
        DJIMapkitLog.d("ready to clearSourceAndLayers");
        if (this.style.isFullyLoaded()) {
            this.style.removeLayer(HEAD_LAYER_ID);
            this.style.removeLayer(TAIL_LAYER_ID);
            this.style.removeSource(HEAD_SOURCE_ID);
            this.style.removeSource(TAIL_SOURCE_ID);
            for (DJIMarker marker : this.markers.values()) {
                MSymbolLayerMarker symbol = (MSymbolLayerMarker)marker;
                this.style.removeLayer(symbol.getLayerId());
                this.style.removeSource(symbol.getSourceId());
                symbol.setSymbolLayer(null);
                symbol.setSource(null);
            }
            for (DJIPolyline polyline : this.polylines) {
                MLineLayerPolyline line = (MLineLayerPolyline)polyline;
                this.style.removeLayer(line.getLayerId());
                this.style.removeSource(line.getSourceId());
            }
            for (DJICircle singleCircle : this.singleCircles) {
                MCircle mSingleCircle = (MCircle)singleCircle;
                this.style.removeLayer(mSingleCircle.getLayerId());
                this.style.removeSource(mSingleCircle.getSourceId());
            }
            for (DJIGroupCircle groupCircle : this.groupCircles) {
                MGroupCircle mGroupCircle = (MGroupCircle)groupCircle;
                this.style.removeLayer(mGroupCircle.getLayerId());
                this.style.removeSource(mGroupCircle.getSourceId());
            }
            for (DJICircle markerCircle : this.markerCircles) {
                MMarkerCircle mMarkerCircle = (MMarkerCircle)markerCircle;
                this.style.removeLayer(mMarkerCircle.getLayerId());
                this.style.removeSource(mMarkerCircle.getSourceID());
            }
        }
        this.sortedLayersByZIndex.clear();
    }

    @Override
    @NonNull
    public DJIMarker addMarker(DJIMarkerOptions markerOptions) {
        DJILatLng latLng = markerOptions.getPosition();
        if (latLng == null) {
            throw new IllegalArgumentException("DJIMarkerOptions parameter must have position set");
        }
        MarkerOptions options = new MarkerOptions();
        options.position(MaplibreUtils.fromDJILatLng(latLng));
        DJIBitmapDescriptor bitmapDescriptor = markerOptions.getIcon();
        if (bitmapDescriptor != null) {
            Icon i = MaplibreUtils.fromDJIBitmapDescriptor(this.context, bitmapDescriptor);
            Bitmap bitmap = i.getBitmap();
            Bitmap shadowBitmap = this.createTransparentBitmap(bitmap);
            Icon icon = IconFactory.getInstance((Context)this.context).fromBitmap(shadowBitmap);
            options.icon(icon);
        }
        Marker shadowMarker = this.mapboxMap.addMarker(options);
        String markerLayerId = this.genMarkerLayerId();
        String markerSourceId = this.genMarkerSourceId();
        SymbolLayer markerSymbolLayer = new SymbolLayer(markerLayerId, markerSourceId);
        GeoJsonSource markerSource = new GeoJsonSource(markerSourceId);
        if (this.style.isFullyLoaded()) {
            this.style.addSource((Source)markerSource);
        }
        MSymbolLayerMarker djiMarker = new MSymbolLayerMarker(this, this.mapboxMap, markerSource, markerSymbolLayer, shadowMarker, this.context, markerOptions);
        ((DJIMarker)djiMarker).setPosition(latLng);
        ((DJIMarker)djiMarker).setRotation(markerOptions.getRotation());
        DJIBitmapDescriptor iconDescriptor = markerOptions.getIcon();
        if (iconDescriptor != null) {
            String markerBitmapId = this.genMarkerBitmapId();
            iconDescriptor.setId(markerBitmapId);
            ((DJIMarker)djiMarker).setIcon(iconDescriptor);
            this.markerBitmaps.add(markerBitmapId);
        }
        ((DJIMarker)djiMarker).setTitle(markerOptions.getTitle());
        ((DJIMarker)djiMarker).setDraggable(markerOptions.getDraggable());
        ((DJIMarker)djiMarker).setAnchor(markerOptions.getAnchorU(), markerOptions.getAnchorV());
        this.addLayerByZIndex(markerOptions.getZIndex(), (Layer)markerSymbolLayer);
        this.markers.put(shadowMarker, djiMarker);
        return djiMarker;
    }

    @Override
    public Object getMap() {
        return this.mapboxMap;
    }

    private Bitmap createTransparentBitmap(Bitmap src) {
        int width = src.getWidth();
        int height = src.getHeight();
        Bitmap transparentBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)src.getConfig());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                transparentBitmap.setPixel(x, y, 0);
            }
        }
        return transparentBitmap;
    }

    public void addLayerByZIndex(long zindex, Layer layer) {
        LayerZIndex waitingLayerZIndex = new LayerZIndex(layer, zindex);
        if (0 == this.sortedLayersByZIndex.size()) {
            this.addDummySourcesAndLayers();
        }
        int size = this.sortedLayersByZIndex.size();
        for (int i = 0; i < size; ++i) {
            LayerZIndex layerZIndex = this.sortedLayersByZIndex.get(i);
            LayerZIndex nextLayerZIndex = this.sortedLayersByZIndex.get(i + 1);
            if (zindex != layerZIndex.zindex && (zindex <= layerZIndex.zindex || zindex >= nextLayerZIndex.zindex)) continue;
            Log.d((String)"joe-line-layer", (String)("layer id=" + layer.getId() + ", zindex=" + zindex + ", cur layer id=" + layerZIndex.layer.getId() + ", zindex=" + layerZIndex.zindex));
            if (this.style.isFullyLoaded()) {
                this.style.addLayerAbove(layer, layerZIndex.layer.getId());
            }
            this.sortedLayersByZIndex.add(i + 1, waitingLayerZIndex);
            break;
        }
    }

    public void updateLayerByZIndex(int zindex, Layer layer) {
        int size = this.sortedLayersByZIndex.size();
        Log.d((String)"joe-layer", (String)("updateLayerByZIndex cur layer id " + layer.getId()));
        for (int i = 0; i < size; ++i) {
            LayerZIndex layerZIndex = this.sortedLayersByZIndex.get(i);
            Log.d((String)"joe-layer", (String)("updateLayerByZIndex layer id " + layerZIndex.layer.getId()));
            if (layer != layerZIndex.layer) continue;
            if (this.style.isFullyLoaded()) {
                this.style.removeLayer(layer);
            }
            this.sortedLayersByZIndex.remove(layerZIndex);
            break;
        }
        this.addLayerByZIndex(zindex, layer);
    }

    private void removeZIndexById(String id2) {
        for (LayerZIndex zIndex : this.sortedLayersByZIndex) {
            if (!zIndex.layer.getId().equals(id2)) continue;
            this.sortedLayersByZIndex.remove(zIndex);
            break;
        }
    }

    public String genMarkerLayerId() {
        String markerLayerId = MARKER_LAYER_ID_PREFIX + this.markerLayersCount;
        ++this.markerLayersCount;
        return markerLayerId;
    }

    public String genMarkerSourceId() {
        String markerSourceId = MARKER_SOURCE_ID_PREFIX + this.markerSourcesCount;
        ++this.markerSourcesCount;
        return markerSourceId;
    }

    public String genMarkerBitmapId() {
        String markerBitmapId = MARKER_BITMAP_ID_PREFIX + this.markerBitmapsCount;
        ++this.markerBitmapsCount;
        return markerBitmapId;
    }

    public String genLineLayerId() {
        String lineLayerId = LINE_LAYER_ID_PREFIX + this.lineLayersCount;
        ++this.lineLayersCount;
        return lineLayerId;
    }

    public String genLineSourceId() {
        String lineSourceId = LINE_SOURCE_ID_PREFIX + this.lineSourceCount;
        ++this.lineSourceCount;
        return lineSourceId;
    }

    public String genSingleCircleLayerId() {
        String singleCircleLayerId = SINGLE_CIRCLE_LAYER_ID_PREFIX + this.singleCircleLayersCount;
        ++this.singleCircleLayersCount;
        return singleCircleLayerId;
    }

    public String genSingleCircleSourceId() {
        String singleCircleSourceId = SINGLE_CIRCLE_SOURCE_ID_PREFIX + this.singleCircleSourceCount;
        ++this.singleCircleSourceCount;
        return singleCircleSourceId;
    }

    public String genGroupCircleLayerId() {
        String groupCircleLayerId = GROUP_CIRCLE_LAYER_ID_PREFIX + this.groupCircleLayersCount;
        ++this.groupCircleLayersCount;
        return groupCircleLayerId;
    }

    public String genGroupCircleSourceId() {
        String groupCircleSourceId = GROUP_CIRCLE_SOURCE_ID_PREFIX + this.groupCircleSourceCount;
        ++this.groupCircleSourceCount;
        return groupCircleSourceId;
    }

    public String genMarkerCircleLayerId() {
        String markerCircleLayerId = MARKER_CIRCLE_LAYER_ID_PREFIX + this.markerCircleLayersCount;
        ++this.markerCircleLayersCount;
        return markerCircleLayerId;
    }

    public String genMarkerCircleSourceId() {
        String markerCircleSourceId = MARKER_CIRCLE_SOURCE_ID_PREFIX + this.markerSourcesCount;
        ++this.markerSourcesCount;
        return markerCircleSourceId;
    }

    @Override
    public DJICameraPosition getCameraPosition() {
        CameraPosition p = this.mapboxMap.getCameraPosition();
        return MaplibreUtils.fromCameraPosition(p);
    }

    @Override
    public void animateCamera(DJICameraUpdate cameraUpdate) {
        CameraUpdate update = MaplibreUtils.fromDJICameraUpdate(cameraUpdate);
        this.mapboxMap.animateCamera(update);
    }

    public void onCameraMove() {
        CameraPosition p = this.mapboxMap.getCameraPosition();
        DJICameraPosition cameraPosition = MaplibreUtils.fromCameraPosition(p);
        this.onCameraChange(cameraPosition);
    }

    @Override
    public void moveCamera(DJICameraUpdate cameraUpdate) {
        CameraUpdate update = MaplibreUtils.fromDJICameraUpdate(cameraUpdate);
        this.mapboxMap.moveCamera(update);
    }

    @Override
    public void setInfoWindowAdapter(DJIMap.InfoWindowAdapter adapter) {
        this.mapboxMap.setInfoWindowAdapter(marker -> {
            if (this.markers.containsKey(marker)) {
                DJIMarker realMarker = this.markers.get(marker);
                return adapter.getInfoWindow(realMarker);
            }
            return null;
        });
    }

    public boolean onMapLongClick(@NonNull LatLng point) {
        Projection projection = this.mapboxMap.getProjection();
        PointF longClickScreenPoint = projection.toScreenLocation(point);
        float minDistanceOfPixel = 60.0f;
        float currentMinDistance = Float.MAX_VALUE;
        Marker candidateMarker = null;
        for (Map.Entry<Marker, DJIMarker> entry : this.markers.entrySet()) {
            float yDis;
            boolean isDraggable = this.markers.get(entry.getKey()).isDraggable();
            if (!isDraggable) continue;
            PointF markerPoint = projection.toScreenLocation(entry.getKey().getPosition());
            float xDis = Math.abs(markerPoint.x - longClickScreenPoint.x);
            float distance = (float)Math.sqrt(xDis * xDis + (yDis = Math.abs(markerPoint.y - longClickScreenPoint.y)) * yDis);
            if (!(distance < minDistanceOfPixel) || !(distance < currentMinDistance)) continue;
            candidateMarker = entry.getKey();
            this.isCatchTouch = true;
        }
        if (this.isCatchTouch) {
            this.currentSelectedMarker = candidateMarker;
            this.onMarkerDragStart(this.markers.get(this.currentSelectedMarker));
            return true;
        }
        this.onMapLongClick(MaplibreUtils.fromLatLng(point));
        return false;
    }

    public boolean onTouch(View v, MotionEvent motionEvent) {
        int action = motionEvent.getAction();
        if (action == 1) {
            if (this.isCatchTouch && this.currentSelectedMarker != null) {
                this.onMarkerDragEnd(this.markers.get(this.currentSelectedMarker));
            }
            this.isCatchTouch = false;
        }
        if (this.isCatchTouch && this.currentSelectedMarker != null) {
            if (action == 2) {
                float x = motionEvent.getX();
                float y = motionEvent.getY();
                LatLng latLng = this.mapboxMap.getProjection().fromScreenLocation(new PointF(x, y));
                this.currentSelectedMarker.setPosition(latLng);
                DJIMarker djiMarker = this.markers.get(this.currentSelectedMarker);
                djiMarker.setPosition(MaplibreUtils.fromLatLng(latLng));
                this.onMarkerDrag(djiMarker);
            }
            return true;
        }
        return false;
    }

    @Override
    public void setMapType(DJIMap.MapType type, OnMapTypeLoadedListener listener2) {
        this.setMapType(type);
        this.onMapTypeLoadedListener = listener2;
    }

    @Override
    public void setMapType(int type) {
        this.stoppingWorld = true;
        this.clearSourcesAndLayers();
        switch (type) {
            case 2: {
                this.mapboxMap.setStyle("mapbox://styles/mapbox/satellite-v9", (Style.OnStyleLoaded)this);
                break;
            }
            case 4: {
                this.mapboxMap.setStyle("mapbox://styles/mapbox/satellite-streets-v11", (Style.OnStyleLoaded)this);
                break;
            }
            default: {
                this.mapboxMap.setStyle("mapbox://styles/mapbox/streets-v11", (Style.OnStyleLoaded)this);
            }
        }
    }

    @Override
    public void setMapType(DJIMap.MapType type) {
        this.stoppingWorld = true;
        this.clearSourcesAndLayers();
        switch (type) {
            case NORMAL: {
                this.mapboxMap.setStyle("mapbox://styles/mapbox/streets-v11", (Style.OnStyleLoaded)this);
                break;
            }
            case SATELLITE: {
                this.mapboxMap.setStyle("mapbox://styles/mapbox/satellite-v9", (Style.OnStyleLoaded)this);
                break;
            }
            case HYBRID: {
                this.mapboxMap.setStyle("mapbox://styles/mapbox/satellite-streets-v11", (Style.OnStyleLoaded)this);
                break;
            }
            default: {
                this.mapboxMap.setStyle("mapbox://styles/mapbox/streets-v11", (Style.OnStyleLoaded)this);
            }
        }
    }

    public void onStyleLoaded(@NonNull Style style2) {
        this.style = style2;
        this.stoppingWorld = false;
        this.sortedLayersByZIndex.clear();
        this.updateState();
        if (this.onMapTypeLoadedListener != null) {
            this.onMapTypeLoadedListener.onMapTypeLoaded();
            this.onMapTypeLoadedListener = null;
        }
    }

    private void updateState() {
        Object layer;
        this.addDummySourcesAndLayers();
        for (DJIMarker marker : this.markers.values()) {
            layer = (MSymbolLayerMarker)marker;
            ((MSymbolLayerMarker)layer).updateSourceLayer();
        }
        for (DJIPolyline polyline : this.polylines) {
            layer = (MLineLayerPolyline)polyline;
            ((MLineLayerPolyline)layer).updateSourceLayer();
        }
        for (DJICircle singleCircle : this.singleCircles) {
            layer = (MCircle)singleCircle;
            ((MCircle)layer).updateSourceLayer();
        }
        for (DJIGroupCircle groupCircle : this.groupCircles) {
            layer = (MGroupCircle)groupCircle;
            ((MGroupCircle)layer).updateSourceLayer();
        }
        for (DJICircle markerCircle : this.markerCircles) {
            layer = (MMarkerCircle)markerCircle;
            ((MMarkerCircle)layer).updateSourceLayer();
        }
    }

    @Override
    @NonNull
    public DJIPolyline addPolyline(DJIPolylineOptions options) {
        if (options.getPoints().size() == 1) {
            DJILatLng latLng = options.getPoints().get(0);
            options.getPoints().add(new DJILatLng(latLng.getLatitude(), latLng.getLongitude()));
        }
        String lineLayerId = this.genLineLayerId();
        String lineSourceId = this.genLineSourceId();
        LineLayer lineLayer = new LineLayer(lineLayerId, lineSourceId);
        GeoJsonSource lineSource = new GeoJsonSource(lineSourceId);
        if (this.style.isFullyLoaded()) {
            this.style.addSource((Source)lineSource);
        }
        if (options.isDashed()) {
            lineLayer.setProperties(new PropertyValue[]{PropertyFactory.lineDasharray((Float[])new Float[]{Float.valueOf(options.getDashLength()), Float.valueOf(options.getDashLength())})});
        }
        MLineLayerPolyline polyline = new MLineLayerPolyline(this, this.mapboxMap, lineLayer, lineSource, options);
        polyline.setPoints(options.getPoints());
        polyline.setColor(options.getColor());
        polyline.setWidth(options.getWidth());
        this.addLayerByZIndex((long)options.getZIndex(), (Layer)lineLayer);
        this.polylines.add(polyline);
        return polyline;
    }

    @Override
    @Nullable
    public DJIPolygon addPolygon(DJIPolygonOptions options) {
        Polygon polygon = this.mapboxMap.addPolygon(MaplibreUtils.fromDJIPolygonOptions(options));
        return new MPolygon(polygon, this.mapboxMap, options);
    }

    @Override
    @Nullable
    public DJICircle addMarkerCircle(DJICircleOptions options) {
        String markerCircleLayerId = this.genMarkerCircleLayerId();
        String markerCircleSourceId = this.genMarkerCircleSourceId();
        CircleLayer markerCircleLayer = new CircleLayer(markerCircleLayerId, markerCircleSourceId);
        GeoJsonSource markerCircleSource = new GeoJsonSource(markerCircleSourceId);
        if (this.style.isFullyLoaded()) {
            this.style.addSource((Source)markerCircleSource);
        }
        MMarkerCircle markerCircle = new MMarkerCircle(this, this.mapboxMap, markerCircleLayer, markerCircleSource, options);
        markerCircle.setVisible(true);
        markerCircle.setCircle(options.getCenter(), options.getRadius());
        markerCircle.setFillColor(options.getFillColor());
        markerCircle.setStrokeColor(options.getStrokeColor());
        this.addLayerByZIndex((long)options.getZIndex(), (Layer)markerCircleLayer);
        this.markerCircles.add(markerCircle);
        return markerCircle;
    }

    @Override
    @Nullable
    public DJICircle addSingleCircle(DJICircleOptions options) {
        String singleCircleLayerId = this.genSingleCircleLayerId();
        String singleCircleSourceId = this.genSingleCircleSourceId();
        FillLayer singleCircleSymboLayer = new FillLayer(singleCircleLayerId, singleCircleSourceId);
        GeoJsonSource singleCircleSource = new GeoJsonSource(singleCircleSourceId);
        if (this.style.isFullyLoaded()) {
            this.style.addSource((Source)singleCircleSource);
        }
        MCircle singleCircle = new MCircle(this, this.mapboxMap, singleCircleSymboLayer, singleCircleSource, options);
        singleCircle.setVisible(true);
        singleCircle.setCircle(options.getCenter(), options.getRadius());
        singleCircle.setFillColor(options.getFillColor());
        singleCircle.setStrokeColor(options.getStrokeColor());
        this.addLayerByZIndex((long)options.getZIndex(), (Layer)singleCircleSymboLayer);
        this.singleCircles.add(singleCircle);
        return singleCircle;
    }

    @Override
    @Nullable
    public DJIGroupCircle addGroupCircle(DJIGroupCircleOptions options) {
        if (options.getRadius().size() != options.getCenters().size() || options.getRadius().size() == 0) {
            return null;
        }
        String groupCircleLayerId = this.genGroupCircleLayerId();
        String groupCircleSourceId = this.genGroupCircleSourceId();
        FillLayer groupCircleSymboLayer = new FillLayer(groupCircleLayerId, groupCircleSourceId);
        GeoJsonSource groupCircleSource = new GeoJsonSource(groupCircleSourceId);
        if (this.style.isFullyLoaded()) {
            this.style.addSource((Source)groupCircleSource);
        }
        MGroupCircle groupCircle = new MGroupCircle(this, this.mapboxMap, groupCircleSymboLayer, groupCircleSource, options);
        groupCircle.setCircles(options.getCenters(), options.getRadius());
        groupCircle.setFillColor(options.getFillColor());
        groupCircle.setStrokeColor(options.getStrokeColor());
        groupCircle.setVisible(true);
        this.addLayerByZIndex((long)options.getZIndex(), (Layer)groupCircleSymboLayer);
        this.groupCircles.add(groupCircle);
        return groupCircle;
    }

    @Override
    public DJIUiSettings getUiSettings() {
        return new MUiSettings(this.mapboxMap.getUiSettings());
    }

    @Override
    public void snapshot(MapScreenShotListener callback) {
        this.mapboxMap.snapshot(snapshot -> callback.onMapScreenShot(snapshot));
    }

    @Override
    public DJIProjection getProjection() {
        return new MProjection(this.mapboxMap.getProjection());
    }

    @Override
    public void clear() {
        this.removeAllOnCameraChangeListeners();
        this.removeAllOnMarkerClickListener();
        this.mapboxMap.clear();
        this.mapboxMap.setInfoWindowAdapter(null);
    }

    public boolean onInfoWindowClick(@NonNull Marker marker) {
        if (this.markers.containsKey(marker)) {
            DJIMarker realMarker = this.markers.get(marker);
            this.onInfoWindowClick(realMarker);
        }
        return false;
    }

    public boolean onMapClick(@NonNull LatLng point) {
        DJILatLng latLng = MaplibreUtils.fromLatLng(point);
        this.onMapClick(latLng);
        return true;
    }

    public boolean onMarkerClick(@NonNull Marker marker) {
        if (this.markers.containsKey(marker)) {
            DJIMarker realMarker = this.markers.get(marker);
            this.onMarkerClick(realMarker);
        }
        return true;
    }

    public void onMarkerRemove(Marker marker) {
        if (this.markers.containsKey(marker) && this.style.isFullyLoaded()) {
            DJIMarker djiMarker = this.markers.get(marker);
            if (djiMarker instanceof MSymbolLayerMarker) {
                MSymbolLayerMarker symbolLayerMarker = (MSymbolLayerMarker)djiMarker;
                Layer removeLayer = this.style.getLayer(symbolLayerMarker.getLayerId());
                if (removeLayer != null) {
                    this.style.removeLayer(removeLayer);
                    this.removeZIndexById(removeLayer.getId());
                }
                this.style.removeSource(symbolLayerMarker.getSourceId());
                symbolLayerMarker.setSource(null);
                symbolLayerMarker.setSymbolLayer(null);
            }
            this.markers.remove(marker);
        }
    }

    public void onPolylineRemove(DJIPolyline polyline) {
        if (this.polylines.contains(polyline) && this.style.isFullyLoaded()) {
            if (polyline instanceof MLineLayerPolyline) {
                MLineLayerPolyline lineLayerPolyline = (MLineLayerPolyline)polyline;
                this.style.removeSource(lineLayerPolyline.getSourceId());
                Layer removeLayer = this.style.getLayer(lineLayerPolyline.getLayerId());
                if (removeLayer != null) {
                    this.style.removeLayer(removeLayer);
                    this.removeZIndexById(removeLayer.getId());
                }
            }
            this.polylines.remove(polyline);
        }
    }

    public void onSingleCircleRemove(DJICircle djiSingleCircle) {
        if (this.singleCircles.contains(djiSingleCircle) && this.style.isFullyLoaded()) {
            if (djiSingleCircle instanceof MCircle) {
                MCircle singleCircle = (MCircle)djiSingleCircle;
                this.style.removeSource(singleCircle.getSourceId());
                Layer removeLayer = this.style.getLayer(singleCircle.getLayerId());
                if (removeLayer != null) {
                    this.style.removeLayer(removeLayer);
                    this.removeZIndexById(removeLayer.getId());
                }
            }
            this.singleCircles.remove(djiSingleCircle);
        }
    }

    public void onGroupCircleRemove(DJIGroupCircle djiGroupCircle) {
        if (this.groupCircles.contains(djiGroupCircle) && this.style.isFullyLoaded()) {
            if (djiGroupCircle instanceof MGroupCircle) {
                MGroupCircle groupCircle = (MGroupCircle)djiGroupCircle;
                this.style.removeSource(groupCircle.getSourceId());
                Layer removeLayer = this.style.getLayer(groupCircle.getLayerId());
                if (removeLayer != null) {
                    this.style.removeLayer(removeLayer);
                    this.removeZIndexById(removeLayer.getId());
                }
            }
            this.groupCircles.remove(djiGroupCircle);
        }
    }

    public void onMarkerCircleRemove(DJICircle djiMarkerCircle) {
        if (this.markerCircles.contains(djiMarkerCircle) && this.style.isFullyLoaded()) {
            if (djiMarkerCircle instanceof MMarkerCircle) {
                MMarkerCircle markerCircle = (MMarkerCircle)djiMarkerCircle;
                this.style.removeSource(markerCircle.getSourceID());
                Layer removeLayer = this.style.getLayer(markerCircle.getLayerId());
                if (removeLayer != null) {
                    this.style.removeLayer(removeLayer);
                    this.removeZIndexById(removeLayer.getId());
                }
            }
            this.markerCircles.remove(djiMarkerCircle);
        }
    }

    public boolean isStoppingWorld() {
        return this.stoppingWorld;
    }

    private class LayerZIndex {
        Layer layer;
        long zindex;

        LayerZIndex(Layer layer, long zindex) {
            this.layer = layer;
            this.zindex = zindex;
        }
    }
}

