/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.mapkit.maplibre.annotations;

import androidx.annotation.ColorInt;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.annotations.PolylineOptions;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import dji.v5.ux.mapkit.core.models.DJILatLng;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolygon;
import dji.v5.ux.mapkit.core.models.annotations.DJIPolygonOptions;
import dji.v5.ux.mapkit.maplibre.utils.MaplibreUtils;
import java.util.ArrayList;
import java.util.List;

public class MPolygon
implements DJIPolygon {
    private static final float NO_ALPHA = 0.0f;
    private MapboxMap mapboxMap;
    private Polygon polygon;
    private DJIPolygonOptions options;
    private Polyline border;
    private float borderAlpha;

    public MPolygon(Polygon polygon, MapboxMap mapboxMap, DJIPolygonOptions options) {
        this.polygon = polygon;
        this.mapboxMap = mapboxMap;
        this.options = options;
        PolylineOptions polylineOptions = new PolylineOptions();
        polylineOptions.addAll((Iterable)polygon.getPoints()).add((LatLng)polygon.getPoints().get(0)).color(options.getStrokeColor()).width(options.getStrokeWidth() / 5.0f);
        this.borderAlpha = polylineOptions.getAlpha();
        this.border = mapboxMap.addPolyline(polylineOptions);
    }

    @Override
    public void remove() {
        this.mapboxMap.removePolygon(this.polygon);
        if (this.border != null) {
            this.mapboxMap.removePolyline(this.border);
        }
    }

    @Override
    public boolean isVisible() {
        boolean visible = this.polygon.getAlpha() != 0.0f;
        return visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.polygon.setAlpha(this.options.getAlpha());
            if (this.border != null) {
                this.border.setAlpha(this.borderAlpha);
            }
        } else {
            this.polygon.setAlpha(0.0f);
            if (this.border != null) {
                this.border.setAlpha(0.0f);
            }
        }
    }

    @Override
    public void setPoints(List<DJILatLng> points) {
        ArrayList<LatLng> mPoints = new ArrayList<LatLng>(points.size());
        for (DJILatLng latLng : points) {
            mPoints.add(MaplibreUtils.fromDJILatLng(latLng));
        }
        this.polygon.setPoints(mPoints);
    }

    @Override
    public List<DJILatLng> getPoints() {
        ArrayList<DJILatLng> djiPoints = new ArrayList<DJILatLng>(this.polygon.getPoints().size());
        for (LatLng latLng : this.polygon.getPoints()) {
            djiPoints.add(MaplibreUtils.fromLatLng(latLng));
        }
        return djiPoints;
    }

    @Override
    public void setFillColor(@ColorInt int color2) {
        this.polygon.setFillColor(color2);
    }

    @Override
    public int getFillColor() {
        return this.polygon.getFillColor();
    }

    @Override
    public void setStrokeColor(@ColorInt int color2) {
        this.polygon.setStrokeColor(color2);
        if (this.border != null) {
            this.border.setColor(color2);
        }
    }

    @Override
    public int getStrokeColor() {
        if (this.border != null) {
            return this.border.getColor();
        }
        return this.polygon.getStrokeColor();
    }

    @Override
    public void setStrokeWidth(float strokeWidth) {
        if (this.border != null) {
            this.border.setWidth(strokeWidth);
        }
    }

    @Override
    public float getStrokeWidth() {
        if (this.border != null) {
            return this.border.getWidth();
        }
        return 0.0f;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MPolygon mPolygon1 = (MPolygon)o;
        if (this.mapboxMap != null ? !this.mapboxMap.equals(mPolygon1.mapboxMap) : mPolygon1.mapboxMap != null) {
            return false;
        }
        return this.polygon != null ? this.polygon.equals((Object)mPolygon1.polygon) : mPolygon1.polygon == null;
    }

    public int hashCode() {
        int result = this.mapboxMap != null ? this.mapboxMap.hashCode() : 0;
        result = 31 * result + (this.polygon != null ? this.polygon.hashCode() : 0);
        return result;
    }
}

