/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.flight.flightparam;

import androidx.annotation.NonNull;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.flightcontroller.GoHomePathMode;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.util.DataProcessor;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;

public class DistanceLimitWidgetModel
extends WidgetModel {
    private final DataProcessor<Integer> goHomeHeightDataProcessor = DataProcessor.create(500);
    private final DataProcessor<Integer> heightLimitDataProcessor = DataProcessor.create(500);
    private final DataProcessor<Integer> distanceLimitDataProcessor = DataProcessor.create(5000);
    private final DataProcessor<Boolean> distanceLimitEnableDataProcessor = DataProcessor.create(false);
    private final DataProcessor<GoHomePathMode> goHomePathModeProcessor = DataProcessor.create(GoHomePathMode.UNKNOWN);

    protected DistanceLimitWidgetModel(@NonNull DJISDKModel djiSdkModel, @NonNull ObservableInMemoryKeyedStore uxKeyManager) {
        super(djiSdkModel, uxKeyManager);
    }

    @Override
    protected void inSetup() {
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyGoHomeHeight), this.goHomeHeightDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyHeightLimit), this.heightLimitDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyDistanceLimit), this.distanceLimitDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyDistanceLimitEnabled), this.distanceLimitEnableDataProcessor);
        this.bindDataProcessor(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyGoHomePathMode), this.goHomePathModeProcessor);
    }

    @Override
    protected void inCleanup() {
    }

    public Flowable<GoHomePathMode> getGoHomePathMode() {
        return this.goHomePathModeProcessor.toFlowable();
    }

    public Flowable<Integer> getGoHomeHeight() {
        return this.goHomeHeightDataProcessor.toFlowable();
    }

    public Completable setGoHomeHeight(int value) {
        return this.djiSdkModel.setValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyGoHomeHeight), value);
    }

    public Flowable<Integer> getHomeLimitHeight() {
        return this.heightLimitDataProcessor.toFlowable();
    }

    public Completable setHeightLimit(int value) {
        return this.djiSdkModel.setValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyHeightLimit), value);
    }

    public Flowable<Integer> getDistanceLimit() {
        return this.distanceLimitDataProcessor.toFlowable();
    }

    public Completable setDistanceLimit(int value) {
        return this.djiSdkModel.setValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyDistanceLimit), value);
    }

    public Flowable<Boolean> getDistanceLimitEnabled() {
        return this.distanceLimitEnableDataProcessor.toFlowable();
    }

    public Completable setDistanceLimitEnabled(boolean value) {
        return this.djiSdkModel.setValue(KeyTools.createKey((DJIKeyInfo)FlightControllerKey.KeyDistanceLimitEnabled), value);
    }
}

