/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.hd.frequency;

import android.content.Context;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dji.sdk.keyvalue.key.AirLinkKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.KeyTools;
import dji.sdk.keyvalue.value.airlink.Bandwidth;
import dji.sdk.keyvalue.value.airlink.ChannelSelectionMode;
import dji.sdk.keyvalue.value.airlink.FrequencyInterferenceInfo;
import dji.v5.common.callback.CommonCallbacks;
import dji.v5.common.error.IDJIError;
import dji.v5.manager.KeyManager;
import dji.v5.utils.common.LogUtils;
import dji.v5.utils.common.SDRLinkHelper;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.charts.model.Line;
import dji.v5.ux.core.base.charts.model.LineChartData;
import dji.v5.ux.core.base.charts.model.PointValue;
import dji.v5.ux.core.base.charts.model.Viewport;
import dji.v5.ux.core.base.charts.view.LineChartView;
import dji.v5.ux.core.base.widget.ConstraintLayoutWidget;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.widget.hd.frequency.ChartRightYAxisView;
import dji.v5.ux.core.widget.hd.frequency.DistanceLineView;
import dji.v5.ux.core.widget.hd.frequency.FreqRangeRectView;
import dji.v5.ux.core.widget.hd.frequency.FreqRangeTextView;
import dji.v5.ux.core.widget.hd.frequency.FreqViewModel;
import dji.v5.ux.core.widget.hd.frequency.RectCenterTextView;
import java.util.ArrayList;
import java.util.List;

public class FreqView
extends ConstraintLayoutWidget<Object> {
    private static final String TAG = "FreqView";
    private LineChartView mSdrSnrLine;
    private LineChartData mSnrValues;
    private FreqRangeRectView mRangeRect;
    private FreqRangeTextView mRangeTv;
    private RectCenterTextView mAverageTv;
    private TextView mCustomTipTv;
    private ChartRightYAxisView mQualityTx;
    private DistanceLineView mQualityLine;
    private static final int M_MIN_VALUE_COLOR = -6954177;
    private static final int M_MAX_VALUE_COLOR = -507326;
    public static final int LINE_MAX_VALUE = 50;
    public static final int NF_BASE_VALUE = -110;
    public static final int NF_MAX_VALUE = -60;
    private final int RSSI_VALUE_NUM_2DOT4G = 41;
    private final int RSSI_VALUE_NUM_5DOT8G = 62;
    private final int RSSI_VALUE_NUM_5DOT7G = 10;
    private final int RSSI_VALUE_NUM_1DOT4G = 7;
    private final int RSSI_VALUE_NUM_5DOT2G = 51;
    private int mNumRssiValues = 41;
    private final float START_INDEX_2DOT4G = 2400.0f;
    private final float START_INDEX_5DOT8G = 5725.0f;
    private final float START_INDEX_5DOT7G = 5650.0f;
    private final float START_INDEX_1DOT4G = 1430.0f;
    private final float START_INDEX_5DOT2G = 5150.0f;
    private float mRssiStartIndex = 2400.0f;
    private final int NF_VALUE_NUM_2DOT4G = 82;
    private final int NF_VALUE_NUM_5DOT8G = 124;
    private final int NF_VALUE_NUM_5DOT7G = 20;
    private final int NF_VALUE_NUM_1DOT4G = 14;
    private final int NF_VALUE_NUM_5DOT2G = 102;
    private int mNumNfValues = 82;
    private float mWidthInterval = 1.0f;
    private FreqBand mCurFreqBand = FreqBand.FREQ_BAND_2DOT4G;
    private FreqViewModel widgetModel = new FreqViewModel(DJISDKModel.getInstance(), ObservableInMemoryKeyedStore.getInstance());
    private Bandwidth mCurBandWidth;
    private ChannelSelectionMode mSelectionMode;
    private Integer[] mValidRanges;
    private int mDisOffset = 0;
    private Integer mFreqIndex;
    private boolean is5Dot7Supported;

    @Override
    protected void initView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this.initView();
    }

    @Override
    protected void reactToModelChanges() {
        this.addReaction(this.widgetModel.getFrequencyPointIndex().subscribe(value -> {
            this.mFreqIndex = value;
            this.onFreqIndexChanged();
        }));
        this.addReaction(this.widgetModel.getChannelSelectionMode().subscribe(value -> {
            this.mSelectionMode = value;
            this.updateCustomTipVisibility(this.mSelectionMode);
        }));
        this.addReaction(this.widgetModel.getBandwidth().subscribe(value -> {
            this.mCurBandWidth = value;
        }));
        KeyManager.getInstance().listen(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyFrequencyInterference), (Object)this, (oldValue, newValue) -> this.setValues((List<FrequencyInterferenceInfo>)newValue));
        this.addReaction(this.widgetModel.getFrequencyPointIndexRange().subscribe(value -> {
            this.mValidRanges = new Integer[2];
            this.mValidRanges[0] = value.getMin();
            this.mValidRanges[1] = value.getMax();
            this.onValidRangeChanged();
        }));
        this.addReaction(this.widgetModel.getSDRHdOffsetParams().subscribe(value -> {
            this.mDisOffset = value.getDistOffset().byteValue();
            this.onDistOffsetChanged();
        }));
        this.addReaction(this.widgetModel.is5Dot7GSupported().subscribe(value -> {
            this.is5Dot7Supported = value;
        }));
    }

    public FreqView(Context context) {
        this(context, null);
    }

    public FreqView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    private void initView() {
        View.inflate((Context)this.getContext(), (int)R.layout.uxsdk_sdr_freq_view, (ViewGroup)this);
        this.mSdrSnrLine = (LineChartView)this.findViewById(R.id.sdr_snr_line);
        KeyManager.getInstance().getValue(KeyTools.createKey((DJIKeyInfo)AirLinkKey.KeyFrequencyPoint), (CommonCallbacks.CompletionCallbackWithParam)new CommonCallbacks.CompletionCallbackWithParam<Integer>(){

            public void onSuccess(Integer integer) {
                FreqView.this.mFreqIndex = integer;
                FreqView.this.onFreqIndexChanged();
                FreqView.this.initValues();
                FreqView.this.mSdrSnrLine.setLineChartData(FreqView.this.mSnrValues);
                FreqView.this.mSdrSnrLine.setZoomEnabled(false);
                FreqView.this.mSdrSnrLine.setLineShader((Shader)new LinearGradient(0.0f, FreqView.this.getResources().getDimension(R.dimen.uxsdk_setting_ui_hd_sdr_chart_height), 0.0f, 0.0f, -6954177, -507326, Shader.TileMode.MIRROR));
                FreqView.this.mSdrSnrLine.setViewportCalculationEnabled(true);
            }

            public void onFailure(@NonNull IDJIError error) {
                LogUtils.e((String)FreqView.TAG, (Object[])new Object[]{"get frequency point failed: " + error.description()});
            }
        });
        this.resetViewport();
        this.mQualityTx = (ChartRightYAxisView)this.findViewById(R.id.sdr_quality_value);
        this.mQualityLine = (DistanceLineView)this.findViewById(R.id.sdr_quality_line);
        this.mCustomTipTv = (TextView)this.findViewById(R.id.sdr_custom_alert_tip);
        this.mRangeTv = (FreqRangeTextView)this.findViewById(R.id.sdr_freq_range_tv);
        this.mAverageTv = (RectCenterTextView)this.findViewById(R.id.sdr_rect_average_value);
        this.mRangeRect = (FreqRangeRectView)this.findViewById(R.id.sdr_snr_freq_range_rect);
        this.mRangeRect.setOnRangeChangedListener(new FreqRangeRectView.OnRangeChangedListener(){

            @Override
            public void onRangeChanged(float leftVal, float rightVal, float leftPos, float rightPos, boolean isRectDragging) {
                if (!isRectDragging) {
                    FreqView.this.mRangeTv.setMinMaxValue(leftVal + 0.5f, rightVal + 0.5f, leftPos, rightPos);
                } else {
                    FreqView.this.mRangeTv.setMinMaxValue(leftVal, rightVal, leftPos, rightPos);
                }
                FreqView.this.mAverageTv.setCenterPos((leftPos + rightPos) / 2.0f, isRectDragging);
            }

            @Override
            public void onAverageValChanged(String averageVal) {
                FreqView.this.mAverageTv.setCenterAverageText(averageVal);
            }
        });
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.setup();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode()) {
            this.widgetModel.cleanup();
        }
        KeyManager.getInstance().cancelListen((Object)this);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.isInEditMode()) {
            return;
        }
        if (changed) {
            this.mWidthInterval = (float)this.mSdrSnrLine.getWidth() * 1.0f / (float)(this.mNumNfValues - 1);
            this.mRangeRect.setWidthInterval(this.mWidthInterval).setNumValues(this.mNumNfValues).setParentWidth(this.mSdrSnrLine.getWidth()).onValidRangeChanged();
            this.onValidRangeChanged();
            this.onDistOffsetChanged();
        }
    }

    private void initValues() {
        ArrayList<PointValue> values = new ArrayList<PointValue>();
        values.add(new PointValue(0.0f, 0.0f));
        for (int i = 0; i < this.mNumRssiValues; ++i) {
            values.add(new PointValue((float)i + 0.5f, 0.0f));
        }
        values.add(new PointValue(this.mNumRssiValues, 0.0f));
        Line line = new Line(values);
        line.setStrokeWidth(2);
        line.setHasPoints(false);
        ArrayList<Line> lines = new ArrayList<Line>();
        lines.add(line);
        this.mSnrValues = new LineChartData(lines);
    }

    private void resetViewport() {
        Viewport v = new Viewport(this.mSdrSnrLine.getMaximumViewport());
        v.bottom = 0.0f;
        v.top = 50.0f;
        v.left = 0.0f;
        v.right = this.mNumRssiValues;
        this.mSdrSnrLine.setMaximumViewport(v);
        this.mSdrSnrLine.setCurrentViewport(v);
    }

    private void setValues(List<FrequencyInterferenceInfo> values) {
        if (values == null) {
            return;
        }
        this.mSdrSnrLine.clearAnimation();
        Line line = this.mSdrSnrLine.getLineChartData().getLines().get(0);
        int rssiValIndex = 0;
        int pointIndex = 0;
        int size = line.getValues().size();
        for (PointValue value : line.getValues()) {
            float y = 0.0f;
            if (pointIndex == 0) {
                y = (float)values.get(rssiValIndex).getRssi().intValue() + 10.0f - -110.0f;
            } else if (pointIndex == values.size() + 1) {
                y = (float)values.get(pointIndex - 2).getRssi().intValue() + 10.0f - -110.0f;
            } else {
                if (rssiValIndex >= size) {
                    LogUtils.e((String)TAG, (Object[])new Object[]{"Illegal state,rssiValIndex >= line.getValues().size(),"});
                    return;
                }
                y = (float)values.get(rssiValIndex++).getRssi().intValue() - -110.0f;
            }
            if (y > 50.0f) {
                y = 50.0f;
            }
            if (y < 0.0f) {
                y = 0.0f;
            }
            value.setTarget(value.getX(), y);
            ++pointIndex;
        }
        this.mSdrSnrLine.startDataAnimation(300L);
    }

    private void onValidRangeChanged() {
        if (this.mCurBandWidth == null || this.mSelectionMode == null || this.mValidRanges == null) {
            return;
        }
        float selectRange = 5.0f;
        if (this.mCurBandWidth == Bandwidth.BANDWIDTH_20MHZ) {
            selectRange = 10.0f;
        } else if (this.mCurBandWidth == Bandwidth.BANDWIDTH_40MHZ) {
            selectRange = 20.0f;
        }
        float left = this.mValidRanges[0].intValue();
        float right = this.mValidRanges[1].intValue();
        if (left != 2400.0f) {
            left -= selectRange;
            right += selectRange;
        }
        Viewport v = new Viewport(this.mSdrSnrLine.getMaximumViewport());
        v.bottom = 0.0f;
        v.top = 50.0f;
        v.left = (left - this.mRssiStartIndex) / 2.0f;
        v.right = (right - this.mRssiStartIndex) / 2.0f;
        if (v.left < 0.0f) {
            v.left = 0.0f;
        }
        if (v.right > (float)this.mNumRssiValues) {
            v.right = this.mNumRssiValues;
        }
        this.mSdrSnrLine.setMaximumViewport(v);
        this.mSdrSnrLine.setCurrentViewport(v);
        this.updateCustomTipVisibility(this.mSelectionMode);
    }

    private void updateCustomTipVisibility(ChannelSelectionMode selectionMode) {
        if (selectionMode == ChannelSelectionMode.AUTO) {
            this.mCustomTipTv.setVisibility(8);
        } else {
            this.mCustomTipTv.setVisibility(0);
        }
    }

    private void onDistOffsetChanged() {
        this.mQualityTx.set1KmNfValue(this.mDisOffset);
        this.mQualityLine.set1KmNfValue(this.mDisOffset);
    }

    private void onFreqIndexChanged() {
        FreqBand old = this.mCurFreqBand;
        if (SDRLinkHelper.isFrequencyIndexIn2dot4G((int)this.mFreqIndex)) {
            this.mCurFreqBand = FreqBand.FREQ_BAND_2DOT4G;
            this.mNumRssiValues = 41;
            this.mRssiStartIndex = 2400.0f;
            this.mNumNfValues = 82;
        } else if (SDRLinkHelper.isFrequencyIndexIn5dot8G((int)this.mFreqIndex) && !this.is5Dot7Supported) {
            this.mCurFreqBand = FreqBand.FREQ_BAND_5DOT8G;
            this.mNumRssiValues = 62;
            this.mRssiStartIndex = 5725.0f;
            this.mNumNfValues = 124;
        } else if (SDRLinkHelper.isFrequencyIndex5dot2G((int)this.mFreqIndex)) {
            this.mCurFreqBand = FreqBand.FREQ_BAND_5DOT2G;
            this.mNumRssiValues = 51;
            this.mRssiStartIndex = 5150.0f;
            this.mNumNfValues = 102;
        } else if (SDRLinkHelper.isFrequencyIndexIn5dot7G((int)this.mFreqIndex)) {
            this.mCurFreqBand = FreqBand.FREQ_BAND_5DOT7G;
            this.mNumRssiValues = 10;
            this.mRssiStartIndex = 5650.0f;
            this.mNumNfValues = 20;
        } else if (SDRLinkHelper.isFrequencyIndexIn840M((int)this.mFreqIndex) || SDRLinkHelper.isFrequencyIndexIn1dot4G((int)this.mFreqIndex)) {
            this.mCurFreqBand = FreqBand.FREQ_BAND_1DOT4G;
            this.mNumRssiValues = 7;
            this.mRssiStartIndex = 1430.0f;
            this.mNumNfValues = 14;
        }
        if (this.mCurFreqBand != old) {
            this.initValues();
            this.mSdrSnrLine.setLineChartData(this.mSnrValues);
            this.resetViewport();
            this.onValidRangeChanged();
        }
        LogUtils.d((String)TAG, (Object[])new Object[]{"onFreqIndexChanged mNumRssiValues: " + this.mNumRssiValues + "  mCurFreqBand: " + (Object)((Object)this.mCurFreqBand) + "  old: " + (Object)((Object)old)});
    }

    private static enum FreqBand {
        FREQ_BAND_2DOT4G,
        FREQ_BAND_5DOT8G,
        FREQ_BAND_1DOT4G,
        FREQ_BAND_5DOT7G,
        FREQ_BAND_840M,
        FREQ_BAND_5DOT2G;

    }
}

