/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.widget.fpv;

import android.view.Surface;
import dji.sdk.keyvalue.key.CameraKey;
import dji.sdk.keyvalue.key.DJIKeyInfo;
import dji.sdk.keyvalue.key.FlightControllerKey;
import dji.sdk.keyvalue.value.camera.CameraType;
import dji.sdk.keyvalue.value.camera.CameraVideoStreamSourceType;
import dji.sdk.keyvalue.value.camera.VideoResolutionFrameRate;
import dji.sdk.keyvalue.value.common.CameraLensType;
import dji.sdk.keyvalue.value.common.ComponentIndexType;
import dji.v5.et.DJIKeyInfoEtKt;
import dji.v5.manager.datacenter.MediaDataCenter;
import dji.v5.manager.interfaces.ICameraStreamManager;
import dji.v5.utils.common.StringUtils;
import dji.v5.ux.R;
import dji.v5.ux.core.base.DJISDKModel;
import dji.v5.ux.core.base.ICameraIndex;
import dji.v5.ux.core.base.WidgetModel;
import dji.v5.ux.core.communication.ObservableInMemoryKeyedStore;
import dji.v5.ux.core.module.FlatCameraModule;
import dji.v5.ux.core.util.CameraUtil;
import dji.v5.ux.core.util.DataProcessor;
import dji.v5.ux.core.util.UxErrorHandle;
import dji.v5.ux.core.widget.fpv.FPVStreamSourceListener;
import dji.v5.ux.core.widget.fpv.FPVWidgetModel;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010*\u001a\u00020&H\u0016J\b\u0010+\u001a\u00020\fH\u0016J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u00020\fH\u0016J\b\u00100\u001a\u00020-H\u0014J\b\u00101\u001a\u00020-H\u0014J\b\u00102\u001a\u00020-H\u0002J\b\u00103\u001a\u00020-H\u0002J\b\u00104\u001a\u00020-H\u0016J&\u00105\u001a\u00020-2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u0002092\u0006\u0010;\u001a\u00020<J\u000e\u0010=\u001a\u00020-2\u0006\u00106\u001a\u000207J\u0006\u0010>\u001a\u00020-J\b\u0010?\u001a\u00020-H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00160(8G\u00a2\u0006\u0006\u001a\u0004\b'\u0010)\u00a8\u0006@"}, d2={"Ldji/v5/ux/core/widget/fpv/FPVWidgetModel;", "Ldji/v5/ux/core/base/WidgetModel;", "Ldji/v5/ux/core/base/ICameraIndex;", "djiSdkModel", "Ldji/v5/ux/core/base/DJISDKModel;", "keyedStore", "Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;", "flatCameraModule", "Ldji/v5/ux/core/module/FlatCameraModule;", "<init>", "(Ldji/v5/ux/core/base/DJISDKModel;Ldji/v5/ux/core/communication/ObservableInMemoryKeyedStore;Ldji/v5/ux/core/module/FlatCameraModule;)V", "currentLensType", "Ldji/sdk/keyvalue/value/common/CameraLensType;", "streamSourceCameraTypeProcessor", "Ldji/v5/ux/core/util/DataProcessor;", "Ldji/sdk/keyvalue/value/camera/CameraVideoStreamSourceType;", "kotlin.jvm.PlatformType", "resolutionAndFrameRateProcessor", "Ldji/sdk/keyvalue/value/camera/VideoResolutionFrameRate;", "cameraTypeProcessor", "Ldji/sdk/keyvalue/value/camera/CameraType;", "isMotorOnProcessor", "", "displayMsgProcessor", "", "getDisplayMsgProcessor", "()Ldji/v5/ux/core/util/DataProcessor;", "cameraSideProcessor", "getCameraSideProcessor", "videoViewChangedProcessor", "streamSourceListener", "Ldji/v5/ux/core/widget/fpv/FPVStreamSourceListener;", "getStreamSourceListener", "()Ldji/v5/ux/core/widget/fpv/FPVStreamSourceListener;", "setStreamSourceListener", "(Ldji/v5/ux/core/widget/fpv/FPVStreamSourceListener;)V", "cameraType", "currentCameraIndex", "Ldji/sdk/keyvalue/value/common/ComponentIndexType;", "hasVideoViewChanged", "Lio/reactivex/rxjava3/core/Flowable;", "()Lio/reactivex/rxjava3/core/Flowable;", "getCameraIndex", "getLensType", "updateCameraSource", "", "cameraIndex", "lensType", "inSetup", "inCleanup", "sourceUpdate", "updateCameraDisplay", "updateStates", "putCameraStreamSurface", "surface", "Landroid/view/Surface;", "width", "", "height", "scaleType", "Ldji/v5/manager/interfaces/ICameraStreamManager$ScaleType;", "removeCameraStreamSurface", "enableVisionAssist", "onStreamSourceUpdated", "android-sdk-v5-uxsdk_debug"})
public final class FPVWidgetModel
extends WidgetModel
implements ICameraIndex {
    @NotNull
    private final FlatCameraModule flatCameraModule;
    @NotNull
    private CameraLensType currentLensType;
    @NotNull
    private final DataProcessor<CameraVideoStreamSourceType> streamSourceCameraTypeProcessor;
    @NotNull
    private final DataProcessor<VideoResolutionFrameRate> resolutionAndFrameRateProcessor;
    @NotNull
    private final DataProcessor<CameraType> cameraTypeProcessor;
    @NotNull
    private final DataProcessor<Boolean> isMotorOnProcessor;
    @NotNull
    private final DataProcessor<String> displayMsgProcessor;
    @NotNull
    private final DataProcessor<String> cameraSideProcessor;
    @NotNull
    private final DataProcessor<Boolean> videoViewChangedProcessor;
    @Nullable
    private FPVStreamSourceListener streamSourceListener;
    @NotNull
    private CameraType cameraType;
    @NotNull
    private ComponentIndexType currentCameraIndex;

    public FPVWidgetModel(@NotNull DJISDKModel djiSdkModel, @NotNull ObservableInMemoryKeyedStore keyedStore, @NotNull FlatCameraModule flatCameraModule) {
        Intrinsics.checkNotNullParameter((Object)djiSdkModel, (String)"djiSdkModel");
        Intrinsics.checkNotNullParameter((Object)keyedStore, (String)"keyedStore");
        Intrinsics.checkNotNullParameter((Object)flatCameraModule, (String)"flatCameraModule");
        super(djiSdkModel, keyedStore);
        this.flatCameraModule = flatCameraModule;
        this.currentLensType = CameraLensType.CAMERA_LENS_DEFAULT;
        DataProcessor<CameraVideoStreamSourceType> dataProcessor = DataProcessor.create(CameraVideoStreamSourceType.UNKNOWN);
        Intrinsics.checkNotNullExpressionValue(dataProcessor, (String)"create(...)");
        this.streamSourceCameraTypeProcessor = dataProcessor;
        DataProcessor<VideoResolutionFrameRate> dataProcessor2 = DataProcessor.create(new VideoResolutionFrameRate());
        Intrinsics.checkNotNullExpressionValue(dataProcessor2, (String)"create(...)");
        this.resolutionAndFrameRateProcessor = dataProcessor2;
        DataProcessor<CameraType> dataProcessor3 = DataProcessor.create(CameraType.NOT_SUPPORTED);
        Intrinsics.checkNotNullExpressionValue(dataProcessor3, (String)"create(...)");
        this.cameraTypeProcessor = dataProcessor3;
        DataProcessor<Boolean> dataProcessor4 = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor4, (String)"create(...)");
        this.isMotorOnProcessor = dataProcessor4;
        DataProcessor<String> dataProcessor5 = DataProcessor.create("");
        Intrinsics.checkNotNullExpressionValue(dataProcessor5, (String)"create(...)");
        this.displayMsgProcessor = dataProcessor5;
        DataProcessor<String> dataProcessor6 = DataProcessor.create("");
        Intrinsics.checkNotNullExpressionValue(dataProcessor6, (String)"create(...)");
        this.cameraSideProcessor = dataProcessor6;
        DataProcessor<Boolean> dataProcessor7 = DataProcessor.create(false);
        Intrinsics.checkNotNullExpressionValue(dataProcessor7, (String)"create(...)");
        this.videoViewChangedProcessor = dataProcessor7;
        this.cameraType = CameraType.NOT_SUPPORTED;
        this.currentCameraIndex = ComponentIndexType.UNKNOWN;
        this.addModule(this.flatCameraModule);
    }

    @NotNull
    public final DataProcessor<String> getDisplayMsgProcessor() {
        return this.displayMsgProcessor;
    }

    @NotNull
    public final DataProcessor<String> getCameraSideProcessor() {
        return this.cameraSideProcessor;
    }

    @Nullable
    public final FPVStreamSourceListener getStreamSourceListener() {
        return this.streamSourceListener;
    }

    public final void setStreamSourceListener(@Nullable FPVStreamSourceListener fPVStreamSourceListener) {
        this.streamSourceListener = fPVStreamSourceListener;
    }

    @JvmName(name="hasVideoViewChanged")
    @NotNull
    public final Flowable<Boolean> hasVideoViewChanged() {
        Flowable<Boolean> flowable = this.videoViewChangedProcessor.toFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"toFlowable(...)");
        return flowable;
    }

    @Override
    @NotNull
    public ComponentIndexType getCameraIndex() {
        return this.currentCameraIndex;
    }

    @Override
    @NotNull
    public CameraLensType getLensType() {
        return this.currentLensType;
    }

    @Override
    public void updateCameraSource(@NotNull ComponentIndexType cameraIndex, @NotNull CameraLensType lensType) {
        Intrinsics.checkNotNullParameter((Object)cameraIndex, (String)"cameraIndex");
        Intrinsics.checkNotNullParameter((Object)lensType, (String)"lensType");
        if (this.currentCameraIndex != cameraIndex) {
            this.currentCameraIndex = cameraIndex;
            this.restart();
        }
    }

    @Override
    protected void inSetup() {
        Function1 videoViewChangedConsumer = arg_0 -> FPVWidgetModel.inSetup$lambda$0(this, arg_0);
        DJIKeyInfo dJIKeyInfo = CameraKey.KeyCameraVideoStreamSource;
        Intrinsics.checkNotNullExpressionValue((Object)dJIKeyInfo, (String)"KeyCameraVideoStreamSource");
        this.bindDataProcessor(DJIKeyInfoEtKt.create((DJIKeyInfo)dJIKeyInfo, (ComponentIndexType)this.currentCameraIndex), this.streamSourceCameraTypeProcessor, arg_0 -> FPVWidgetModel.inSetup$lambda$1(this, arg_0));
        DJIKeyInfo dJIKeyInfo2 = FlightControllerKey.KeyAreMotorsOn;
        Intrinsics.checkNotNullExpressionValue((Object)dJIKeyInfo2, (String)"KeyAreMotorsOn");
        this.bindDataProcessor(DJIKeyInfoEtKt.create((DJIKeyInfo)dJIKeyInfo2), this.isMotorOnProcessor, arg_0 -> FPVWidgetModel.inSetup$lambda$2(this, arg_0));
        DJIKeyInfo dJIKeyInfo3 = CameraKey.KeyCameraType;
        Intrinsics.checkNotNullExpressionValue((Object)dJIKeyInfo3, (String)"KeyCameraType");
        this.bindDataProcessor(DJIKeyInfoEtKt.create((DJIKeyInfo)dJIKeyInfo3, (ComponentIndexType)this.currentCameraIndex), this.cameraTypeProcessor, arg_0 -> FPVWidgetModel.inSetup$lambda$3(this, arg_0));
        DJIKeyInfo dJIKeyInfo4 = CameraKey.KeyVideoResolutionFrameRate;
        Intrinsics.checkNotNullExpressionValue((Object)dJIKeyInfo4, (String)"KeyVideoResolutionFrameRate");
        this.bindDataProcessor(DJIKeyInfoEtKt.createCamera((DJIKeyInfo)dJIKeyInfo4, (ComponentIndexType)this.currentCameraIndex, (CameraLensType)this.currentLensType), this.resolutionAndFrameRateProcessor);
        this.addDisposable(this.flatCameraModule.getCameraModeDataProcessor().toFlowable().doOnNext(new Consumer(videoViewChangedConsumer){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void accept(Object t) {
                this.function.invoke(t);
            }
        }).subscribe((Consumer)inSetup.4.INSTANCE, UxErrorHandle.logErrorConsumer(this.tag, "camera mode: ")));
        this.sourceUpdate();
    }

    @Override
    protected void inCleanup() {
        this.currentLensType = CameraLensType.CAMERA_LENS_DEFAULT;
    }

    private final void sourceUpdate() {
        this.onStreamSourceUpdated();
        this.updateCameraDisplay();
    }

    private final void updateCameraDisplay() {
        Object msg = "";
        if (!CameraUtil.isFPVTypeView(this.currentCameraIndex)) {
            msg = this.cameraType.name();
        }
        if (this.currentCameraIndex == ComponentIndexType.VISION_ASSIST && !this.isMotorOnProcessor.getValue().booleanValue()) {
            msg = StringUtils.getResStr((int)R.string.uxsdk_assistant_video_empty_text, (Object[])new Object[0]);
        }
        if (this.currentLensType != CameraLensType.CAMERA_LENS_DEFAULT && this.currentLensType != CameraLensType.UNKNOWN) {
            msg = (String)msg + "_" + this.currentLensType.name();
        }
        this.displayMsgProcessor.onNext((String)msg);
        this.cameraSideProcessor.onNext(this.currentCameraIndex.name());
    }

    @Override
    public void updateStates() {
    }

    public final void putCameraStreamSurface(@NotNull Surface surface, int width, int height, @NotNull ICameraStreamManager.ScaleType scaleType) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        Intrinsics.checkNotNullParameter((Object)scaleType, (String)"scaleType");
        MediaDataCenter.getInstance().getCameraStreamManager().putCameraStreamSurface(this.currentCameraIndex, surface, width, height, scaleType);
    }

    public final void removeCameraStreamSurface(@NotNull Surface surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        MediaDataCenter.getInstance().getCameraStreamManager().removeCameraStreamSurface(surface);
    }

    public final void enableVisionAssist() {
        MediaDataCenter.getInstance().getCameraStreamManager().enableVisionAssist(true, null);
    }

    private final void onStreamSourceUpdated() {
        block0: {
            FPVStreamSourceListener fPVStreamSourceListener = this.streamSourceListener;
            if (fPVStreamSourceListener == null) break block0;
            fPVStreamSourceListener.onStreamSourceUpdated(this.currentCameraIndex, this.currentLensType);
        }
    }

    private static final Unit inSetup$lambda$0(FPVWidgetModel this$0, Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<unused var>");
        this$0.videoViewChangedProcessor.onNext(true);
        return Unit.INSTANCE;
    }

    private static final void inSetup$lambda$1(FPVWidgetModel this$0, CameraVideoStreamSourceType it) {
        CameraVideoStreamSourceType cameraVideoStreamSourceType = it;
        this$0.currentLensType = switch (cameraVideoStreamSourceType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cameraVideoStreamSourceType.ordinal()]) {
            case 1 -> CameraLensType.CAMERA_LENS_WIDE;
            case 2 -> CameraLensType.CAMERA_LENS_ZOOM;
            case 3 -> CameraLensType.CAMERA_LENS_THERMAL;
            case 4 -> CameraLensType.CAMERA_LENS_MS_NDVI;
            case 5 -> CameraLensType.CAMERA_LENS_MS_G;
            case 6 -> CameraLensType.CAMERA_LENS_MS_R;
            case 7 -> CameraLensType.CAMERA_LENS_MS_RE;
            case 8 -> CameraLensType.CAMERA_LENS_MS_NIR;
            case 9 -> CameraLensType.CAMERA_LENS_RGB;
            default -> CameraLensType.CAMERA_LENS_DEFAULT;
        };
        this$0.sourceUpdate();
    }

    private static final void inSetup$lambda$2(FPVWidgetModel this$0, Boolean it) {
        this$0.updateCameraDisplay();
    }

    private static final void inSetup$lambda$3(FPVWidgetModel this$0, CameraType it) {
        this$0.cameraType = it;
        this$0.updateCameraDisplay();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CameraVideoStreamSourceType.values().length];
            try {
                nArray[CameraVideoStreamSourceType.WIDE_CAMERA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CameraVideoStreamSourceType.ZOOM_CAMERA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CameraVideoStreamSourceType.INFRARED_CAMERA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CameraVideoStreamSourceType.NDVI_CAMERA.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CameraVideoStreamSourceType.MS_G_CAMERA.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CameraVideoStreamSourceType.MS_R_CAMERA.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CameraVideoStreamSourceType.MS_RE_CAMERA.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CameraVideoStreamSourceType.MS_NIR_CAMERA.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CameraVideoStreamSourceType.RGB_CAMERA.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

