/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.util;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import dji.v5.utils.common.LogUtils;
import dji.v5.ux.core.base.SchedulerProvider;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.Disposable;

public final class AudioUtil {
    private static final float MIN_RATIO = 0.3f;
    private static MediaPlayer player;

    private AudioUtil() {
    }

    public static void playSound(Context context, int resID) {
        AudioUtil.playSound(context, resID, false);
    }

    public static synchronized void playSound(Context context, int resID, boolean ignoreWhenBusy) {
        try {
            if (player != null) {
                if (player.isPlaying()) {
                    if (ignoreWhenBusy) {
                        return;
                    }
                    player.stop();
                }
                player.release();
                player = null;
            }
            player = MediaPlayer.create((Context)context, (int)resID);
            player.setOnCompletionListener(mp -> {
                if (player != null) {
                    player.release();
                    player = null;
                }
            });
            AudioManager am = (AudioManager)context.getSystemService("audio");
            float audioMaxVolume = am.getStreamMaxVolume(3);
            float audioCurrentVolume = am.getStreamVolume(3);
            float volumeRatio = audioCurrentVolume / audioMaxVolume;
            if (volumeRatio < 0.3f) {
                volumeRatio = 0.3f;
            }
            player.setVolume(volumeRatio, volumeRatio);
            player.start();
        }
        catch (Exception e) {
            LogUtils.d((String)"PlaySound", (Object[])new Object[]{e.getMessage()});
        }
    }

    public static Disposable playSoundInBackground(Context context, int resID) {
        return Observable.just((Object)true).subscribeOn(SchedulerProvider.computation()).subscribe(aBoolean -> AudioUtil.playSound(context, resID), e -> LogUtils.d((String)"PlaySound", (Object[])new Object[]{e.getMessage()}));
    }
}

