/*
 * Decompiled with CFR 0.152.
 */
package dji.v5.ux.core.ui.setting.ui;

import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import dji.v5.ux.R;
import dji.v5.ux.core.ui.setting.ui.MenuFragment;
import dji.v5.ux.core.ui.setting.ui.MenuFragmentFactory;

public class SettingMenuFragment
extends Fragment
implements FragmentManager.OnBackStackChangedListener {
    public static final String ARG_PARAM = "fragment_tag";
    private static final String NEED_LAZY_INFLATE = "need_lazy_inflate";
    private TextView mTitleView;
    private ImageView mBackBtn;
    private ImageView mProgressBar;
    private String mFragmentTag;
    private String mFragmentFlag;
    private View mFragmentRoot;
    private FragmentManager fragmentManager;
    private Runnable mLazyInflateTask;

    private SettingMenuFragment() {
    }

    public static SettingMenuFragment newInstance(String tag) {
        return SettingMenuFragment.newInstance(tag, true);
    }

    public static SettingMenuFragment newInstance(String tag, boolean needLazyInitView) {
        SettingMenuFragment fragment = new SettingMenuFragment();
        Bundle args = fragment.getArguments();
        if (args == null) {
            args = new Bundle();
        }
        args.putString(ARG_PARAM, tag);
        args.putBoolean(NEED_LAZY_INFLATE, needLazyInitView);
        fragment.setArguments(args);
        fragment.setFragmentFlag(tag);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.fragmentManager = this.getChildFragmentManager();
        this.fragmentManager.addOnBackStackChangedListener((FragmentManager.OnBackStackChangedListener)this);
        this.mFragmentTag = this.getArguments().getString(ARG_PARAM, "");
        this.mLazyInflateTask = this::inflateFunctionFragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mFragmentRoot = inflater.inflate(R.layout.uxsdk_setting_menu_fragment_layout, null);
        return this.mFragmentRoot;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mTitleView = (TextView)view.findViewById(R.id.setting_menu_header_title);
        this.mBackBtn = (ImageView)view.findViewById(R.id.setting_menu_header_back);
        this.mProgressBar = (ImageView)view.findViewById(R.id.setting_menu_progress_bar);
        if (!TextUtils.isEmpty((CharSequence)this.mFragmentTag)) {
            if (this.getArguments() == null) {
                return;
            }
            this.mProgressBar.setVisibility(0);
            boolean needLazyInflate = this.getArguments().getBoolean(NEED_LAZY_INFLATE, true);
            if (needLazyInflate) {
                this.mFragmentRoot.post(this.mLazyInflateTask);
            } else {
                this.inflateFunctionFragment();
            }
        } else {
            this.updateTitle();
        }
        this.mBackBtn.setOnClickListener(v -> {
            if (this.fragmentManager.getBackStackEntryCount() > 1) {
                MenuFragment menuFragment = this.getLastMenuFragment();
                if (menuFragment != null && !menuFragment.onBackPressed()) {
                    this.popBackFragmentStack();
                }
            } else {
                this.popBackFragmentStack();
            }
        });
    }

    private void inflateFunctionFragment() {
        if (TextUtils.isEmpty((CharSequence)this.mFragmentTag) || this.mProgressBar == null) {
            return;
        }
        MenuFragment menuFragment = MenuFragmentFactory.getMenuFragment(this.mFragmentTag);
        MenuFragment.addFragment(this.fragmentManager, menuFragment);
        this.mProgressBar.setVisibility(8);
        this.mFragmentTag = null;
    }

    private void popBackFragmentStack() {
        if (this.fragmentManager.getBackStackEntryCount() > 1) {
            this.fragmentManager.popBackStackImmediate();
        }
    }

    public void onBackStackChanged() {
        this.updateTitle();
    }

    private void updateTitle() {
        int entryCount = this.fragmentManager.getBackStackEntryCount();
        if (this.mBackBtn != null) {
            this.mBackBtn.setVisibility(entryCount > 1 ? 0 : 4);
        }
        if (entryCount > 0) {
            FragmentManager.BackStackEntry entry = this.fragmentManager.getBackStackEntryAt(entryCount - 1);
            if (this.mTitleView != null) {
                this.mTitleView.setText((CharSequence)entry.getName());
            }
        }
    }

    private MenuFragment getLastMenuFragment() {
        if (this.fragmentManager.getFragments().size() > 0) {
            Fragment fragment = (Fragment)this.fragmentManager.getFragments().get(this.fragmentManager.getFragments().size() - 1);
            if (fragment instanceof MenuFragment) {
                return (MenuFragment)fragment;
            }
            return null;
        }
        return null;
    }

    public void onDestroyView() {
        this.mProgressBar.setVisibility(8);
        this.mProgressBar = null;
        this.mBackBtn = null;
        this.mTitleView = null;
        if (this.mLazyInflateTask != null && this.mFragmentRoot != null) {
            this.mFragmentRoot.removeCallbacks(this.mLazyInflateTask);
        }
        this.mFragmentRoot = null;
        super.onDestroyView();
    }

    public void onDestroy() {
        this.mLazyInflateTask = null;
        super.onDestroy();
    }

    public void onDetach() {
        super.onDetach();
    }

    public String getFragmentFlag() {
        return this.mFragmentFlag;
    }

    public void setFragmentFlag(String mFragmentFlag) {
        this.mFragmentFlag = mFragmentFlag;
    }
}

